/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.shape;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import onnx.Onnx;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.base.Preconditions;
import org.nd4j.imports.NoOpNameFoundException;
import org.nd4j.imports.graphmapper.tf.TFGraphMapper;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.nd4j.linalg.factory.Nd4j;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tensorflow.framework.AttrValue;
import org.tensorflow.framework.GraphDef;
import org.tensorflow.framework.NodeDef;

public class Rank
extends DynamicCustomOp {
    private static final Logger log = LoggerFactory.getLogger(Rank.class);

    public Rank() {
    }

    public Rank(SameDiff sameDiff, SDVariable input, boolean inPlace) {
        super(null, sameDiff, new SDVariable[]{input}, inPlace);
    }

    @Override
    public void initFromTensorFlow(NodeDef nodeDef, SameDiff initWith, Map<String, AttrValue> attributesForNode, GraphDef graph) {
        String name = TFGraphMapper.getInstance().getNodeName(nodeDef.getName());
        SDVariable input = initWith.getVariable(name);
        String outputVertex = input.getVarName();
        if (!initWith.isPlaceHolder(input.getVarName()) && initWith.shapeAlreadyExistsForVarName(outputVertex)) {
            long[] inputShape = initWith.getShapeForVarName(input.getVarName());
            INDArray resultLength = Nd4j.scalar(inputShape.length);
            String thisResultId = outputVertex;
            initWith.setArrayForVariable(thisResultId, resultLength);
            initWith.putShapeForVarName(thisResultId, new long[]{1L, 1L});
        }
    }

    @Override
    public void initFromOnnx(Onnx.NodeProto node, SameDiff initWith, Map<String, Onnx.AttributeProto> attributesForNode, Onnx.GraphProto graph) {
    }

    @Override
    public String opName() {
        return "rank";
    }

    @Override
    public String onnxName() {
        throw new NoOpNameFoundException("No onnx found for op " + this.opName());
    }

    @Override
    public String tensorflowName() {
        return "Rank";
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> i_v) {
        return Collections.singletonList(this.sameDiff.zerosLike(this.arg()));
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> dataTypes) {
        Preconditions.checkState((dataTypes.size() == 1 ? 1 : 0) != 0, (String)"Expected list with exactly 1 datatype for %s, got %s", this.getClass(), dataTypes);
        return Collections.singletonList(DataType.INT);
    }
}

