/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.scalar;

import java.util.Arrays;
import java.util.List;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.imports.NoOpNameFoundException;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseScalarOp;

public class Pow
extends BaseScalarOp {
    private double pow;

    public Pow() {
    }

    public Pow(SameDiff sameDiff, SDVariable i_v, boolean inPlace, double pow) {
        super(sameDiff, i_v, (Number)pow, inPlace);
        this.pow = pow;
        this.extraArgs = new Object[]{pow};
    }

    public Pow(SameDiff sameDiff, SDVariable i_v, Object[] extraArgs, double pow) {
        super(sameDiff, i_v, (Number)pow, extraArgs);
        this.pow = pow;
        this.extraArgs = new Object[]{pow};
    }

    public Pow(INDArray x, INDArray z, double pow) {
        super(x, z, (Number)pow);
        this.pow = pow;
        this.extraArgs = new Object[]{pow};
    }

    public Pow(INDArray x, double pow) {
        super(x, pow);
        this.pow = pow;
        this.extraArgs = new Object[]{pow};
    }

    @Override
    public int opNum() {
        return 31;
    }

    @Override
    public String opName() {
        return "pow";
    }

    @Override
    public String onnxName() {
        return "Pow";
    }

    @Override
    public String tensorflowName() {
        throw new NoOpNameFoundException("No TensorFlow op found for " + this.getClass().getSimpleName());
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> i_v1) {
        SDVariable g = this.f().powDerivative(this.arg(), this.pow).mul(i_v1.get(0));
        return Arrays.asList(g);
    }
}

