/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.scalar;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseScalarOp;
import org.nd4j.linalg.factory.Nd4j;
import org.tensorflow.framework.AttrValue;
import org.tensorflow.framework.GraphDef;
import org.tensorflow.framework.NodeDef;

public class LeakyReLU
extends BaseScalarOp {
    public static final double DEFAULT_ALPHA = 0.01;
    private double alpha = 0.01;

    public LeakyReLU(SameDiff sameDiff, SDVariable i_v, boolean inPlace, double alpha) {
        super(sameDiff, i_v, (Number)alpha, inPlace);
        this.alpha = alpha;
        this.extraArgs = new Object[]{alpha};
    }

    public LeakyReLU(SameDiff sameDiff, SDVariable i_v, Object[] extraArgs, double alpha) {
        super(sameDiff, i_v, (Number)alpha, extraArgs);
        this.alpha = alpha;
        this.extraArgs = new Object[]{alpha};
    }

    public LeakyReLU() {
    }

    public LeakyReLU(INDArray x, double alpha) {
        super(x, alpha);
        this.alpha = alpha;
        this.extraArgs = new Object[]{alpha};
    }

    public LeakyReLU(INDArray x, INDArray z, double alpha) {
        super(x, null, z, alpha);
        this.alpha = alpha;
        this.extraArgs = new Object[]{alpha};
    }

    public LeakyReLU(INDArray x, INDArray z) {
        this(x, z, 0.01);
    }

    public LeakyReLU(INDArray x) {
        super(x, 0.01);
    }

    @Override
    public int opNum() {
        return 35;
    }

    @Override
    public String opName() {
        return "leakyrelu";
    }

    @Override
    public String onnxName() {
        return "LeakyRelu";
    }

    @Override
    public String tensorflowName() {
        return "LeakyRelu";
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> i_v) {
        return Collections.singletonList(this.f().leakyReluBp(this.arg(), i_v.get(0), this.alpha));
    }

    @Override
    public void initFromTensorFlow(NodeDef nodeDef, SameDiff initWith, Map<String, AttrValue> attributesForNode, GraphDef graph) {
        this.alpha = attributesForNode.get("alpha").getF();
        this.extraArgs = new Object[]{this.alpha};
        this.setScalar(Nd4j.scalar(DataType.FLOAT, this.alpha));
    }
}

