/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.reduce;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import onnx.Onnx;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.linalg.api.blas.params.MMulTranspose;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.api.shape.LongShapeDescriptor;
import org.nd4j.linalg.api.shape.Shape;
import org.nd4j.linalg.exception.ND4JIllegalStateException;
import org.nd4j.linalg.util.ArrayUtil;
import org.nd4j.shade.guava.primitives.Ints;
import org.nd4j.shade.guava.primitives.Longs;
import org.tensorflow.framework.AttrValue;
import org.tensorflow.framework.GraphDef;
import org.tensorflow.framework.NodeDef;

public class TensorMmul
extends DynamicCustomOp {
    private int[][] axes;
    protected boolean addedEdges;
    protected MMulTranspose mMulTranspose;

    public TensorMmul(SameDiff sameDiff, SDVariable i_v1, SDVariable i_v2, int[][] dimensions) {
        this(sameDiff, i_v1, i_v2, dimensions, MMulTranspose.allFalse());
    }

    public TensorMmul(SameDiff sameDiff, SDVariable i_v1, SDVariable i_v2, int[][] dimensions, MMulTranspose mMulTranspose) {
        super(null, sameDiff, new SDVariable[]{i_v1, i_v2});
        this.sameDiff = sameDiff;
        this.mMulTranspose = mMulTranspose;
        this.axes = dimensions;
        if (!this.addedEdges && sameDiff.getOutputsForOp(this) == null) {
            this.addedEdges = true;
        }
        this.addIArgument(dimensions[0].length);
        this.addIArgument(dimensions[0]);
        this.addIArgument(dimensions[1].length);
        this.addIArgument(dimensions[1]);
    }

    @Override
    public List<LongShapeDescriptor> calculateOutputShape() {
        long[] bShape;
        ArrayList<LongShapeDescriptor> ret = new ArrayList<LongShapeDescriptor>(1);
        long[] aShape = this.mMulTranspose.isTransposeA() ? ArrayUtil.reverseCopy((long[])this.larg().getShape()) : this.larg().getShape();
        long[] lArray = bShape = this.mMulTranspose.isTransposeB() ? ArrayUtil.reverseCopy((long[])this.rarg().getShape()) : this.rarg().getShape();
        if (Shape.isPlaceholderShape(aShape) || Shape.isPlaceholderShape(bShape)) {
            return Collections.emptyList();
        }
        if (aShape != null && bShape != null) {
            long[] shape = ArrayUtil.getTensorMmulShape((long[])aShape, (long[])bShape, (int[][])this.axes);
            ret.add(LongShapeDescriptor.fromShape(shape, Shape.pickPairwiseDataType(this.larg().dataType(), this.rarg().dataType())));
        }
        if (!ret.isEmpty()) {
            for (int i = 0; i < ((LongShapeDescriptor)ret.get(0)).getShape().length; ++i) {
                if (((LongShapeDescriptor)ret.get(0)).getShape()[i] >= 1L) continue;
                throw new ND4JIllegalStateException("Invalid shape computed at index " + i);
            }
        }
        return ret;
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> i_v1) {
        ArrayList<SDVariable> ret = new ArrayList<SDVariable>();
        int[] bAxes = ArrayUtil.range((int)0, (int)this.rarg().getShape().length);
        int[] aAxes = ArrayUtil.range((int)0, (int)this.larg().getShape().length);
        int aRank = this.larg().getShape().length;
        int bRank = this.rarg().getShape().length;
        int[][] sumAxes = new int[][]{ArrayUtil.mod((int[])this.axes[0], (int)aRank), ArrayUtil.mod((int[])this.axes[1], (int)bRank)};
        int[][] deletedAxes = new int[][]{ArrayUtil.removeIndex((int[])aAxes, (int[])sumAxes[0]), ArrayUtil.removeIndex((int[])bAxes, (int[])sumAxes[1])};
        int[] gAxes = ArrayUtil.range((int)0, (int)i_v1.get(0).getShape().length);
        int[][] firstAxes = new int[][]{Arrays.copyOfRange(gAxes, deletedAxes[0].length, gAxes.length), deletedAxes[1]};
        int[][] secondAxes = new int[][]{deletedAxes[0], Arrays.copyOfRange(gAxes, 0, deletedAxes[0].length)};
        int[] firstPerm = ArrayUtil.argsort((int[])ArrayUtil.combine((int[][])new int[][]{deletedAxes[0], ArrayUtil.keep((int[])ArrayUtil.argsort((int[])sumAxes[1]), (int[])sumAxes[0])}));
        SDVariable firstResult = this.doTensorMmul(i_v1.get(0), this.rarg(), firstAxes);
        SDVariable permuted = this.f().permute(firstResult, firstPerm);
        ret.add(permuted);
        int[] secondPerm = ArrayUtil.argsort((int[])ArrayUtil.combine((int[][])new int[][]{ArrayUtil.keep((int[])ArrayUtil.argsort((int[])sumAxes[0]), (int[])sumAxes[1]), deletedAxes[1]}));
        SDVariable secondResult = this.doTensorMmul(i_v1.get(0), this.larg(), secondAxes);
        SDVariable secondPermuted = this.f().permute(secondResult, secondPerm);
        ret.add(secondPermuted);
        return ret;
    }

    private SDVariable doTensorMmul(SDVariable a, SDVariable b, int[][] axes) {
        long[] oldShapeB;
        long[] oldShapeA;
        int validationLength = Math.min(axes[0].length, axes[1].length);
        for (int i = 0; i < validationLength; ++i) {
            if (a.getShape()[axes[0][i]] != b.getShape()[axes[1][i]]) {
                throw new IllegalArgumentException("Size of the given axes at each dimension must be the same size.");
            }
            if (axes[0][i] < 0) {
                int[] nArray = axes[0];
                int n = i;
                nArray[n] = nArray[n] + a.getShape().length;
            }
            if (axes[1][i] >= 0) continue;
            int[] nArray = axes[1];
            int n = i;
            nArray[n] = nArray[n] + b.getShape().length;
        }
        ArrayList<Integer> listA = new ArrayList<Integer>();
        for (int i = 0; i < a.getShape().length; ++i) {
            if (Ints.contains((int[])axes[0], (int)i)) continue;
            listA.add(i);
        }
        int[] newAxesA = Ints.concat((int[][])new int[][]{Ints.toArray(listA), axes[0]});
        ArrayList<Integer> listB = new ArrayList<Integer>();
        for (int i = 0; i < b.getShape().length; ++i) {
            if (Ints.contains((int[])axes[1], (int)i)) continue;
            listB.add(i);
        }
        int[] newAxesB = Ints.concat((int[][])new int[][]{axes[1], Ints.toArray(listB)});
        int n2 = 1;
        int aLength = Math.min(a.getShape().length, axes[0].length);
        for (int i = 0; i < aLength; ++i) {
            n2 = (int)((long)n2 * a.getShape()[axes[0][i]]);
        }
        long[] newShapeA = new long[]{-1L, n2};
        if (listA.size() == 0) {
            oldShapeA = new long[]{1L};
        } else {
            oldShapeA = Longs.toArray(listA);
            for (int i = 0; i < oldShapeA.length; ++i) {
                oldShapeA[i] = a.getShape()[(int)oldShapeA[i]];
            }
        }
        int n3 = 1;
        int bNax = Math.min(b.getShape().length, axes[1].length);
        for (int i = 0; i < bNax; ++i) {
            n3 = (int)((long)n3 * b.getShape()[axes[1][i]]);
        }
        int[] newShapeB = new int[]{n3, -1};
        if (listB.size() == 0) {
            oldShapeB = new long[]{1L};
        } else {
            oldShapeB = Longs.toArray(listB);
            for (int i = 0; i < oldShapeB.length; ++i) {
                oldShapeB[i] = b.getShape()[(int)oldShapeB[i]];
            }
        }
        SDVariable at = this.f().reshape(this.f().permute(a, newAxesA), newShapeA);
        SDVariable bt = this.f().reshape(this.f().permute(b, newAxesB), newShapeB);
        SDVariable ret = this.f().mmul(at, bt);
        long[] aPlusB = Longs.concat((long[][])new long[][]{oldShapeA, oldShapeB});
        return this.f().reshape(ret, aPlusB);
    }

    public TensorMmul(INDArray x, INDArray y, int[][] axes) {
        super(null, new INDArray[]{x, y}, null);
        this.axes = axes;
        this.extraArgs = new Object[]{axes};
    }

    public TensorMmul(INDArray x, INDArray y, INDArray z, int[][] axes) {
        super(null, new INDArray[]{x, y, z}, null);
        this.axes = axes;
    }

    @Override
    public String opName() {
        return "tensordot";
    }

    @Override
    public void initFromTensorFlow(NodeDef nodeDef, SameDiff initWith, Map<String, AttrValue> attributesForNode, GraphDef graph) {
        MMulTranspose mMulTranspose;
        super.initFromTensorFlow(nodeDef, initWith, attributesForNode, graph);
        boolean isTransposeA = attributesForNode.get("transpose_a").getB();
        boolean isTransposeB = attributesForNode.get("transpose_b").getB();
        this.mMulTranspose = mMulTranspose = MMulTranspose.builder().transposeA(isTransposeA).transposeB(isTransposeB).build();
        SDVariable[] args = this.args();
    }

    @Override
    public void initFromOnnx(Onnx.NodeProto node, SameDiff initWith, Map<String, Onnx.AttributeProto> attributesForNode, Onnx.GraphProto graph) {
        MMulTranspose mMulTranspose;
        boolean isTransposeA;
        boolean bl = !attributesForNode.containsKey("transA") ? false : (isTransposeA = attributesForNode.get("transA").getI() > 0L);
        boolean isTransposeB = !attributesForNode.containsKey("transB") ? false : attributesForNode.get("transB").getI() > 0L;
        this.mMulTranspose = mMulTranspose = MMulTranspose.builder().transposeA(isTransposeA).transposeB(isTransposeB).build();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TensorMmul that = (TensorMmul)o;
        if (this.addedEdges != that.addedEdges) {
            return false;
        }
        if (!Arrays.deepEquals((Object[])this.axes, (Object[])that.axes)) {
            return false;
        }
        return this.mMulTranspose != null ? this.mMulTranspose.equals(that.mMulTranspose) : that.mMulTranspose == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Arrays.deepHashCode((Object[])this.axes);
        result = 31 * result + (this.addedEdges ? 1 : 0);
        result = 31 * result + (this.mMulTranspose != null ? this.mMulTranspose.hashCode() : 0);
        return result;
    }

    @Override
    public Op.Type opType() {
        return Op.Type.CUSTOM;
    }

    @Override
    public String onnxName() {
        return "Gemm";
    }

    @Override
    public String tensorflowName() {
        return "matmul";
    }

    public TensorMmul() {
    }
}

