/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.layers.convolution.config;

import java.util.LinkedHashMap;
import java.util.Map;
import org.nd4j.linalg.api.ops.impl.layers.convolution.Pooling2D;
import org.nd4j.linalg.api.ops.impl.layers.convolution.config.BaseConvolutionConfig;
import org.nd4j.linalg.util.ConvConfigUtil;

public class Pooling2DConfig
extends BaseConvolutionConfig {
    private long kH;
    private long kW;
    private long sH;
    private long sW;
    private long pH;
    private long pW;
    private double extra;
    private Pooling2D.Pooling2DType type;
    private Pooling2D.Divisor divisor;
    private boolean isSameMode;
    private long dH;
    private long dW;
    private boolean isNHWC;

    public Pooling2DConfig(long kH, long kW, long sH, long sW, long pH, long pW, double extra, Pooling2D.Pooling2DType type, Pooling2D.Divisor divisor, boolean isSameMode, long dH, long dW, boolean isNHWC) {
        this.kH = kH;
        this.kW = kW;
        this.sH = sH;
        this.sW = sW;
        this.pH = pH;
        this.pW = pW;
        this.extra = extra;
        this.type = type;
        this.divisor = divisor;
        this.isSameMode = isSameMode;
        this.dH = dH;
        this.dW = dW;
        this.isNHWC = isNHWC;
        this.validate();
    }

    @Override
    public Map<String, Object> toProperties() {
        LinkedHashMap<String, Object> ret = new LinkedHashMap<String, Object>();
        ret.put("kH", this.kH);
        ret.put("kW", this.kW);
        ret.put("sH", this.sH);
        ret.put("sW", this.sW);
        ret.put("pH", this.pH);
        ret.put("pW", this.pW);
        ret.put("extra", this.extra);
        ret.put("type", this.type.toString());
        ret.put("isSameMode", this.isSameMode);
        ret.put("dH", this.dH);
        ret.put("dW", this.dW);
        ret.put("isNHWC", this.isNHWC);
        return ret;
    }

    @Override
    protected void validate() {
        ConvConfigUtil.validate2D(this.kH, this.kW, this.sH, this.sW, this.pH, this.pW, this.dH, this.dW);
    }

    private static long $default$kH() {
        return -1L;
    }

    private static long $default$kW() {
        return -1L;
    }

    private static long $default$sH() {
        return 1L;
    }

    private static long $default$sW() {
        return 1L;
    }

    private static long $default$pH() {
        return 0L;
    }

    private static long $default$pW() {
        return 0L;
    }

    private static Pooling2D.Pooling2DType $default$type() {
        return Pooling2D.Pooling2DType.MAX;
    }

    private static Pooling2D.Divisor $default$divisor() {
        return Pooling2D.Divisor.EXCLUDE_PADDING;
    }

    private static long $default$dH() {
        return 1L;
    }

    private static long $default$dW() {
        return 1L;
    }

    private static boolean $default$isNHWC() {
        return false;
    }

    public static Pooling2DConfigBuilder builder() {
        return new Pooling2DConfigBuilder();
    }

    public long getKH() {
        return this.kH;
    }

    public long getKW() {
        return this.kW;
    }

    public long getSH() {
        return this.sH;
    }

    public long getSW() {
        return this.sW;
    }

    public long getPH() {
        return this.pH;
    }

    public long getPW() {
        return this.pW;
    }

    public double getExtra() {
        return this.extra;
    }

    public Pooling2D.Pooling2DType getType() {
        return this.type;
    }

    public Pooling2D.Divisor getDivisor() {
        return this.divisor;
    }

    public boolean isSameMode() {
        return this.isSameMode;
    }

    public long getDH() {
        return this.dH;
    }

    public long getDW() {
        return this.dW;
    }

    public boolean isNHWC() {
        return this.isNHWC;
    }

    public void setKH(long kH) {
        this.kH = kH;
    }

    public void setKW(long kW) {
        this.kW = kW;
    }

    public void setSH(long sH) {
        this.sH = sH;
    }

    public void setSW(long sW) {
        this.sW = sW;
    }

    public void setPH(long pH) {
        this.pH = pH;
    }

    public void setPW(long pW) {
        this.pW = pW;
    }

    public void setExtra(double extra) {
        this.extra = extra;
    }

    public void setType(Pooling2D.Pooling2DType type) {
        this.type = type;
    }

    public void setDivisor(Pooling2D.Divisor divisor) {
        this.divisor = divisor;
    }

    public void setSameMode(boolean isSameMode) {
        this.isSameMode = isSameMode;
    }

    public void setDH(long dH) {
        this.dH = dH;
    }

    public void setDW(long dW) {
        this.dW = dW;
    }

    public void setNHWC(boolean isNHWC) {
        this.isNHWC = isNHWC;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Pooling2DConfig)) {
            return false;
        }
        Pooling2DConfig other = (Pooling2DConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getKH() != other.getKH()) {
            return false;
        }
        if (this.getKW() != other.getKW()) {
            return false;
        }
        if (this.getSH() != other.getSH()) {
            return false;
        }
        if (this.getSW() != other.getSW()) {
            return false;
        }
        if (this.getPH() != other.getPH()) {
            return false;
        }
        if (this.getPW() != other.getPW()) {
            return false;
        }
        if (Double.compare(this.getExtra(), other.getExtra()) != 0) {
            return false;
        }
        Pooling2D.Pooling2DType this$type = this.getType();
        Pooling2D.Pooling2DType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        Pooling2D.Divisor this$divisor = this.getDivisor();
        Pooling2D.Divisor other$divisor = other.getDivisor();
        if (this$divisor == null ? other$divisor != null : !((Object)((Object)this$divisor)).equals((Object)other$divisor)) {
            return false;
        }
        if (this.isSameMode() != other.isSameMode()) {
            return false;
        }
        if (this.getDH() != other.getDH()) {
            return false;
        }
        if (this.getDW() != other.getDW()) {
            return false;
        }
        return this.isNHWC() == other.isNHWC();
    }

    protected boolean canEqual(Object other) {
        return other instanceof Pooling2DConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $kH = this.getKH();
        result = result * 59 + (int)($kH >>> 32 ^ $kH);
        long $kW = this.getKW();
        result = result * 59 + (int)($kW >>> 32 ^ $kW);
        long $sH = this.getSH();
        result = result * 59 + (int)($sH >>> 32 ^ $sH);
        long $sW = this.getSW();
        result = result * 59 + (int)($sW >>> 32 ^ $sW);
        long $pH = this.getPH();
        result = result * 59 + (int)($pH >>> 32 ^ $pH);
        long $pW = this.getPW();
        result = result * 59 + (int)($pW >>> 32 ^ $pW);
        long $extra = Double.doubleToLongBits(this.getExtra());
        result = result * 59 + (int)($extra >>> 32 ^ $extra);
        Pooling2D.Pooling2DType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        Pooling2D.Divisor $divisor = this.getDivisor();
        result = result * 59 + ($divisor == null ? 43 : ((Object)((Object)$divisor)).hashCode());
        result = result * 59 + (this.isSameMode() ? 79 : 97);
        long $dH = this.getDH();
        result = result * 59 + (int)($dH >>> 32 ^ $dH);
        long $dW = this.getDW();
        result = result * 59 + (int)($dW >>> 32 ^ $dW);
        result = result * 59 + (this.isNHWC() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "Pooling2DConfig(kH=" + this.getKH() + ", kW=" + this.getKW() + ", sH=" + this.getSH() + ", sW=" + this.getSW() + ", pH=" + this.getPH() + ", pW=" + this.getPW() + ", extra=" + this.getExtra() + ", type=" + (Object)((Object)this.getType()) + ", divisor=" + (Object)((Object)this.getDivisor()) + ", isSameMode=" + this.isSameMode() + ", dH=" + this.getDH() + ", dW=" + this.getDW() + ", isNHWC=" + this.isNHWC() + ")";
    }

    public Pooling2DConfig() {
        this.kH = Pooling2DConfig.$default$kH();
        this.kW = Pooling2DConfig.$default$kW();
        this.sH = Pooling2DConfig.$default$sH();
        this.sW = Pooling2DConfig.$default$sW();
        this.pH = Pooling2DConfig.$default$pH();
        this.pW = Pooling2DConfig.$default$pW();
        this.type = Pooling2DConfig.$default$type();
        this.divisor = Pooling2DConfig.$default$divisor();
        this.dH = Pooling2DConfig.$default$dH();
        this.dW = Pooling2DConfig.$default$dW();
        this.isNHWC = Pooling2DConfig.$default$isNHWC();
    }

    public static class Pooling2DConfigBuilder {
        private boolean kH$set;
        private long kH;
        private boolean kW$set;
        private long kW;
        private boolean sH$set;
        private long sH;
        private boolean sW$set;
        private long sW;
        private boolean pH$set;
        private long pH;
        private boolean pW$set;
        private long pW;
        private double extra;
        private boolean type$set;
        private Pooling2D.Pooling2DType type;
        private boolean divisor$set;
        private Pooling2D.Divisor divisor;
        private boolean isSameMode;
        private boolean dH$set;
        private long dH;
        private boolean dW$set;
        private long dW;
        private boolean isNHWC$set;
        private boolean isNHWC;

        Pooling2DConfigBuilder() {
        }

        public Pooling2DConfigBuilder kH(long kH) {
            this.kH = kH;
            this.kH$set = true;
            return this;
        }

        public Pooling2DConfigBuilder kW(long kW) {
            this.kW = kW;
            this.kW$set = true;
            return this;
        }

        public Pooling2DConfigBuilder sH(long sH) {
            this.sH = sH;
            this.sH$set = true;
            return this;
        }

        public Pooling2DConfigBuilder sW(long sW) {
            this.sW = sW;
            this.sW$set = true;
            return this;
        }

        public Pooling2DConfigBuilder pH(long pH) {
            this.pH = pH;
            this.pH$set = true;
            return this;
        }

        public Pooling2DConfigBuilder pW(long pW) {
            this.pW = pW;
            this.pW$set = true;
            return this;
        }

        public Pooling2DConfigBuilder extra(double extra) {
            this.extra = extra;
            return this;
        }

        public Pooling2DConfigBuilder type(Pooling2D.Pooling2DType type) {
            this.type = type;
            this.type$set = true;
            return this;
        }

        public Pooling2DConfigBuilder divisor(Pooling2D.Divisor divisor) {
            this.divisor = divisor;
            this.divisor$set = true;
            return this;
        }

        public Pooling2DConfigBuilder isSameMode(boolean isSameMode) {
            this.isSameMode = isSameMode;
            return this;
        }

        public Pooling2DConfigBuilder dH(long dH) {
            this.dH = dH;
            this.dH$set = true;
            return this;
        }

        public Pooling2DConfigBuilder dW(long dW) {
            this.dW = dW;
            this.dW$set = true;
            return this;
        }

        public Pooling2DConfigBuilder isNHWC(boolean isNHWC) {
            this.isNHWC = isNHWC;
            this.isNHWC$set = true;
            return this;
        }

        public Pooling2DConfig build() {
            long kH = this.kH;
            if (!this.kH$set) {
                kH = Pooling2DConfig.$default$kH();
            }
            long kW = this.kW;
            if (!this.kW$set) {
                kW = Pooling2DConfig.$default$kW();
            }
            long sH = this.sH;
            if (!this.sH$set) {
                sH = Pooling2DConfig.$default$sH();
            }
            long sW = this.sW;
            if (!this.sW$set) {
                sW = Pooling2DConfig.$default$sW();
            }
            long pH = this.pH;
            if (!this.pH$set) {
                pH = Pooling2DConfig.$default$pH();
            }
            long pW = this.pW;
            if (!this.pW$set) {
                pW = Pooling2DConfig.$default$pW();
            }
            Pooling2D.Pooling2DType type = this.type;
            if (!this.type$set) {
                type = Pooling2DConfig.$default$type();
            }
            Pooling2D.Divisor divisor = this.divisor;
            if (!this.divisor$set) {
                divisor = Pooling2DConfig.$default$divisor();
            }
            long dH = this.dH;
            if (!this.dH$set) {
                dH = Pooling2DConfig.$default$dH();
            }
            long dW = this.dW;
            if (!this.dW$set) {
                dW = Pooling2DConfig.$default$dW();
            }
            boolean isNHWC = this.isNHWC;
            if (!this.isNHWC$set) {
                isNHWC = Pooling2DConfig.$default$isNHWC();
            }
            return new Pooling2DConfig(kH, kW, sH, sW, pH, pW, this.extra, type, divisor, this.isSameMode, dH, dW, isNHWC);
        }

        public String toString() {
            return "Pooling2DConfig.Pooling2DConfigBuilder(kH=" + this.kH + ", kW=" + this.kW + ", sH=" + this.sH + ", sW=" + this.sW + ", pH=" + this.pH + ", pW=" + this.pW + ", extra=" + this.extra + ", type=" + (Object)((Object)this.type) + ", divisor=" + (Object)((Object)this.divisor) + ", isSameMode=" + this.isSameMode + ", dH=" + this.dH + ", dW=" + this.dW + ", isNHWC=" + this.isNHWC + ")";
        }
    }
}

