/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops;

import java.util.Collections;
import java.util.List;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.base.Preconditions;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseReduceOp;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.api.ops.ReduceLongOp;
import org.nd4j.linalg.api.shape.LongShapeDescriptor;
import org.nd4j.linalg.api.shape.Shape;

public abstract class BaseReduceLongOp
extends BaseReduceOp
implements ReduceLongOp {
    public BaseReduceLongOp(SameDiff sameDiff, SDVariable i_v, SDVariable i_v2, int[] dimensions) {
        super(sameDiff, i_v, i_v2, dimensions);
    }

    protected BaseReduceLongOp(SameDiff sameDiff, SDVariable input, int[] dimensions, boolean keepDims) {
        super(sameDiff, input, dimensions, keepDims);
    }

    protected BaseReduceLongOp(SameDiff sameDiff, SDVariable input, int ... dimensions) {
        super(sameDiff, input, dimensions);
    }

    public BaseReduceLongOp(INDArray x, int ... dimensions) {
        super(x, dimensions);
    }

    public BaseReduceLongOp(INDArray x, INDArray z, int ... dimensions) {
        super(x, z, dimensions);
    }

    protected BaseReduceLongOp() {
    }

    @Override
    public Op.Type opType() {
        return Op.Type.REDUCE_LONG;
    }

    @Override
    public Op.Type getOpType() {
        return this.opType();
    }

    @Override
    public DataType resultType() {
        return DataType.LONG;
    }

    @Override
    public boolean validateDataTypes() {
        if (this.y() != null) {
            Preconditions.checkArgument((this.x().dataType() == this.y().dataType() ? 1 : 0) != 0, (String)"Op.X type must be the same as Op.Y: x.dataType=%s, y.dataType=%s, op=%s", (Object)this.x.dataType(), (Object)this.y.dataType(), (Object)this.getClass().getName());
        }
        if (this.z() != null) {
            Preconditions.checkArgument((this.z().dataType() == DataType.LONG ? 1 : 0) != 0, (String)"Op.Z must be long: has type %s for op %s", (Object)this.z().dataType(), this.getClass());
        }
        return true;
    }

    @Override
    public List<LongShapeDescriptor> calculateOutputShape() {
        if (this.x == null) {
            return Collections.emptyList();
        }
        long[] reducedShape = this.x.rank() == 0 ? this.x.shape() : Shape.getReducedShape(this.x.shape(), this.dimensions, this.isKeepDims());
        return Collections.singletonList(LongShapeDescriptor.fromShape(reducedShape, DataType.LONG));
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> dataTypes) {
        Preconditions.checkState((dataTypes != null && (dataTypes.size() == 1 || dataTypes.size() == 2) ? 1 : 0) != 0, (String)"Expected 1 or input datatype for %s, got input %s", this.getClass(), dataTypes);
        Preconditions.checkState((dataTypes.size() == 1 || dataTypes.get(1).isIntType() ? 1 : 0) != 0, (String)"When executing reductionswith 2 inputs, second input (axis) must be an integer datatype for %s, got %s", this.getClass(), dataTypes);
        return Collections.singletonList(DataType.LONG);
    }
}

