/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.blas.impl;

import org.nd4j.linalg.api.blas.Level1;
import org.nd4j.linalg.api.blas.impl.SparseBaseLevel;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.BaseSparseNDArray;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.executioner.DefaultOpExecutioner;

public abstract class SparseBaseLevel1
extends SparseBaseLevel
implements Level1 {
    @Override
    public double dot(long n, double alpha, INDArray X, INDArray Y) {
        if (X instanceof BaseSparseNDArray) {
            BaseSparseNDArray sparseX = (BaseSparseNDArray)X;
            DataBuffer pointers = sparseX.getVectorCoordinates();
            switch (X.data().dataType()) {
                case DOUBLE: {
                    DefaultOpExecutioner.validateDataType(DataType.DOUBLE, X, Y);
                    return this.ddoti(n, X, pointers, Y);
                }
                case FLOAT: {
                    DefaultOpExecutioner.validateDataType(DataType.FLOAT, X, Y);
                    return this.sdoti(n, X, pointers, Y);
                }
                case HALF: {
                    DefaultOpExecutioner.validateDataType(DataType.HALF, X, Y);
                    return this.hdoti(n, X, pointers, Y);
                }
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public double dot(long n, DataBuffer dx, int offsetX, int incrX, DataBuffer y, int offsetY, int incrY) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double nrm2(INDArray arr) {
        switch (arr.data().dataType()) {
            case DOUBLE: {
                DefaultOpExecutioner.validateDataType(DataType.DOUBLE, arr, new INDArray[0]);
                return this.dnrm2(arr.length(), arr, 1);
            }
            case FLOAT: {
                DefaultOpExecutioner.validateDataType(DataType.FLOAT, arr, new INDArray[0]);
                return this.snrm2(arr.length(), arr, 1);
            }
            case HALF: {
                return this.hnrm2(arr.length(), arr, 1);
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public double asum(INDArray arr) {
        switch (arr.data().dataType()) {
            case DOUBLE: {
                DefaultOpExecutioner.validateDataType(DataType.DOUBLE, arr, new INDArray[0]);
                return this.dasum(arr.length(), arr, 1);
            }
            case FLOAT: {
                DefaultOpExecutioner.validateDataType(DataType.FLOAT, arr, new INDArray[0]);
                return this.sasum(arr.length(), arr, 1);
            }
            case HALF: {
                DefaultOpExecutioner.validateDataType(DataType.HALF, arr, new INDArray[0]);
                return this.hasum(arr.length(), arr, 1);
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public double asum(long n, DataBuffer x, int offsetX, int incrX) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int iamax(INDArray arr) {
        switch (arr.data().dataType()) {
            case DOUBLE: {
                DefaultOpExecutioner.validateDataType(DataType.DOUBLE, arr, new INDArray[0]);
                return this.idamax(arr.length(), arr, 1);
            }
            case FLOAT: {
                DefaultOpExecutioner.validateDataType(DataType.FLOAT, arr, new INDArray[0]);
                return this.isamax(arr.length(), arr, 1);
            }
            case HALF: {
                DefaultOpExecutioner.validateDataType(DataType.HALF, arr, new INDArray[0]);
                return this.ihamax(arr.length(), arr, 1);
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public int iamax(long n, INDArray arr, int stride) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int iamax(long n, DataBuffer x, int offsetX, int incrX) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int iamin(INDArray arr) {
        switch (arr.data().dataType()) {
            case DOUBLE: {
                DefaultOpExecutioner.validateDataType(DataType.DOUBLE, arr, new INDArray[0]);
                return this.idamin(arr.length(), arr, 1);
            }
            case FLOAT: {
                DefaultOpExecutioner.validateDataType(DataType.FLOAT, arr, new INDArray[0]);
                return this.isamin(arr.length(), arr, 1);
            }
            case HALF: {
                DefaultOpExecutioner.validateDataType(DataType.HALF, arr, new INDArray[0]);
                return this.ihamin(arr.length(), arr, 1);
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public void swap(INDArray x, INDArray y) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void copy(INDArray x, INDArray y) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void copy(long n, DataBuffer x, int offsetX, int incrX, DataBuffer y, int offsetY, int incrY) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void axpy(long n, double alpha, INDArray x, INDArray y) {
        BaseSparseNDArray sparseX = (BaseSparseNDArray)x;
        DataBuffer pointers = sparseX.getVectorCoordinates();
        switch (x.data().dataType()) {
            case DOUBLE: {
                DefaultOpExecutioner.validateDataType(DataType.DOUBLE, x, new INDArray[0]);
                DefaultOpExecutioner.validateDataType(DataType.DOUBLE, y, new INDArray[0]);
                this.daxpyi(n, alpha, x, pointers, y);
                break;
            }
            case FLOAT: {
                DefaultOpExecutioner.validateDataType(DataType.FLOAT, x, new INDArray[0]);
                DefaultOpExecutioner.validateDataType(DataType.FLOAT, y, new INDArray[0]);
                this.saxpyi(n, alpha, x, pointers, y);
                break;
            }
            case HALF: {
                DefaultOpExecutioner.validateDataType(DataType.HALF, x, new INDArray[0]);
                DefaultOpExecutioner.validateDataType(DataType.HALF, y, new INDArray[0]);
                this.haxpyi(n, alpha, x, pointers, y);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    @Override
    public void axpy(long n, double alpha, DataBuffer x, int offsetX, int incrX, DataBuffer y, int offsetY, int incrY) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void rotg(INDArray a, INDArray b, INDArray c, INDArray s) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void rot(long N, INDArray X, INDArray Y, double c, double s) {
        if (X instanceof BaseSparseNDArray) {
            BaseSparseNDArray sparseX = (BaseSparseNDArray)X;
            switch (X.data().dataType()) {
                case DOUBLE: {
                    this.droti(N, X, sparseX.getVectorCoordinates(), Y, c, s);
                    break;
                }
                case FLOAT: {
                    this.sroti(N, X, sparseX.getVectorCoordinates(), Y, c, s);
                    break;
                }
                case HALF: {
                    this.hroti(N, X, sparseX.getVectorCoordinates(), Y, c, s);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
        } else {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public void rotmg(INDArray d1, INDArray d2, INDArray b1, double b2, INDArray P) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void scal(long N, double alpha, INDArray X) {
        switch (X.data().dataType()) {
            case DOUBLE: {
                this.dscal(N, alpha, X, 1);
                break;
            }
            case FLOAT: {
                this.sscal(N, alpha, X, 1);
                break;
            }
            case HALF: {
                this.hscal(N, alpha, X, 1);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    @Override
    public boolean supportsDataBufferL1Ops() {
        return false;
    }

    protected abstract double ddoti(long var1, INDArray var3, DataBuffer var4, INDArray var5);

    protected abstract double sdoti(long var1, INDArray var3, DataBuffer var4, INDArray var5);

    protected abstract double hdoti(long var1, INDArray var3, DataBuffer var4, INDArray var5);

    protected abstract double snrm2(long var1, INDArray var3, int var4);

    protected abstract double dnrm2(long var1, INDArray var3, int var4);

    protected abstract double hnrm2(long var1, INDArray var3, int var4);

    protected abstract double dasum(long var1, INDArray var3, int var4);

    protected abstract double sasum(long var1, INDArray var3, int var4);

    protected abstract double hasum(long var1, INDArray var3, int var4);

    protected abstract int isamax(long var1, INDArray var3, int var4);

    protected abstract int idamax(long var1, INDArray var3, int var4);

    protected abstract int ihamax(long var1, INDArray var3, int var4);

    protected abstract int isamin(long var1, INDArray var3, int var4);

    protected abstract int idamin(long var1, INDArray var3, int var4);

    protected abstract int ihamin(long var1, INDArray var3, int var4);

    protected abstract void daxpyi(long var1, double var3, INDArray var5, DataBuffer var6, INDArray var7);

    protected abstract void saxpyi(long var1, double var3, INDArray var5, DataBuffer var6, INDArray var7);

    protected abstract void haxpyi(long var1, double var3, INDArray var5, DataBuffer var6, INDArray var7);

    protected abstract void droti(long var1, INDArray var3, DataBuffer var4, INDArray var5, double var6, double var8);

    protected abstract void sroti(long var1, INDArray var3, DataBuffer var4, INDArray var5, double var6, double var8);

    protected abstract void hroti(long var1, INDArray var3, DataBuffer var4, INDArray var5, double var6, double var8);

    protected abstract void dscal(long var1, double var3, INDArray var5, int var6);

    protected abstract void sscal(long var1, double var3, INDArray var5, int var6);

    protected abstract void hscal(long var1, double var3, INDArray var5, int var6);
}

