/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.activations;

import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.linalg.activations.IActivation;
import org.nd4j.linalg.activations.impl.ActivationCube;
import org.nd4j.linalg.activations.impl.ActivationELU;
import org.nd4j.linalg.activations.impl.ActivationGELU;
import org.nd4j.linalg.activations.impl.ActivationHardSigmoid;
import org.nd4j.linalg.activations.impl.ActivationHardTanH;
import org.nd4j.linalg.activations.impl.ActivationIdentity;
import org.nd4j.linalg.activations.impl.ActivationLReLU;
import org.nd4j.linalg.activations.impl.ActivationRReLU;
import org.nd4j.linalg.activations.impl.ActivationRationalTanh;
import org.nd4j.linalg.activations.impl.ActivationReLU;
import org.nd4j.linalg.activations.impl.ActivationReLU6;
import org.nd4j.linalg.activations.impl.ActivationRectifiedTanh;
import org.nd4j.linalg.activations.impl.ActivationSELU;
import org.nd4j.linalg.activations.impl.ActivationSigmoid;
import org.nd4j.linalg.activations.impl.ActivationSoftPlus;
import org.nd4j.linalg.activations.impl.ActivationSoftSign;
import org.nd4j.linalg.activations.impl.ActivationSoftmax;
import org.nd4j.linalg.activations.impl.ActivationSwish;
import org.nd4j.linalg.activations.impl.ActivationTanH;
import org.nd4j.linalg.activations.impl.ActivationThresholdedReLU;

public enum Activation {
    CUBE,
    ELU,
    HARDSIGMOID,
    HARDTANH,
    IDENTITY,
    LEAKYRELU,
    RATIONALTANH,
    RELU,
    RELU6,
    RRELU,
    SIGMOID,
    SOFTMAX,
    SOFTPLUS,
    SOFTSIGN,
    TANH,
    RECTIFIEDTANH,
    SELU,
    SWISH,
    THRESHOLDEDRELU,
    GELU;


    public IActivation getActivationFunction() {
        switch (this) {
            case CUBE: {
                return new ActivationCube();
            }
            case ELU: {
                return new ActivationELU();
            }
            case HARDSIGMOID: {
                return new ActivationHardSigmoid();
            }
            case HARDTANH: {
                return new ActivationHardTanH();
            }
            case IDENTITY: {
                return new ActivationIdentity();
            }
            case LEAKYRELU: {
                return new ActivationLReLU();
            }
            case RATIONALTANH: {
                return new ActivationRationalTanh();
            }
            case RECTIFIEDTANH: {
                return new ActivationRectifiedTanh();
            }
            case RELU: {
                return new ActivationReLU();
            }
            case RELU6: {
                return new ActivationReLU6();
            }
            case SELU: {
                return new ActivationSELU();
            }
            case SWISH: {
                return new ActivationSwish();
            }
            case RRELU: {
                return new ActivationRReLU();
            }
            case SIGMOID: {
                return new ActivationSigmoid();
            }
            case SOFTMAX: {
                return new ActivationSoftmax();
            }
            case SOFTPLUS: {
                return new ActivationSoftPlus();
            }
            case SOFTSIGN: {
                return new ActivationSoftSign();
            }
            case TANH: {
                return new ActivationTanH();
            }
            case THRESHOLDEDRELU: {
                return new ActivationThresholdedReLU();
            }
            case GELU: {
                return new ActivationGELU();
            }
        }
        throw new UnsupportedOperationException("Unknown or not supported activation function: " + (Object)((Object)this));
    }

    public static Activation fromString(String name) {
        return Activation.valueOf(name.toUpperCase());
    }

    public SDVariable asSameDiff(SameDiff sd, SDVariable input) {
        return this.asSameDiff(null, sd, input);
    }

    public SDVariable asSameDiff(String variableName, SameDiff sd, SDVariable input) {
        switch (this) {
            case CUBE: {
                return sd.math().pow(variableName, input, 3.0);
            }
            case ELU: {
                return sd.nn().elu(variableName, input);
            }
            case HARDTANH: {
                return sd.nn().hardTanh(variableName, input);
            }
            case IDENTITY: {
                return sd.identity(variableName, input);
            }
            case LEAKYRELU: {
                return sd.nn().leakyRelu(variableName, input, 0.0);
            }
            case RELU: {
                return sd.nn().relu(variableName, input, 0.0);
            }
            case SIGMOID: {
                return sd.nn().sigmoid(variableName, input);
            }
            case SOFTMAX: {
                return sd.nn().softmax(variableName, input);
            }
            case SOFTPLUS: {
                return sd.nn().softplus(variableName, input);
            }
            case SOFTSIGN: {
                return sd.nn().softsign(variableName, input);
            }
            case TANH: {
                return sd.math().tanh(variableName, input);
            }
            case GELU: {
                return sd.nn().gelu(variableName, input);
            }
        }
        throw new UnsupportedOperationException("Activation function not yet supported: " + (Object)((Object)this));
    }
}

