/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.imports.graphmapper.onnx;

import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import onnx.Onnx;
import org.nd4j.autodiff.functions.DifferentialFunction;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.imports.NoOpNameFoundException;
import org.nd4j.imports.converters.DifferentialFunctionClassHolder;
import org.nd4j.imports.descriptors.properties.AttributeAdapter;
import org.nd4j.imports.descriptors.properties.PropertyMapping;
import org.nd4j.imports.graphmapper.BaseGraphMapper;
import org.nd4j.imports.graphmapper.ImportState;
import org.nd4j.imports.graphmapper.OpImportFilter;
import org.nd4j.imports.graphmapper.OpImportOverride;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.exception.ND4JIllegalStateException;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.util.ArrayUtil;
import org.nd4j.shade.guava.primitives.Floats;
import org.nd4j.shade.guava.primitives.Ints;
import org.nd4j.shade.guava.primitives.Longs;
import org.nd4j.shade.protobuf.ByteString;
import org.nd4j.shade.protobuf.Message;

public class OnnxGraphMapper
extends BaseGraphMapper<Onnx.GraphProto, Onnx.NodeProto, Onnx.AttributeProto, Onnx.TypeProto.Tensor> {
    private static OnnxGraphMapper INSTANCE = new OnnxGraphMapper();

    public static OnnxGraphMapper getInstance() {
        return INSTANCE;
    }

    @Override
    public void dumpBinaryProtoAsText(InputStream inputFile, File outputFile) {
        try {
            Onnx.ModelProto graphDef = Onnx.ModelProto.parseFrom(inputFile);
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(outputFile, true));
            for (Onnx.NodeProto node : graphDef.getGraph().getNodeList()) {
                bufferedWriter.write(node.toString() + "\n");
            }
            bufferedWriter.flush();
            bufferedWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void initFunctionFromProperties(String mappedTfName, DifferentialFunction on, Map<String, Onnx.AttributeProto> attributesForNode, Onnx.NodeProto node, Onnx.GraphProto graph) {
        Map<String, Map<String, PropertyMapping>> properties = on.mappingsForFunction();
        Map<String, PropertyMapping> tfProperties = properties.get(mappedTfName);
        Map<String, Field> fields = DifferentialFunctionClassHolder.getInstance().getFieldsForFunction(on);
        Map<String, Map<String, AttributeAdapter>> attributeAdapters = on.attributeAdaptersForFunction();
        for (Map.Entry<String, PropertyMapping> entry : tfProperties.entrySet()) {
            String tfAttrName = entry.getValue().getTfAttrName();
            Field currentField = fields.get(entry.getKey());
            AttributeAdapter adapter = null;
            if (tfAttrName == null || currentField == null) continue;
            if (attributeAdapters != null && !attributeAdapters.isEmpty()) {
                AttributeAdapter adapterFor;
                Map<String, AttributeAdapter> mappers = attributeAdapters.get(on.tensorflowName());
                adapter = adapterFor = mappers.get(entry.getKey());
            }
            if (!attributesForNode.containsKey(tfAttrName)) continue;
            Onnx.AttributeProto attr = attributesForNode.get(tfAttrName);
            switch (attr.getType()) {
                case STRING: {
                    String setString = attr.getS().toStringUtf8();
                    if (adapter != null) {
                        adapter.mapAttributeFor(setString, currentField, on);
                        break;
                    }
                    on.setValueFor(currentField, setString);
                    break;
                }
                case INT: {
                    int setInt = (int)attr.getI();
                    if (adapter != null) {
                        adapter.mapAttributeFor(setInt, currentField, on);
                        break;
                    }
                    on.setValueFor(currentField, setInt);
                    break;
                }
                case INTS: {
                    List<Long> setList = attr.getIntsList();
                    if (setList.isEmpty()) break;
                    int[] intList = Ints.toArray(setList);
                    if (adapter != null) {
                        adapter.mapAttributeFor(intList, currentField, on);
                        break;
                    }
                    on.setValueFor(currentField, intList);
                    break;
                }
                case FLOATS: {
                    List<Float> floatsList = attr.getFloatsList();
                    if (floatsList.isEmpty()) break;
                    float[] floats = Floats.toArray(floatsList);
                    if (adapter != null) {
                        adapter.mapAttributeFor(floats, currentField, on);
                        break;
                    }
                    on.setValueFor(currentField, floats);
                    break;
                }
                case TENSOR: {
                    INDArray tensorToGet = this.mapTensorProto(attr.getT());
                    if (adapter != null) {
                        adapter.mapAttributeFor(tensorToGet, currentField, on);
                        break;
                    }
                    on.setValueFor(currentField, tensorToGet);
                }
            }
        }
    }

    @Override
    public boolean isOpIgnoreException(Onnx.NodeProto node) {
        return false;
    }

    @Override
    public String getTargetMappingForOp(DifferentialFunction function, Onnx.NodeProto node) {
        return function.opName();
    }

    @Override
    public void mapProperty(String name, DifferentialFunction on, Onnx.NodeProto node, Onnx.GraphProto graph, SameDiff sameDiff, Map<String, Map<String, PropertyMapping>> propertyMappingsForFunction) {
        PropertyMapping mapping = propertyMappingsForFunction.get(name).get(this.getTargetMappingForOp(on, node));
        Map<String, Field> fields = DifferentialFunctionClassHolder.getInstance().getFieldsForFunction(on);
        Map<String, Object> propsForFunction = on.propertiesForFunction();
        if (mapping.getTfAttrName() == null) {
            int tfMappingIdx = mapping.getTfInputPosition();
            if (tfMappingIdx < 0) {
                tfMappingIdx += node.getInputCount();
            }
            String input = node.getInput(tfMappingIdx);
            Onnx.NodeProto inputNode = OnnxGraphMapper.getInstance().getNodeWithNameFromGraph(graph, input);
            INDArray arr = sameDiff.getArrForVarName(input);
            Field field = fields.get(mapping.getPropertyNames()[0]);
            Class<?> type = field.getType();
            if (type.equals(int[].class)) {
                try {
                    field.set(arr.data().asInt(), on);
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            } else if (type.equals(Integer.TYPE) || type.equals(Long.TYPE) || type.equals(Long.class) || type.equals(Integer.class)) {
                try {
                    field.set(arr.getInt(0), on);
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            } else if (type.equals(Float.TYPE) || type.equals(Double.TYPE) || type.equals(Float.class) || type.equals(Double.class)) {
                try {
                    field.set(arr.getDouble(0L), on);
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
        } else {
            String tfMappingAttrName = mapping.getOnnxAttrName();
            Onnx.AttributeProto attr = this.getAttrMap(node).get(tfMappingAttrName);
            Onnx.AttributeProto.AttributeType type = attr.getType();
            Field field = fields.get(mapping.getPropertyNames()[0]);
            Number valueToSet = null;
            switch (type) {
                case INT: {
                    valueToSet = attr.getI();
                    break;
                }
                case FLOAT: {
                    valueToSet = Float.valueOf(attr.getF());
                    break;
                }
                case STRING: {
                    valueToSet = Float.valueOf(attr.getF());
                }
            }
            try {
                field.set(valueToSet, on);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public Onnx.NodeProto getNodeWithNameFromGraph(Onnx.GraphProto graph, String name) {
        for (int i = 0; i < graph.getNodeCount(); ++i) {
            Onnx.NodeProto node = graph.getNode(i);
            if (!node.getName().equals(name)) continue;
            return node;
        }
        return null;
    }

    @Override
    public boolean isPlaceHolderNode(Onnx.TypeProto.Tensor node) {
        return false;
    }

    @Override
    public List<String> getControlDependencies(Onnx.NodeProto node) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public void dumpBinaryProtoAsText(File inputFile, File outputFile) {
        try {
            Onnx.ModelProto graphDef = Onnx.ModelProto.parseFrom(new BufferedInputStream(new FileInputStream(inputFile)));
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(outputFile, true));
            for (Onnx.NodeProto node : graphDef.getGraph().getNodeList()) {
                bufferedWriter.write(node.toString());
            }
            bufferedWriter.flush();
            bufferedWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public DifferentialFunction getMappedOp(String name) {
        return DifferentialFunctionClassHolder.getInstance().getOpWithOnnxName(name);
    }

    @Override
    public Map<String, Onnx.TypeProto.Tensor> variablesForGraph(Onnx.GraphProto graphProto) {
        int i;
        HashMap<String, Onnx.TypeProto.Tensor> ret = new HashMap<String, Onnx.TypeProto.Tensor>();
        for (i = 0; i < graphProto.getInputCount(); ++i) {
            ret.put(graphProto.getInput(i).getName(), graphProto.getInput(i).getType().getTensorType());
        }
        for (i = 0; i < graphProto.getOutputCount(); ++i) {
            ret.put(graphProto.getOutput(i).getName(), graphProto.getOutput(i).getType().getTensorType());
        }
        for (i = 0; i < graphProto.getNodeCount(); ++i) {
            int j;
            String name;
            Onnx.NodeProto node = graphProto.getNode(i);
            String string = name = node.getName().isEmpty() ? String.valueOf(i) : node.getName();
            if (!ret.containsKey(name)) {
                this.addDummyTensor(name, ret);
            }
            for (j = 0; j < node.getInputCount(); ++j) {
                if (ret.containsKey(node.getInput(j))) continue;
                this.addDummyTensor(node.getInput(j), ret);
            }
            for (j = 0; j < node.getOutputCount(); ++j) {
                if (ret.containsKey(node.getOutput(j))) continue;
                this.addDummyTensor(node.getOutput(j), ret);
            }
        }
        return ret;
    }

    @Override
    public String translateToSameDiffName(String name, Onnx.NodeProto node) {
        return null;
    }

    protected void addDummyTensor(String name, Map<String, Onnx.TypeProto.Tensor> to) {
        Onnx.TensorShapeProto.Dimension dim = Onnx.TensorShapeProto.Dimension.newBuilder().setDimValue(-1L).build();
        Onnx.TypeProto.Tensor typeProto = Onnx.TypeProto.Tensor.newBuilder().setShape(Onnx.TensorShapeProto.newBuilder().addDim(dim).addDim(dim).build()).build();
        to.put(name, typeProto);
    }

    @Override
    public Message.Builder getNewGraphBuilder() {
        return Onnx.GraphProto.newBuilder();
    }

    @Override
    public Onnx.GraphProto parseGraphFrom(byte[] inputStream) throws IOException {
        return Onnx.ModelProto.parseFrom(inputStream).getGraph();
    }

    @Override
    public Onnx.GraphProto parseGraphFrom(InputStream inputStream) throws IOException {
        return Onnx.ModelProto.parseFrom(inputStream).getGraph();
    }

    @Override
    public void mapNodeType(Onnx.NodeProto tfNode, ImportState<Onnx.GraphProto, Onnx.TypeProto.Tensor> importState, OpImportOverride<Onnx.GraphProto, Onnx.NodeProto, Onnx.AttributeProto> opImportOverride, OpImportFilter<Onnx.GraphProto, Onnx.NodeProto, Onnx.AttributeProto> opFilter) {
        DifferentialFunction differentialFunction = DifferentialFunctionClassHolder.getInstance().getOpWithOnnxName(tfNode.getOpType());
        if (differentialFunction == null) {
            throw new NoOpNameFoundException("No op name found " + tfNode.getOpType());
        }
        SameDiff diff = importState.getSameDiff();
        int idx = importState.getGraph().getNodeList().indexOf(tfNode);
        String name = !tfNode.getName().isEmpty() ? tfNode.getName() : String.valueOf(idx);
        try {
            DifferentialFunction newInstance = (DifferentialFunction)differentialFunction.getClass().newInstance();
            SDVariable[] args = new SDVariable[tfNode.getInputCount()];
            newInstance.setSameDiff(importState.getSameDiff());
            newInstance.initFromOnnx(tfNode, diff, this.getAttrMap(tfNode), importState.getGraph());
            importState.getSameDiff().putOpForId(newInstance.getOwnName(), newInstance);
            diff.setBaseNameForFunctionInstanceId(tfNode.getName(), newInstance);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public DataType dataTypeForTensor(Onnx.TypeProto.Tensor tensorProto, int outputNum) {
        return this.nd4jTypeFromOnnxType(tensorProto.getElemType());
    }

    @Override
    public boolean isStringType(Onnx.TypeProto.Tensor tensor) {
        return tensor.getElemType() == Onnx.TensorProto.DataType.STRING;
    }

    public DataType nd4jTypeFromOnnxType(Onnx.TensorProto.DataType dataType) {
        switch (dataType) {
            case DOUBLE: {
                return DataType.DOUBLE;
            }
            case FLOAT: {
                return DataType.FLOAT;
            }
            case FLOAT16: {
                return DataType.HALF;
            }
            case INT32: 
            case INT64: {
                return DataType.INT;
            }
        }
        return DataType.UNKNOWN;
    }

    @Override
    public String getAttrValueFromNode(Onnx.NodeProto nodeProto, String key) {
        for (Onnx.AttributeProto attributeProto : nodeProto.getAttributeList()) {
            if (!attributeProto.getName().equals(key)) continue;
            return attributeProto.getS().toString();
        }
        throw new ND4JIllegalStateException("No key found for " + key);
    }

    @Override
    public long[] getShapeFromAttribute(Onnx.AttributeProto attributeProto) {
        return Longs.toArray(attributeProto.getT().getDimsList());
    }

    @Override
    public boolean isPlaceHolder(Onnx.TypeProto.Tensor nodeType) {
        return false;
    }

    @Override
    public boolean isConstant(Onnx.TypeProto.Tensor nodeType) {
        return false;
    }

    @Override
    public INDArray getNDArrayFromTensor(String tensorName, Onnx.TypeProto.Tensor tensorProto, Onnx.GraphProto graph) {
        DataType type = this.dataTypeForTensor(tensorProto, 0);
        if (!tensorProto.isInitialized()) {
            throw new ND4JIllegalStateException("Unable to retrieve ndarray. Tensor was not initialized");
        }
        Onnx.TensorProto tensor = null;
        for (int i = 0; i < graph.getInitializerCount(); ++i) {
            Onnx.TensorProto initializer = graph.getInitializer(i);
            if (!initializer.getName().equals(tensorName)) continue;
            tensor = initializer;
            break;
        }
        if (tensor == null) {
            return null;
        }
        ByteString bytes = tensor.getRawData();
        ByteBuffer byteBuffer = bytes.asReadOnlyByteBuffer().order(ByteOrder.nativeOrder());
        ByteBuffer directAlloc = ByteBuffer.allocateDirect(byteBuffer.capacity()).order(ByteOrder.nativeOrder());
        directAlloc.put(byteBuffer);
        directAlloc.rewind();
        long[] shape = this.getShapeFromTensor(tensorProto);
        DataBuffer buffer = Nd4j.createBuffer(directAlloc, type, ArrayUtil.prod((long[])shape));
        INDArray arr = Nd4j.create(buffer).reshape(shape);
        return arr;
    }

    public INDArray mapTensorProto(Onnx.TensorProto tensor) {
        if (tensor == null) {
            return null;
        }
        DataType type = this.nd4jTypeFromOnnxType(tensor.getDataType());
        ByteString bytes = tensor.getRawData();
        ByteBuffer byteBuffer = bytes.asReadOnlyByteBuffer().order(ByteOrder.nativeOrder());
        ByteBuffer directAlloc = ByteBuffer.allocateDirect(byteBuffer.capacity()).order(ByteOrder.nativeOrder());
        directAlloc.put(byteBuffer);
        directAlloc.rewind();
        long[] shape = this.getShapeFromTensor(tensor);
        DataBuffer buffer = Nd4j.createBuffer(directAlloc, type, ArrayUtil.prod((long[])shape));
        INDArray arr = Nd4j.create(buffer).reshape(shape);
        return arr;
    }

    @Override
    public long[] getShapeFromTensor(Onnx.TypeProto.Tensor tensorProto) {
        long[] ret = new long[Math.max(2, tensorProto.getShape().getDimCount())];
        int dimCount = tensorProto.getShape().getDimCount();
        if (dimCount >= 2) {
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (int)tensorProto.getShape().getDim(i).getDimValue();
            }
        } else {
            ret[0] = 1L;
            for (int i = 1; i < ret.length; ++i) {
                ret[i] = (int)tensorProto.getShape().getDim(i - 1).getDimValue();
            }
        }
        return ret;
    }

    @Override
    public long[] getShapeFromTensor(Onnx.TensorProto tensorProto) {
        long[] ret = new long[Math.max(2, tensorProto.getDimsCount())];
        int dimCount = tensorProto.getDimsCount();
        if (dimCount >= 2) {
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (int)tensorProto.getDims(i);
            }
        } else {
            ret[0] = 1L;
            for (int i = 1; i < ret.length; ++i) {
                ret[i] = (int)tensorProto.getDims(i - 1);
            }
        }
        return ret;
    }

    @Override
    public Set<String> opsToIgnore() {
        return Collections.emptySet();
    }

    @Override
    public String getInputFromNode(Onnx.NodeProto node, int index) {
        return node.getInput(index);
    }

    @Override
    public int numInputsFor(Onnx.NodeProto nodeProto) {
        return nodeProto.getInputCount();
    }

    @Override
    public long[] getShapeFromAttr(Onnx.AttributeProto attr) {
        return Longs.toArray(attr.getT().getDimsList());
    }

    @Override
    public Map<String, Onnx.AttributeProto> getAttrMap(Onnx.NodeProto nodeProto) {
        HashMap<String, Onnx.AttributeProto> proto = new HashMap<String, Onnx.AttributeProto>();
        for (int i = 0; i < nodeProto.getAttributeCount(); ++i) {
            Onnx.AttributeProto attributeProto = nodeProto.getAttribute(i);
            proto.put(attributeProto.getName(), attributeProto);
        }
        return proto;
    }

    @Override
    public String getName(Onnx.NodeProto nodeProto) {
        return nodeProto.getName();
    }

    @Override
    public boolean alreadySeen(Onnx.NodeProto nodeProto) {
        return false;
    }

    @Override
    public boolean isVariableNode(Onnx.NodeProto nodeProto) {
        return nodeProto.getOpType().contains("Var");
    }

    @Override
    public boolean shouldSkip(Onnx.NodeProto opType) {
        return false;
    }

    @Override
    public boolean hasShape(Onnx.NodeProto nodeProto) {
        return false;
    }

    @Override
    public long[] getShape(Onnx.NodeProto nodeProto) {
        return null;
    }

    @Override
    public INDArray getArrayFrom(Onnx.NodeProto nodeProto, Onnx.GraphProto graph) {
        return null;
    }

    @Override
    public String getOpType(Onnx.NodeProto nodeProto) {
        return nodeProto.getOpType();
    }

    @Override
    public List<Onnx.NodeProto> getNodeList(Onnx.GraphProto graphProto) {
        return graphProto.getNodeList();
    }
}

