/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.evaluation.custom;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;
import org.nd4j.evaluation.BaseEvaluation;
import org.nd4j.evaluation.IEvaluation;
import org.nd4j.evaluation.IMetric;
import org.nd4j.evaluation.custom.EvaluationLambda;
import org.nd4j.evaluation.custom.MergeLambda;
import org.nd4j.evaluation.custom.ResultLambda;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.shade.guava.collect.Lists;

public class CustomEvaluation<T>
extends BaseEvaluation<CustomEvaluation> {
    @NonNull
    private EvaluationLambda<T> evaluationLambda;
    @NonNull
    private MergeLambda<T> mergeLambda;
    private List<T> evaluations = new ArrayList<T>();

    public static <R> MergeLambda<R> mergeConcatenate() {
        return new MergeLambda<R>(){

            @Override
            public List<R> merge(List<R> a, List<R> b) {
                ArrayList res = Lists.newArrayList(a);
                res.addAll(b);
                return res;
            }
        };
    }

    @Override
    public void eval(INDArray labels, INDArray networkPredictions, INDArray maskArray, List<? extends Serializable> recordMetaData) {
        this.evaluations.add(this.evaluationLambda.eval(labels, networkPredictions, maskArray, recordMetaData));
    }

    @Override
    public void merge(CustomEvaluation other) {
        this.evaluations = this.mergeLambda.merge(this.evaluations, other.evaluations);
    }

    @Override
    public void reset() {
        this.evaluations = new ArrayList<T>();
    }

    @Override
    public String stats() {
        return "";
    }

    @Override
    public double getValue(IMetric metric) {
        if (metric instanceof Metric) {
            return ((Metric)metric).getGetResult().toResult(this.evaluations);
        }
        throw new IllegalStateException("Can't get value for non-regression Metric " + metric);
    }

    @Override
    public CustomEvaluation<T> newInstance() {
        return new CustomEvaluation<T>(this.evaluationLambda, this.mergeLambda);
    }

    public CustomEvaluation(@NonNull EvaluationLambda<T> evaluationLambda, @NonNull MergeLambda<T> mergeLambda) {
        if (evaluationLambda == null) {
            throw new NullPointerException("evaluationLambda is marked @NonNull but is null");
        }
        if (mergeLambda == null) {
            throw new NullPointerException("mergeLambda is marked @NonNull but is null");
        }
        this.evaluationLambda = evaluationLambda;
        this.mergeLambda = mergeLambda;
    }

    @NonNull
    public EvaluationLambda<T> getEvaluationLambda() {
        return this.evaluationLambda;
    }

    @NonNull
    public MergeLambda<T> getMergeLambda() {
        return this.mergeLambda;
    }

    public List<T> getEvaluations() {
        return this.evaluations;
    }

    public void setEvaluationLambda(@NonNull EvaluationLambda<T> evaluationLambda) {
        if (evaluationLambda == null) {
            throw new NullPointerException("evaluationLambda is marked @NonNull but is null");
        }
        this.evaluationLambda = evaluationLambda;
    }

    public void setMergeLambda(@NonNull MergeLambda<T> mergeLambda) {
        if (mergeLambda == null) {
            throw new NullPointerException("mergeLambda is marked @NonNull but is null");
        }
        this.mergeLambda = mergeLambda;
    }

    public void setEvaluations(List<T> evaluations) {
        this.evaluations = evaluations;
    }

    @Override
    public String toString() {
        return "CustomEvaluation(evaluationLambda=" + this.getEvaluationLambda() + ", mergeLambda=" + this.getMergeLambda() + ", evaluations=" + this.getEvaluations() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CustomEvaluation)) {
            return false;
        }
        CustomEvaluation other = (CustomEvaluation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EvaluationLambda<T> this$evaluationLambda = this.getEvaluationLambda();
        EvaluationLambda<T> other$evaluationLambda = other.getEvaluationLambda();
        if (this$evaluationLambda == null ? other$evaluationLambda != null : !this$evaluationLambda.equals(other$evaluationLambda)) {
            return false;
        }
        MergeLambda<T> this$mergeLambda = this.getMergeLambda();
        MergeLambda<T> other$mergeLambda = other.getMergeLambda();
        if (this$mergeLambda == null ? other$mergeLambda != null : !this$mergeLambda.equals(other$mergeLambda)) {
            return false;
        }
        List<T> this$evaluations = this.getEvaluations();
        List<T> other$evaluations = other.getEvaluations();
        return !(this$evaluations == null ? other$evaluations != null : !((Object)this$evaluations).equals(other$evaluations));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof CustomEvaluation;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        EvaluationLambda<T> $evaluationLambda = this.getEvaluationLambda();
        result = result * 59 + ($evaluationLambda == null ? 43 : $evaluationLambda.hashCode());
        MergeLambda<T> $mergeLambda = this.getMergeLambda();
        result = result * 59 + ($mergeLambda == null ? 43 : $mergeLambda.hashCode());
        List<T> $evaluations = this.getEvaluations();
        result = result * 59 + ($evaluations == null ? 43 : ((Object)$evaluations).hashCode());
        return result;
    }

    public static class Metric<T>
    implements IMetric {
        @NonNull
        private ResultLambda<T> getResult;
        private boolean minimize = false;

        @Override
        public Class<? extends IEvaluation> getEvaluationClass() {
            return CustomEvaluation.class;
        }

        @Override
        public boolean minimize() {
            return this.minimize;
        }

        public static Metric<Double> doubleAverage(boolean minimize) {
            return new Metric<Double>(new ResultLambda<Double>(){

                @Override
                public double toResult(List<Double> data) {
                    int count = 0;
                    double sum = 0.0;
                    for (Double d : data) {
                        ++count;
                        sum += d.doubleValue();
                    }
                    return sum / (double)count;
                }
            }, minimize);
        }

        public static Metric<Double> doubleMax(boolean minimize) {
            return new Metric<Double>(new ResultLambda<Double>(){

                @Override
                public double toResult(List<Double> data) {
                    double max = 0.0;
                    for (Double d : data) {
                        if (!(d > max)) continue;
                        max = d;
                    }
                    return max;
                }
            }, minimize);
        }

        public static Metric<Double> doubleMin(boolean minimize) {
            return new Metric<Double>(new ResultLambda<Double>(){

                @Override
                public double toResult(List<Double> data) {
                    double max = 0.0;
                    for (Double d : data) {
                        if (!(d < max)) continue;
                        max = d;
                    }
                    return max;
                }
            }, minimize);
        }

        public Metric(@NonNull ResultLambda<T> getResult, boolean minimize) {
            if (getResult == null) {
                throw new NullPointerException("getResult is marked @NonNull but is null");
            }
            this.getResult = getResult;
            this.minimize = minimize;
        }

        public Metric(@NonNull ResultLambda<T> getResult) {
            if (getResult == null) {
                throw new NullPointerException("getResult is marked @NonNull but is null");
            }
            this.getResult = getResult;
        }

        @NonNull
        public ResultLambda<T> getGetResult() {
            return this.getResult;
        }
    }
}

