/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.factory;

import com.google.common.base.Function;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.ref.ReferenceQueue;
import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Random;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import lombok.NonNull;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.apache.commons.lang3.ArrayUtils;
import org.bytedeco.javacpp.DoublePointer;
import org.bytedeco.javacpp.FloatPointer;
import org.bytedeco.javacpp.IntPointer;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.indexer.HalfIndexer;
import org.bytedeco.javacpp.indexer.Indexer;
import org.nd4j.autodiff.samediff.serde.FlatBuffersMapper;
import org.nd4j.base.Preconditions;
import org.nd4j.context.Nd4jContext;
import org.nd4j.graph.FlatArray;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.buffer.factory.DataBufferFactory;
import org.nd4j.linalg.api.buffer.factory.DefaultDataBufferFactory;
import org.nd4j.linalg.api.buffer.util.DataTypeUtil;
import org.nd4j.linalg.api.concurrency.AffinityManager;
import org.nd4j.linalg.api.concurrency.BasicAffinityManager;
import org.nd4j.linalg.api.instrumentation.InMemoryInstrumentation;
import org.nd4j.linalg.api.instrumentation.Instrumentation;
import org.nd4j.linalg.api.memory.MemoryWorkspaceManager;
import org.nd4j.linalg.api.ndarray.BaseShapeInfoProvider;
import org.nd4j.linalg.api.ndarray.BaseSparseInfoProvider;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ndarray.ShapeInfoProvider;
import org.nd4j.linalg.api.ndarray.SparseInfoProvider;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.nd4j.linalg.api.ops.executioner.DefaultOpExecutioner;
import org.nd4j.linalg.api.ops.executioner.OpExecutioner;
import org.nd4j.linalg.api.ops.factory.DefaultOpFactory;
import org.nd4j.linalg.api.ops.factory.OpFactory;
import org.nd4j.linalg.api.ops.impl.indexaccum.IMax;
import org.nd4j.linalg.api.ops.impl.indexaccum.IMin;
import org.nd4j.linalg.api.ops.impl.shape.Diag;
import org.nd4j.linalg.api.ops.impl.shape.DiagPart;
import org.nd4j.linalg.api.ops.impl.shape.Stack;
import org.nd4j.linalg.api.ops.impl.transforms.OldReverse;
import org.nd4j.linalg.api.ops.impl.transforms.ReplaceNans;
import org.nd4j.linalg.api.ops.random.custom.RandomExponential;
import org.nd4j.linalg.api.ops.random.impl.BernoulliDistribution;
import org.nd4j.linalg.api.ops.random.impl.BinomialDistribution;
import org.nd4j.linalg.api.ops.random.impl.Choice;
import org.nd4j.linalg.api.ops.random.impl.GaussianDistribution;
import org.nd4j.linalg.api.ops.random.impl.Linspace;
import org.nd4j.linalg.api.ops.random.impl.UniformDistribution;
import org.nd4j.linalg.api.rng.DefaultRandom;
import org.nd4j.linalg.api.rng.distribution.Distribution;
import org.nd4j.linalg.api.rng.distribution.factory.DefaultDistributionFactory;
import org.nd4j.linalg.api.rng.distribution.factory.DistributionFactory;
import org.nd4j.linalg.api.shape.Shape;
import org.nd4j.linalg.cache.BasicConstantHandler;
import org.nd4j.linalg.cache.ConstantHandler;
import org.nd4j.linalg.compression.BasicNDArrayCompressor;
import org.nd4j.linalg.compression.CompressedDataBuffer;
import org.nd4j.linalg.convolution.ConvolutionInstance;
import org.nd4j.linalg.convolution.DefaultConvolutionInstance;
import org.nd4j.linalg.env.EnvironmentalAction;
import org.nd4j.linalg.exception.ND4JArraySizeException;
import org.nd4j.linalg.exception.ND4JIllegalStateException;
import org.nd4j.linalg.factory.BlasWrapper;
import org.nd4j.linalg.factory.NDArrayFactory;
import org.nd4j.linalg.factory.Nd4jBackend;
import org.nd4j.linalg.factory.RandomFactory;
import org.nd4j.linalg.memory.BasicMemoryManager;
import org.nd4j.linalg.memory.MemoryManager;
import org.nd4j.linalg.primitives.Pair;
import org.nd4j.linalg.string.NDArrayStrings;
import org.nd4j.linalg.util.ArrayUtil;
import org.nd4j.tools.PropertyParser;
import org.nd4j.versioncheck.VersionCheck;

public class Nd4j {
    public static final String NUMERICAL_STABILITY = "force.stability";
    public static final String DATA_BUFFER_OPS = "databufferfactory";
    public static final String CONVOLUTION_OPS = "convops";
    @Deprecated
    public static final String DTYPE = "dtype";
    public static final String BLAS_OPS = "blas.ops";
    public static final String SPARSE_BLAS_OPS = "sparseblas.ops";
    public static final String NATIVE_OPS = "native.ops";
    public static final String ORDER_KEY = "ndarray.order";
    public static final String NDARRAY_FACTORY_CLASS = "ndarrayfactory.class";
    public static final String SPARSE_NDARRAY_FACTORY_CLASS = "sparsendarrayfactory.class";
    public static final String COPY_OPS = "ndarray.copyops";
    public static final String OP_EXECUTIONER = "opexec";
    public static final String OP_FACTORY = "opfactory";
    public static final String DISTRIBUTION = "dist";
    public static final String INSTRUMENTATION = "instrumentation";
    public static final String INSTRUMENTATION_CLASS = "instrumentation.class";
    public static final String RESOURCE_MANGER_ON = "resourcemanager_state";
    public static final String EXECUTION_MODE = "opexec.mode";
    public static final String SHAPEINFO_PROVIDER = "shapeinfoprovider";
    public static final String SPARSEINFO_PROVIDER = "sparseinfoprovider";
    public static final String CONSTANT_PROVIDER = "constantsprovider";
    public static final String AFFINITY_MANAGER = "affinitymanager";
    public static final String COMPRESSION_DEBUG = "compressiondebug";
    public static final String MEMORY_MANAGER = "memorymanager";
    public static final String WORKSPACE_MANAGER = "workspacemanager";
    public static final String RANDOM_PROVIDER = "random";
    @Deprecated
    public static final String LOG_INIT_ENV_PROPERTY = "org.nd4j.log.initialization";
    public static OpExecutioner.ExecutionMode executionMode = OpExecutioner.ExecutionMode.JAVA;
    protected static DataBuffer.Type dtype = DataBuffer.Type.FLOAT;
    public static DataBuffer.AllocationMode alloc = DataBuffer.AllocationMode.HEAP;
    public static char ORDER = (char)99;
    public static double EPS_THRESHOLD = 1.0E-5;
    public static int MAX_ELEMENTS_PER_SLICE = 3;
    public static int MAX_SLICES_TO_PRINT = 3;
    public static boolean ENFORCE_NUMERICAL_STABILITY = false;
    public static boolean copyOnOps = true;
    public static boolean shouldInstrument = false;
    public static boolean resourceManagerOn = false;
    private static boolean allowsOrder = false;
    public static boolean compressDebug = false;
    public static volatile boolean preventUnpack;
    public static Nd4jBackend backend;
    public static RandomFactory randomFactory;
    private static MemoryWorkspaceManager workspaceManager;
    private static final AtomicInteger numThreads;
    private static final AtomicBoolean skipTheadSafetyChecks;
    protected static Class<? extends MemoryWorkspaceManager> workspaceManagerClazz;
    protected static Class<? extends BlasWrapper> blasWrapperClazz;
    protected static Class<? extends BlasWrapper> sparseBlasWrapperClazz;
    protected static Class<? extends NDArrayFactory> ndArrayFactoryClazz;
    protected static Class<? extends NDArrayFactory> sparseNDArrayClazz;
    protected static Class<? extends ConvolutionInstance> convolutionInstanceClazz;
    protected static Class<? extends DataBufferFactory> dataBufferFactoryClazz;
    protected static Class<? extends OpExecutioner> opExecutionerClazz;
    protected static Class<? extends OpFactory> opFactoryClazz;
    protected static Class<? extends org.nd4j.linalg.api.rng.Random> randomClazz;
    protected static Class<? extends DistributionFactory> distributionFactoryClazz;
    protected static Class<? extends Instrumentation> instrumentationClazz;
    protected static Class<? extends BaseShapeInfoProvider> shapeInfoProviderClazz;
    protected static Class<? extends BaseSparseInfoProvider> sparseInfoProviderClazz;
    protected static Class<? extends BasicConstantHandler> constantProviderClazz;
    protected static Class<? extends BasicAffinityManager> affinityManagerClazz;
    protected static Class<? extends BasicMemoryManager> memoryManagerClazz;
    protected static DataBufferFactory DATA_BUFFER_FACTORY_INSTANCE;
    protected static BlasWrapper BLAS_WRAPPER_INSTANCE;
    protected static BlasWrapper SPARSE_BLAS_WRAPPER_INSTANCE;
    protected static NDArrayFactory INSTANCE;
    protected static NDArrayFactory SPARSE_INSTANCE;
    protected static ConvolutionInstance CONVOLUTION_INSTANCE;
    protected static OpExecutioner OP_EXECUTIONER_INSTANCE;
    protected static DistributionFactory DISTRIBUTION_FACTORY;
    protected static OpFactory OP_FACTORY_INSTANCE;
    protected static Instrumentation instrumentation;
    protected static ShapeInfoProvider shapeInfoProvider;
    protected static SparseInfoProvider sparseInfoProvider;
    protected static ConstantHandler constantHandler;
    protected static AffinityManager affinityManager;
    protected static MemoryManager memoryManager;
    protected static AtomicBoolean fallbackMode;
    protected static Properties props;
    protected static ReferenceQueue<INDArray> referenceQueue;
    protected static ReferenceQueue<DataBuffer> bufferQueue;
    private static final Logger logger;

    public static INDArray pad(INDArray toPad, int[][] padWidth, PadMode padMode) {
        return Nd4j.pad(toPad, padWidth, (List<double[]>)ArrayUtil.zerosMatrix((long[])toPad.shape()), padMode);
    }

    public static INDArray pad(INDArray toPad, int[][] padWidth, List<double[]> constantValues, PadMode padMode) {
        switch (padMode) {
            case CONSTANT: {
                if (padWidth.length < toPad.rank()) {
                    throw new IllegalArgumentException("Please specify a pad width for each dimension");
                }
                ArrayList<int[]> sizes = new ArrayList<int[]>();
                for (int i = 0; i < toPad.rank(); ++i) {
                    sizes.add(padWidth[i]);
                }
                INDArray ret = toPad;
                for (int i = 0; i < toPad.rank(); ++i) {
                    int[] pad = (int[])sizes.get(i);
                    double[] constant = constantValues.get(i);
                    int padBefore = pad[0];
                    int padAfter = pad[1];
                    if (constant.length < 2) {
                        double val = constant[0];
                        constant = new double[]{val, val};
                    }
                    double beforeVal = constant[0];
                    double afterVal = constant[1];
                    ret = Nd4j.prepend(ret, padBefore, beforeVal, i);
                    ret = Nd4j.append(ret, padAfter, afterVal, i);
                }
                return ret;
            }
        }
        throw new UnsupportedOperationException();
    }

    public static INDArray pad(INDArray toPad, int[] padWidth, List<double[]> constantValues, PadMode padMode) {
        switch (padMode) {
            case CONSTANT: {
                if (padWidth.length < toPad.rank()) {
                    throw new IllegalArgumentException("Please specify a pad width for each dimension");
                }
                toPad = Nd4j.stripOnes(toPad);
                ArrayList<int[]> sizes = new ArrayList<int[]>();
                for (int i = 0; i < toPad.rank(); ++i) {
                    sizes.add(padWidth);
                }
                INDArray ret = toPad;
                for (int i = 0; i < toPad.rank(); ++i) {
                    int[] pad = (int[])sizes.get(i);
                    double[] constant = constantValues.get(i);
                    int padBefore = pad[0];
                    int padAfter = pad[1];
                    if (constant.length < 2) {
                        double val = constant[0];
                        constant = new double[]{val, val};
                    }
                    double beforeVal = constant[0];
                    double afterVal = constant[1];
                    ret = Nd4j.prepend(ret, padBefore, beforeVal, i);
                    ret = Nd4j.append(ret, padAfter, afterVal, i);
                }
                return ret;
            }
        }
        throw new UnsupportedOperationException();
    }

    public static INDArray pad(INDArray toPad, int[] padWidth, PadMode padMode) {
        return Nd4j.pad(toPad, padWidth, (List<double[]>)ArrayUtil.zerosMatrix((int[])padWidth), padMode);
    }

    public static INDArray append(INDArray arr, int padAmount, double val, int axis) {
        if (padAmount == 0) {
            return arr;
        }
        long[] paShape = ArrayUtil.copy((long[])arr.shape());
        if (axis < 0) {
            axis += arr.shape().length;
        }
        paShape[axis] = padAmount;
        INDArray concatArray = Nd4j.valueArrayOf(paShape, val);
        return Nd4j.concat(axis, arr, concatArray);
    }

    public static INDArray prepend(INDArray arr, int padAmount, double val, int axis) {
        if (padAmount == 0) {
            return arr;
        }
        long[] paShape = ArrayUtil.copy((long[])arr.shape());
        if (axis < 0) {
            axis += arr.shape().length;
        }
        paShape[axis] = padAmount;
        INDArray concatArr = Nd4j.valueArrayOf(paShape, val);
        return Nd4j.concat(axis, concatArr, arr);
    }

    public static INDArray expandDims(INDArray input, int dimension) {
        if (dimension < 0) {
            dimension += input.rank();
        }
        long[] shape = input.shape();
        long[] indexes = new long[input.rank() + 1];
        for (int i = 0; i < indexes.length; ++i) {
            indexes[i] = i < dimension ? shape[i] : (i == dimension ? 1L : shape[i - 1]);
        }
        return input.reshape(input.ordering(), indexes);
    }

    public static INDArray squeeze(INDArray input, int dimension) {
        long[] shape;
        if (dimension < 0) {
            dimension += input.rank();
        }
        Preconditions.checkState(((shape = input.shape())[dimension] == 1L ? 1 : 0) != 0, (String)String.format("Squeeze: Only dimension of size 1 can be squeezed. Attempted to squeeze dimension %d of array with shape %s (size %d).", dimension, ArrayUtils.toString((Object)shape), shape[dimension]));
        long[] newShape = ArrayUtil.removeIndex((long[])shape, (int)dimension);
        return input.reshape(input.ordering(), newShape);
    }

    public static boolean allowsSpecifyOrdering() {
        return allowsOrder;
    }

    public static void shuffle(INDArray toShuffle, Random random, int ... dimension) {
        INSTANCE.shuffle(toShuffle, random, dimension);
    }

    public static void shuffle(INDArray toShuffle, int ... dimension) {
        INSTANCE.shuffle(toShuffle, new Random(), dimension);
    }

    public static void shuffle(Collection<INDArray> toShuffle, int ... dimension) {
        INSTANCE.shuffle(toShuffle, new Random(), dimension);
    }

    public static void shuffle(Collection<INDArray> toShuffle, Random rnd, int ... dimension) {
        INSTANCE.shuffle(toShuffle, rnd, dimension);
    }

    public static void shuffle(List<INDArray> toShuffle, Random rnd, List<int[]> dimensions) {
        INSTANCE.shuffle(toShuffle, rnd, dimensions);
    }

    public static ReferenceQueue<INDArray> refQueue() {
        return referenceQueue;
    }

    public static ReferenceQueue<DataBuffer> bufferRefQueue() {
        return bufferQueue;
    }

    public static Instrumentation getInstrumentation() {
        return instrumentation;
    }

    public static DistributionFactory getDistributions() {
        return DISTRIBUTION_FACTORY;
    }

    public static void setNdArrayFactoryClazz(Class<? extends NDArrayFactory> clazz) {
        ndArrayFactoryClazz = clazz;
    }

    public static void setSparseNDArrayClazz(Class<? extends NDArrayFactory> clazz) {
        sparseNDArrayClazz = clazz;
    }

    public static org.nd4j.linalg.api.rng.Random getRandom() {
        return randomFactory.getRandom();
    }

    public static RandomFactory getRandomFactory() {
        return randomFactory;
    }

    public static ConvolutionInstance getConvolution() {
        return CONVOLUTION_INSTANCE;
    }

    public static void setConvolution(ConvolutionInstance convolutionInstance) {
        if (convolutionInstance == null) {
            throw new IllegalArgumentException("No null instances allowed");
        }
        CONVOLUTION_INSTANCE = convolutionInstance;
    }

    public static long[] shape(INDArray arr) {
        return arr.shape();
    }

    public static INDArray create(int[] sliceShape, float[] ... arrays) {
        int slices = arrays.length;
        INDArray ret = Nd4j.create(ArrayUtil.combine((int[][])new int[][]{{slices}, sliceShape}));
        int i = 0;
        while ((long)i < ret.slices()) {
            ret.putSlice(i, Nd4j.create(arrays[i]).reshape(ArrayUtil.toLongArray((int[])sliceShape)));
            ++i;
        }
        return ret;
    }

    public static INDArray create(int[] sliceShape, double[] ... arrays) {
        int slices = arrays.length;
        INDArray ret = Nd4j.create(ArrayUtil.combine((int[][])new int[][]{{slices}, sliceShape}));
        int i = 0;
        while ((long)i < ret.slices()) {
            ret.putSlice(i, Nd4j.create(arrays[i]).reshape(ArrayUtil.toLongArray((int[])sliceShape)));
            ++i;
        }
        return ret;
    }

    public static OpExecutioner getExecutioner() {
        return OP_EXECUTIONER_INSTANCE;
    }

    public static OpFactory getOpFactory() {
        return OP_FACTORY_INSTANCE;
    }

    public static DataBufferFactory getDataBufferFactory() {
        return DATA_BUFFER_FACTORY_INSTANCE;
    }

    public static void setParams(INDArray theta, Collection<INDArray> ... matrices) {
        int index = 0;
        for (Collection<INDArray> matrixCollection : matrices) {
            for (INDArray matrix : matrixCollection) {
                INDArray linear = matrix.linearView();
                int i = 0;
                while ((long)i < matrix.length()) {
                    linear.putScalar((long)i, theta.getDouble((long)index));
                    ++index;
                    ++i;
                }
            }
        }
        if ((long)index != theta.length()) {
            throw new AssertionError((Object)"Did not entirely use the theta vector");
        }
    }

    public static INDArray rollAxis(INDArray a, int axis) {
        return Nd4j.rollAxis(a, axis, 0);
    }

    public static INDArray argMax(INDArray arr, int ... dimension) {
        IMax imax = new IMax(arr);
        if (dimension == null || dimension.length == 0) {
            return Nd4j.getExecutioner().exec(imax, Integer.MAX_VALUE);
        }
        return Nd4j.getExecutioner().exec(imax, dimension);
    }

    public static INDArray argMin(INDArray arr, int ... dimension) {
        IMin imin = new IMin(arr);
        if (dimension == null || dimension.length == 0) {
            return Nd4j.getExecutioner().exec(imin, Integer.MAX_VALUE);
        }
        return Nd4j.getExecutioner().exec(imin, dimension);
    }

    public static INDArray rollAxis(INDArray a, int axis, int start) {
        if (axis < 0) {
            axis += a.rank();
        }
        if (start < 0) {
            start += a.rank();
        }
        if (axis == start) {
            return a;
        }
        if (axis < start) {
            --start;
        }
        if (axis < 0 || axis >= a.rank()) {
            throw new IllegalArgumentException("Axis must be >= 0 && < start");
        }
        if (start < 0 || axis >= a.rank() + 1) {
            throw new IllegalArgumentException("Axis must be >= 0 && < start");
        }
        ArrayList<Integer> range = new ArrayList<Integer>(Ints.asList((int[])ArrayUtil.range((int)0, (int)a.rank())));
        range.remove(axis);
        range.add(start, axis);
        int[] newRange = Ints.toArray(range);
        return a.permute(newRange);
    }

    public static INDArray tensorMmul(INDArray a, INDArray b, INDArray result, int[][] axes) {
        long[] oldShapeB;
        long[] oldShapeA;
        int validationLength = Math.min(axes[0].length, axes[1].length);
        for (int i = 0; i < validationLength; ++i) {
            if (a.size(axes[0][i]) != b.size(axes[1][i])) {
                throw new IllegalArgumentException("Size of the given axes at each dimension must be the same size.");
            }
            if (axes[0][i] < 0) {
                int[] nArray = axes[0];
                int n = i;
                nArray[n] = nArray[n] + a.rank();
            }
            if (axes[1][i] >= 0) continue;
            int[] nArray = axes[1];
            int n = i;
            nArray[n] = nArray[n] + b.rank();
        }
        ArrayList<Integer> listA = new ArrayList<Integer>();
        for (int i = 0; i < a.rank(); ++i) {
            if (Ints.contains((int[])axes[0], (int)i)) continue;
            listA.add(i);
        }
        int[] newAxesA = Ints.concat((int[][])new int[][]{Ints.toArray(listA), axes[0]});
        ArrayList<Integer> listB = new ArrayList<Integer>();
        for (int i = 0; i < b.rank(); ++i) {
            if (Ints.contains((int[])axes[1], (int)i)) continue;
            listB.add(i);
        }
        int[] newAxesB = Ints.concat((int[][])new int[][]{axes[1], Ints.toArray(listB)});
        int n2 = 1;
        int aLength = Math.min(a.rank(), axes[0].length);
        for (int i = 0; i < aLength; ++i) {
            n2 = (int)((long)n2 * a.size(axes[0][i]));
        }
        long[] newShapeA = new long[]{-1L, n2};
        if (listA.size() == 0) {
            oldShapeA = new long[]{1L};
        } else {
            oldShapeA = Longs.toArray(listA);
            for (int i = 0; i < oldShapeA.length; ++i) {
                oldShapeA[i] = a.size((int)oldShapeA[i]);
            }
        }
        int n3 = 1;
        int bNax = Math.min(b.rank(), axes[1].length);
        for (int i = 0; i < bNax; ++i) {
            n3 = (int)((long)n3 * b.size(axes[1][i]));
        }
        long[] newShapeB = new long[]{n3, -1L};
        if (listB.size() == 0) {
            oldShapeB = new long[]{1L};
        } else {
            oldShapeB = Longs.toArray(listB);
            for (int i = 0; i < oldShapeB.length; ++i) {
                oldShapeB[i] = b.size((int)oldShapeB[i]);
            }
        }
        INDArray at = a.permute(newAxesA).reshape(newShapeA);
        INDArray bt = b.permute(newAxesB).reshape(newShapeB);
        INDArray ret = at.mmul(bt, result);
        long[] aPlusB = Longs.concat((long[][])new long[][]{oldShapeA, oldShapeB});
        return ret.reshape(aPlusB);
    }

    public static INDArray tensorMmul(INDArray a, INDArray b, int[][] axes) {
        long[] oldShapeB;
        long[] oldShapeA;
        int validationLength = Math.min(axes[0].length, axes[1].length);
        for (int i = 0; i < validationLength; ++i) {
            if (a.size(axes[0][i]) != b.size(axes[1][i])) {
                throw new IllegalArgumentException("Size of the given axes at each dimension must be the same size.");
            }
            if (axes[0][i] < 0) {
                int[] nArray = axes[0];
                int n = i;
                nArray[n] = nArray[n] + a.rank();
            }
            if (axes[1][i] >= 0) continue;
            int[] nArray = axes[1];
            int n = i;
            nArray[n] = nArray[n] + b.rank();
        }
        ArrayList<Integer> listA = new ArrayList<Integer>();
        for (int i = 0; i < a.rank(); ++i) {
            if (Ints.contains((int[])axes[0], (int)i)) continue;
            listA.add(i);
        }
        int[] newAxesA = Ints.concat((int[][])new int[][]{Ints.toArray(listA), axes[0]});
        ArrayList<Integer> listB = new ArrayList<Integer>();
        for (int i = 0; i < b.rank(); ++i) {
            if (Ints.contains((int[])axes[1], (int)i)) continue;
            listB.add(i);
        }
        int[] newAxesB = Ints.concat((int[][])new int[][]{axes[1], Ints.toArray(listB)});
        int n2 = 1;
        int aLength = Math.min(a.rank(), axes[0].length);
        for (int i = 0; i < aLength; ++i) {
            n2 = (int)((long)n2 * a.size(axes[0][i]));
        }
        long[] newShapeA = new long[]{-1L, n2};
        if (listA.size() == 0) {
            oldShapeA = new long[]{1L};
        } else {
            oldShapeA = Longs.toArray(listA);
            for (int i = 0; i < oldShapeA.length; ++i) {
                oldShapeA[i] = a.size((int)oldShapeA[i]);
            }
        }
        int n3 = 1;
        int bNax = Math.min(b.rank(), axes[1].length);
        for (int i = 0; i < bNax; ++i) {
            n3 = (int)((long)n3 * b.size(axes[1][i]));
        }
        long[] newShapeB = new long[]{n3, -1L};
        if (listB.size() == 0) {
            oldShapeB = new long[]{1L};
        } else {
            oldShapeB = Longs.toArray(listB);
            for (int i = 0; i < oldShapeB.length; ++i) {
                oldShapeB[i] = b.size((int)oldShapeB[i]);
            }
        }
        INDArray at = a.permute(newAxesA).reshape(newShapeA);
        INDArray bt = b.permute(newAxesB).reshape(newShapeB);
        INDArray ret = at.mmul(bt);
        long[] aPlusB = Longs.concat((long[][])new long[][]{oldShapeA, oldShapeB});
        return ret.reshape(aPlusB);
    }

    public static INDArray gemm(INDArray a, INDArray b, boolean transposeA, boolean transposeB) {
        long cRows = transposeA ? a.columns() : a.rows();
        long cCols = transposeB ? b.rows() : b.columns();
        INDArray c = Nd4j.createUninitialized(new long[]{cRows, cCols}, 'f');
        return Nd4j.gemm(a, b, c, transposeA, transposeB, 1.0, 0.0);
    }

    public static INDArray gemm(INDArray a, INDArray b, INDArray c, boolean transposeA, boolean transposeB, double alpha, double beta) {
        Preconditions.checkState((c.length() == 1L || c.ordering() == 'f' && Shape.hasDefaultStridesForShape(c) || c.isVectorOrScalar() && c.elementWiseStride() == 1 ? 1 : 0) != 0, (String)"C (result) array is not F order or is a view. Nd4j.gemm requires the result array to be F order and not a view. C (result) array: [%ndSInfo]", (Object)c);
        Nd4j.getBlasWrapper().level3().gemm(a, b, c, transposeA, transposeB, alpha, beta);
        return c;
    }

    public static void setParams(INDArray theta, Iterator<? extends INDArray> ... matrices) {
        int index = 0;
        for (Iterator<? extends INDArray> matrixIterator : matrices) {
            while (matrixIterator.hasNext()) {
                INDArray matrix = matrixIterator.next().linearView();
                int i = 0;
                while ((long)i < matrix.length()) {
                    matrix.putScalar((long)i, theta.getDouble((long)index));
                    ++index;
                    ++i;
                }
            }
        }
        if ((long)index != theta.length()) {
            throw new AssertionError((Object)"Did not entirely use the theta vector");
        }
    }

    private static void logCreationIfNecessary(DataBuffer log) {
        if (shouldInstrument) {
            Nd4j.getInstrumentation().log(log);
        }
    }

    private static void logCreationIfNecessary(INDArray log) {
        if (shouldInstrument) {
            Nd4j.getInstrumentation().log(log);
        }
    }

    public static NDArrayFactory factory() {
        return INSTANCE;
    }

    public static NDArrayFactory sparseFactory() {
        return SPARSE_INSTANCE;
    }

    public static INDArray cumsum(INDArray compute) {
        return compute.cumsum(Integer.MAX_VALUE);
    }

    public static INDArray max(INDArray compute) {
        return compute.max(Integer.MAX_VALUE);
    }

    public static INDArray min(INDArray compute) {
        return compute.min(Integer.MAX_VALUE);
    }

    public static INDArray prod(INDArray compute) {
        return compute.prod(Integer.MAX_VALUE);
    }

    public static INDArray normmax(INDArray compute) {
        return compute.normmax(Integer.MAX_VALUE);
    }

    public static INDArray norm2(INDArray compute) {
        return compute.norm2(Integer.MAX_VALUE);
    }

    public static INDArray norm1(INDArray compute) {
        return compute.norm1(Integer.MAX_VALUE);
    }

    public static INDArray std(INDArray compute) {
        return compute.std(Integer.MAX_VALUE);
    }

    public static INDArray var(INDArray compute) {
        return compute.var(Integer.MAX_VALUE);
    }

    public static INDArray sum(INDArray compute) {
        return compute.sum(Integer.MAX_VALUE);
    }

    public static INDArray mean(INDArray compute) {
        return compute.mean(Integer.MAX_VALUE);
    }

    public static INDArray cumsum(INDArray compute, int dimension) {
        return compute.cumsum(dimension);
    }

    public static INDArray max(INDArray compute, int dimension) {
        return compute.max(dimension);
    }

    public static INDArray min(INDArray compute, int dimension) {
        return compute.min(dimension);
    }

    public static INDArray prod(INDArray compute, int dimension) {
        return compute.prod(dimension);
    }

    public static INDArray normmax(INDArray compute, int dimension) {
        return compute.normmax(dimension);
    }

    public static INDArray norm2(INDArray compute, int dimension) {
        return compute.norm2(dimension);
    }

    public static INDArray norm1(INDArray compute, int dimension) {
        return compute.norm1(dimension);
    }

    public static INDArray std(INDArray compute, int dimension) {
        return compute.std(dimension);
    }

    public static INDArray var(INDArray compute, int dimension) {
        return compute.var(dimension);
    }

    public static INDArray sum(INDArray compute, int dimension) {
        return compute.sum(dimension);
    }

    public static INDArray mean(INDArray compute, int dimension) {
        return compute.mean(dimension);
    }

    public static DataBuffer createBuffer(DataBuffer underlyingBuffer, long offset, long length) {
        return DATA_BUFFER_FACTORY_INSTANCE.create(underlyingBuffer, offset, length);
    }

    public static DataBuffer createBuffer(int[] shape, DataBuffer.Type type, long offset) {
        int length = ArrayUtil.prod((int[])shape);
        return type == DataBuffer.Type.DOUBLE ? Nd4j.createBuffer(new double[length], offset) : Nd4j.createBuffer(new float[length], offset);
    }

    public static DataBuffer createBuffer(ByteBuffer buffer, DataBuffer.Type type, int length, long offset) {
        switch (type) {
            case INT: {
                return DATA_BUFFER_FACTORY_INSTANCE.createInt(offset, buffer, length);
            }
            case DOUBLE: {
                return DATA_BUFFER_FACTORY_INSTANCE.createDouble(offset, buffer, length);
            }
            case FLOAT: {
                return DATA_BUFFER_FACTORY_INSTANCE.createFloat(offset, buffer, length);
            }
        }
        throw new IllegalArgumentException("Illegal opType " + type);
    }

    public static DataBuffer createBuffer(byte[] data, int length, long offset) {
        DataBuffer ret = Nd4j.dataType() == DataBuffer.Type.DOUBLE ? DATA_BUFFER_FACTORY_INSTANCE.createDouble(offset, data, length) : DATA_BUFFER_FACTORY_INSTANCE.createFloat(offset, data, length);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static DataBuffer createBuffer(int[] data, long offset) {
        DataBuffer ret = DATA_BUFFER_FACTORY_INSTANCE.createInt(offset, data);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static DataBuffer createBuffer(int length, long offset) {
        Object ret = Nd4j.dataType() == DataBuffer.Type.FLOAT ? DATA_BUFFER_FACTORY_INSTANCE.createFloat(offset, length) : (Nd4j.dataType() == DataBuffer.Type.INT ? DATA_BUFFER_FACTORY_INSTANCE.createInt(offset, length) : (Nd4j.dataType() == DataBuffer.Type.DOUBLE ? DATA_BUFFER_FACTORY_INSTANCE.createDouble(offset, length) : (Nd4j.dataType() == DataBuffer.Type.HALF ? DATA_BUFFER_FACTORY_INSTANCE.createHalf(offset, length) : null)));
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static DataBuffer createBuffer(DoublePointer doublePointer, long length) {
        return DATA_BUFFER_FACTORY_INSTANCE.create(doublePointer, length);
    }

    public static DataBuffer createBuffer(FloatPointer floatPointer, long length) {
        return DATA_BUFFER_FACTORY_INSTANCE.create(floatPointer, length);
    }

    public static DataBuffer createBuffer(IntPointer intPointer, long length) {
        return DATA_BUFFER_FACTORY_INSTANCE.create(intPointer, length);
    }

    public static DataBuffer createBuffer(float[] data, long offset) {
        DataBuffer ret = Nd4j.dataType() == DataBuffer.Type.FLOAT ? (Nd4j.getMemoryManager().getCurrentWorkspace() == null ? DATA_BUFFER_FACTORY_INSTANCE.createFloat(offset, data) : DATA_BUFFER_FACTORY_INSTANCE.createFloat(offset, data, Nd4j.getMemoryManager().getCurrentWorkspace())) : (Nd4j.dataType() == DataBuffer.Type.HALF ? (Nd4j.getMemoryManager().getCurrentWorkspace() == null ? DATA_BUFFER_FACTORY_INSTANCE.createHalf(offset, data) : DATA_BUFFER_FACTORY_INSTANCE.createHalf(offset, data, Nd4j.getMemoryManager().getCurrentWorkspace())) : (Nd4j.getMemoryManager().getCurrentWorkspace() == null ? DATA_BUFFER_FACTORY_INSTANCE.createDouble(offset, ArrayUtil.toDoubles((float[])data)) : DATA_BUFFER_FACTORY_INSTANCE.createDouble(offset, ArrayUtil.toDoubles((float[])data), Nd4j.getMemoryManager().getCurrentWorkspace())));
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static DataBuffer createBuffer(double[] data, long offset) {
        DataBuffer ret = Nd4j.dataType() == DataBuffer.Type.DOUBLE ? (Nd4j.getMemoryManager().getCurrentWorkspace() == null ? DATA_BUFFER_FACTORY_INSTANCE.createDouble(offset, data) : DATA_BUFFER_FACTORY_INSTANCE.createDouble(offset, data, Nd4j.getMemoryManager().getCurrentWorkspace())) : (Nd4j.dataType() == DataBuffer.Type.HALF ? (Nd4j.getMemoryManager().getCurrentWorkspace() == null ? DATA_BUFFER_FACTORY_INSTANCE.createHalf(offset, data) : DATA_BUFFER_FACTORY_INSTANCE.createHalf(offset, ArrayUtil.toFloats((double[])data), Nd4j.getMemoryManager().getCurrentWorkspace())) : (Nd4j.getMemoryManager().getCurrentWorkspace() == null ? DATA_BUFFER_FACTORY_INSTANCE.createFloat(offset, ArrayUtil.toFloats((double[])data)) : DATA_BUFFER_FACTORY_INSTANCE.createFloat(offset, ArrayUtil.toFloats((double[])data), Nd4j.getMemoryManager().getCurrentWorkspace())));
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static DataBuffer createBuffer(int[] shape, DataBuffer.Type type) {
        long length = ArrayUtil.prodLong((int[])shape);
        if (type == DataBuffer.Type.INT) {
            return Nd4j.getMemoryManager().getCurrentWorkspace() == null ? DATA_BUFFER_FACTORY_INSTANCE.createInt(length, true) : DATA_BUFFER_FACTORY_INSTANCE.createInt(length, true, Nd4j.getMemoryManager().getCurrentWorkspace());
        }
        if (type == DataBuffer.Type.LONG) {
            return Nd4j.getMemoryManager().getCurrentWorkspace() == null ? DATA_BUFFER_FACTORY_INSTANCE.createLong(length, true) : DATA_BUFFER_FACTORY_INSTANCE.createLong(length, true, Nd4j.getMemoryManager().getCurrentWorkspace());
        }
        if (type == DataBuffer.Type.HALF) {
            return Nd4j.getMemoryManager().getCurrentWorkspace() == null ? DATA_BUFFER_FACTORY_INSTANCE.createHalf(length, true) : DATA_BUFFER_FACTORY_INSTANCE.createHalf(length, true, Nd4j.getMemoryManager().getCurrentWorkspace());
        }
        if (type == DataBuffer.Type.DOUBLE) {
            return Nd4j.getMemoryManager().getCurrentWorkspace() == null ? DATA_BUFFER_FACTORY_INSTANCE.createDouble(length, true) : DATA_BUFFER_FACTORY_INSTANCE.createDouble(length, true, Nd4j.getMemoryManager().getCurrentWorkspace());
        }
        return Nd4j.getMemoryManager().getCurrentWorkspace() == null ? DATA_BUFFER_FACTORY_INSTANCE.createFloat(length, true) : DATA_BUFFER_FACTORY_INSTANCE.createFloat(length, true, Nd4j.getMemoryManager().getCurrentWorkspace());
    }

    public static DataBuffer createBufferDetached(int[] shape, DataBuffer.Type type) {
        long length = ArrayUtil.prodLong((int[])shape);
        if (type == DataBuffer.Type.INT) {
            return DATA_BUFFER_FACTORY_INSTANCE.createInt(length);
        }
        if (type == DataBuffer.Type.LONG) {
            return DATA_BUFFER_FACTORY_INSTANCE.createLong(new long[]{length});
        }
        if (type == DataBuffer.Type.HALF) {
            return DATA_BUFFER_FACTORY_INSTANCE.createHalf(length);
        }
        return type == DataBuffer.Type.DOUBLE ? DATA_BUFFER_FACTORY_INSTANCE.createDouble(length) : DATA_BUFFER_FACTORY_INSTANCE.createFloat(length);
    }

    public static DataBuffer createBuffer(long[] shape, DataBuffer.Type type) {
        long length = ArrayUtil.prodLong((long[])shape);
        if (type == DataBuffer.Type.INT) {
            return Nd4j.getMemoryManager().getCurrentWorkspace() == null ? DATA_BUFFER_FACTORY_INSTANCE.createInt(length, true) : DATA_BUFFER_FACTORY_INSTANCE.createInt(length, true, Nd4j.getMemoryManager().getCurrentWorkspace());
        }
        if (type == DataBuffer.Type.LONG) {
            return Nd4j.getMemoryManager().getCurrentWorkspace() == null ? DATA_BUFFER_FACTORY_INSTANCE.createLong(length, true) : DATA_BUFFER_FACTORY_INSTANCE.createLong(length, true, Nd4j.getMemoryManager().getCurrentWorkspace());
        }
        if (type == DataBuffer.Type.HALF) {
            return Nd4j.getMemoryManager().getCurrentWorkspace() == null ? DATA_BUFFER_FACTORY_INSTANCE.createHalf(length, true) : DATA_BUFFER_FACTORY_INSTANCE.createHalf(length, true, Nd4j.getMemoryManager().getCurrentWorkspace());
        }
        if (type == DataBuffer.Type.DOUBLE) {
            return Nd4j.getMemoryManager().getCurrentWorkspace() == null ? DATA_BUFFER_FACTORY_INSTANCE.createDouble(length, true) : DATA_BUFFER_FACTORY_INSTANCE.createDouble(length, true, Nd4j.getMemoryManager().getCurrentWorkspace());
        }
        return Nd4j.getMemoryManager().getCurrentWorkspace() == null ? DATA_BUFFER_FACTORY_INSTANCE.createFloat(length, true) : DATA_BUFFER_FACTORY_INSTANCE.createFloat(length, true, Nd4j.getMemoryManager().getCurrentWorkspace());
    }

    public static DataBuffer createBufferDetached(long[] shape, DataBuffer.Type type) {
        long length = ArrayUtil.prodLong((long[])shape);
        if (type == DataBuffer.Type.INT) {
            return DATA_BUFFER_FACTORY_INSTANCE.createInt(length);
        }
        if (type == DataBuffer.Type.LONG) {
            return DATA_BUFFER_FACTORY_INSTANCE.createLong(length);
        }
        if (type == DataBuffer.Type.HALF) {
            return DATA_BUFFER_FACTORY_INSTANCE.createHalf(length);
        }
        return type == DataBuffer.Type.DOUBLE ? DATA_BUFFER_FACTORY_INSTANCE.createDouble(length) : DATA_BUFFER_FACTORY_INSTANCE.createFloat(length);
    }

    public static DataBuffer createBuffer(ByteBuffer buffer, DataBuffer.Type type, int length) {
        switch (type) {
            case INT: {
                return DATA_BUFFER_FACTORY_INSTANCE.createInt(buffer, length);
            }
            case LONG: {
                return DATA_BUFFER_FACTORY_INSTANCE.createLong(buffer, length);
            }
            case DOUBLE: {
                return DATA_BUFFER_FACTORY_INSTANCE.createDouble(buffer, length);
            }
            case FLOAT: {
                return DATA_BUFFER_FACTORY_INSTANCE.createFloat(buffer, length);
            }
            case HALF: {
                return DATA_BUFFER_FACTORY_INSTANCE.createHalf(buffer, length);
            }
        }
        throw new IllegalArgumentException("Illegal opType " + type);
    }

    public static DataBuffer createBuffer(byte[] data, int length) {
        DataBuffer ret = Nd4j.dataType() == DataBuffer.Type.DOUBLE ? DATA_BUFFER_FACTORY_INSTANCE.createDouble(data, length) : (Nd4j.dataType() == DataBuffer.Type.HALF ? DATA_BUFFER_FACTORY_INSTANCE.createHalf(data, length) : DATA_BUFFER_FACTORY_INSTANCE.createFloat(data, length));
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static DataBuffer createBuffer(int[] data) {
        DataBuffer ret = Nd4j.getMemoryManager().getCurrentWorkspace() == null ? DATA_BUFFER_FACTORY_INSTANCE.createInt(data) : DATA_BUFFER_FACTORY_INSTANCE.createInt(data, Nd4j.getMemoryManager().getCurrentWorkspace());
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static DataBuffer createBuffer(long[] data) {
        DataBuffer ret = Nd4j.getMemoryManager().getCurrentWorkspace() == null ? DATA_BUFFER_FACTORY_INSTANCE.createLong(data) : DATA_BUFFER_FACTORY_INSTANCE.createLong(data, Nd4j.getMemoryManager().getCurrentWorkspace());
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static DataBuffer createBufferDetached(int[] data) {
        DataBuffer ret = DATA_BUFFER_FACTORY_INSTANCE.createInt(data);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static DataBuffer createBufferDetached(long[] data) {
        DataBuffer ret = DATA_BUFFER_FACTORY_INSTANCE.createLong(data);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static DataBuffer createBuffer(long length) {
        return Nd4j.createBuffer(length, true);
    }

    public static DataBuffer createBuffer(Pointer pointer, DataBuffer.Type type, long length, Indexer indexer) {
        return DATA_BUFFER_FACTORY_INSTANCE.create(pointer, type, length, indexer);
    }

    public static DataBuffer createBuffer(long length, boolean initialize) {
        DataBuffer ret = Nd4j.dataType() == DataBuffer.Type.FLOAT ? (Nd4j.getMemoryManager().getCurrentWorkspace() == null ? DATA_BUFFER_FACTORY_INSTANCE.createFloat(length, initialize) : DATA_BUFFER_FACTORY_INSTANCE.createFloat(length, initialize, Nd4j.getMemoryManager().getCurrentWorkspace())) : (Nd4j.dataType() == DataBuffer.Type.INT ? DATA_BUFFER_FACTORY_INSTANCE.createInt(length, initialize) : (Nd4j.dataType() == DataBuffer.Type.HALF ? (Nd4j.getMemoryManager().getCurrentWorkspace() == null ? DATA_BUFFER_FACTORY_INSTANCE.createHalf(length, initialize) : DATA_BUFFER_FACTORY_INSTANCE.createHalf(length, initialize, Nd4j.getMemoryManager().getCurrentWorkspace())) : (Nd4j.getMemoryManager().getCurrentWorkspace() == null ? DATA_BUFFER_FACTORY_INSTANCE.createDouble(length, initialize) : DATA_BUFFER_FACTORY_INSTANCE.createDouble(length, initialize, Nd4j.getMemoryManager().getCurrentWorkspace()))));
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static DataBuffer createBuffer(float[] data) {
        DataBuffer ret = Nd4j.dataType() == DataBuffer.Type.FLOAT ? (Nd4j.getMemoryManager().getCurrentWorkspace() == null ? DATA_BUFFER_FACTORY_INSTANCE.createFloat(data) : DATA_BUFFER_FACTORY_INSTANCE.createFloat(data, Nd4j.getMemoryManager().getCurrentWorkspace())) : (Nd4j.dataType() == DataBuffer.Type.HALF ? (Nd4j.getMemoryManager().getCurrentWorkspace() == null ? DATA_BUFFER_FACTORY_INSTANCE.createHalf(data) : DATA_BUFFER_FACTORY_INSTANCE.createHalf(data, Nd4j.getMemoryManager().getCurrentWorkspace())) : (Nd4j.getMemoryManager().getCurrentWorkspace() == null ? DATA_BUFFER_FACTORY_INSTANCE.createDouble(ArrayUtil.toDoubles((float[])data)) : DATA_BUFFER_FACTORY_INSTANCE.createDouble(ArrayUtil.toDoubles((float[])data), Nd4j.getMemoryManager().getCurrentWorkspace())));
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static DataBuffer createBufferDetached(float[] data) {
        DataBuffer ret = Nd4j.dataType() == DataBuffer.Type.FLOAT ? DATA_BUFFER_FACTORY_INSTANCE.createFloat(data) : (Nd4j.dataType() == DataBuffer.Type.HALF ? DATA_BUFFER_FACTORY_INSTANCE.createHalf(data) : DATA_BUFFER_FACTORY_INSTANCE.createDouble(ArrayUtil.toDoubles((float[])data)));
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static DataBuffer createBufferDetached(double[] data) {
        DataBuffer ret = Nd4j.dataType() == DataBuffer.Type.DOUBLE ? DATA_BUFFER_FACTORY_INSTANCE.createDouble(data) : (Nd4j.dataType() == DataBuffer.Type.HALF ? DATA_BUFFER_FACTORY_INSTANCE.createHalf(ArrayUtil.toFloats((double[])data)) : DATA_BUFFER_FACTORY_INSTANCE.createFloat(ArrayUtil.toFloats((double[])data)));
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static DataBuffer createBuffer(double[] data) {
        DataBuffer ret = Nd4j.dataType() == DataBuffer.Type.DOUBLE ? (Nd4j.getMemoryManager().getCurrentWorkspace() == null ? DATA_BUFFER_FACTORY_INSTANCE.createDouble(data) : DATA_BUFFER_FACTORY_INSTANCE.createDouble(data, Nd4j.getMemoryManager().getCurrentWorkspace())) : (Nd4j.dataType() == DataBuffer.Type.HALF ? (Nd4j.getMemoryManager().getCurrentWorkspace() == null ? DATA_BUFFER_FACTORY_INSTANCE.createHalf(data) : DATA_BUFFER_FACTORY_INSTANCE.createHalf(ArrayUtil.toFloats((double[])data), Nd4j.getMemoryManager().getCurrentWorkspace())) : (Nd4j.getMemoryManager().getCurrentWorkspace() == null ? DATA_BUFFER_FACTORY_INSTANCE.createFloat(ArrayUtil.toFloats((double[])data)) : DATA_BUFFER_FACTORY_INSTANCE.createFloat(ArrayUtil.toFloats((double[])data), Nd4j.getMemoryManager().getCurrentWorkspace())));
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static void setFactory(NDArrayFactory factory) {
        INSTANCE = factory;
    }

    public static void setSparseFactory(NDArrayFactory factory) {
        SPARSE_INSTANCE = factory;
    }

    public static Character order() {
        return Character.valueOf(Nd4j.factory().order());
    }

    public static DataBuffer.Type dataType() {
        return DataTypeUtil.getDtypeFromContext();
    }

    public static void setDataType(@NonNull DataBuffer.Type dType) {
        if (dType == null) {
            throw new NullPointerException("dType is marked @NonNull but is null");
        }
        DataTypeUtil.setDTypeForContext((DataBuffer.Type)dType);
    }

    public static Nd4jBackend getBackend() {
        return backend;
    }

    public static BlasWrapper getBlasWrapper() {
        return BLAS_WRAPPER_INSTANCE;
    }

    public static BlasWrapper getSparseBlasWrapper() {
        return SPARSE_BLAS_WRAPPER_INSTANCE;
    }

    public static void setBlasWrapper(BlasWrapper factory) {
        BLAS_WRAPPER_INSTANCE = factory;
    }

    public static INDArray[] sortWithIndices(INDArray ndarray, int dimension, boolean ascending) {
        INDArray indices = Nd4j.create(ndarray.shape());
        INDArray[] ret = new INDArray[2];
        int i = 0;
        while ((long)i < ndarray.vectorsAlongDimension(dimension)) {
            INDArray vec = ndarray.vectorAlongDimension(i, dimension);
            INDArray indexVector = indices.vectorAlongDimension(i, dimension);
            final Double[] data = new Double[(int)vec.length()];
            Double[] index = new Double[(int)vec.length()];
            int j = 0;
            while ((long)j < vec.length()) {
                data[j] = vec.getDouble((long)j);
                index[j] = j;
                ++j;
            }
            Arrays.sort(index, new Comparator<Double>(){

                @Override
                public int compare(Double o1, Double o2) {
                    int o = (int)o1.doubleValue();
                    int oo2 = (int)o2.doubleValue();
                    return Double.compare(data[o], data[oo2]);
                }
            });
            if (ascending) {
                j = 0;
                while ((long)j < vec.length()) {
                    vec.putScalar((long)j, (double)data[(int)index[j].doubleValue()]);
                    indexVector.putScalar((long)j, (double)index[j]);
                    ++j;
                }
            } else {
                int count = data.length - 1;
                int j2 = 0;
                while ((long)j2 < vec.length()) {
                    int currCount2 = count--;
                    vec.putScalar((long)j2, (double)data[(int)index[currCount2].doubleValue()]);
                    indexVector.putScalar((long)j2, (double)index[currCount2]);
                    ++j2;
                }
            }
            ++i;
        }
        ret[0] = indices;
        ret[1] = ndarray;
        return ret;
    }

    public static INDArray sort(INDArray ndarray, boolean ascending) {
        return Nd4j.getNDArrayFactory().sort(ndarray, !ascending);
    }

    public static INDArray sort(INDArray ndarray, int dimension, boolean ascending) {
        return Nd4j.getNDArrayFactory().sort(ndarray, !ascending, dimension);
    }

    public static INDArray sortRows(final INDArray in, final int colIdx, final boolean ascending) {
        int i;
        if (in.rank() != 2) {
            throw new IllegalArgumentException("Cannot sort rows on non-2d matrix");
        }
        if (colIdx < 0 || colIdx >= in.columns()) {
            throw new IllegalArgumentException("Cannot sort on values in column " + colIdx + ", nCols=" + in.columns());
        }
        if (in.rows() > Integer.MAX_VALUE) {
            throw new ND4JArraySizeException();
        }
        INDArray out = Nd4j.create(in.shape());
        int nRows = in.rows();
        ArrayList<Integer> list = new ArrayList<Integer>(nRows);
        for (i = 0; i < nRows; ++i) {
            list.add(i);
        }
        Collections.sort(list, new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                if (ascending) {
                    return Double.compare(in.getDouble((long)o1.intValue(), (long)colIdx), in.getDouble((long)o2.intValue(), (long)colIdx));
                }
                return -Double.compare(in.getDouble((long)o1.intValue(), (long)colIdx), in.getDouble((long)o2.intValue(), (long)colIdx));
            }
        });
        for (i = 0; i < nRows; ++i) {
            out.putRow(i, in.getRow(((Integer)list.get(i)).intValue()));
        }
        return out;
    }

    public static INDArray sortColumns(final INDArray in, final int rowIdx, final boolean ascending) {
        int i;
        if (in.rank() != 2) {
            throw new IllegalArgumentException("Cannot sort columns on non-2d matrix");
        }
        if (rowIdx < 0 || rowIdx >= in.rows()) {
            throw new IllegalArgumentException("Cannot sort on values in row " + rowIdx + ", nRows=" + in.rows());
        }
        if (in.columns() > Integer.MAX_VALUE) {
            throw new ND4JArraySizeException();
        }
        INDArray out = Nd4j.create(in.shape());
        int nCols = in.columns();
        ArrayList<Integer> list = new ArrayList<Integer>(nCols);
        for (i = 0; i < nCols; ++i) {
            list.add(i);
        }
        Collections.sort(list, new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                if (ascending) {
                    return Double.compare(in.getDouble((long)rowIdx, (long)o1.intValue()), in.getDouble((long)rowIdx, (long)o2.intValue()));
                }
                return -Double.compare(in.getDouble((long)rowIdx, (long)o1.intValue()), in.getDouble((long)rowIdx, (long)o2.intValue()));
            }
        });
        for (i = 0; i < nCols; ++i) {
            out.putColumn(i, in.getColumn(((Integer)list.get(i)).intValue()));
        }
        return out;
    }

    public static INDArray repeat(INDArray n, int num) {
        long[] lArray;
        ArrayList<INDArray> list = new ArrayList<INDArray>();
        for (int i = 0; i < num; ++i) {
            list.add(n.dup());
        }
        long[] nShape = n.shape();
        if (n.isColumnVector()) {
            long[] lArray2 = new long[1];
            lArray = lArray2;
            lArray2[0] = n.shape()[0];
        } else {
            lArray = nShape;
        }
        long[] shape = lArray;
        long[] retShape = Longs.concat((long[][])new long[][]{{num}, shape});
        return Nd4j.create(list, retShape);
    }

    public static INDArray linspace(long lower, long upper, long num) {
        if (lower == upper && num == 1L) {
            return Nd4j.scalar(lower);
        }
        double approx = (double)num / ((double)(upper - lower) + 1.0);
        if (approx % 1.0 <= EPS_THRESHOLD) {
            return INSTANCE.linspace((int)lower, (int)upper, (int)num);
        }
        return Nd4j.linspace((double)lower, (double)upper, (long)((int)num));
    }

    public static INDArray linspace(double lower, double upper, long num) {
        return Nd4j.getExecutioner().exec(new Linspace(lower, upper, (int)num));
    }

    public static INDArray linspace(float lower, float upper, long num) {
        return Nd4j.linspace((double)lower, (double)upper, num);
    }

    public static INDArray[] meshgrid(@NonNull INDArray x, @NonNull INDArray y) {
        if (x == null) {
            throw new NullPointerException("x is marked @NonNull but is null");
        }
        if (y == null) {
            throw new NullPointerException("y is marked @NonNull but is null");
        }
        Preconditions.checkArgument((boolean)x.isVectorOrScalar(), (String)"X must be a vector");
        Preconditions.checkArgument((boolean)y.isVectorOrScalar(), (String)"Y must be a vector");
        INDArray xOut = Nd4j.createUninitialized(y.length(), x.length());
        INDArray yOut = Nd4j.createUninitialized(y.length(), x.length());
        DynamicCustomOp op = DynamicCustomOp.builder("meshgrid").addInputs(x, y).addOutputs(xOut, yOut).build();
        Nd4j.getExecutioner().exec(op);
        return new INDArray[]{xOut, yOut};
    }

    public static INDArray toFlattened(Collection<INDArray> matrices) {
        INDArray ret = INSTANCE.toFlattened(matrices);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray toFlattened(char order, Collection<INDArray> matrices) {
        INDArray ret = INSTANCE.toFlattened(order, matrices);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray toFlattened(int length, Iterator<? extends INDArray> ... matrices) {
        INDArray ret = INSTANCE.toFlattened(length, matrices);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray bilinearProducts(INDArray curr, INDArray in) {
        return INSTANCE.bilinearProducts(curr, in);
    }

    public static INDArray toFlattened(INDArray ... matrices) {
        return INSTANCE.toFlattened(matrices);
    }

    public static INDArray toFlattened(char order, INDArray ... matrices) {
        return INSTANCE.toFlattened(order, matrices);
    }

    public static INDArray eye(long n) {
        INDArray ret = INSTANCE.eye(n);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static void rot90(INDArray toRotate) {
        INSTANCE.rot90(toRotate);
    }

    public static void writeTxt(INDArray write, String filePath, String split, int precision) {
        Nd4j.writeTxt(write, filePath);
    }

    public static void writeTxt(INDArray write, String filePath, int precision) {
        Nd4j.writeTxt(write, filePath);
    }

    public static void writeTxt(INDArray write, String filePath, String split) {
        Nd4j.writeTxt(write, filePath);
    }

    public static void writeTxt(INDArray write, String filePath) {
        try {
            String toWrite = Nd4j.writeStringForArray(write, "0.000000000000000000E0");
            FileUtils.writeStringToFile((File)new File(filePath), (String)toWrite);
        }
        catch (IOException e) {
            throw new RuntimeException("Error writing output", e);
        }
    }

    public static void writeTxtString(INDArray write, OutputStream os, String split, int precision) {
        Nd4j.writeTxtString(write, os);
    }

    @Deprecated
    public static void writeTxtString(INDArray write, OutputStream os, int precision) {
        Nd4j.writeTxtString(write, os);
    }

    @Deprecated
    public static void writeTxtString(INDArray write, OutputStream os, String split) {
        Nd4j.writeTxtString(write, os);
    }

    public static void writeTxtString(INDArray write, OutputStream os) {
        try {
            String toWrite = Nd4j.writeStringForArray(write, "0.000000000000000000E0");
            os.write(toWrite.getBytes());
        }
        catch (IOException e) {
            throw new RuntimeException("Error writing output", e);
        }
    }

    private static String writeStringForArray(INDArray write, String format) {
        if (write.isView() || !Shape.hasDefaultStridesForShape(write)) {
            write = write.dup();
        }
        if (format.isEmpty()) {
            format = "0.000000000000000000E0";
        }
        String lineOne = "{\n";
        String lineTwo = "\"filefrom\": \"dl4j\",\n";
        String lineThree = "\"ordering\": \"" + write.ordering() + "\",\n";
        String lineFour = "\"shape\":\t" + Arrays.toString(write.shape()) + ",\n";
        String lineFive = "\"data\":\n";
        String fileData = new NDArrayStrings(",", format).format(write, false);
        String fileEnd = "\n}\n";
        String fileBegin = lineOne + lineTwo + lineThree + lineFour + lineFive;
        String fileContents = fileBegin + fileData + fileEnd;
        return fileContents;
    }

    public static void write(OutputStream writer, INDArray write) throws IOException {
        DataOutputStream stream = new DataOutputStream(writer);
        Nd4j.write(write, stream);
        stream.close();
    }

    public static byte[] toByteArray(INDArray arr) throws IOException {
        if (arr.length() * (long)arr.data().getElementSize() > Integer.MAX_VALUE) {
            throw new ND4JIllegalStateException("");
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream((int)(arr.length() * (long)arr.data().getElementSize()));
        DataOutputStream dos = new DataOutputStream(bos);
        Nd4j.write(arr, dos);
        byte[] ret = bos.toByteArray();
        return ret;
    }

    public static INDArray fromByteArray(byte[] arr) throws IOException {
        ByteArrayInputStream bis = new ByteArrayInputStream(arr);
        INDArray ret = Nd4j.read(bis);
        return ret;
    }

    public static INDArray readNumpy(InputStream filePath, String split) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(filePath));
        ArrayList<float[]> data2 = new ArrayList<float[]>();
        int numColumns = -1;
        while ((line = reader.readLine()) != null) {
            String[] data = line.trim().split(split);
            if (numColumns < 0) {
                numColumns = data.length;
            } else {
                Preconditions.checkState((data.length == numColumns ? 1 : 0) != 0, (String)"Data has inconsistent number of columns: data length %s, numColumns %s", (int)data.length, (int)numColumns);
            }
            data2.add(Nd4j.readSplit(data));
        }
        INDArray ret = Nd4j.create(data2.size(), numColumns);
        for (int i = 0; i < data2.size(); ++i) {
            ret.putRow(i, Nd4j.create(Nd4j.createBuffer((float[])data2.get(i))));
        }
        return ret;
    }

    private static float[] readSplit(String[] split) {
        float[] ret = new float[split.length];
        for (int i = 0; i < split.length; ++i) {
            ret[i] = Float.parseFloat(split[i]);
        }
        return ret;
    }

    public static INDArray readNumpy(String filePath, String split) throws IOException {
        return Nd4j.readNumpy(new FileInputStream(filePath), split);
    }

    public static INDArray readNumpy(String filePath) throws IOException {
        return Nd4j.readNumpy(filePath, "\t");
    }

    public static INDArray read(InputStream reader) throws IOException {
        return Nd4j.read(new DataInputStream(reader));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static INDArray readTxtString(InputStream ndarray) {
        String sep = ",";
        INDArray newArr = null;
        BufferedReader reader = new BufferedReader(new InputStreamReader(ndarray));
        LineIterator it = IOUtils.lineIterator((Reader)reader);
        DecimalFormat format = (DecimalFormat)NumberFormat.getInstance(Locale.US);
        format.setParseBigDecimal(true);
        try {
            int lineNum = 0;
            int tensorNum = 0;
            char theOrder = 'c';
            int rank = 0;
            int[] theShape = null;
            double[] subsetArr = null;
            while (it.hasNext()) {
                String[] lineArr;
                String fileSource;
                String line = it.nextLine();
                ++lineNum;
                if ((line = line.replaceAll("\\s", "")).equals("") || line.equals("}")) continue;
                if (lineNum == 2 && !(fileSource = (lineArr = line.split(":"))[1].replaceAll("\\W", "")).equals("dl4j")) {
                    throw new IllegalArgumentException("Only files written out from Nd4j.writeTxT/writeTxtString can be read with the readTxt/readTxtString methods");
                }
                if (lineNum == 3) {
                    lineArr = line.split(":");
                    theOrder = lineArr[1].replaceAll("\\W", "").charAt(0);
                    continue;
                }
                if (lineNum == 4) {
                    String shapeString = line.split(":")[1].replace("[", "").replace("],", "");
                    if (shapeString.isEmpty()) {
                        newArr = Nd4j.trueScalar(0);
                        continue;
                    }
                    String[] shapeArr = shapeString.split(",");
                    rank = shapeArr.length;
                    theShape = new int[rank];
                    for (int i = 0; i < rank; ++i) {
                        theShape[i] = Integer.parseInt(shapeArr[i]);
                    }
                    newArr = theOrder == 'f' && theShape[rank - 1] == 1 ? Nd4j.zeros(theShape, 'c') : Nd4j.zeros(theShape, theOrder);
                    subsetArr = new double[theShape[rank - 1]];
                    continue;
                }
                if (lineNum <= 5) continue;
                String[] entries = line.replace("\\],", "").replaceAll("\\]", "").replaceAll("\\[", "").split(sep);
                if (rank == 0) {
                    try {
                        newArr.addi(format.parse(entries[0]).doubleValue());
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                Preconditions.checkState((entries.length == theShape[rank - 1] ? 1 : 0) != 0, (String)"Invalid number of entries - format does not match expected shape.Expected %s values per line, got %s at line %s", (int)theShape[rank - 1], (int)entries.length, (int)lineNum);
                for (int i = 0; i < theShape[rank - 1]; ++i) {
                    try {
                        BigDecimal number = (BigDecimal)format.parse(entries[i]);
                        subsetArr[i] = number.doubleValue();
                        continue;
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                }
                INDArray subTensor = Nd4j.create(subsetArr);
                newArr.tensorAlongDimension(tensorNum, rank - 1).addi(subTensor);
                ++tensorNum;
            }
            if (theOrder == 'f' && rank > 1 && theShape[rank - 1] == true) {
                newArr = newArr.dup('f');
            }
        }
        finally {
            LineIterator.closeQuietly((LineIterator)it);
        }
        return newArr;
    }

    public static INDArray readTxt(String filePath) {
        String sep = ",";
        File file = new File(filePath);
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
            INDArray iNDArray = Nd4j.readTxtString(is);
            return iNDArray;
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static int[] toIntArray(int length, DataBuffer buffer) {
        int[] ret = new int[length];
        for (int i = 0; i < length; ++i) {
            ret[i] = buffer.getInt((long)i);
        }
        return ret;
    }

    public static INDArray createArrayFromShapeBuffer(DataBuffer data, DataBuffer shapeInfo) {
        int rank = Shape.rank(shapeInfo);
        long offset = 0L;
        INDArray result = Nd4j.create(data, Nd4j.toIntArray(rank, Shape.shapeOf(shapeInfo)), Nd4j.toIntArray(rank, Shape.stride(shapeInfo)), offset, Shape.order(shapeInfo));
        if (data instanceof CompressedDataBuffer) {
            result.markAsCompressed(true);
        }
        return result;
    }

    public static INDArray createArrayFromShapeBuffer(DataBuffer data, Pair<DataBuffer, long[]> shapeInfo) {
        int rank = Shape.rank((DataBuffer)shapeInfo.getFirst());
        long offset = Shape.offset((DataBuffer)shapeInfo.getFirst());
        INDArray result = Nd4j.create(data, Nd4j.toIntArray(rank, Shape.shapeOf((DataBuffer)shapeInfo.getFirst())), Nd4j.toIntArray(rank, Shape.stride((DataBuffer)shapeInfo.getFirst())), offset, Shape.order((DataBuffer)shapeInfo.getFirst()));
        if (data instanceof CompressedDataBuffer) {
            result.markAsCompressed(true);
        }
        return result;
    }

    public static INDArray read(DataInputStream dis) throws IOException {
        DataBuffer shapeInformation = Nd4j.createBufferDetached(new long[1], DataBuffer.Type.LONG);
        shapeInformation.read(dis);
        long length = Shape.length(shapeInformation);
        DataBuffer data = CompressedDataBuffer.readUnknown(dis, length);
        return Nd4j.createArrayFromShapeBuffer(data, shapeInformation);
    }

    public static void write(INDArray arr, DataOutputStream dataOutputStream) throws IOException {
        if (arr.isView()) {
            arr = arr.dup();
        }
        arr.shapeInfoDataBuffer().write(dataOutputStream);
        arr.data().write(dataOutputStream);
    }

    public static void saveBinary(INDArray arr, File saveTo) throws IOException {
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(saveTo));
        DataOutputStream dos = new DataOutputStream(bos);
        Nd4j.write(arr, dos);
        dos.flush();
        dos.close();
        bos.close();
    }

    public static INDArray readBinary(File read) throws IOException {
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(read));
        DataInputStream dis = new DataInputStream(bis);
        INDArray ret = Nd4j.read(dis);
        dis.close();
        return ret;
    }

    public static void clearNans(INDArray arr) {
        Nd4j.getExecutioner().exec(new ReplaceNans(arr, EPS_THRESHOLD));
    }

    public static INDArray rot(INDArray reverse) {
        INDArray ret = INSTANCE.rot(reverse);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray reverse(INDArray reverse) {
        return Nd4j.getExecutioner().exec(new OldReverse(reverse)).z();
    }

    public static INDArray arange(double begin, double end) {
        INDArray ret = INSTANCE.arange(begin, end);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray arange(double end) {
        return Nd4j.arange(0.0, end);
    }

    public static void copy(INDArray a, INDArray b) {
        INSTANCE.copy(a, b);
    }

    public static INDArray diag(INDArray x, int k) {
        INDArray ret;
        if (x.isMatrix()) {
            ret = Nd4j.createUninitialized(new long[]{Math.min(x.size(0), x.size(1))});
            Nd4j.getExecutioner().exec(new DiagPart(x, ret));
        } else {
            ret = Nd4j.create(x.length(), x.length());
            Nd4j.getExecutioner().exec(new Diag(new INDArray[]{x}, new INDArray[]{ret}));
        }
        return ret;
    }

    public static INDArray diag(INDArray x) {
        return Nd4j.diag(x, 0);
    }

    public static INDArray choice(@NonNull INDArray source, @NonNull INDArray probs, @NonNull INDArray target, @NonNull org.nd4j.linalg.api.rng.Random rng) {
        if (source == null) {
            throw new NullPointerException("source is marked @NonNull but is null");
        }
        if (probs == null) {
            throw new NullPointerException("probs is marked @NonNull but is null");
        }
        if (target == null) {
            throw new NullPointerException("target is marked @NonNull but is null");
        }
        if (rng == null) {
            throw new NullPointerException("rng is marked @NonNull but is null");
        }
        if (source.length() != probs.length()) {
            throw new ND4JIllegalStateException("Nd4j.choice() requires lengths of Source and Probs to be equal");
        }
        return Nd4j.getExecutioner().exec(new Choice(source, probs, target), rng);
    }

    public static INDArray choice(INDArray source, INDArray probs, INDArray target) {
        return Nd4j.choice(source, probs, target, Nd4j.getRandom());
    }

    public static INDArray choice(INDArray source, INDArray probs, int numSamples, @NonNull org.nd4j.linalg.api.rng.Random rng) {
        if (rng == null) {
            throw new NullPointerException("rng is marked @NonNull but is null");
        }
        if (numSamples < 1) {
            throw new ND4JIllegalStateException("Nd4j.choice() numSamples must be positive value");
        }
        return Nd4j.choice(source, probs, Nd4j.createUninitialized(numSamples), rng);
    }

    public static INDArray choice(INDArray source, INDArray probs, int numSamples) {
        return Nd4j.choice(source, probs, numSamples, Nd4j.getRandom());
    }

    public static INDArray appendBias(INDArray ... vectors) {
        INDArray ret = INSTANCE.appendBias(vectors);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static void doAlongDiagonal(INDArray x, Function<Number, Number> func) {
        if (x.isMatrix()) {
            for (int i = 0; i < x.rows(); ++i) {
                x.put(i, i, (Number)func.apply((Object)x.getDouble((long)i, (long)i)));
            }
        }
    }

    public static INDArray rand(int[] shape) {
        INDArray ret = Nd4j.createUninitialized(shape, Nd4j.order().charValue());
        Nd4j.logCreationIfNecessary(ret);
        return Nd4j.rand(ret);
    }

    public static INDArray rand(long[] shape) {
        INDArray ret = Nd4j.createUninitialized(shape, Nd4j.order().charValue());
        Nd4j.logCreationIfNecessary(ret);
        return Nd4j.rand(ret);
    }

    public static INDArray rand(char order, int[] shape) {
        INDArray ret = Nd4j.createUninitialized(shape, order);
        Nd4j.logCreationIfNecessary(ret);
        return Nd4j.rand(ret);
    }

    public static INDArray rand(int rows, int columns) {
        if (rows < 1 || columns < 1) {
            throw new ND4JIllegalStateException("Number of rows and columns should be positive for new INDArray");
        }
        INDArray ret = Nd4j.createUninitialized(new int[]{rows, columns}, Nd4j.order().charValue());
        Nd4j.logCreationIfNecessary(ret);
        return Nd4j.rand(ret);
    }

    public static INDArray rand(char order, int rows, int columns) {
        if (rows < 1 || columns < 1) {
            throw new ND4JIllegalStateException("Number of rows and columns should be positive for new INDArray");
        }
        INDArray ret = Nd4j.createUninitialized(new int[]{rows, columns}, order);
        Nd4j.logCreationIfNecessary(ret);
        return Nd4j.rand(ret);
    }

    public static INDArray rand(int[] shape, long seed) {
        INDArray ret = Nd4j.createUninitialized(shape, Nd4j.order().charValue());
        Nd4j.logCreationIfNecessary(ret);
        return Nd4j.rand(ret, seed);
    }

    public static INDArray rand(int rows, int columns, long seed) {
        INDArray ret = Nd4j.createUninitialized(new int[]{rows, columns}, Nd4j.order().charValue());
        Nd4j.logCreationIfNecessary(ret);
        return Nd4j.rand(ret, seed);
    }

    public static INDArray rand(int[] shape, org.nd4j.linalg.api.rng.Random rng) {
        INDArray ret = Nd4j.createUninitialized(shape, Nd4j.order().charValue());
        Nd4j.logCreationIfNecessary(ret);
        return Nd4j.rand(ret, rng);
    }

    public static INDArray rand(int[] shape, Distribution dist) {
        return dist.sample(shape);
    }

    public static INDArray rand(long[] shape, Distribution dist) {
        return dist.sample(shape);
    }

    public static INDArray rand(int rows, int columns, org.nd4j.linalg.api.rng.Random rng) {
        INDArray ret = Nd4j.createUninitialized(new int[]{rows, columns}, Nd4j.order().charValue());
        Nd4j.logCreationIfNecessary(ret);
        return Nd4j.rand(ret, rng);
    }

    public static INDArray rand(int[] shape, double min, double max, org.nd4j.linalg.api.rng.Random rng) {
        INDArray ret = Nd4j.createUninitialized(shape, Nd4j.order().charValue());
        Nd4j.logCreationIfNecessary(ret);
        return Nd4j.rand(ret, min, max, rng);
    }

    public static INDArray rand(long[] shape, double min, double max, org.nd4j.linalg.api.rng.Random rng) {
        INDArray ret = Nd4j.createUninitialized(shape, Nd4j.order().charValue());
        Nd4j.logCreationIfNecessary(ret);
        return Nd4j.rand(ret, min, max, rng);
    }

    public static INDArray rand(int rows, int columns, double min, double max, org.nd4j.linalg.api.rng.Random rng) {
        INDArray ret = Nd4j.createUninitialized(rows, columns);
        Nd4j.logCreationIfNecessary(ret);
        return Nd4j.rand(ret, min, max, rng);
    }

    public static INDArray randn(INDArray target) {
        return Nd4j.getExecutioner().exec(new GaussianDistribution(target), Nd4j.getRandom());
    }

    public static INDArray randn(int[] shape) {
        INDArray ret = Nd4j.createUninitialized(shape, Nd4j.order().charValue());
        Nd4j.logCreationIfNecessary(ret);
        return Nd4j.randn(ret);
    }

    public static INDArray randn(long[] shape) {
        INDArray ret = Nd4j.createUninitialized(shape, Nd4j.order().charValue());
        Nd4j.logCreationIfNecessary(ret);
        return Nd4j.randn(ret);
    }

    public static INDArray randn(char order, int[] shape) {
        INDArray ret = Nd4j.createUninitialized(shape, order);
        Nd4j.logCreationIfNecessary(ret);
        return Nd4j.randn(ret);
    }

    public static INDArray randn(char order, long[] shape) {
        INDArray ret = Nd4j.createUninitialized(shape, order);
        Nd4j.logCreationIfNecessary(ret);
        return Nd4j.randn(ret);
    }

    public static INDArray randn(int[] shape, long seed) {
        INDArray ret = Nd4j.createUninitialized(shape, Nd4j.order().charValue());
        Nd4j.logCreationIfNecessary(ret);
        return Nd4j.randn(ret, seed);
    }

    public static INDArray randn(long rows, long columns) {
        INDArray ret = Nd4j.createUninitialized(new long[]{rows, columns}, Nd4j.order().charValue());
        Nd4j.logCreationIfNecessary(ret);
        return Nd4j.randn(ret);
    }

    public static INDArray randn(char order, long rows, long columns) {
        INDArray ret = Nd4j.createUninitialized(new long[]{rows, columns}, order);
        Nd4j.logCreationIfNecessary(ret);
        return Nd4j.randn(ret);
    }

    public static INDArray randn(long rows, long columns, long seed) {
        INDArray ret = Nd4j.createUninitialized(new long[]{rows, columns}, Nd4j.order().charValue());
        Nd4j.logCreationIfNecessary(ret);
        return Nd4j.randn(ret, seed);
    }

    public static INDArray randn(long rows, long columns, org.nd4j.linalg.api.rng.Random r) {
        INDArray ret = Nd4j.createUninitialized(new long[]{rows, columns}, Nd4j.order().charValue());
        Nd4j.logCreationIfNecessary(ret);
        return Nd4j.randn(ret, r);
    }

    public static INDArray randn(int[] shape, org.nd4j.linalg.api.rng.Random r) {
        INDArray ret = Nd4j.createUninitialized(shape, Nd4j.order().charValue());
        Nd4j.logCreationIfNecessary(ret);
        return Nd4j.randn(ret, r);
    }

    public static INDArray randn(long[] shape, org.nd4j.linalg.api.rng.Random r) {
        INDArray ret = Nd4j.createUninitialized(shape, Nd4j.order().charValue());
        Nd4j.logCreationIfNecessary(ret);
        return Nd4j.randn(ret, r);
    }

    public static INDArray rand(INDArray target) {
        return Nd4j.getExecutioner().exec(new UniformDistribution(target), Nd4j.getRandom());
    }

    public static INDArray rand(INDArray target, long seed) {
        Nd4j.getRandom().setSeed(seed);
        return Nd4j.getExecutioner().exec(new UniformDistribution(target), Nd4j.getRandom());
    }

    public static INDArray rand(INDArray target, org.nd4j.linalg.api.rng.Random rng) {
        return Nd4j.getExecutioner().exec(new UniformDistribution(target), rng);
    }

    public static INDArray rand(INDArray target, Distribution dist) {
        return dist.sample(target);
    }

    public static INDArray rand(INDArray target, double min, double max, org.nd4j.linalg.api.rng.Random rng) {
        if (min > max) {
            throw new IllegalArgumentException("the maximum value supplied is smaller than the minimum");
        }
        return Nd4j.getExecutioner().exec(new UniformDistribution(target, min, max), rng);
    }

    public static INDArray randn(INDArray target, long seed) {
        Nd4j.getRandom().setSeed(seed);
        return Nd4j.getExecutioner().exec(new GaussianDistribution(target), Nd4j.getRandom());
    }

    public static INDArray randn(INDArray target, org.nd4j.linalg.api.rng.Random rng) {
        return Nd4j.getExecutioner().exec(new GaussianDistribution(target), rng);
    }

    public static INDArray randomBernoulli(double p, long ... shape) {
        return Nd4j.randomBernoulli(p, Nd4j.createUninitialized(shape));
    }

    public static INDArray randomBernoulli(double p, @NonNull INDArray target) {
        if (target == null) {
            throw new NullPointerException("target is marked @NonNull but is null");
        }
        Preconditions.checkArgument((p >= 0.0 && p <= 1.0 ? 1 : 0) != 0, (String)"Invalid probability: must be in range 0 to 1, got %s", (double)p);
        return Nd4j.getExecutioner().exec(new BernoulliDistribution(target, p));
    }

    public static INDArray randomBinomial(int nTrials, double p, long ... shape) {
        return Nd4j.randomBinomial(nTrials, p, Nd4j.createUninitialized(shape));
    }

    public static INDArray randomBinomial(int nTrials, double p, INDArray target) {
        Preconditions.checkArgument((p >= 0.0 && p <= 1.0 ? 1 : 0) != 0, (String)"Invalid probability: must be in range 0 to 1, got %s", (double)p);
        Preconditions.checkArgument((nTrials >= 0 ? 1 : 0) != 0, (String)"Number of trials must be positive: got %s", (int)nTrials);
        return Nd4j.getExecutioner().exec(new BinomialDistribution(target, nTrials, p));
    }

    public static INDArray randomExponential(double lambda, long ... shape) {
        return Nd4j.randomExponential(lambda, Nd4j.createUninitialized(shape));
    }

    public static INDArray randomExponential(double lambda, INDArray target) {
        Preconditions.checkArgument((lambda > 0.0 ? 1 : 0) != 0, (String)"Lambda argument must be >= 0 - got %s", (double)lambda);
        INDArray shapeArr = Nd4j.create(ArrayUtil.toDouble((long[])target.shape()));
        Nd4j.getExecutioner().exec(new RandomExponential(shapeArr, target, lambda));
        return target;
    }

    public static INDArray createUninitialized(long rows, long columns) {
        return Nd4j.createUninitialized(new long[]{rows, columns});
    }

    public static INDArray create(float[] data) {
        return Nd4j.create(data, Nd4j.order().charValue());
    }

    public static INDArray create(List<? extends Number> list) {
        INDArray array = Nd4j.create(list.size());
        int cnt = 0;
        if (Nd4j.dataType() == DataBuffer.Type.DOUBLE) {
            for (Number number : list) {
                array.putScalar((long)cnt++, number.doubleValue());
            }
        } else {
            for (Number number : list) {
                array.putScalar((long)cnt++, number.floatValue());
            }
        }
        return array;
    }

    public static INDArray create(double[] data) {
        return Nd4j.create(data, Nd4j.order().charValue());
    }

    public static INDArray create(float[][] data) {
        return INSTANCE.create(data);
    }

    public static INDArray create(float[][] data, char ordering) {
        return INSTANCE.create(data, ordering);
    }

    public static INDArray create(double[][] data) {
        return INSTANCE.create(data);
    }

    public static INDArray create(double[][][] data) {
        return Nd4j.create(ArrayUtil.flatten((double[][][])data), new int[]{data.length, data[0].length, data[0][0].length});
    }

    public static INDArray create(float[][][] data) {
        return Nd4j.create(ArrayUtil.flatten((float[][][])data), new int[]{data.length, data[0].length, data[0][0].length});
    }

    public static INDArray create(int[][][] data) {
        return Nd4j.create(ArrayUtil.flatten((int[][][])data), new int[]{data.length, data[0].length, data[0][0].length});
    }

    public static INDArray create(double[][][][] data) {
        return Nd4j.create(ArrayUtil.flatten((double[][][][])data), new int[]{data.length, data[0].length, data[0][0].length, data[0][0][0].length});
    }

    public static INDArray create(float[][][][] data) {
        return Nd4j.create(ArrayUtil.flatten((float[][][][])data), new int[]{data.length, data[0].length, data[0][0].length, data[0][0][0].length});
    }

    public static INDArray create(int[][][][] data) {
        return Nd4j.create(ArrayUtil.flatten((int[][][][])data), new int[]{data.length, data[0].length, data[0][0].length, data[0][0][0].length});
    }

    public static INDArray create(double[][] data, char ordering) {
        return INSTANCE.create(data, ordering);
    }

    public static INDArray create(int columns) {
        return Nd4j.create(columns, Nd4j.order().charValue());
    }

    public static INDArray create(float[] data, char order) {
        INDArray ret = INSTANCE.create(data, order);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray create(double[] data, char order) {
        INDArray ret = INSTANCE.create(data, order);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray create(int columns, char order) {
        if (columns < 1) {
            throw new ND4JIllegalStateException("Number of columns should be positive for new INDArray");
        }
        INDArray ret = INSTANCE.create(new int[]{1, columns}, Nd4j.getStrides(new int[]{1, columns}, order), 0L, order);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray zeros(int columns, char order) {
        return Nd4j.create(columns, order);
    }

    public static INDArray trueScalar(Number scalar) {
        INDArray ret = INSTANCE.trueScalar(scalar);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray trueVector(float[] data) {
        INDArray ret = INSTANCE.trueVector(data);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray trueVector(double[] data) {
        INDArray ret = INSTANCE.trueVector(data);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray empty() {
        return Nd4j.empty(Nd4j.dataType());
    }

    public static INDArray empty(DataBuffer.Type type) {
        INDArray ret = INSTANCE.empty(type);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray create(float[] data, int[] shape) {
        if (shape.length == 0 && data.length == 1) {
            return Nd4j.trueScalar(Float.valueOf(data[0]));
        }
        if ((shape = Nd4j.getEnsuredShape(shape)).length == 1 && shape[0] != data.length) {
            throw new ND4JIllegalStateException("Shape of the new array doesn't match data length");
        }
        Nd4j.checkShapeValues(data.length, shape);
        INDArray ret = INSTANCE.create(data, shape);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray create(float[] data, long[] shape) {
        if (shape.length == 0 && data.length == 1) {
            return Nd4j.trueScalar(Float.valueOf(data[0]));
        }
        if ((shape = Nd4j.getEnsuredShape(shape)).length == 1 && shape[0] != (long)data.length) {
            throw new ND4JIllegalStateException("Shape of the new array doesn't match data length");
        }
        Nd4j.checkShapeValues(data.length, shape);
        INDArray ret = INSTANCE.create(data, shape);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray create(double[] data, long[] shape) {
        if (shape.length == 0 && data.length == 1) {
            return Nd4j.trueScalar(data[0]);
        }
        if ((shape = Nd4j.getEnsuredShape(shape)).length == 1 && shape[0] != (long)data.length) {
            throw new ND4JIllegalStateException("Shape of the new array doesn't match data length");
        }
        Nd4j.checkShapeValues(data.length, shape);
        INDArray ret = INSTANCE.create(data, shape);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray create(double[] data, int[] shape) {
        if ((shape = Nd4j.getEnsuredShape(shape)).length == 1 && shape[0] != data.length) {
            throw new ND4JIllegalStateException("Shape of the new array " + Arrays.toString(shape) + " doesn't match data length: " + data.length);
        }
        Nd4j.checkShapeValues(data.length, shape);
        INDArray ret = INSTANCE.create(data, shape);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray create(double[] data, int[] shape, int[] stride, long offset) {
        if ((shape = Nd4j.getEnsuredShape(shape)).length == 1) {
            if (shape[0] == data.length) {
                shape = new int[]{1, data.length};
            } else {
                throw new ND4JIllegalStateException("Shape of the new array " + Arrays.toString(shape) + " doesn't match data length: " + data.length);
            }
        }
        Nd4j.checkShapeValues(data.length, shape);
        INDArray ret = INSTANCE.create(data, shape, stride, offset);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray create(double[] data, long[] shape, long[] stride, long offset, char order) {
        shape = Nd4j.getEnsuredShape(shape);
        Nd4j.checkShapeValues(data.length, shape);
        INDArray ret = INSTANCE.create(data, shape, stride, offset, order);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray create(float[] data, int rows, int columns, int[] stride, long offset) {
        if (rows < 1 || columns < 1) {
            throw new ND4JIllegalStateException("Number of rows and columns should be positive for new INDArray");
        }
        INDArray ret = INSTANCE.create(data, (long)rows, (long)columns, stride, offset);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray create(double[] data, int rows, int columns, int[] stride, long offset) {
        if (rows < 1 || columns < 1) {
            throw new ND4JIllegalStateException("Number of rows and columns should be positive for new INDArray");
        }
        INDArray ret = INSTANCE.create(data, (long)rows, (long)columns, stride, offset);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray create(float[] data, int[] shape, long offset) {
        if ((shape = Nd4j.getEnsuredShape(shape)).length == 1) {
            if (shape[0] == data.length) {
                shape = new int[]{1, data.length};
            } else {
                throw new ND4JIllegalStateException("Shape of the new array " + Arrays.toString(shape) + " doesn't match data length: " + data.length);
            }
        }
        Nd4j.checkShapeValues(data.length, shape);
        INDArray ret = INSTANCE.create(data, shape, offset, Nd4j.order());
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray create(float[] data, long[] shape, long offset) {
        if ((shape = Nd4j.getEnsuredShape(shape)).length == 1) {
            if (shape[0] == (long)data.length) {
                shape = new long[]{1L, data.length};
            } else {
                throw new ND4JIllegalStateException("Shape of the new array " + Arrays.toString(shape) + " doesn't match data length: " + data.length);
            }
        }
        Nd4j.checkShapeValues(data.length, shape);
        INDArray ret = INSTANCE.create(data, shape, offset, Nd4j.order());
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray create(double[] data, int[] shape, long offset, char ordering) {
        if ((shape = Nd4j.getEnsuredShape(shape)).length == 1) {
            if (shape[0] == data.length) {
                shape = new int[]{1, data.length};
            } else {
                throw new ND4JIllegalStateException("Shape of the new array " + Arrays.toString(shape) + " doesn't match data length: " + data.length);
            }
        }
        Nd4j.checkShapeValues(data.length, shape);
        INDArray ret = INSTANCE.create(data, shape, Nd4j.getStrides(shape, ordering), offset, ordering);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray create(double[] data, long[] shape, long offset, char ordering) {
        if ((shape = Nd4j.getEnsuredShape(shape)).length == 1) {
            if (shape[0] == (long)data.length) {
                shape = new long[]{1L, data.length};
            } else {
                throw new ND4JIllegalStateException("Shape of the new array " + Arrays.toString(shape) + " doesn't match data length: " + data.length);
            }
        }
        Nd4j.checkShapeValues(data.length, shape);
        INDArray ret = INSTANCE.create(data, shape, Nd4j.getStrides(shape, ordering), offset, ordering);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray create(float[] data, int[] shape, int[] stride, long offset) {
        if ((shape = Nd4j.getEnsuredShape(shape)).length == 1) {
            if (shape[0] == data.length) {
                shape = new int[]{1, data.length};
            } else {
                throw new ND4JIllegalStateException("Shape of the new array " + Arrays.toString(shape) + " doesn't match data length: " + data.length);
            }
        }
        Nd4j.checkShapeValues(data.length, shape);
        INDArray ret = INSTANCE.create(data, shape, stride, offset);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray create(List<INDArray> list, int[] shape) {
        shape = Nd4j.getEnsuredShape(shape);
        Nd4j.checkShapeValues(shape);
        INDArray ret = INSTANCE.create(list, shape);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray create(List<INDArray> list, long[] shape) {
        shape = Nd4j.getEnsuredShape(shape);
        Nd4j.checkShapeValues(shape);
        INDArray ret = INSTANCE.create(list, shape);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray create(int rows, int columns, int[] stride, long offset) {
        if (rows < 1 || columns < 1) {
            throw new ND4JIllegalStateException("Number of rows and columns should be positive for new INDArray");
        }
        INDArray ret = INSTANCE.create((long)rows, (long)columns, stride, offset);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray zeros(int rows, int columns, int[] stride, long offset) {
        return Nd4j.create(rows, columns, stride, offset);
    }

    public static INDArray create(int[] shape, int[] stride, long offset) {
        shape = Nd4j.getEnsuredShape(shape);
        Nd4j.checkShapeValues(shape);
        INDArray ret = INSTANCE.create(shape, stride, offset);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray zeros(int[] shape, int[] stride, long offset) {
        return Nd4j.create(shape, stride, offset);
    }

    public static INDArray create(int rows, int columns, int[] stride) {
        return Nd4j.create(rows, columns, stride, Nd4j.order().charValue());
    }

    public static INDArray zeros(int rows, int columns, int[] stride) {
        return Nd4j.create(rows, columns, stride, Nd4j.order().charValue());
    }

    public static INDArray create(int[] shape, int[] stride) {
        return Nd4j.create(shape, stride, Nd4j.order().charValue());
    }

    public static INDArray create(long[] shape, long[] stride) {
        return Nd4j.create(shape, stride, Nd4j.order().charValue());
    }

    public static INDArray zeros(int[] shape, int[] stride) {
        return Nd4j.create(shape, stride);
    }

    public static INDArray create(int rows, int columns) {
        return Nd4j.create((long)rows, (long)columns, Nd4j.order().charValue());
    }

    public static INDArray create(int ... shape) {
        return Nd4j.create(shape, Nd4j.order().charValue());
    }

    public static INDArray create(long ... shape) {
        return Nd4j.create(shape, Nd4j.order().charValue());
    }

    public static INDArray create(float[] data, int[] shape, int[] stride, char ordering, long offset) {
        if ((shape = Nd4j.getEnsuredShape(shape)).length == 1) {
            if (shape[0] == data.length) {
                shape = new int[]{1, data.length};
            } else {
                throw new ND4JIllegalStateException("Shape of the new array " + Arrays.toString(shape) + " doesn't match data length: " + data.length);
            }
        }
        Nd4j.checkShapeValues(data.length, shape);
        INDArray ret = INSTANCE.create(data, shape, stride, offset, ordering);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray create(float[] data, int[] shape, char ordering, long offset) {
        if ((shape = Nd4j.getEnsuredShape(shape)).length == 1 && shape[0] != data.length) {
            throw new ND4JIllegalStateException("Shape of the new array " + Arrays.toString(shape) + " doesn't match data length: " + data.length);
        }
        Nd4j.checkShapeValues(data.length, shape);
        INDArray ret = INSTANCE.create(data, shape, Nd4j.getStrides(shape, ordering), offset, ordering);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray create(double[] data, int[] shape, char ordering, long offset) {
        if ((shape = Nd4j.getEnsuredShape(shape)).length == 1 && shape[0] != data.length) {
            throw new ND4JIllegalStateException("Shape of the new array " + Arrays.toString(shape) + " doesn't match data length: " + data.length);
        }
        Nd4j.checkShapeValues(data.length, shape);
        INDArray ret = INSTANCE.create(data, shape, Nd4j.getStrides(shape, ordering), offset, ordering);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray create(DataBuffer data, int[] shape, int[] strides, long offset) {
        shape = Nd4j.getEnsuredShape(shape);
        Nd4j.checkShapeValues(shape);
        INDArray ret = INSTANCE.create(data, shape, strides, offset);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray create(DataBuffer data, long[] shape, long[] strides, long offset) {
        shape = Nd4j.getEnsuredShape(shape);
        Nd4j.checkShapeValues(shape);
        INDArray ret = INSTANCE.create(data, shape, strides, offset);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray create(DataBuffer data, int[] shape, long offset) {
        shape = Nd4j.getEnsuredShape(shape);
        Nd4j.checkShapeValues(shape);
        INDArray ret = INSTANCE.create(data, shape, Nd4j.getStrides(shape), offset);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray create(DataBuffer data, int[] newShape, int[] newStride, long offset, char ordering) {
        Nd4j.checkShapeValues(newShape);
        INDArray ret = INSTANCE.create(data, newShape, newStride, offset, ordering);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray create(DataBuffer data, long[] newShape, long[] newStride, long offset, char ordering) {
        Nd4j.checkShapeValues(newShape);
        INDArray ret = INSTANCE.create(data, newShape, newStride, offset, ordering);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray create(DataBuffer data, int[] shape) {
        Nd4j.checkShapeValues(shape);
        INDArray ret = INSTANCE.create(data, shape);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray create(DataBuffer data, long[] shape) {
        Nd4j.checkShapeValues(shape);
        INDArray ret = INSTANCE.create(data, shape);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray create(DataBuffer buffer) {
        INDArray ret = INSTANCE.create(buffer);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray create(float[] data, int rows, int columns, int[] stride, long offset, char ordering) {
        int[] shape = new int[]{rows, columns};
        shape = Nd4j.getEnsuredShape(shape);
        Nd4j.checkShapeValues(data.length, shape);
        INDArray ret = INSTANCE.create(data, shape, stride, offset, ordering);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray create(int[] shape, DataBuffer.Type dataType) {
        shape = Nd4j.getEnsuredShape(shape);
        Nd4j.checkShapeValues(shape);
        INDArray ret = INSTANCE.create(shape, dataType);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray zeros(int[] shape, DataBuffer.Type dataType) {
        return Nd4j.create(shape, dataType);
    }

    public static INDArray create(double[] data, int[] shape, int[] stride, long offset, char ordering) {
        if (data.length == 1 && shape.length == 0) {
            return Nd4j.trueScalar(data[0]);
        }
        if ((shape = Nd4j.getEnsuredShape(shape)).length == 1 && shape[0] != data.length) {
            throw new ND4JIllegalStateException("Shape of the new array " + Arrays.toString(shape) + " doesn't match data length: " + data.length);
        }
        Nd4j.checkShapeValues(data.length, shape);
        INDArray ret = INSTANCE.create(data, shape, stride, offset, ordering);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray create(double[] data, int[] shape, char ordering) {
        if ((shape = Nd4j.getEnsuredShape(shape)).length == 1) {
            if (shape[0] == data.length) {
                shape = new int[]{1, data.length};
            } else {
                throw new ND4JIllegalStateException("Shape of the new array " + Arrays.toString(shape) + " doesn't match data length: " + data.length);
            }
        }
        Nd4j.checkShapeValues(data.length, shape);
        INDArray ret = INSTANCE.create(data, shape, ordering);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray create(float[] data, int[] shape, char ordering) {
        if ((shape = Nd4j.getEnsuredShape(shape)).length == 1) {
            if (shape[0] == data.length) {
                shape = new int[]{1, data.length};
            } else {
                throw new ND4JIllegalStateException("Shape of the new array " + Arrays.toString(shape) + " doesn't match data length: " + data.length);
            }
        }
        Nd4j.checkShapeValues(data.length, shape);
        INDArray ret = INSTANCE.create(data, shape, ordering);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray create(float[] data, long[] shape, char ordering) {
        shape = Nd4j.getEnsuredShape(shape);
        Nd4j.checkShapeValues(data.length, shape);
        INDArray ret = INSTANCE.create(data, shape, 0L, Character.valueOf(ordering));
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray create(double[] data, long[] shape, char ordering) {
        shape = Nd4j.getEnsuredShape(shape);
        Nd4j.checkShapeValues(data.length, shape);
        INDArray ret = INSTANCE.create(data, shape, 0L, Character.valueOf(ordering));
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray create(double[] data, int rows, int columns, int[] stride, long offset, char ordering) {
        int[] shape = Nd4j.getEnsuredShape(rows, columns);
        Nd4j.checkShapeValues(data.length, shape);
        INDArray ret = INSTANCE.create(Nd4j.createBuffer(data), shape, stride, offset, ordering);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray create(float[] data, int[] shape, int[] stride, long offset, char ordering) {
        if ((shape = Nd4j.getEnsuredShape(shape)).length == 1) {
            if (shape[0] == data.length) {
                shape = new int[]{1, data.length};
            } else {
                throw new ND4JIllegalStateException("Shape of the new array " + Arrays.toString(shape) + " doesn't match data length: " + data.length);
            }
        }
        Nd4j.checkShapeValues(data.length, shape);
        INDArray ret = INSTANCE.create(data, shape, stride, offset, ordering);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray create(List<INDArray> list, int[] shape, char ordering) {
        shape = Nd4j.getEnsuredShape(shape);
        Nd4j.checkShapeValues(shape);
        INDArray ret = INSTANCE.create(list, shape, ordering);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray create(int rows, int columns, int[] stride, long offset, char ordering) {
        int[] shape = Nd4j.getEnsuredShape(rows, columns);
        Nd4j.checkShapeValues(shape);
        INDArray ret = INSTANCE.create(shape, stride, offset, ordering);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray zeros(int rows, int columns, int[] stride, long offset, char ordering) {
        return Nd4j.create(rows, columns, stride, offset, ordering);
    }

    public static INDArray create(int[] shape, int[] stride, long offset, char ordering) {
        if (shape.length == 0) {
            return Nd4j.trueScalar(0.0);
        }
        shape = Nd4j.getEnsuredShape(shape);
        Nd4j.checkShapeValues(shape);
        INDArray ret = INSTANCE.create(shape, stride, offset, ordering);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray create(long[] shape, long[] stride, long offset, char ordering) {
        if (shape.length == 0) {
            return Nd4j.trueScalar(0.0);
        }
        shape = Nd4j.getEnsuredShape(shape);
        Nd4j.checkShapeValues(shape);
        INDArray ret = INSTANCE.create(shape, stride, offset, ordering);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray zeros(int[] shape, int[] stride, long offset, char ordering) {
        return Nd4j.create(shape, stride, offset, ordering);
    }

    public static INDArray create(int rows, int columns, int[] stride, char ordering) {
        int[] shape = Nd4j.getEnsuredShape(rows, columns);
        Nd4j.checkShapeValues(shape);
        INDArray ret = INSTANCE.create(shape, stride, 0L, ordering);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray zeros(int rows, int columns, int[] stride, char ordering) {
        return Nd4j.create(rows, columns, stride, ordering);
    }

    public static INDArray create(int[] shape, int[] stride, char ordering) {
        if (shape.length == 0) {
            return Nd4j.trueScalar(0.0);
        }
        shape = Nd4j.getEnsuredShape(shape);
        Nd4j.checkShapeValues(shape);
        INDArray ret = INSTANCE.create(shape, stride, 0L, ordering);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray create(long[] shape, long[] stride, char ordering) {
        if (shape.length == 0) {
            return Nd4j.trueScalar(0.0);
        }
        shape = Nd4j.getEnsuredShape(shape);
        Nd4j.checkShapeValues(shape);
        INDArray ret = INSTANCE.create(shape, stride, 0L, ordering);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray zeros(int[] shape, int[] stride, char ordering) {
        return Nd4j.create(shape, stride, ordering);
    }

    public static INDArray create(long rows, long columns, char ordering) {
        return Nd4j.create(new long[]{rows, columns}, ordering);
    }

    public static INDArray zeros(int rows, int columns, char ordering) {
        return Nd4j.create(new int[]{rows, columns}, ordering);
    }

    public static INDArray create(@NonNull int[] shape, char ordering) {
        if (shape == null) {
            throw new NullPointerException("shape is marked @NonNull but is null");
        }
        if (shape.length == 0) {
            return Nd4j.trueScalar(0.0);
        }
        if (shape.length == 1 && shape[0] == 0) {
            shape = new int[]{1, 1};
        } else if (shape.length == 1) {
            shape = new int[]{1, shape[0]};
        }
        Nd4j.checkShapeValues(shape);
        INDArray ret = INSTANCE.create(shape, ordering);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray create(@NonNull long[] shape, char ordering) {
        if (shape == null) {
            throw new NullPointerException("shape is marked @NonNull but is null");
        }
        if (shape.length == 0) {
            return Nd4j.trueScalar(0.0);
        }
        Nd4j.checkShapeValues(shape);
        INDArray ret = INSTANCE.create(shape, ordering);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static void checkShapeValues(long[] shape) {
        for (long e : shape) {
            if (e >= 1L) continue;
            throw new ND4JIllegalStateException("Invalid shape: Requested INDArray shape " + Arrays.toString(shape) + " contains dimension size values < 1 (all dimensions must be 1 or more)");
        }
    }

    public static void checkShapeValues(int[] shape) {
        for (int e : shape) {
            if (e >= 1) continue;
            throw new ND4JIllegalStateException("Invalid shape: Requested INDArray shape " + Arrays.toString(shape) + " contains dimension size values < 1 (all dimensions must be 1 or more)");
        }
    }

    protected static void checkShapeValues(int length, int[] shape) {
        Nd4j.checkShapeValues(shape);
        if (ArrayUtil.prodLong((int[])shape) > (long)length) {
            throw new ND4JIllegalStateException("Shape of the new array " + Arrays.toString(shape) + " doesn't match data length: " + length);
        }
    }

    protected static void checkShapeValues(int length, long[] shape) {
        Nd4j.checkShapeValues(shape);
        if (ArrayUtil.prodLong((long[])shape) > (long)length) {
            throw new ND4JIllegalStateException("Shape of the new array " + Arrays.toString(shape) + " doesn't match data length: " + length);
        }
    }

    public static INDArray createUninitialized(int[] shape, char ordering) {
        if (shape.length == 0) {
            return Nd4j.trueScalar(0.0);
        }
        shape = Nd4j.getEnsuredShape(shape);
        Nd4j.checkShapeValues(shape);
        INDArray ret = INSTANCE.createUninitialized(shape, ordering);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray createUninitialized(long[] shape, char ordering) {
        if (shape.length == 0) {
            return Nd4j.trueScalar(0.0);
        }
        shape = Nd4j.getEnsuredShape(shape);
        Nd4j.checkShapeValues(shape);
        INDArray ret = INSTANCE.createUninitialized(shape, ordering);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray createUninitializedDetached(int[] shape, char ordering) {
        if (shape.length == 0) {
            return Nd4j.trueScalar(0.0);
        }
        if (shape.length == 1 && shape[0] == 0) {
            shape = new int[]{1, 1};
        } else if (shape.length == 1) {
            shape = new int[]{1, shape[0]};
        }
        Nd4j.checkShapeValues(shape);
        INDArray ret = INSTANCE.createUninitializedDetached(shape, ordering);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray createUninitializedDetached(long[] shape, char ordering) {
        if (shape.length == 0) {
            return Nd4j.trueScalar(0.0);
        }
        if (shape.length == 1 && shape[0] == 0L) {
            shape = new long[]{1L, 1L};
        } else if (shape.length == 1) {
            shape = new long[]{1L, shape[0]};
        }
        Nd4j.checkShapeValues(shape);
        INDArray ret = INSTANCE.createUninitializedDetached(shape, ordering);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray createUninitialized(int[] shape) {
        if (shape.length == 0) {
            return Nd4j.trueScalar(0.0);
        }
        Nd4j.checkShapeValues(shape);
        return Nd4j.createUninitialized(shape, Nd4j.order().charValue());
    }

    public static INDArray createUninitialized(long[] shape) {
        Nd4j.checkShapeValues(shape);
        return Nd4j.createUninitialized(shape, Nd4j.order().charValue());
    }

    public static INDArray createUninitializedDetached(int[] shape) {
        return Nd4j.createUninitializedDetached(shape, Nd4j.order().charValue());
    }

    public static INDArray createUninitializedDetached(long[] shape) {
        return Nd4j.createUninitializedDetached(shape, Nd4j.order().charValue());
    }

    public static INDArray createUninitialized(int length) {
        if (length < 1) {
            throw new IllegalStateException("INDArray length should be positive value");
        }
        int[] shape = new int[]{1, length};
        INDArray ret = INSTANCE.createUninitialized(shape, Nd4j.order().charValue());
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray createUninitialized(long length) {
        if (length < 1L) {
            throw new IllegalStateException("INDArray length should be positive value");
        }
        long[] shape = new long[]{1L, length};
        INDArray ret = INSTANCE.createUninitialized(shape, Nd4j.order().charValue());
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray createUninitializedDetached(int length) {
        if (length < 1) {
            throw new IllegalStateException("INDArray length should be positive value");
        }
        int[] shape = new int[]{1, length};
        INDArray ret = INSTANCE.createUninitializedDetached(shape, Nd4j.order().charValue());
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray create(double[] data, int[] shape, long offset) {
        if ((shape = Nd4j.getEnsuredShape(shape)).length == 1) {
            if (shape[0] == data.length) {
                shape = new int[]{1, data.length};
            } else {
                throw new ND4JIllegalStateException("Shape of the new array " + Arrays.toString(shape) + " doesn't match data length: " + data.length);
            }
        }
        Nd4j.checkShapeValues(data.length, shape);
        INDArray ret = INSTANCE.create(data, shape, offset);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray createSparseCSR(double[] data, int[] columns, int[] pointerB, int[] pointerE, long[] shape) {
        INDArray matrix = SPARSE_INSTANCE.createSparseCSR(data, columns, pointerB, pointerE, shape);
        return matrix;
    }

    public static INDArray createSparseCSR(float[] data, int[] columns, int[] pointerB, int[] pointerE, long[] shape) {
        INDArray matrix = SPARSE_INSTANCE.createSparseCSR(data, columns, pointerB, pointerE, shape);
        return matrix;
    }

    public static INDArray createSparseCSR(DataBuffer data, int[] columns, int[] pointerB, int[] pointerE, long[] shape) {
        INDArray matrix = SPARSE_INSTANCE.createSparseCSR(data, columns, pointerB, pointerE, shape);
        return matrix;
    }

    public static INDArray createSparseCOO(double[] data, int[][] indices, long[] shape) {
        INDArray matrix = SPARSE_INSTANCE.createSparseCOO(data, indices, shape);
        return matrix;
    }

    public static INDArray createSparseCOO(float[] data, int[][] indices, long[] shape) {
        INDArray matrix = SPARSE_INSTANCE.createSparseCOO(data, indices, shape);
        return matrix;
    }

    public static INDArray createSparseCOO(double[] data, long[][] indices, long[] shape) {
        INDArray matrix = SPARSE_INSTANCE.createSparseCOO(data, indices, shape);
        return matrix;
    }

    public static INDArray createSparseCOO(float[] data, long[][] indices, long[] shape) {
        INDArray matrix = SPARSE_INSTANCE.createSparseCOO(data, indices, shape);
        return matrix;
    }

    public static INDArray createSparseCOO(DataBuffer data, DataBuffer indices, long[] shape) {
        INDArray matrix = SPARSE_INSTANCE.createSparseCOO(data, indices, shape);
        return matrix;
    }

    public static INDArray createSparseCOO(DataBuffer values, DataBuffer indices, DataBuffer sparseInformation, long[] shape) {
        INDArray matrix = SPARSE_INSTANCE.createSparseCOO(values, indices, sparseInformation, shape);
        return matrix;
    }

    public static INDArray createSparseCOO(DataBuffer values, DataBuffer indices, long[] sparseOffsets, int[] flags, long[] shape, int[] hiddenDimensions, int underlyingRank) {
        INDArray matrix = SPARSE_INSTANCE.createSparseCOO(values, indices, sparseOffsets, flags, hiddenDimensions, underlyingRank, shape);
        return matrix;
    }

    public static INDArray zeros(long rows, long columns) {
        INDArray ret = INSTANCE.zeros(rows, columns);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray zeros(int columns) {
        return INSTANCE.zeros(columns);
    }

    public static INDArray valueArrayOf(int[] shape, double value) {
        if (shape.length == 0) {
            return Nd4j.trueScalar(value);
        }
        Nd4j.checkShapeValues(shape);
        INDArray ret = INSTANCE.valueArrayOf(shape, value);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray valueArrayOf(long[] shape, double value) {
        if (shape.length == 0) {
            return Nd4j.trueScalar(value);
        }
        Nd4j.checkShapeValues(shape);
        INDArray ret = INSTANCE.valueArrayOf(shape, value);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray valueArrayOf(long num, double value) {
        INDArray ret = INSTANCE.valueArrayOf(new long[]{1L, num}, value);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray valueArrayOf(long rows, long columns, double value) {
        if (rows < 1L || columns < 1L) {
            throw new ND4JIllegalStateException("Number of rows and columns should be positive for new INDArray");
        }
        INDArray ret = INSTANCE.valueArrayOf(rows, columns, value);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray ones(int rows, int columns) {
        INDArray ret = INSTANCE.ones(rows, columns);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray zerosLike(INDArray arr) {
        return Nd4j.create(arr.shape());
    }

    public static INDArray emptyLike(INDArray arr) {
        return Nd4j.create(arr.shape());
    }

    public static INDArray onesLike(INDArray arr) {
        return Nd4j.ones(arr.shape());
    }

    public static INDArray ones(int columns) {
        INDArray ret = INSTANCE.ones(columns);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray hstack(INDArray ... arrs) {
        INDArray ret = INSTANCE.hstack(arrs);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray hstack(Collection<INDArray> arrs) {
        INDArray[] arrays = arrs.toArray(new INDArray[0]);
        INDArray ret = INSTANCE.hstack(arrays);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray vstack(INDArray ... arrs) {
        INDArray ret = INSTANCE.vstack(arrs);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray vstack(Collection<INDArray> arrs) {
        INDArray[] arrays = arrs.toArray(new INDArray[0]);
        INDArray ret = INSTANCE.vstack(arrays);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray averageAndPropagate(INDArray target, INDArray[] arrays) {
        INDArray ret = INSTANCE.average(target, arrays);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray averageAndPropagate(INDArray[] arrays) {
        INDArray ret = INSTANCE.average(arrays);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray averageAndPropagate(Collection<INDArray> arrays) {
        INDArray ret = INSTANCE.average(arrays);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray averageAndPropagate(INDArray target, Collection<INDArray> arrays) {
        INDArray ret = INSTANCE.average(target, arrays);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray stripOnes(INDArray toStrip) {
        if (toStrip.isVector()) {
            return toStrip;
        }
        long[] shape = Shape.squeeze(toStrip.shape());
        return toStrip.reshape(shape);
    }

    public static INDArray accumulate(Collection<INDArray> arrays) {
        if (arrays == null || arrays.size() == 0) {
            throw new ND4JIllegalStateException("Input for accumulation is null or empty");
        }
        return Nd4j.accumulate(arrays.toArray(new INDArray[0]));
    }

    public static INDArray accumulate(INDArray ... arrays) {
        if (arrays == null || arrays.length == 0) {
            throw new ND4JIllegalStateException("Input for accumulation is null or empty");
        }
        return Nd4j.accumulate(Nd4j.create(arrays[0].shape(), arrays[0].ordering()), arrays);
    }

    public static INDArray accumulate(INDArray target, Collection<INDArray> arrays) {
        return Nd4j.accumulate(target, arrays.toArray(new INDArray[0]));
    }

    public static INDArray accumulate(INDArray target, INDArray[] arrays) {
        if (arrays == null || arrays.length == 0) {
            return target;
        }
        return Nd4j.factory().accumulate(target, arrays);
    }

    public static INDArray pullRows(INDArray source, int sourceDimension, int[] indexes) {
        return Nd4j.pullRows(source, sourceDimension, indexes, Nd4j.order().charValue());
    }

    public static INDArray pullRows(INDArray source, int sourceDimension, int[] indexes, char order) {
        if (sourceDimension >= source.rank()) {
            throw new IllegalStateException("Source dimension can't be higher the rank of source tensor");
        }
        if (indexes == null || indexes.length == 0) {
            throw new IllegalStateException("Indexes shouldn't be empty");
        }
        if (order != 'c' && order != 'f' && order != 'a') {
            throw new IllegalStateException("Unknown order being passed in [" + order + "]");
        }
        for (int idx : indexes) {
            if (idx >= 0 && (long)idx < source.shape()[source.rank() - sourceDimension - 1]) continue;
            throw new IllegalStateException("Index can't be < 0 and >= " + source.shape()[source.rank() - sourceDimension - 1]);
        }
        INDArray ret = INSTANCE.pullRows(source, sourceDimension, indexes, order);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray pullRows(INDArray source, INDArray destination, int sourceDimension, int[] indexes) {
        if (sourceDimension >= source.rank()) {
            throw new IllegalStateException("Source dimension can't be higher the rank of source tensor");
        }
        if (indexes == null || indexes.length == 0) {
            throw new IllegalStateException("Indexes shouldn't be empty");
        }
        for (int idx : indexes) {
            if (idx >= 0 && (long)idx < source.shape()[source.rank() - sourceDimension - 1]) continue;
            throw new IllegalStateException("Index can't be < 0 and >= " + source.shape()[source.rank() - sourceDimension - 1]);
        }
        INDArray ret = INSTANCE.pullRows(source, destination, sourceDimension, indexes);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray stack(int axis, INDArray ... values) {
        Preconditions.checkArgument((values != null && values.length > 0 ? 1 : 0) != 0, (String)"No inputs: %s", (Object[])values);
        Preconditions.checkState((axis >= -(values[0].rank() + 1) && axis < values[0].rank() + 1 ? 1 : 0) != 0, (String)"Invalid axis: must be between %s (inclusive) and %s (exclusive) for rank %s input, got %s", (int)(-(values[0].rank() + 1)), (int)(values[0].rank() + 1), (int)values[0].rank(), (int)axis);
        Stack stack = new Stack(values, null, axis);
        INDArray[] outputArrays = Nd4j.getExecutioner().allocateOutputArrays(stack);
        stack.addOutputArgument(outputArrays);
        Nd4j.getExecutioner().exec(stack);
        return outputArrays[0];
    }

    public static INDArray concat(int dimension, INDArray ... toConcat) {
        if (dimension < 0) {
            dimension += toConcat[0].rank();
        }
        INDArray ret = INSTANCE.concat(dimension, toConcat);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray specialConcat(int dimension, INDArray ... toConcat) {
        INDArray ret = INSTANCE.specialConcat(dimension, toConcat);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray zeros(int[] shape, char order) {
        Nd4j.checkShapeValues(shape);
        INDArray ret = INSTANCE.create(shape, order);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray zeros(long[] shape, char order) {
        Nd4j.checkShapeValues(shape);
        INDArray ret = INSTANCE.create(shape, order);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray zeros(int ... shape) {
        return Nd4j.create(shape);
    }

    public static INDArray zeros(long ... shape) {
        return Nd4j.create(shape);
    }

    public static INDArray ones(int ... shape) {
        if (shape == null) {
            throw new NullPointerException("shape is marked @NonNull but is null");
        }
        if (shape.length == 0) {
            return Nd4j.trueScalar(1.0);
        }
        Nd4j.checkShapeValues(shape);
        INDArray ret = INSTANCE.ones(shape);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray ones(long ... shape) {
        if (shape == null) {
            throw new NullPointerException("shape is marked @NonNull but is null");
        }
        if (shape.length == 0) {
            return Nd4j.trueScalar(1.0);
        }
        Nd4j.checkShapeValues(shape);
        INDArray ret = INSTANCE.ones(shape);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray scalar(Number value, long offset) {
        return INSTANCE.scalar(value, offset);
    }

    public static INDArray scalar(double value, long offset) {
        INDArray ret = INSTANCE.scalar(value, offset);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray scalar(float value, long offset) {
        INDArray ret = INSTANCE.scalar(value, offset);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray scalar(Number value) {
        INDArray ret = INSTANCE.scalar(value);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray scalar(double value) {
        INDArray ret = INSTANCE.scalar(value);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray scalar(float value) {
        INDArray ret = INSTANCE.scalar(value);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static int[] getStrides(int[] shape, char order) {
        if (order == 'f') {
            return ArrayUtil.calcStridesFortran((int[])shape);
        }
        return ArrayUtil.calcStrides((int[])shape);
    }

    public static long[] getStrides(long[] shape, char order) {
        if (order == 'f') {
            return ArrayUtil.calcStridesFortran((long[])shape);
        }
        return ArrayUtil.calcStrides((long[])shape);
    }

    public static int[] getStrides(int[] shape) {
        return Nd4j.getStrides(shape, Nd4j.order().charValue());
    }

    public static long[] getStrides(long[] shape) {
        return Nd4j.getStrides(shape, Nd4j.order().charValue());
    }

    public static INDArray tile(INDArray tile, int ... repeat) {
        int d = repeat.length;
        long[] shape = ArrayUtil.copy((long[])tile.shape());
        long n = Math.max(tile.length(), 1L);
        if (d < tile.rank()) {
            repeat = Ints.concat((int[][])new int[][]{ArrayUtil.nTimes((int)(tile.rank() - d), (int)1), repeat});
        }
        for (int i = 0; i < shape.length; ++i) {
            long nOut;
            if (repeat[i] != 1) {
                tile = tile.reshape(-1L, n).repeat(0, repeat[i]);
            }
            long in = shape[i];
            shape[i] = nOut = in * (long)repeat[i];
            n /= Math.max(in, 1L);
        }
        return tile.reshape(shape);
    }

    public static int[] getComplexStrides(int[] shape, char order) {
        if (order == 'f') {
            return ArrayUtil.calcStridesFortran((int[])shape, (int)2);
        }
        return ArrayUtil.calcStrides((int[])shape, (int)2);
    }

    public static long[] getComplexStrides(long[] shape, char order) {
        if (order == 'f') {
            return ArrayUtil.calcStridesFortran((long[])shape, (int)2);
        }
        return ArrayUtil.calcStrides((long[])shape, (int)2);
    }

    public static int[] getComplexStrides(int[] shape) {
        return Nd4j.getComplexStrides(shape, Nd4j.order().charValue());
    }

    public static long[] getComplexStrides(long[] shape) {
        return Nd4j.getComplexStrides(shape, Nd4j.order().charValue());
    }

    public synchronized void initContext() {
        try {
            Nd4jBackend backend = Nd4jBackend.load();
            this.initWithBackend(backend);
        }
        catch (Nd4jBackend.NoAvailableBackendException e) {
            throw new RuntimeException(e);
        }
    }

    public void initWithBackend(Nd4jBackend backend) {
        VersionCheck.checkVersions();
        try {
            if (System.getProperties().getProperty("backends") != null && !System.getProperties().getProperty("backends").contains(backend.getClass().getName())) {
                return;
            }
            if (!Nd4j.isSupportedPlatform()) {
                Nd4j.showAttractiveMessage(Nd4j.getMessageForUnsupportedPlatform());
                return;
            }
            Nd4j.backend = backend;
            this.updateNd4jContext();
            props = Nd4jContext.getInstance().getConf();
            PropertyParser pp = new PropertyParser(props);
            String otherDtype = pp.toString(DTYPE);
            DataBuffer.Type type = otherDtype.equalsIgnoreCase("float") ? DataBuffer.Type.FLOAT : (dtype = otherDtype.equalsIgnoreCase("half") ? DataBuffer.Type.HALF : DataBuffer.Type.DOUBLE);
            if (dtype == DataBuffer.Type.HALF && backend.getClass().getName().equals("CpuBackend")) {
                Nd4j.showAttractiveMessage(this.getMessageForNativeHalfPrecision());
            }
            if (Nd4j.dataType() != dtype) {
                DataTypeUtil.setDTypeForContext((DataBuffer.Type)dtype);
            }
            compressDebug = pp.toBoolean(COMPRESSION_DEBUG);
            copyOnOps = pp.toBoolean(COPY_OPS, true);
            shouldInstrument = pp.toBoolean(INSTRUMENTATION);
            resourceManagerOn = pp.toBoolean(RESOURCE_MANGER_ON);
            executionMode = pp.toString(EXECUTION_MODE, "java").equals("java") ? OpExecutioner.ExecutionMode.JAVA : OpExecutioner.ExecutionMode.NATIVE;
            ORDER = pp.toChar(ORDER_KEY, 'c');
            affinityManagerClazz = Class.forName(pp.toString(AFFINITY_MANAGER));
            affinityManager = affinityManagerClazz.newInstance();
            ndArrayFactoryClazz = Class.forName(pp.toString(NDARRAY_FACTORY_CLASS));
            sparseNDArrayClazz = Class.forName(pp.toString(SPARSE_NDARRAY_FACTORY_CLASS));
            convolutionInstanceClazz = Class.forName(pp.toString(CONVOLUTION_OPS, DefaultConvolutionInstance.class.getName()));
            String defaultName = pp.toString(DATA_BUFFER_OPS, DefaultDataBufferFactory.class.getName());
            dataBufferFactoryClazz = Class.forName(pp.toString(DATA_BUFFER_OPS, defaultName));
            shapeInfoProviderClazz = Class.forName(pp.toString(SHAPEINFO_PROVIDER));
            sparseInfoProviderClazz = Class.forName(pp.toString(SPARSEINFO_PROVIDER));
            constantProviderClazz = Class.forName(pp.toString(CONSTANT_PROVIDER));
            memoryManagerClazz = Class.forName(pp.toString(MEMORY_MANAGER));
            allowsOrder = backend.allowsOrder();
            String rand = pp.toString(RANDOM_PROVIDER, DefaultRandom.class.getName());
            randomClazz = Class.forName(rand);
            randomFactory = new RandomFactory(randomClazz);
            workspaceManagerClazz = Class.forName(pp.toString(WORKSPACE_MANAGER));
            instrumentationClazz = Class.forName(pp.toString(INSTRUMENTATION_CLASS, InMemoryInstrumentation.class.getName()));
            opFactoryClazz = Class.forName(pp.toString(OP_FACTORY, DefaultOpFactory.class.getName()));
            blasWrapperClazz = Class.forName(pp.toString(BLAS_OPS));
            sparseBlasWrapperClazz = Class.forName(pp.toString(SPARSE_BLAS_OPS));
            String clazzName = pp.toString(DISTRIBUTION, DefaultDistributionFactory.class.getName());
            distributionFactoryClazz = Class.forName(clazzName);
            memoryManager = memoryManagerClazz.newInstance();
            constantHandler = constantProviderClazz.newInstance();
            shapeInfoProvider = shapeInfoProviderClazz.newInstance();
            sparseInfoProvider = sparseInfoProviderClazz.newInstance();
            workspaceManager = workspaceManagerClazz.newInstance();
            opExecutionerClazz = Class.forName(pp.toString(OP_EXECUTIONER, DefaultOpExecutioner.class.getName()));
            instrumentation = instrumentationClazz.newInstance();
            OP_EXECUTIONER_INSTANCE = opExecutionerClazz.newInstance();
            Constructor<? extends NDArrayFactory> c2 = ndArrayFactoryClazz.getConstructor(DataBuffer.Type.class, Character.TYPE);
            INSTANCE = c2.newInstance(dtype, Character.valueOf(ORDER));
            SPARSE_INSTANCE = sparseNDArrayClazz.newInstance();
            CONVOLUTION_INSTANCE = convolutionInstanceClazz.newInstance();
            BLAS_WRAPPER_INSTANCE = blasWrapperClazz.newInstance();
            SPARSE_BLAS_WRAPPER_INSTANCE = sparseBlasWrapperClazz.newInstance();
            DATA_BUFFER_FACTORY_INSTANCE = dataBufferFactoryClazz.newInstance();
            OP_FACTORY_INSTANCE = opFactoryClazz.newInstance();
            ENFORCE_NUMERICAL_STABILITY = pp.toBoolean(NUMERICAL_STABILITY);
            DISTRIBUTION_FACTORY = distributionFactoryClazz.newInstance();
            Nd4j.getExecutioner().setExecutionMode(executionMode);
            if (this.isFallback()) {
                fallbackMode.set(true);
                Nd4j.showAttractiveMessage(Nd4j.getMessageForFallback());
            } else {
                fallbackMode.set(false);
            }
            String logInitProperty = System.getProperty(LOG_INIT_ENV_PROPERTY, "true");
            if (Boolean.parseBoolean(logInitProperty)) {
                OP_EXECUTIONER_INSTANCE.printEnvironmentInformation();
            }
            ServiceLoader<EnvironmentalAction> actions = ServiceLoader.load(EnvironmentalAction.class);
            HashMap<String, EnvironmentalAction> mappedActions = new HashMap<String, EnvironmentalAction>();
            for (EnvironmentalAction a : actions) {
                if (mappedActions.containsKey(a.targetVariable())) continue;
                mappedActions.put(a.targetVariable(), a);
            }
            for (String e : mappedActions.keySet()) {
                EnvironmentalAction action = (EnvironmentalAction)mappedActions.get(e);
                String value = System.getenv(e);
                if (value == null) continue;
                try {
                    action.process(value);
                }
                catch (Exception e2) {
                    logger.info("Failed to process env variable [" + e + "], got exception: " + e2.toString());
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean isSupportedPlatform() {
        return System.getProperty("java.vm.name").equalsIgnoreCase("Dalvik") || System.getProperty("os.arch").toLowerCase().startsWith("arm") || System.getProperty("sun.arch.data.model").equals("64");
    }

    private static void showAttractiveMessage(String ... strings) {
        System.out.println(Nd4j.attract(strings));
    }

    private static String attract(String ... strings) {
        String delimiter = "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!";
        String shift = "                 ";
        StringBuilder sb = new StringBuilder().append(delimiter).append("\n").append("\n");
        for (String s : strings) {
            sb.append(shift).append(s).append("\n");
        }
        sb.append("\n").append(delimiter).append("\n");
        return sb.toString();
    }

    private static String[] getMessageForUnsupportedPlatform() {
        return new String[]{"Unfortunately you can't use DL4j/ND4j on 32-bit x86 JVM", "Please, consider running this on 64-bit JVM instead"};
    }

    private static String[] getMessageForFallback() {
        return new String[]{"ND4J_FALLBACK environment variable is detected!", "Performance will be slightly reduced"};
    }

    private String[] getMessageForNativeHalfPrecision() {
        return new String[]{"Half-precision data opType isn't support for nd4j-native", "Please, consider using FLOAT or DOUBLE data opType instead"};
    }

    private void updateNd4jContext() throws IOException {
        try (InputStream is = backend.getConfigurationResource().getInputStream();){
            Nd4jContext.getInstance().updateProperties(is);
        }
    }

    private boolean isFallback() {
        String fallback = System.getenv("ND4J_FALLBACK");
        if (fallback == null) {
            return false;
        }
        return fallback.equalsIgnoreCase("true") || fallback.equalsIgnoreCase("1");
    }

    private static int[] getEnsuredShape(int[] shape) {
        if (shape.length == 1 && shape[0] == 0) {
            return new int[]{1, 1};
        }
        return shape;
    }

    private static long[] getEnsuredShape(long[] shape) {
        if (shape.length == 1 && shape[0] == 0L) {
            return new long[]{1L, 1L};
        }
        return shape;
    }

    private static int[] getEnsuredShape(int rows, int columns) {
        return Nd4j.getEnsuredShape(new int[]{rows, columns});
    }

    public static ShapeInfoProvider getShapeInfoProvider() {
        return shapeInfoProvider;
    }

    public static SparseInfoProvider getSparseInfoProvider() {
        return sparseInfoProvider;
    }

    public static ConstantHandler getConstantHandler() {
        return constantHandler;
    }

    public static AffinityManager getAffinityManager() {
        return affinityManager;
    }

    public static NDArrayFactory getNDArrayFactory() {
        return INSTANCE;
    }

    public static BasicNDArrayCompressor getCompressor() {
        return BasicNDArrayCompressor.getInstance();
    }

    public static MemoryManager getMemoryManager() {
        return memoryManager;
    }

    public static INDArray typeConversion(INDArray array, DataBuffer.TypeEx targetType) {
        return null;
    }

    public static int sizeOfDataType() {
        return Nd4j.sizeOfDataType(Nd4j.dataType());
    }

    public static int sizeOfDataType(DataBuffer.Type dtype) {
        switch (dtype) {
            case FLOAT: {
                return 4;
            }
            case HALF: {
                return 2;
            }
            case INT: {
                return 4;
            }
        }
        return 8;
    }

    public static void enableFallbackMode(boolean reallyEnable) {
        fallbackMode.set(reallyEnable);
    }

    public static boolean isFallbackModeEnabled() {
        return fallbackMode.get();
    }

    public static MemoryWorkspaceManager getWorkspaceManager() {
        return workspaceManager;
    }

    public static INDArray pile(INDArray ... arrays) {
        if (arrays[0].isRowVector() && arrays[0].rank() == 2) {
            return Nd4j.vstack(arrays);
        }
        long[] shape = arrays[0].shape();
        long[] newShape = ArrayUtils.add((long[])shape, (int)0, (long)1L);
        boolean shouldReshape = true;
        if (arrays[0].size(0) == 1L) {
            shouldReshape = false;
        }
        ArrayList<INDArray> reshaped = new ArrayList<INDArray>();
        for (INDArray array : arrays) {
            if (!shouldReshape) {
                reshaped.add(array);
                continue;
            }
            reshaped.add(array.reshape(array.ordering(), newShape));
        }
        return Nd4j.vstack(reshaped);
    }

    public static INDArray pile(@NonNull Collection<INDArray> arrays) {
        if (arrays == null) {
            throw new NullPointerException("arrays is marked @NonNull but is null");
        }
        return Nd4j.pile(arrays.toArray(new INDArray[0]));
    }

    public static INDArray[] tear(INDArray tensor, int ... dimensions) {
        if (dimensions.length >= tensor.rank()) {
            throw new ND4JIllegalStateException("Target dimensions number should be less tensor rank");
        }
        for (int e = 0; e < dimensions.length; ++e) {
            if (dimensions[e] >= 0) continue;
            throw new ND4JIllegalStateException("Target dimensions can't have negative values");
        }
        return Nd4j.factory().tear(tensor, dimensions);
    }

    public static INDArray triu(INDArray m, int k) {
        INDArray result = Nd4j.createUninitialized(m.shape());
        DynamicCustomOp op = DynamicCustomOp.builder("triu").addInputs(m).addOutputs(result).addIntegerArguments((long)k).build();
        Nd4j.getExecutioner().exec(op);
        return result;
    }

    public static INDArray tri(int n) {
        return Nd4j.tri(n, n, 0);
    }

    public static INDArray tri(int n, int k) {
        return Nd4j.tri(n, n, k);
    }

    public static INDArray tri(int n, int m, int k) {
        INDArray ret = Nd4j.createUninitialized(n, m);
        DynamicCustomOp op = DynamicCustomOp.builder("tri").addIntegerArguments(n, m, k).addOutputs(ret).build();
        Nd4j.getExecutioner().exec(op);
        return ret;
    }

    public static INDArray[] where(INDArray condition, INDArray x, INDArray y) {
        Preconditions.checkState((x == null && y == null || x != null && y != null ? 1 : 0) != 0, (String)"Both X and Y must benull, or neither must be null");
        DynamicCustomOp.DynamicCustomOpsBuilder op = DynamicCustomOp.builder("where_np");
        if (x == null) {
            op.addInputs(condition);
        } else {
            if (!x.equalShapes(y) || !x.equalShapes(condition)) {
                Preconditions.throwStateEx((String)"Shapes must be equal: condition=%s, x=%s, y=%s", (Object[])new Object[]{condition.shape(), x.shape(), y.shape()});
            }
            op.addInputs(condition, x, y);
        }
        DynamicCustomOp o = op.build();
        List<long[]> outShapes = Nd4j.getExecutioner().calculateOutputShape(o);
        INDArray[] outputs = new INDArray[outShapes.size()];
        if (x == null && (outShapes.get(0) == null || outShapes.get(0).length == 0 || outShapes.get(0)[0] == 0L)) {
            for (int i = 0; i < outputs.length; ++i) {
                outputs[i] = Nd4j.empty();
            }
            return outputs;
        }
        for (int i = 0; i < outputs.length; ++i) {
            outputs[i] = Nd4j.createUninitialized(outShapes.get(i));
        }
        op.addOutputs(outputs);
        Nd4j.getExecutioner().exec(op.build());
        return outputs;
    }

    public static void writeAsNumpy(INDArray arr, File file) throws IOException {
        Nd4j.writeAsNumpy(arr, new FileOutputStream(file));
    }

    public static Pointer convertToNumpy(INDArray arr) {
        return INSTANCE.convertToNumpy(arr);
    }

    public static void writeAsNumpy(INDArray arr, OutputStream writeTo) throws IOException {
        try (BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(writeTo);){
            Pointer asNumpy = Nd4j.convertToNumpy(arr);
            WritableByteChannel channel = Channels.newChannel(bufferedOutputStream);
            int written = channel.write(asNumpy.asByteBuffer());
            if ((long)written != asNumpy.capacity()) {
                throw new IllegalStateException("Not all bytes were written! Original capacity " + asNumpy.capacity() + " but wrote " + written);
            }
            bufferedOutputStream.flush();
        }
    }

    public static INDArray createFromNpyPointer(Pointer pointer) {
        return INSTANCE.createFromNpyPointer(pointer);
    }

    public static INDArray createFromNpyFile(File file) {
        return INSTANCE.createFromNpyFile(file);
    }

    public static INDArray createNpyFromInputStream(InputStream is) throws IOException {
        byte[] content = IOUtils.toByteArray((InputStream)is);
        return Nd4j.createNpyFromByteArray(content);
    }

    public static INDArray createNpyFromByteArray(byte[] input) {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(input.length);
        byteBuffer.put(input);
        byteBuffer.rewind();
        Pointer pointer = new Pointer((Buffer)byteBuffer);
        return Nd4j.createFromNpyPointer(pointer);
    }

    public static byte[] toNpyByteArray(INDArray input) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Nd4j.writeAsNumpy(input, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static INDArray createFromFlatArray(FlatArray array) {
        byte dtype = array.dtype();
        byte order = array.byteOrder();
        int rank = (int)array.shape(0);
        long[] shapeInfo = new long[Shape.shapeInfoLength(rank)];
        for (int e = 0; e < shapeInfo.length; ++e) {
            shapeInfo[e] = array.shape(e);
        }
        if (Shape.isEmpty(shapeInfo)) {
            return Nd4j.empty();
        }
        char ordering = shapeInfo[shapeInfo.length - 1] == 99L ? (char)'c' : 'f';
        long[] shapeOf = Shape.shapeOf(shapeInfo);
        long[] stridesOf = Shape.stridesOf(shapeInfo);
        DataBuffer.Type _dtype = FlatBuffersMapper.getDataTypeFromByte(dtype);
        ByteOrder _order = FlatBuffersMapper.getOrderFromByte(order);
        int prod = rank > 0 ? ArrayUtil.prod((long[])shapeOf) : 1;
        double[] doubles = new double[prod];
        ByteBuffer bb = array.bufferAsByteBuffer();
        switch (_dtype) {
            case DOUBLE: {
                DoubleBuffer db = bb.order(_order).asDoubleBuffer();
                for (int e = 0; e < prod; ++e) {
                    doubles[e] = db.get(e);
                }
                break;
            }
            case FLOAT: {
                FloatBuffer fb = bb.order(_order).asFloatBuffer();
                for (int e = 0; e < prod; ++e) {
                    doubles[e] = fb.get(e);
                }
                break;
            }
            case HALF: {
                ShortBuffer sb = bb.order(_order).asShortBuffer();
                for (int e = 0; e < prod; ++e) {
                    doubles[e] = HalfIndexer.toFloat((int)sb.get(e));
                }
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown datatype: [" + _dtype + "]");
            }
        }
        return Nd4j.create(doubles, shapeOf, stridesOf, 0L, ordering);
    }

    public static int numThreads() {
        int v = numThreads.get();
        if (v <= 0) {
            return Math.max(1, Runtime.getRuntime().availableProcessors() / 2);
        }
        return v;
    }

    public static void setNumThreads(int numthreads) {
        numThreads.set(numthreads);
    }

    public static void skipThreadSafetyChecks(boolean reallySkip) {
        skipTheadSafetyChecks.set(reallySkip);
    }

    public static boolean areThreadSafetyChecksSkipped() {
        return skipTheadSafetyChecks.get();
    }

    static {
        numThreads = new AtomicInteger(-1);
        skipTheadSafetyChecks = new AtomicBoolean(false);
        props = new Properties();
        referenceQueue = new ReferenceQueue();
        bufferQueue = new ReferenceQueue();
        logger = Logger.getLogger(Nd4j.class.getName());
        fallbackMode = new AtomicBoolean(false);
        Nd4j nd4j = new Nd4j();
        nd4j.initContext();
    }

    public static enum PadMode {
        CONSTANT,
        EDGE,
        LINEAR_RAMP,
        MAXIMUM,
        MEAN,
        MEDIAN,
        MINIMUM,
        REFLECT,
        SYMMETRIC,
        WRAP;

    }
}

