/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.shape;

import java.util.Arrays;
import lombok.NonNull;
import org.nd4j.linalg.api.shape.ShapeDescriptor;
import org.nd4j.linalg.util.ArrayUtil;

public class LongShapeDescriptor {
    private char order;
    private long offset;
    private long ews;
    private long hashShape = 0L;
    private long hashStride = 0L;
    private long[] shape;
    private long[] stride;
    private long extras;

    public LongShapeDescriptor(long[] shape, long[] stride, long offset, long ews, char order, long extras) {
        this.shape = Arrays.copyOf(shape, shape.length);
        this.stride = Arrays.copyOf(stride, stride.length);
        this.offset = offset;
        this.ews = ews;
        this.order = order;
        this.extras = extras;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LongShapeDescriptor that = (LongShapeDescriptor)o;
        if (this.extras != that.extras) {
            return false;
        }
        if (this.order != that.order) {
            return false;
        }
        if (this.offset != that.offset) {
            return false;
        }
        if (this.ews != that.ews) {
            return false;
        }
        if (!Arrays.equals(this.shape, that.shape)) {
            return false;
        }
        return Arrays.equals(this.stride, that.stride);
    }

    public int hashCode() {
        int result = this.order;
        result = 31 * result + this.longHashCode(this.offset);
        result = 31 * result + this.longHashCode(this.ews);
        result = 31 * result + this.longHashCode(this.extras);
        result = 31 * result + Arrays.hashCode(this.shape);
        result = 31 * result + Arrays.hashCode(this.stride);
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.shape.length).append(",").append(Arrays.toString(this.shape)).append(",").append(Arrays.toString(this.stride)).append(",").append(this.offset).append(",").append(this.ews).append(",").append(this.order);
        String result = builder.toString().replaceAll("\\]", "").replaceAll("\\[", "");
        result = "[" + result + "]";
        return result;
    }

    private int longHashCode(long v) {
        return (int)(v ^ v >>> 32);
    }

    public static LongShapeDescriptor fromShapeDescriptor(@NonNull ShapeDescriptor descriptor) {
        if (descriptor == null) {
            throw new NullPointerException("descriptor is marked @NonNull but is null");
        }
        return new LongShapeDescriptor(ArrayUtil.toLongArray((int[])descriptor.getShape()), ArrayUtil.toLongArray((int[])descriptor.getStride()), descriptor.getOffset(), descriptor.getEws(), descriptor.getOrder(), descriptor.getExtras());
    }
}

