/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.rng;

import org.apache.commons.math3.random.MersenneTwister;
import org.apache.commons.math3.random.RandomGenerator;
import org.apache.commons.math3.random.SynchronizedRandomGenerator;
import org.bytedeco.javacpp.Pointer;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.rng.Random;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.util.ArrayUtil;

public class DefaultRandom
implements Random,
RandomGenerator {
    protected RandomGenerator randomGenerator;
    protected long seed;

    public DefaultRandom() {
        this(System.currentTimeMillis());
    }

    public DefaultRandom(long seed) {
        this.seed = seed;
        this.randomGenerator = new SynchronizedRandomGenerator((RandomGenerator)new MersenneTwister(seed));
    }

    public DefaultRandom(RandomGenerator randomGenerator) {
        this.randomGenerator = randomGenerator;
    }

    @Override
    public void setSeed(int seed) {
        this.seed = seed;
        this.getRandomGenerator().setSeed(seed);
    }

    @Override
    public void setSeed(int[] seed) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setSeed(long seed) {
        this.seed = seed;
        this.getRandomGenerator().setSeed(seed);
    }

    @Override
    public void nextBytes(byte[] bytes) {
        this.getRandomGenerator().nextBytes(bytes);
    }

    @Override
    public int nextInt() {
        return this.getRandomGenerator().nextInt();
    }

    @Override
    public int nextInt(int n) {
        return this.getRandomGenerator().nextInt(n);
    }

    @Override
    public int nextInt(int a, int n) {
        return this.nextInt(n - a) + a;
    }

    @Override
    public long nextLong() {
        return this.getRandomGenerator().nextLong();
    }

    @Override
    public boolean nextBoolean() {
        return this.getRandomGenerator().nextBoolean();
    }

    @Override
    public float nextFloat() {
        return this.getRandomGenerator().nextFloat();
    }

    @Override
    public double nextDouble() {
        return this.getRandomGenerator().nextDouble();
    }

    @Override
    public double nextGaussian() {
        return this.getRandomGenerator().nextGaussian();
    }

    @Override
    public INDArray nextGaussian(long[] shape) {
        return this.nextGaussian(Nd4j.order().charValue(), shape);
    }

    @Override
    public INDArray nextGaussian(int[] shape) {
        return this.nextGaussian(Nd4j.order().charValue(), shape);
    }

    @Override
    public INDArray nextGaussian(char order, int[] shape) {
        return this.nextGaussian(order, ArrayUtil.toLongArray((int[])shape));
    }

    @Override
    public INDArray nextGaussian(char order, long[] shape) {
        long length = ArrayUtil.prodLong((long[])shape);
        INDArray ret = Nd4j.create(shape, order);
        DataBuffer data = ret.data();
        for (long i = 0L; i < length; ++i) {
            data.put(i, this.nextGaussian());
        }
        return ret;
    }

    @Override
    public INDArray nextDouble(long[] shape) {
        return this.nextDouble(Nd4j.order().charValue(), shape);
    }

    @Override
    public INDArray nextDouble(int[] shape) {
        return this.nextDouble(Nd4j.order().charValue(), shape);
    }

    @Override
    public INDArray nextDouble(char order, int[] shape) {
        return this.nextDouble(order, ArrayUtil.toLongArray((int[])shape));
    }

    @Override
    public INDArray nextDouble(char order, long[] shape) {
        long length = ArrayUtil.prodLong((long[])shape);
        INDArray ret = Nd4j.create(shape, order);
        DataBuffer data = ret.data();
        for (long i = 0L; i < length; ++i) {
            data.put(i, this.nextDouble());
        }
        return ret;
    }

    @Override
    public INDArray nextFloat(long[] shape) {
        return this.nextFloat(Nd4j.order().charValue(), shape);
    }

    @Override
    public INDArray nextFloat(int[] shape) {
        return this.nextFloat(Nd4j.order().charValue(), shape);
    }

    @Override
    public INDArray nextFloat(char order, int[] shape) {
        return this.nextFloat(order, ArrayUtil.toLongArray((int[])shape));
    }

    @Override
    public INDArray nextFloat(char order, long[] shape) {
        long length = ArrayUtil.prodLong((long[])shape);
        INDArray ret = Nd4j.create(shape, order);
        DataBuffer data = ret.data();
        for (long i = 0L; i < length; ++i) {
            data.put(i, this.nextFloat());
        }
        return ret;
    }

    @Override
    public INDArray nextInt(int[] shape) {
        return this.nextInt(ArrayUtil.toLongArray((int[])shape));
    }

    @Override
    public INDArray nextInt(long[] shape) {
        int length = ArrayUtil.prod((long[])shape);
        INDArray ret = Nd4j.create(shape);
        DataBuffer data = ret.data();
        for (int i = 0; i < length; ++i) {
            data.put((long)i, this.nextInt());
        }
        return ret;
    }

    @Override
    public INDArray nextInt(int n, int[] shape) {
        return this.nextInt(n, ArrayUtil.toLongArray((int[])shape));
    }

    @Override
    public INDArray nextInt(int n, long[] shape) {
        int length = ArrayUtil.prod((long[])shape);
        INDArray ret = Nd4j.create(shape);
        DataBuffer data = ret.data();
        for (int i = 0; i < length; ++i) {
            data.put((long)i, this.nextInt(n));
        }
        return ret;
    }

    public synchronized RandomGenerator getRandomGenerator() {
        return this.randomGenerator;
    }

    @Override
    public synchronized long getSeed() {
        return this.seed;
    }

    @Override
    public Pointer getStatePointer() {
        return null;
    }

    @Override
    public DataBuffer getStateBuffer() {
        return null;
    }

    @Override
    public void close() throws Exception {
    }

    @Override
    public void reSeed() {
        this.reSeed(System.currentTimeMillis());
    }

    @Override
    public void reSeed(long seed) {
        this.setSeed(seed);
    }
}

