/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.random.custom;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.base.Preconditions;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tensorflow.framework.AttrValue;
import org.tensorflow.framework.GraphDef;
import org.tensorflow.framework.NodeDef;

public class DistributionUniform
extends DynamicCustomOp {
    private static final Logger log = LoggerFactory.getLogger(DistributionUniform.class);
    private double min = 0.0;
    private double max = 1.0;

    public DistributionUniform() {
    }

    public DistributionUniform(SameDiff sd, SDVariable shape, double min, double max) {
        super(null, sd, new SDVariable[]{shape});
        Preconditions.checkState((min <= max ? 1 : 0) != 0, (String)"Minimum (%s) must be <= max (%s)", (double)min, (double)max);
        this.addTArgument(min, max);
    }

    public DistributionUniform(INDArray shape, INDArray out, double min, double max) {
        super(null, new INDArray[]{shape}, new INDArray[]{out}, Arrays.asList(min, max), (List<Integer>)null);
    }

    @Override
    public void initFromTensorFlow(NodeDef nodeDef, SameDiff initWith, Map<String, AttrValue> attributesForNode, GraphDef graph) {
        super.initFromTensorFlow(nodeDef, initWith, attributesForNode, graph);
        this.addArgs();
    }

    protected void addArgs() {
        this.addTArgument(this.min, this.max);
    }

    @Override
    public String opName() {
        return "randomuniform";
    }

    @Override
    public String tensorflowName() {
        return "RandomUniform";
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> gradients) {
        return Collections.singletonList(this.sameDiff.zerosLike(this.arg()));
    }
}

