/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.accum;

import java.util.Collections;
import java.util.List;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseAccumulation;
import org.nd4j.linalg.api.ops.Op;

public class LogSumExp
extends BaseAccumulation {
    public LogSumExp(SameDiff sameDiff, SDVariable i_v, int[] dimensions) {
        super(sameDiff, i_v, dimensions);
    }

    public LogSumExp(SameDiff sameDiff, SDVariable i_v, SDVariable i_v2, int[] dimensions) {
        super(sameDiff, i_v, i_v2, dimensions);
    }

    public LogSumExp() {
    }

    public LogSumExp(INDArray x, INDArray y, INDArray z, long n) {
        super(x, y, z, n);
    }

    public LogSumExp(INDArray x, INDArray y, long n) {
        super(x, y, n);
    }

    public LogSumExp(INDArray x) {
        super(x);
    }

    public LogSumExp(INDArray x, INDArray y) {
        super(x, y);
    }

    public LogSumExp(INDArray x, INDArray y, INDArray z) {
        super(x, y, z, x.lengthLong());
    }

    @Override
    public int opNum() {
        return 19;
    }

    @Override
    public String opName() {
        return "logexpsum";
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> f1) {
        SDVariable exp = this.f().exp(this.arg());
        SDVariable sumExp = exp.sum(this.dimensions);
        SDVariable gradProd = f1.get(0).div(sumExp);
        SDVariable dSumExpdx = this.f().sumBp(this.arg(), gradProd, this.keepDims, this.dimensions).mul(exp);
        return Collections.singletonList(dSumExpdx);
    }

    @Override
    public String onnxName() {
        return "ReduceLogSumExp";
    }

    @Override
    public String tensorflowName() {
        return "reduce_logsumexp";
    }

    @Override
    public Op.Type getOpType() {
        return Op.Type.REDUCE;
    }
}

