/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.executioner;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.bytedeco.javacpp.Pointer;
import org.nd4j.autodiff.functions.DifferentialFunction;
import org.nd4j.base.Preconditions;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.memory.MemoryWorkspace;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.Accumulation;
import org.nd4j.linalg.api.ops.BroadcastOp;
import org.nd4j.linalg.api.ops.CustomOp;
import org.nd4j.linalg.api.ops.CustomOpDescriptor;
import org.nd4j.linalg.api.ops.GridOp;
import org.nd4j.linalg.api.ops.IndexAccumulation;
import org.nd4j.linalg.api.ops.MetaOp;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.api.ops.RandomOp;
import org.nd4j.linalg.api.ops.ScalarOp;
import org.nd4j.linalg.api.ops.ShapeOp;
import org.nd4j.linalg.api.ops.TransformOp;
import org.nd4j.linalg.api.ops.aggregates.Aggregate;
import org.nd4j.linalg.api.ops.aggregates.Batch;
import org.nd4j.linalg.api.ops.executioner.OpExecutioner;
import org.nd4j.linalg.api.ops.executioner.OpExecutionerUtil;
import org.nd4j.linalg.api.ops.impl.accum.Variance;
import org.nd4j.linalg.api.rng.Random;
import org.nd4j.linalg.api.shape.Shape;
import org.nd4j.linalg.cache.TADManager;
import org.nd4j.linalg.exception.ND4JIllegalStateException;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.primitives.AtomicBoolean;
import org.nd4j.linalg.primitives.Optional;
import org.nd4j.linalg.profiler.OpProfiler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultOpExecutioner
implements OpExecutioner {
    private static final Logger log = LoggerFactory.getLogger(DefaultOpExecutioner.class);
    private static final String SCOPE_PANIC_MSG = "For more details, see the ND4J User Guide: nd4j.org/userguide#workspaces-panic";
    protected OpExecutioner.ProfilingMode profilingMode = OpExecutioner.ProfilingMode.SCOPE_PANIC;
    protected OpExecutioner.ExecutionMode executionMode = OpExecutioner.ExecutionMode.JAVA;
    protected AtomicBoolean verbose = new AtomicBoolean(false);
    protected AtomicBoolean debug = new AtomicBoolean(false);

    protected void checkForCompression(Op op) {
        this.interceptIntDataType(op);
        if (op.x() != null && op.x().isCompressed()) {
            Nd4j.getCompressor().decompressi(op.x());
        }
        if (op.y() != null && op.y().isCompressed()) {
            Nd4j.getCompressor().decompressi(op.y());
        }
        if (op.z() != null && op.z().isCompressed()) {
            Nd4j.getCompressor().decompressi(op.z());
        }
    }

    @Override
    public String getLastOp() {
        return "UNKNOWN";
    }

    protected void interceptIntDataType(Op op) {
        if (op.x() != null && op.x().data().dataType() == DataBuffer.Type.INT) {
            throw new ND4JIllegalStateException("Op.X contains INT data. Operations on INT dataType are not supported yet");
        }
        if (op.z() != null && op.z().data().dataType() == DataBuffer.Type.INT) {
            throw new ND4JIllegalStateException("Op.Z contains INT data. Operations on INT dataType are not supported yet");
        }
        if (op.y() != null && op.y().data().dataType() == DataBuffer.Type.INT) {
            throw new ND4JIllegalStateException("Op.Y contains INT data. Operations on INT dataType are not supported yet.");
        }
    }

    @Override
    public Op exec(Op op) {
        if (op.isPassThrough()) {
            op.exec();
            return op;
        }
        throw new IllegalStateException("Java computation no longer supported");
    }

    @Override
    public INDArray execAndReturn(Op op) {
        if (op instanceof TransformOp) {
            return this.execAndReturn((TransformOp)op);
        }
        if (op instanceof ScalarOp) {
            return this.execAndReturn((ScalarOp)op);
        }
        if (op instanceof Accumulation) {
            return Nd4j.scalar(this.execAndReturn((Accumulation)op).getFinalResult());
        }
        if (op instanceof IndexAccumulation) {
            return Nd4j.scalar(this.execAndReturn((IndexAccumulation)op).getFinalResult());
        }
        throw new IllegalArgumentException("Illegal opType of op: " + op.getClass());
    }

    @Override
    public void iterateOverAllRows(Op op) {
        if (op.x().isVector()) {
            op.setX(op.x());
            if (op.y() != null) {
                op.setY(op.y());
            }
            op.setZ(op.z());
            this.exec(op);
        } else if (op.x().isMatrix()) {
            INDArray original = op.x();
            INDArray originalZ = op.z();
            INDArray y = op.y();
            for (int i = 0; i < original.rows(); ++i) {
                INDArray row = original.getRow(i);
                INDArray zRow = originalZ.getRow(i);
                op.setX(row.dup());
                op.setZ(zRow.dup());
                if (y != null) {
                    op.setY(y.getRow(i).dup());
                }
                this.exec(op);
                zRow.assign(op.z());
            }
        } else {
            INDArray originalX = op.x();
            INDArray originalZ = op.z();
            int i = 0;
            while ((long)i < originalX.slices()) {
                INDArray slice = originalX.slice(i);
                INDArray zSlice = originalZ.slice(i);
                op.setX(slice);
                op.setZ(zSlice);
                this.iterateOverAllRows(op);
                ++i;
            }
        }
    }

    @Override
    public void iterateOverAllColumns(Op op) {
        if (op.x().isVector()) {
            this.exec(op);
        } else if (op.x().isMatrix() || op.x().isColumnVector()) {
            this.exec(op, 1);
        } else {
            INDArray originalX = op.x();
            INDArray originalZ = op.z();
            INDArray y = op.y();
            int i = 0;
            while ((long)i < op.x().slices()) {
                op.setX(originalX.getColumn(i));
                op.setZ(originalZ.getColumn(i));
                if (y != null) {
                    op.setY(y.getColumn(i));
                }
                this.iterateOverAllColumns(op);
                ++i;
            }
        }
    }

    @Override
    public INDArray execAndReturn(TransformOp op) {
        Op result = this.exec(op);
        TransformOp t = (TransformOp)result;
        return t.z();
    }

    @Override
    public Accumulation execAndReturn(Accumulation op) {
        return (Accumulation)this.exec(op);
    }

    @Override
    public Accumulation execAndReturn(Variance op, boolean biasCorrected) {
        return null;
    }

    @Override
    public INDArray execAndReturn(ScalarOp op) {
        return this.exec(op).z();
    }

    @Override
    public IndexAccumulation execAndReturn(IndexAccumulation op) {
        return (IndexAccumulation)this.exec(op);
    }

    @Override
    public INDArray execAndReturn(BroadcastOp op) {
        return this.exec(op).z();
    }

    @Override
    public INDArray execAndReturn(ShapeOp op) {
        this.exec(op);
        return op.z();
    }

    @Override
    public Op exec(Op op, int ... dimension) {
        if (dimension.length == op.x().rank()) {
            dimension = new int[]{Integer.MAX_VALUE};
        }
        if (op.isPassThrough()) {
            op.exec(dimension);
            return op;
        }
        if (op instanceof Accumulation || op instanceof IndexAccumulation) {
            throw new IllegalStateException("exec(Op,int...) should never be invoked for Accumulation/IndexAccumulation");
        }
        if (op instanceof ScalarOp) {
            throw new IllegalStateException("Java computation no longer supported");
        }
        if (op instanceof TransformOp) {
            throw new UnsupportedOperationException("Executing transform ops along a dimension should be done via exec special");
        }
        throw new UnsupportedOperationException("Unknown op opType");
    }

    @Override
    public INDArray exec(Accumulation op, int ... dimension) {
        throw new UnsupportedOperationException("Java computation no longer supported");
    }

    @Override
    public INDArray exec(Variance accumulation, boolean biasCorrected, int ... dimension) {
        accumulation.setBiasCorrected(biasCorrected);
        return this.exec((Accumulation)accumulation, dimension);
    }

    @Override
    public INDArray exec(IndexAccumulation op, int ... dimension) {
        throw new UnsupportedOperationException("Operation should use exec special");
    }

    @Override
    public OpExecutioner.ExecutionMode executionMode() {
        return this.executionMode;
    }

    @Override
    public void setExecutionMode(OpExecutioner.ExecutionMode executionMode) {
        this.executionMode = executionMode;
    }

    @Override
    public INDArray exec(BroadcastOp broadcast, int ... dimension) {
        if (dimension.length == broadcast.x().rank()) {
            dimension = new int[]{Integer.MAX_VALUE};
        }
        if (broadcast.isPassThrough()) {
            broadcast.exec(dimension);
            return broadcast.z();
        }
        throw new IllegalStateException("Java computation no longer supported");
    }

    @Override
    public void exec(MetaOp op) {
        throw new UnsupportedOperationException("MetaOp execution isn't supported for this OpExecutioner yet");
    }

    @Override
    public void exec(GridOp op) {
        throw new UnsupportedOperationException("GridOp execution isn't supported for this OpExecutioner yet");
    }

    @Override
    public <T extends Aggregate> void exec(Batch<T> batch) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void exec(Aggregate op) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void exec(ShapeOp op) {
        if (!op.isExecSpecial()) {
            throw new IllegalArgumentException("Only special execution supported right now.");
        }
        op.exec();
    }

    @Override
    public void exec(List<Aggregate> batch) {
        throw new UnsupportedOperationException();
    }

    @Override
    public INDArray exec(RandomOp op) {
        return this.exec(op, Nd4j.getRandom());
    }

    @Override
    public INDArray exec(RandomOp op, Random rng) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setProfilingMode(OpExecutioner.ProfilingMode mode) {
        this.profilingMode = mode;
    }

    @Override
    public OpExecutioner.ProfilingMode getProfilingMode() {
        return this.profilingMode;
    }

    public long profilingHookIn(Op op, DataBuffer ... tadBuffers) {
        switch (this.profilingMode) {
            case ALL: {
                OpProfiler.getInstance().processOpCall(op, tadBuffers);
                break;
            }
            case METHODS: {
                break;
            }
            case OPERATIONS: {
                OpProfiler.getInstance().processOpCall(op, tadBuffers);
                break;
            }
            default: {
                return 0L;
            }
        }
        return System.nanoTime();
    }

    protected void checkWorkspace(String opName, INDArray array) {
        MemoryWorkspace ws;
        if (array.isAttached() && (ws = array.data().getParentWorkspace()).getWorkspaceType() != MemoryWorkspace.Type.CIRCULAR) {
            if (!ws.isScopeActive()) {
                throw new ND4JIllegalStateException("Op [" + opName + "] X argument uses leaked workspace pointer from workspace [" + ws.getId() + "]\nAll open workspaces: " + DefaultOpExecutioner.allOpenWorkspaces() + "\n" + SCOPE_PANIC_MSG);
            }
            if (ws.getGenerationId() != array.data().getGenerationId()) {
                throw new ND4JIllegalStateException("Op [" + opName + "] X argument uses outdated workspace pointer from workspace [" + ws.getId() + "]\nAll open workspaces: " + DefaultOpExecutioner.allOpenWorkspaces() + "\n" + SCOPE_PANIC_MSG);
            }
        }
    }

    protected void checkForWorkspaces(CustomOp op) {
        for (INDArray input : op.inputArguments()) {
            this.checkWorkspace(op.opName(), input);
        }
        for (INDArray output : op.outputArguments()) {
            this.checkWorkspace(op.opName(), output);
        }
    }

    protected void checkForWorkspaces(Op op) {
        INDArray z;
        INDArray y;
        INDArray x = op.x();
        if (x != null) {
            this.checkWorkspace(op.opName(), x);
        }
        if ((y = op.y()) != null) {
            this.checkWorkspace(op.opName(), y);
        }
        if ((z = op.z()) != null) {
            this.checkWorkspace(op.opName(), z);
        }
    }

    private static List<String> allOpenWorkspaces() {
        List l = Nd4j.getWorkspaceManager().getAllWorkspacesForCurrentThread();
        ArrayList<String> workspaces = new ArrayList<String>(l.size());
        for (MemoryWorkspace ws : l) {
            if (!ws.isScopeActive()) continue;
            workspaces.add(ws.getId());
        }
        return workspaces;
    }

    public long profilingHookIn(Op op) {
        switch (this.profilingMode) {
            case ALL: {
                OpProfiler.getInstance().processOpCall(op);
                break;
            }
            case METHODS: {
                break;
            }
            case OPERATIONS: {
                OpProfiler.getInstance().processOpCall(op);
                break;
            }
            case SCOPE_PANIC: {
                this.checkForWorkspaces(op);
                return 0L;
            }
            default: {
                return 0L;
            }
        }
        return System.nanoTime();
    }

    public long profilingHookIn(CustomOp op) {
        switch (this.profilingMode) {
            case ALL: {
                OpProfiler.getInstance().processOpCall(op);
                break;
            }
            case METHODS: {
                break;
            }
            case OPERATIONS: {
                OpProfiler.getInstance().processOpCall(op);
                break;
            }
            case SCOPE_PANIC: {
                this.checkForWorkspaces(op);
                return 0L;
            }
            default: {
                return 0L;
            }
        }
        return System.nanoTime();
    }

    public void profilingHookOut(Op op, long timeStart) {
        switch (this.profilingMode) {
            case ALL: {
                OpProfiler.getInstance().processStackCall(op, timeStart);
                OpProfiler.getInstance().timeOpCall(op, timeStart);
                break;
            }
            case METHODS: {
                OpProfiler.getInstance().processStackCall(op, timeStart);
                break;
            }
            case OPERATIONS: {
                OpProfiler.getInstance().timeOpCall(op, timeStart);
                break;
            }
            case NAN_PANIC: {
                OpExecutionerUtil.checkForNaN(op);
                break;
            }
            case INF_PANIC: {
                OpExecutionerUtil.checkForInf(op);
                break;
            }
            case ANY_PANIC: {
                OpExecutionerUtil.checkForNaN(op);
                OpExecutionerUtil.checkForInf(op);
                break;
            }
        }
        if (Nd4j.getExecutioner().isVerbose()) {
            if (op.z() != null) {
                log.info("Z shapeInfo: {}; Z values: {}", (Object)op.z().shapeInfoJava(), (Object)DefaultOpExecutioner.firstX(op.z(), 10));
            }
            System.out.println();
        }
    }

    public void profilingHookOut(CustomOp op, long timeStart) {
        switch (this.profilingMode) {
            case ALL: {
                OpProfiler.getInstance().processStackCall(op, timeStart);
                OpProfiler.getInstance().timeOpCall(op, timeStart);
                break;
            }
            case METHODS: {
                OpProfiler.getInstance().processStackCall(op, timeStart);
                break;
            }
            case OPERATIONS: {
                OpProfiler.getInstance().timeOpCall(op, timeStart);
                break;
            }
            case NAN_PANIC: {
                OpExecutionerUtil.checkForNaN(op);
                break;
            }
            case INF_PANIC: {
                OpExecutionerUtil.checkForInf(op);
                break;
            }
            case ANY_PANIC: {
                OpExecutionerUtil.checkForNaN(op);
                OpExecutionerUtil.checkForInf(op);
                break;
            }
        }
    }

    public static void validateDataType(DataBuffer.Type expectedType, Op op) {
        if (op.x() != null && !Shape.isEmpty(op.x().shapeInfoJava()) && op.x().data().dataType() == DataBuffer.Type.COMPRESSED) {
            Nd4j.getCompressor().decompressi(op.x());
        }
        if (op.y() != null && !Shape.isEmpty(op.y().shapeInfoJava()) && op.y().data().dataType() == DataBuffer.Type.COMPRESSED) {
            Nd4j.getCompressor().decompressi(op.y());
        }
        if (op.z() != null && !Shape.isEmpty(op.z().shapeInfoJava()) && op.z().data().dataType() == DataBuffer.Type.COMPRESSED) {
            Nd4j.getCompressor().decompressi(op.z());
        }
        if (op.x() != null && !Shape.isEmpty(op.x().shapeInfoJava()) && op.x().data().dataType() != expectedType && op.x().data().dataType() != DataBuffer.Type.COMPRESSED) {
            throw new ND4JIllegalStateException("op.X dataType is [" + op.x().data().dataType() + "] instead of expected [" + expectedType + "]");
        }
        if (op.z() != null && !Shape.isEmpty(op.z().shapeInfoJava()) && op.z().data().dataType() != expectedType && op.z().data().dataType() != DataBuffer.Type.COMPRESSED) {
            throw new ND4JIllegalStateException("op.Z dataType is [" + op.z().data().dataType() + "] instead of expected [" + expectedType + "]");
        }
        if (op.y() != null && !Shape.isEmpty(op.y().shapeInfoJava()) && op.y().data().dataType() != expectedType) {
            throw new ND4JIllegalStateException("op.Y dataType is [" + op.y().data().dataType() + "] instead of expected [" + expectedType + "]");
        }
        if (Nd4j.getExecutioner().isVerbose()) {
            log.info("Reporting [{}]", (Object)op.opName());
            if (op.x() != null) {
                log.info("X shapeInfo: {}; X values: {}", (Object)op.x().shapeInfoJava(), (Object)DefaultOpExecutioner.firstX(op.x(), 10));
            }
            if (op.y() != null) {
                log.info("Y shapeInfo: {}; Y values: {}", (Object)op.y().shapeInfoJava(), (Object)DefaultOpExecutioner.firstX(op.y(), 10));
            }
        }
    }

    protected static String firstX(INDArray array, int x) {
        StringBuilder builder = new StringBuilder("[");
        int limit = (int)Math.min((long)x, array.length());
        for (int e = 0; e < limit; ++e) {
            builder.append(array.getDouble((long)e));
            if (e >= limit - 1) continue;
            builder.append(", ");
        }
        builder.append("]");
        return builder.toString();
    }

    public static void validateDataType(DataBuffer.Type expectedType, INDArray ... operands) {
        if (operands == null || operands.length == 0) {
            return;
        }
        int cnt = 0;
        for (INDArray operand : operands) {
            if (operand == null || operand.data().dataType() == expectedType) continue;
            throw new ND4JIllegalStateException("INDArray [" + cnt++ + "] dataType is [" + operand.data().dataType() + "] instead of expected [" + expectedType + "]");
        }
    }

    @Override
    public TADManager getTADManager() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Properties getEnvironmentInformation() {
        Properties environment = new Properties();
        environment.put("cores", (Object)Runtime.getRuntime().availableProcessors());
        environment.put("memory.available", (Object)Runtime.getRuntime().maxMemory());
        environment.put("os", System.getProperty("os.name"));
        return environment;
    }

    @Override
    public void printEnvironmentInformation() {
        Properties env = this.getEnvironmentInformation();
        double memory = (double)((Long)env.get("memory.available")).longValue() / 1024.0 / 1024.0 / 1024.0;
        String fm = String.format("%.1f", memory);
        log.info("Backend used: [{}]; OS: [{}]", env.get("backend"), env.get("os"));
        log.info("Cores: [{}]; Memory: [{}GB];", env.get("cores"), (Object)fm);
        log.info("Blas vendor: [{}]", env.get("blas.vendor"));
    }

    @Override
    public void push() {
    }

    @Override
    public void commit() {
    }

    @Override
    public INDArray thresholdEncode(INDArray input, double threshold) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public INDArray thresholdEncode(INDArray input, double threshold, Integer boundary) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public INDArray thresholdDecode(INDArray encoded, INDArray target) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public long bitmapEncode(INDArray indArray, INDArray target, double threshold) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public INDArray bitmapEncode(INDArray indArray, double threshold) {
        DataBuffer buffer = Nd4j.getDataBufferFactory().createInt(indArray.length() / 16L + 5L);
        INDArray ret = Nd4j.createArrayFromShapeBuffer(buffer, indArray.shapeInfoDataBuffer());
        this.bitmapEncode(indArray, ret, threshold);
        return ret;
    }

    @Override
    public INDArray bitmapDecode(INDArray encoded, INDArray target) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public Map<String, CustomOpDescriptor> getCustomOperations() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void exec(CustomOp op) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<long[]> calculateOutputShape(CustomOp op) {
        throw new UnsupportedOperationException();
    }

    @Override
    public INDArray[] allocateOutputArrays(CustomOp op) {
        List<long[]> shapes = this.calculateOutputShape(op);
        INDArray[] out = new INDArray[shapes.size()];
        for (int i = 0; i < shapes.size(); ++i) {
            out[i] = Nd4j.create(shapes.get(i));
        }
        return out;
    }

    @Override
    public void enableDebugMode(boolean reallyEnable) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void enableVerboseMode(boolean reallyEnable) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void registerGraph(long id, Pointer graph) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public Map<String, INDArray> executeGraph(long id, Map<String, INDArray> map, Map<String, Integer> reverseMap) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public void forgetGraph(long id) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public void setElementsThreshold(int threshold) {
    }

    @Override
    public void setTadThreshold(int threshold) {
    }

    @Override
    public boolean isVerbose() {
        return this.verbose.get();
    }

    @Override
    public boolean isDebug() {
        return this.debug.get();
    }

    @Override
    public OpExecutioner.ExecutionerType type() {
        throw new UnsupportedOperationException();
    }

    public String opInfoString(Op op, Optional<int[]> dimensions) {
        if (op == null) {
            return "<NULL OP>";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Class: ").append(op.getClass().getName()).append("; opNum: ").append(op.opNum()).append("; opName: ").append(op.opName());
        if (op instanceof DifferentialFunction) {
            sb.append("; opType: ").append((Object)((DifferentialFunction)((Object)op)).opType());
        }
        if (dimensions != null) {
            sb.append("; dimensions: ");
            if (dimensions.isPresent()) {
                sb.append(Arrays.toString((int[])dimensions.get()));
            } else {
                sb.append("<null>");
            }
        }
        INDArray x = op.x();
        INDArray y = op.y();
        INDArray z = op.z();
        boolean execSpecial = op.isExecSpecial();
        Object[] extraArgs = op.extraArgs();
        sb.append("\n");
        sb.append("x: ").append(this.arrayInfo(x)).append("; ");
        sb.append("y: ").append(this.arrayInfo(y)).append("; ");
        sb.append("z: ").append(this.arrayInfo(z)).append("; ");
        if (x == y && x != null) {
            sb.append("(x == y)");
        }
        if (x == z && x != null) {
            sb.append("(x == z)");
        }
        if (y == z && y != null) {
            sb.append("(y == z)");
        }
        sb.append("\n");
        sb.append("isExecSpecial: ").append(execSpecial).append("; extraArgs: ").append(Preconditions.formatArray((Object)extraArgs));
        return sb.toString();
    }

    public String arrayInfo(INDArray arr) {
        if (arr == null) {
            return "<null>";
        }
        if (arr.isEmpty()) {
            return "(empty NDArray)";
        }
        return arr.shapeInfoToString().replaceAll("\n", "");
    }
}

