/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.autodiff.samediff;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.nd4j.base.Preconditions;
import org.nd4j.linalg.learning.config.IUpdater;

public class TrainingConfig {
    private IUpdater updater;
    private double l1;
    private double l2;
    private boolean minimize = true;
    private List<String> dataSetFeatureMapping;
    private List<String> dataSetLabelMapping;
    private List<String> dataSetFeatureMaskMapping;
    private List<String> dataSetLabelMaskMapping;
    private List<String> trainableParams;
    private int iterationCount;
    private int epochCount;

    public TrainingConfig(IUpdater updater, double l1, double l2, String dataSetFeatureMapping, String dataSetLabelMapping) {
        this(updater, l1, l2, true, Collections.singletonList(dataSetFeatureMapping), Collections.singletonList(dataSetLabelMapping), Collections.emptyList(), Collections.emptyList(), null);
    }

    public TrainingConfig(IUpdater updater, double l1, double l2, boolean minimize, List<String> dataSetFeatureMapping, List<String> dataSetLabelMapping, List<String> dataSetFeatureMaskMapping, List<String> dataSetLabelMaskMapping, List<String> trainableParams) {
        this.updater = updater;
        this.l1 = l1;
        this.l2 = l2;
        this.minimize = minimize;
        this.dataSetFeatureMapping = dataSetFeatureMapping;
        this.dataSetLabelMapping = dataSetLabelMapping;
        this.dataSetFeatureMaskMapping = dataSetFeatureMaskMapping;
        this.dataSetLabelMaskMapping = dataSetLabelMaskMapping;
        this.trainableParams = trainableParams;
    }

    public void incrementIterationCount() {
        ++this.iterationCount;
    }

    public void incrementEpochCount() {
        ++this.epochCount;
    }

    public static Builder builder() {
        return new Builder();
    }

    public int labelIdx(String s) {
        return this.dataSetLabelMapping.indexOf(s);
    }

    public IUpdater getUpdater() {
        return this.updater;
    }

    public double getL1() {
        return this.l1;
    }

    public double getL2() {
        return this.l2;
    }

    public boolean isMinimize() {
        return this.minimize;
    }

    public List<String> getDataSetFeatureMapping() {
        return this.dataSetFeatureMapping;
    }

    public List<String> getDataSetLabelMapping() {
        return this.dataSetLabelMapping;
    }

    public List<String> getDataSetFeatureMaskMapping() {
        return this.dataSetFeatureMaskMapping;
    }

    public List<String> getDataSetLabelMaskMapping() {
        return this.dataSetLabelMaskMapping;
    }

    public List<String> getTrainableParams() {
        return this.trainableParams;
    }

    public int getIterationCount() {
        return this.iterationCount;
    }

    public int getEpochCount() {
        return this.epochCount;
    }

    public void setUpdater(IUpdater updater) {
        this.updater = updater;
    }

    public void setL1(double l1) {
        this.l1 = l1;
    }

    public void setL2(double l2) {
        this.l2 = l2;
    }

    public void setMinimize(boolean minimize) {
        this.minimize = minimize;
    }

    public void setDataSetFeatureMapping(List<String> dataSetFeatureMapping) {
        this.dataSetFeatureMapping = dataSetFeatureMapping;
    }

    public void setDataSetLabelMapping(List<String> dataSetLabelMapping) {
        this.dataSetLabelMapping = dataSetLabelMapping;
    }

    public void setDataSetFeatureMaskMapping(List<String> dataSetFeatureMaskMapping) {
        this.dataSetFeatureMaskMapping = dataSetFeatureMaskMapping;
    }

    public void setDataSetLabelMaskMapping(List<String> dataSetLabelMaskMapping) {
        this.dataSetLabelMaskMapping = dataSetLabelMaskMapping;
    }

    public void setTrainableParams(List<String> trainableParams) {
        this.trainableParams = trainableParams;
    }

    public void setIterationCount(int iterationCount) {
        this.iterationCount = iterationCount;
    }

    public void setEpochCount(int epochCount) {
        this.epochCount = epochCount;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TrainingConfig)) {
            return false;
        }
        TrainingConfig other = (TrainingConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        IUpdater this$updater = this.getUpdater();
        IUpdater other$updater = other.getUpdater();
        if (this$updater == null ? other$updater != null : !((Object)this$updater).equals(other$updater)) {
            return false;
        }
        if (Double.compare(this.getL1(), other.getL1()) != 0) {
            return false;
        }
        if (Double.compare(this.getL2(), other.getL2()) != 0) {
            return false;
        }
        if (this.isMinimize() != other.isMinimize()) {
            return false;
        }
        List<String> this$dataSetFeatureMapping = this.getDataSetFeatureMapping();
        List<String> other$dataSetFeatureMapping = other.getDataSetFeatureMapping();
        if (this$dataSetFeatureMapping == null ? other$dataSetFeatureMapping != null : !((Object)this$dataSetFeatureMapping).equals(other$dataSetFeatureMapping)) {
            return false;
        }
        List<String> this$dataSetLabelMapping = this.getDataSetLabelMapping();
        List<String> other$dataSetLabelMapping = other.getDataSetLabelMapping();
        if (this$dataSetLabelMapping == null ? other$dataSetLabelMapping != null : !((Object)this$dataSetLabelMapping).equals(other$dataSetLabelMapping)) {
            return false;
        }
        List<String> this$dataSetFeatureMaskMapping = this.getDataSetFeatureMaskMapping();
        List<String> other$dataSetFeatureMaskMapping = other.getDataSetFeatureMaskMapping();
        if (this$dataSetFeatureMaskMapping == null ? other$dataSetFeatureMaskMapping != null : !((Object)this$dataSetFeatureMaskMapping).equals(other$dataSetFeatureMaskMapping)) {
            return false;
        }
        List<String> this$dataSetLabelMaskMapping = this.getDataSetLabelMaskMapping();
        List<String> other$dataSetLabelMaskMapping = other.getDataSetLabelMaskMapping();
        if (this$dataSetLabelMaskMapping == null ? other$dataSetLabelMaskMapping != null : !((Object)this$dataSetLabelMaskMapping).equals(other$dataSetLabelMaskMapping)) {
            return false;
        }
        List<String> this$trainableParams = this.getTrainableParams();
        List<String> other$trainableParams = other.getTrainableParams();
        if (this$trainableParams == null ? other$trainableParams != null : !((Object)this$trainableParams).equals(other$trainableParams)) {
            return false;
        }
        if (this.getIterationCount() != other.getIterationCount()) {
            return false;
        }
        return this.getEpochCount() == other.getEpochCount();
    }

    protected boolean canEqual(Object other) {
        return other instanceof TrainingConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        IUpdater $updater = this.getUpdater();
        result = result * 59 + ($updater == null ? 43 : $updater.hashCode());
        long $l1 = Double.doubleToLongBits(this.getL1());
        result = result * 59 + (int)($l1 >>> 32 ^ $l1);
        long $l2 = Double.doubleToLongBits(this.getL2());
        result = result * 59 + (int)($l2 >>> 32 ^ $l2);
        result = result * 59 + (this.isMinimize() ? 79 : 97);
        List<String> $dataSetFeatureMapping = this.getDataSetFeatureMapping();
        result = result * 59 + ($dataSetFeatureMapping == null ? 43 : ((Object)$dataSetFeatureMapping).hashCode());
        List<String> $dataSetLabelMapping = this.getDataSetLabelMapping();
        result = result * 59 + ($dataSetLabelMapping == null ? 43 : ((Object)$dataSetLabelMapping).hashCode());
        List<String> $dataSetFeatureMaskMapping = this.getDataSetFeatureMaskMapping();
        result = result * 59 + ($dataSetFeatureMaskMapping == null ? 43 : ((Object)$dataSetFeatureMaskMapping).hashCode());
        List<String> $dataSetLabelMaskMapping = this.getDataSetLabelMaskMapping();
        result = result * 59 + ($dataSetLabelMaskMapping == null ? 43 : ((Object)$dataSetLabelMaskMapping).hashCode());
        List<String> $trainableParams = this.getTrainableParams();
        result = result * 59 + ($trainableParams == null ? 43 : ((Object)$trainableParams).hashCode());
        result = result * 59 + this.getIterationCount();
        result = result * 59 + this.getEpochCount();
        return result;
    }

    public String toString() {
        return "TrainingConfig(updater=" + this.getUpdater() + ", l1=" + this.getL1() + ", l2=" + this.getL2() + ", minimize=" + this.isMinimize() + ", dataSetFeatureMapping=" + this.getDataSetFeatureMapping() + ", dataSetLabelMapping=" + this.getDataSetLabelMapping() + ", dataSetFeatureMaskMapping=" + this.getDataSetFeatureMaskMapping() + ", dataSetLabelMaskMapping=" + this.getDataSetLabelMaskMapping() + ", trainableParams=" + this.getTrainableParams() + ", iterationCount=" + this.getIterationCount() + ", epochCount=" + this.getEpochCount() + ")";
    }

    public TrainingConfig() {
    }

    public TrainingConfig(IUpdater updater, double l1, double l2, boolean minimize, List<String> dataSetFeatureMapping, List<String> dataSetLabelMapping, List<String> dataSetFeatureMaskMapping, List<String> dataSetLabelMaskMapping, List<String> trainableParams, int iterationCount, int epochCount) {
        this.updater = updater;
        this.l1 = l1;
        this.l2 = l2;
        this.minimize = minimize;
        this.dataSetFeatureMapping = dataSetFeatureMapping;
        this.dataSetLabelMapping = dataSetLabelMapping;
        this.dataSetFeatureMaskMapping = dataSetFeatureMaskMapping;
        this.dataSetLabelMaskMapping = dataSetLabelMaskMapping;
        this.trainableParams = trainableParams;
        this.iterationCount = iterationCount;
        this.epochCount = epochCount;
    }

    public static class TrainingConfigBuilder {
        private IUpdater updater;
        private double l1;
        private double l2;
        private boolean minimize;
        private List<String> dataSetFeatureMapping;
        private List<String> dataSetLabelMapping;
        private List<String> dataSetFeatureMaskMapping;
        private List<String> dataSetLabelMaskMapping;
        private List<String> trainableParams;
        private int iterationCount;
        private int epochCount;

        TrainingConfigBuilder() {
        }

        public TrainingConfigBuilder updater(IUpdater updater) {
            this.updater = updater;
            return this;
        }

        public TrainingConfigBuilder l1(double l1) {
            this.l1 = l1;
            return this;
        }

        public TrainingConfigBuilder l2(double l2) {
            this.l2 = l2;
            return this;
        }

        public TrainingConfigBuilder minimize(boolean minimize) {
            this.minimize = minimize;
            return this;
        }

        public TrainingConfigBuilder dataSetFeatureMapping(List<String> dataSetFeatureMapping) {
            this.dataSetFeatureMapping = dataSetFeatureMapping;
            return this;
        }

        public TrainingConfigBuilder dataSetLabelMapping(List<String> dataSetLabelMapping) {
            this.dataSetLabelMapping = dataSetLabelMapping;
            return this;
        }

        public TrainingConfigBuilder dataSetFeatureMaskMapping(List<String> dataSetFeatureMaskMapping) {
            this.dataSetFeatureMaskMapping = dataSetFeatureMaskMapping;
            return this;
        }

        public TrainingConfigBuilder dataSetLabelMaskMapping(List<String> dataSetLabelMaskMapping) {
            this.dataSetLabelMaskMapping = dataSetLabelMaskMapping;
            return this;
        }

        public TrainingConfigBuilder trainableParams(List<String> trainableParams) {
            this.trainableParams = trainableParams;
            return this;
        }

        public TrainingConfigBuilder iterationCount(int iterationCount) {
            this.iterationCount = iterationCount;
            return this;
        }

        public TrainingConfigBuilder epochCount(int epochCount) {
            this.epochCount = epochCount;
            return this;
        }

        public TrainingConfig build() {
            return new TrainingConfig(this.updater, this.l1, this.l2, this.minimize, this.dataSetFeatureMapping, this.dataSetLabelMapping, this.dataSetFeatureMaskMapping, this.dataSetLabelMaskMapping, this.trainableParams, this.iterationCount, this.epochCount);
        }

        public String toString() {
            return "TrainingConfig.TrainingConfigBuilder(updater=" + this.updater + ", l1=" + this.l1 + ", l2=" + this.l2 + ", minimize=" + this.minimize + ", dataSetFeatureMapping=" + this.dataSetFeatureMapping + ", dataSetLabelMapping=" + this.dataSetLabelMapping + ", dataSetFeatureMaskMapping=" + this.dataSetFeatureMaskMapping + ", dataSetLabelMaskMapping=" + this.dataSetLabelMaskMapping + ", trainableParams=" + this.trainableParams + ", iterationCount=" + this.iterationCount + ", epochCount=" + this.epochCount + ")";
        }
    }

    public static class Builder {
        private IUpdater updater;
        private double l1;
        private double l2;
        private boolean minimize = true;
        private List<String> dataSetFeatureMapping;
        private List<String> dataSetLabelMapping;
        private List<String> dataSetFeatureMaskMapping;
        private List<String> dataSetLabelMaskMapping;
        private List<String> trainableParams;

        public Builder updater(IUpdater updater) {
            this.updater = updater;
            return this;
        }

        public Builder l1(double l1) {
            Preconditions.checkState((l1 >= 0.0 ? 1 : 0) != 0, (String)"L1 regularization coefficient must be >= 0. Got %s", (double)l1);
            this.l1 = l1;
            return this;
        }

        public Builder l2(double l2) {
            Preconditions.checkState((l2 >= 0.0 ? 1 : 0) != 0, (String)"L2 regularization coefficient must be >= 0. Got %s", (double)l2);
            this.l2 = l2;
            return this;
        }

        public Builder minimize(boolean minimize) {
            this.minimize = minimize;
            return this;
        }

        public Builder dataSetFeatureMapping(String ... dataSetFeatureMapping) {
            return this.dataSetFeatureMapping(Arrays.asList(dataSetFeatureMapping));
        }

        public Builder dataSetFeatureMapping(List<String> dataSetFeatureMapping) {
            Preconditions.checkNotNull((Object)(dataSetFeatureMapping != null && dataSetFeatureMapping.size() > 0 ? 1 : 0), (String)"No feature mapping was provided");
            this.dataSetFeatureMapping = dataSetFeatureMapping;
            return this;
        }

        public Builder dataSetLabelMapping(String ... dataSetLabelMapping) {
            return this.dataSetLabelMapping(Arrays.asList(dataSetLabelMapping));
        }

        public Builder dataSetLabelMapping(List<String> dataSetLabelMapping) {
            Preconditions.checkNotNull((Object)(dataSetLabelMapping != null && dataSetLabelMapping.size() > 0 ? 1 : 0), (String)"No label mapping was provided");
            this.dataSetLabelMapping = dataSetLabelMapping;
            return this;
        }

        public Builder dataSetFeatureMaskMapping(List<String> dataSetFeatureMaskMapping) {
            this.dataSetFeatureMaskMapping = dataSetFeatureMaskMapping;
            return this;
        }

        public Builder dataSetLabelMaskMapping(List<String> dataSetLabelMaskMapping) {
            this.dataSetLabelMaskMapping = dataSetLabelMaskMapping;
            return this;
        }

        public Builder trainableParams(String ... trainableParams) {
            return this.trainableParams(Arrays.asList(trainableParams));
        }

        public Builder trainableParams(List<String> trainableParams) {
            this.trainableParams = trainableParams;
            return this;
        }

        public TrainingConfig build() {
            Preconditions.checkState((this.updater != null ? 1 : 0) != 0, (String)"Updater (optimizer) must not be null. Use updater(IUpdater) to set an updater");
            Preconditions.checkState((this.dataSetFeatureMapping != null ? 1 : 0) != 0, (String)"No DataSet feature mapping has been provided. A mapping between DataSet array positions and variables/placeholders must be provided - use  dateSetFeatureMapping(...) to set this");
            Preconditions.checkState((this.dataSetLabelMapping != null ? 1 : 0) != 0, (String)"No DataSet label mapping has been provided. A mapping between DataSet array positions and variables/placeholders must be provided - use  dateSetLabelMapping(...) to set this");
            return new TrainingConfig(this.updater, this.l1, this.l2, this.minimize, this.dataSetFeatureMapping, this.dataSetLabelMapping, this.dataSetFeatureMaskMapping, this.dataSetLabelMaskMapping, this.trainableParams);
        }
    }
}

