/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.indexing;

import com.google.common.base.Function;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.NonNull;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.impl.accum.MatchCondition;
import org.nd4j.linalg.api.ops.impl.indexaccum.FirstIndex;
import org.nd4j.linalg.api.ops.impl.indexaccum.LastIndex;
import org.nd4j.linalg.api.ops.impl.transforms.comparison.Choose;
import org.nd4j.linalg.api.ops.impl.transforms.comparison.CompareAndReplace;
import org.nd4j.linalg.api.ops.impl.transforms.comparison.CompareAndSet;
import org.nd4j.linalg.api.shape.Shape;
import org.nd4j.linalg.api.shape.loop.coordinatefunction.CoordinateFunction;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.indexing.NDArrayIndex;
import org.nd4j.linalg.indexing.conditions.BaseCondition;
import org.nd4j.linalg.indexing.conditions.Condition;

public class BooleanIndexing {
    public static boolean and(final INDArray n, final Condition cond) {
        if (cond instanceof BaseCondition) {
            long val = (long)Nd4j.getExecutioner().exec(new MatchCondition(n, cond), Integer.MAX_VALUE).getDouble(0L);
            return val == n.lengthLong();
        }
        boolean ret = true;
        final AtomicBoolean a = new AtomicBoolean(ret);
        Shape.iterate(n, new CoordinateFunction(){

            @Override
            public void process(long[] ... coord) {
                if (a.get()) {
                    a.compareAndSet(true, a.get() && cond.apply(n.getDouble(coord[0])) != false);
                }
            }
        });
        return a.get();
    }

    public static boolean[] and(INDArray n, Condition condition, int ... dimension) {
        if (!(condition instanceof BaseCondition)) {
            throw new UnsupportedOperationException("Only static Conditions are supported");
        }
        MatchCondition op = new MatchCondition(n, condition);
        INDArray arr = Nd4j.getExecutioner().exec(op, dimension);
        boolean[] result = new boolean[(int)arr.length()];
        long tadLength = Shape.getTADLength(n.shape(), dimension);
        int i = 0;
        while ((long)i < arr.length()) {
            result[i] = arr.getDouble((long)i) == (double)tadLength;
            ++i;
        }
        return result;
    }

    public static boolean[] or(INDArray n, Condition condition, int ... dimension) {
        if (!(condition instanceof BaseCondition)) {
            throw new UnsupportedOperationException("Only static Conditions are supported");
        }
        MatchCondition op = new MatchCondition(n, condition);
        INDArray arr = Nd4j.getExecutioner().exec(op, dimension);
        boolean[] result = new boolean[(int)arr.length()];
        int i = 0;
        while ((long)i < arr.length()) {
            result[i] = arr.getDouble((long)i) > 0.0;
            ++i;
        }
        return result;
    }

    public static boolean or(final INDArray n, final Condition cond) {
        if (cond instanceof BaseCondition) {
            long val = (long)Nd4j.getExecutioner().exec(new MatchCondition(n, cond), Integer.MAX_VALUE).getDouble(0L);
            return val > 0L;
        }
        boolean ret = false;
        final AtomicBoolean a = new AtomicBoolean(ret);
        Shape.iterate(n, new CoordinateFunction(){

            @Override
            public void process(long[] ... coord) {
                if (!a.get()) {
                    a.compareAndSet(false, a.get() || cond.apply(n.getDouble(coord[0])) != false);
                }
            }
        });
        return a.get();
    }

    public static void applyWhere(final INDArray to, final Condition condition, final Function<Number, Number> function) {
        Shape.iterate(to, new CoordinateFunction(){

            @Override
            public void process(long[] ... coord) {
                if (condition.apply(to.getDouble(coord[0])).booleanValue()) {
                    to.putScalar(coord[0], ((Number)function.apply((Object)to.getDouble(coord[0]))).doubleValue());
                }
            }
        });
    }

    public static void applyWhere(final INDArray to, final Condition condition, Number number) {
        if (condition instanceof BaseCondition) {
            Nd4j.getExecutioner().exec(new CompareAndSet(to, number.doubleValue(), condition));
        } else {
            final double value = number.doubleValue();
            Function<Number, Number> dynamic = new Function<Number, Number>(){

                public Number apply(Number number) {
                    return value;
                }
            };
            Shape.iterate(to, new CoordinateFunction((Function)dynamic){
                final /* synthetic */ Function val$dynamic;
                {
                    this.val$dynamic = function;
                }

                @Override
                public void process(long[] ... coord) {
                    if (condition.apply(to.getDouble(coord[0])).booleanValue()) {
                        to.putScalar(coord[0], ((Number)this.val$dynamic.apply((Object)to.getDouble(coord[0]))).doubleValue());
                    }
                }
            });
        }
    }

    public static void assignIf(@NonNull INDArray to, @NonNull INDArray from, @NonNull Condition condition) {
        if (to == null) {
            throw new NullPointerException("to is marked @NonNull but is null");
        }
        if (from == null) {
            throw new NullPointerException("from is marked @NonNull but is null");
        }
        if (condition == null) {
            throw new NullPointerException("condition is marked @NonNull but is null");
        }
        if (!(condition instanceof BaseCondition)) {
            throw new UnsupportedOperationException("Only static Conditions are supported");
        }
        if (to.lengthLong() != from.lengthLong()) {
            throw new IllegalStateException("Mis matched length for to and from");
        }
        Nd4j.getExecutioner().exec(new CompareAndSet(to, from, condition));
    }

    public static void replaceWhere(@NonNull INDArray to, @NonNull INDArray from, @NonNull Condition condition) {
        if (to == null) {
            throw new NullPointerException("to is marked @NonNull but is null");
        }
        if (from == null) {
            throw new NullPointerException("from is marked @NonNull but is null");
        }
        if (condition == null) {
            throw new NullPointerException("condition is marked @NonNull but is null");
        }
        if (!(condition instanceof BaseCondition)) {
            throw new UnsupportedOperationException("Only static Conditions are supported");
        }
        if (to.lengthLong() != from.lengthLong()) {
            throw new IllegalStateException("Mis matched length for to and from");
        }
        Nd4j.getExecutioner().exec(new CompareAndReplace(to, from, condition));
    }

    public static INDArray chooseFrom(@NonNull INDArray[] input, @NonNull Condition condition) {
        if (input == null) {
            throw new NullPointerException("input is marked @NonNull but is null");
        }
        if (condition == null) {
            throw new NullPointerException("condition is marked @NonNull but is null");
        }
        Choose choose = new Choose(input, condition);
        Nd4j.getExecutioner().exec(choose);
        int secondOutput = choose.getOutputArgument(1).getInt(0);
        if (secondOutput < 1) {
            return null;
        }
        return choose.getOutputArgument(0);
    }

    public static INDArray applyMask(INDArray arr, INDArray mask) {
        return arr.mul(mask);
    }

    public static INDArray applyMaskInPlace(INDArray arr, INDArray mask) {
        return arr.muli(mask);
    }

    public static INDArray chooseFrom(@NonNull INDArray[] input, @NonNull List<Double> tArgs, @NonNull List<Integer> iArgs, @NonNull Condition condition) {
        if (input == null) {
            throw new NullPointerException("input is marked @NonNull but is null");
        }
        if (tArgs == null) {
            throw new NullPointerException("tArgs is marked @NonNull but is null");
        }
        if (iArgs == null) {
            throw new NullPointerException("iArgs is marked @NonNull but is null");
        }
        if (condition == null) {
            throw new NullPointerException("condition is marked @NonNull but is null");
        }
        Choose choose = new Choose(input, iArgs, tArgs, condition);
        Nd4j.getExecutioner().exec(choose);
        int secondOutput = choose.getOutputArgument(1).getInt(0);
        if (secondOutput < 1) {
            return null;
        }
        INDArray ret = choose.getOutputArgument(0).get(NDArrayIndex.interval(0, secondOutput));
        ret = ret.reshape(ret.length());
        return ret;
    }

    public static void replaceWhere(@NonNull INDArray to, @NonNull Number set, @NonNull Condition condition) {
        if (to == null) {
            throw new NullPointerException("to is marked @NonNull but is null");
        }
        if (set == null) {
            throw new NullPointerException("set is marked @NonNull but is null");
        }
        if (condition == null) {
            throw new NullPointerException("condition is marked @NonNull but is null");
        }
        if (!(condition instanceof BaseCondition)) {
            throw new UnsupportedOperationException("Only static Conditions are supported");
        }
        Nd4j.getExecutioner().exec(new CompareAndSet(to, set.doubleValue(), condition));
    }

    public static void applyWhere(final INDArray to, final Condition condition, final Function<Number, Number> function, final Function<Number, Number> alternativeFunction) {
        Shape.iterate(to, new CoordinateFunction(){

            @Override
            public void process(long[] ... coord) {
                if (condition.apply(to.getDouble(coord[0])).booleanValue()) {
                    to.putScalar(coord[0], ((Number)function.apply((Object)to.getDouble(coord[0]))).doubleValue());
                } else {
                    to.putScalar(coord[0], ((Number)alternativeFunction.apply((Object)to.getDouble(coord[0]))).doubleValue());
                }
            }
        });
    }

    public static INDArray firstIndex(INDArray array, Condition condition) {
        if (!(condition instanceof BaseCondition)) {
            throw new UnsupportedOperationException("Only static Conditions are supported");
        }
        FirstIndex idx = new FirstIndex(array, condition);
        Nd4j.getExecutioner().exec(idx);
        return Nd4j.scalar((double)idx.getFinalResult());
    }

    public static INDArray firstIndex(INDArray array, Condition condition, int ... dimension) {
        if (!(condition instanceof BaseCondition)) {
            throw new UnsupportedOperationException("Only static Conditions are supported");
        }
        return Nd4j.getExecutioner().exec(new FirstIndex(array, condition), dimension);
    }

    public static INDArray lastIndex(INDArray array, Condition condition) {
        if (!(condition instanceof BaseCondition)) {
            throw new UnsupportedOperationException("Only static Conditions are supported");
        }
        LastIndex idx = new LastIndex(array, condition);
        Nd4j.getExecutioner().exec(idx);
        return Nd4j.scalar((double)idx.getFinalResult());
    }

    public static INDArray lastIndex(INDArray array, Condition condition, int ... dimension) {
        if (!(condition instanceof BaseCondition)) {
            throw new UnsupportedOperationException("Only static Conditions are supported");
        }
        return Nd4j.getExecutioner().exec(new LastIndex(array, condition), dimension);
    }
}

