/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.random.impl;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.imports.NoOpNameFoundException;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.random.BaseRandomOp;

public class BinomialDistributionEx
extends BaseRandomOp {
    private int trials;
    private double probability;

    public BinomialDistributionEx() {
    }

    public BinomialDistributionEx(@NonNull INDArray z, int trials, double probability) {
        if (z == null) {
            throw new NullPointerException("z is marked @NonNull but is null");
        }
        this.init(z, z, z, z.lengthLong());
        this.trials = trials;
        this.probability = probability;
        this.extraArgs = new Object[]{(double)this.trials, this.probability};
    }

    public BinomialDistributionEx(@NonNull INDArray z, int trials, @NonNull INDArray probabilities) {
        if (z == null) {
            throw new NullPointerException("z is marked @NonNull but is null");
        }
        if (probabilities == null) {
            throw new NullPointerException("probabilities is marked @NonNull but is null");
        }
        if (z.lengthLong() != probabilities.lengthLong()) {
            throw new IllegalStateException("Length of probabilities array should match length of target array");
        }
        if (probabilities.elementWiseStride() < 1) {
            throw new IllegalStateException("Probabilities array shouldn't have negative elementWiseStride");
        }
        this.init(z, probabilities, z, z.lengthLong());
        this.trials = trials;
        this.probability = 0.0;
        this.extraArgs = new Object[]{(double)this.trials, this.probability};
    }

    public BinomialDistributionEx(@NonNull INDArray z, @NonNull INDArray probabilities) {
        this(z, (int)probabilities.length(), probabilities);
        if (z == null) {
            throw new NullPointerException("z is marked @NonNull but is null");
        }
        if (probabilities == null) {
            throw new NullPointerException("probabilities is marked @NonNull but is null");
        }
    }

    @Override
    public Map<String, Object> propertiesForFunction() {
        LinkedHashMap<String, Object> ret = new LinkedHashMap<String, Object>();
        ret.put("trials", this.trials);
        ret.put("probability", this.probability);
        return ret;
    }

    @Override
    public int opNum() {
        return 9;
    }

    @Override
    public String opName() {
        return "distribution_binomial_ex";
    }

    @Override
    public boolean isExecSpecial() {
        return true;
    }

    @Override
    public String onnxName() {
        throw new NoOpNameFoundException("No onnx op opName found for " + this.opName());
    }

    @Override
    public String tensorflowName() {
        throw new NoOpNameFoundException("No tensorflow op opName found for " + this.opName());
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> f1) {
        return null;
    }
}

