/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.random.impl;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.imports.NoOpNameFoundException;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.random.BaseRandomOp;
import org.nd4j.linalg.exception.ND4JIllegalStateException;

public class BernoulliDistribution
extends BaseRandomOp {
    private double prob;

    public BernoulliDistribution(SameDiff sd, double prob, long[] shape) {
        super(sd, shape);
        this.prob = prob;
        this.extraArgs = new Object[]{this.prob};
    }

    public BernoulliDistribution() {
    }

    public BernoulliDistribution(@NonNull INDArray z, double prob) {
        if (z == null) {
            throw new NullPointerException("z is marked @NonNull but is null");
        }
        this.init(null, null, z, z.lengthLong());
        this.prob = prob;
        this.extraArgs = new Object[]{this.prob};
    }

    public BernoulliDistribution(@NonNull INDArray z, @NonNull INDArray prob) {
        if (z == null) {
            throw new NullPointerException("z is marked @NonNull but is null");
        }
        if (prob == null) {
            throw new NullPointerException("prob is marked @NonNull but is null");
        }
        if (prob.elementWiseStride() != 1) {
            throw new ND4JIllegalStateException("Probabilities should have ElementWiseStride of 1");
        }
        if (prob.lengthLong() != z.lengthLong()) {
            throw new ND4JIllegalStateException("Length of probabilities array [" + prob.lengthLong() + "] doesn't match length of output array [" + z.lengthLong() + "]");
        }
        this.init(prob, null, z, z.lengthLong());
        this.prob = 0.0;
        this.extraArgs = new Object[]{this.prob};
    }

    @Override
    public Map<String, Object> propertiesForFunction() {
        LinkedHashMap<String, Object> ret = new LinkedHashMap<String, Object>();
        ret.put("prob", this.prob);
        return ret;
    }

    @Override
    public int opNum() {
        return 7;
    }

    @Override
    public String opName() {
        return "distribution_bernoulli";
    }

    @Override
    public String onnxName() {
        throw new NoOpNameFoundException("No onnx op opName found for " + this.opName());
    }

    @Override
    public String tensorflowName() {
        throw new NoOpNameFoundException("No tensorflow op opName found for " + this.opName());
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> f1) {
        return Collections.emptyList();
    }
}

