/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.shape;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.imports.descriptors.properties.PropertyMapping;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.tensorflow.framework.AttrValue;
import org.tensorflow.framework.GraphDef;
import org.tensorflow.framework.NodeDef;

public class Squeeze
extends DynamicCustomOp {
    private int[] squeezeDims;

    public Squeeze() {
    }

    public Squeeze(SameDiff sameDiff, SDVariable arg, int[] squeezeDims) {
        super(null, sameDiff, new SDVariable[]{arg});
        this.squeezeDims = squeezeDims;
    }

    @Override
    public void initFromTensorFlow(NodeDef nodeDef, SameDiff initWith, Map<String, AttrValue> attributesForNode, GraphDef graph) {
        super.initFromTensorFlow(nodeDef, initWith, attributesForNode, graph);
        if (this.squeezeDims != null) {
            this.addIArgument(this.squeezeDims);
        }
    }

    @Override
    public void resolvePropertiesFromSameDiffBeforeExecution() {
        super.resolvePropertiesFromSameDiffBeforeExecution();
        if (this.squeezeDims != null && this.numIArguments() < this.squeezeDims.length) {
            this.addIArgument(this.squeezeDims);
        }
    }

    @Override
    public String opName() {
        return "squeeze";
    }

    @Override
    public String tensorflowName() {
        return "Squeeze";
    }

    @Override
    public Map<String, Map<String, PropertyMapping>> mappingsForFunction() {
        HashMap<String, Map<String, PropertyMapping>> ret = new HashMap<String, Map<String, PropertyMapping>>();
        LinkedHashMap<String, PropertyMapping> mapping = new LinkedHashMap<String, PropertyMapping>();
        PropertyMapping squeezeDims = PropertyMapping.builder().tfAttrName("squeeze_dims").propertyNames(new String[]{"squeezeDims"}).build();
        mapping.put("squeezeDims", squeezeDims);
        ret.put(this.tensorflowName(), mapping);
        return ret;
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> i_v) {
        if (this.squeezeDims == null) {
            throw new IllegalStateException("Cannot do Squeeze backprop with no dimensions");
        }
        SDVariable ret = i_v.get(0);
        for (int d : this.squeezeDims) {
            ret = this.sameDiff.expandDims(ret, d);
        }
        return Arrays.asList(ret);
    }
}

