/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.layers.convolution;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.nd4j.autodiff.functions.DifferentialFunction;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.imports.converters.DifferentialFunctionClassHolder;
import org.nd4j.imports.descriptors.properties.AttributeAdapter;
import org.nd4j.imports.descriptors.properties.PropertyMapping;
import org.nd4j.imports.descriptors.properties.adapters.ConditionalFieldValueIntIndexArrayAdapter;
import org.nd4j.imports.descriptors.properties.adapters.ConditionalFieldValueNDArrayShapeAdapter;
import org.nd4j.imports.descriptors.properties.adapters.SizeThresholdIntArrayIntIndexAdpater;
import org.nd4j.imports.descriptors.properties.adapters.StringEqualsAdapter;
import org.nd4j.imports.graphmapper.tf.TFGraphMapper;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.nd4j.linalg.api.ops.impl.layers.convolution.config.DeConv2DConfig;
import org.nd4j.linalg.util.ArrayUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tensorflow.framework.AttrValue;
import org.tensorflow.framework.GraphDef;
import org.tensorflow.framework.NodeDef;

public class DeConv2DTF
extends DynamicCustomOp {
    private static final Logger log = LoggerFactory.getLogger(DeConv2DTF.class);
    protected DeConv2DConfig config;

    public DeConv2DTF(SameDiff sameDiff, SDVariable[] inputs, INDArray[] inputArrays, INDArray[] outputs, DeConv2DConfig config) {
        super(null, inputArrays, outputs);
        this.sameDiff = sameDiff;
        this.config = config;
        if (inputArrays != null) {
            this.addInputArgument(inputArrays);
        }
        if (outputs != null) {
            this.addOutputArgument(outputs);
        }
        this.addArgs();
        sameDiff.putFunctionForId(this.getOwnName(), this);
        sameDiff.addArgsFor(inputs, (DifferentialFunction)this);
    }

    @Override
    public long[] iArgs() {
        if (this.iArguments.size() == 0) {
            this.addArgs();
        }
        return super.iArgs();
    }

    @Override
    public Map<String, Object> propertiesForFunction() {
        return this.config.toProperties();
    }

    private void addArgs() {
        this.addIArgument(this.config.getKH());
        this.addIArgument(this.config.getKW());
        this.addIArgument(this.config.getSH());
        this.addIArgument(this.config.getSW());
        this.addIArgument(this.config.getPH());
        this.addIArgument(this.config.getPW());
        this.addIArgument(this.config.getDH());
        this.addIArgument(this.config.getDW());
        this.addIArgument(ArrayUtil.fromBoolean((boolean)this.config.isSameMode()));
        this.addIArgument(ArrayUtil.fromBoolean((boolean)this.config.isNHWC()));
    }

    @Override
    public boolean isConfigProperties() {
        return true;
    }

    @Override
    public String configFieldName() {
        return "config";
    }

    @Override
    public Object getValue(Field property) {
        if (this.config == null) {
            this.config = DeConv2DConfig.builder().build();
        }
        return this.config.getValue(property);
    }

    @Override
    public void setValueFor(Field target, Object value) {
        this.config.setValueFor(target, value);
    }

    @Override
    public Map<String, Map<String, PropertyMapping>> mappingsForFunction() {
        HashMap<String, Map<String, PropertyMapping>> ret = new HashMap<String, Map<String, PropertyMapping>>();
        HashMap<String, PropertyMapping> map = new HashMap<String, PropertyMapping>();
        PropertyMapping strideMapping = PropertyMapping.builder().tfAttrName("strides").onnxAttrName("strides").propertyNames(new String[]{"sH", "sW"}).build();
        PropertyMapping kernelMapping = PropertyMapping.builder().propertyNames(new String[]{"kH", "kW"}).tfInputPosition(1).onnxAttrName("kernel_shape").build();
        PropertyMapping dilationMapping = PropertyMapping.builder().onnxAttrName("dilations").propertyNames(new String[]{"dW", "dH"}).tfAttrName("rates").build();
        PropertyMapping sameMode = PropertyMapping.builder().onnxAttrName("auto_pad").propertyNames(new String[]{"isSameMode"}).tfAttrName("padding").build();
        PropertyMapping dataFormat = PropertyMapping.builder().onnxAttrName("data_format").tfAttrName("data_format").propertyNames(new String[]{"isNHWC"}).build();
        map.put("sW", strideMapping);
        map.put("sH", strideMapping);
        map.put("kH", kernelMapping);
        map.put("kW", kernelMapping);
        map.put("dW", dilationMapping);
        map.put("dH", dilationMapping);
        map.put("isSameMode", sameMode);
        map.put("isNHWC", dataFormat);
        ret.put(this.tensorflowName(), map);
        return ret;
    }

    @Override
    public Map<String, Map<String, AttributeAdapter>> attributeAdaptersForFunction() {
        HashMap<String, Map<String, AttributeAdapter>> ret = new HashMap<String, Map<String, AttributeAdapter>>();
        LinkedHashMap<String, AttributeAdapter> tfMappings = new LinkedHashMap<String, AttributeAdapter>();
        Map<String, Field> fields = DifferentialFunctionClassHolder.getInstance().getFieldsForFunction(this);
        tfMappings.put("kH", new ConditionalFieldValueNDArrayShapeAdapter("NCHW", 2, 0, fields.get("dataFormat")));
        tfMappings.put("kW", new ConditionalFieldValueNDArrayShapeAdapter("NCHW", 3, 1, fields.get("dataFormat")));
        tfMappings.put("sH", new ConditionalFieldValueIntIndexArrayAdapter("NCHW", 2, 1, fields.get("dataFormat")));
        tfMappings.put("sW", new ConditionalFieldValueIntIndexArrayAdapter("NCHW", 3, 2, fields.get("dataFormat")));
        tfMappings.put("isSameMode", new StringEqualsAdapter("SAME"));
        tfMappings.put("isNHWC", new StringEqualsAdapter("NHWC"));
        HashMap<String, AttributeAdapter> onnxMappings = new HashMap<String, AttributeAdapter>();
        onnxMappings.put("kH", new SizeThresholdIntArrayIntIndexAdpater(0, 2, 0));
        onnxMappings.put("kW", new SizeThresholdIntArrayIntIndexAdpater(1, 2, 0));
        onnxMappings.put("dH", new SizeThresholdIntArrayIntIndexAdpater(0, 2, 0));
        onnxMappings.put("dW", new SizeThresholdIntArrayIntIndexAdpater(1, 2, 0));
        onnxMappings.put("sH", new SizeThresholdIntArrayIntIndexAdpater(0, 2, 0));
        onnxMappings.put("sW", new SizeThresholdIntArrayIntIndexAdpater(1, 2, 0));
        onnxMappings.put("isSameMode", new StringEqualsAdapter("SAME"));
        onnxMappings.put("isNHWC", new StringEqualsAdapter("NHWC"));
        ret.put(this.tensorflowName(), tfMappings);
        return ret;
    }

    @Override
    public void initFromTensorFlow(NodeDef nodeDef, SameDiff initWith, Map<String, AttrValue> attributesForNode, GraphDef graph) {
        TFGraphMapper.getInstance().initFunctionFromProperties(nodeDef.getOp(), this, attributesForNode, nodeDef, graph);
        this.addArgs();
    }

    @Override
    public String opName() {
        return "deconv2d_tf";
    }

    @Override
    public String onnxName() {
        return "ConvTranspose-Absent";
    }

    @Override
    public String tensorflowName() {
        return "Conv2DBackpropInput";
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> f1) {
        throw new UnsupportedOperationException("To be implemented yet");
    }

    public static DeConv2DTFBuilder builder() {
        return new DeConv2DTFBuilder();
    }

    public DeConv2DConfig getConfig() {
        return this.config;
    }

    public DeConv2DTF() {
    }

    public static class DeConv2DTFBuilder {
        private SameDiff sameDiff;
        private SDVariable[] inputs;
        private INDArray[] inputArrays;
        private INDArray[] outputs;
        private DeConv2DConfig config;

        DeConv2DTFBuilder() {
        }

        public DeConv2DTFBuilder sameDiff(SameDiff sameDiff) {
            this.sameDiff = sameDiff;
            return this;
        }

        public DeConv2DTFBuilder inputs(SDVariable[] inputs) {
            this.inputs = inputs;
            return this;
        }

        public DeConv2DTFBuilder inputArrays(INDArray[] inputArrays) {
            this.inputArrays = inputArrays;
            return this;
        }

        public DeConv2DTFBuilder outputs(INDArray[] outputs) {
            this.outputs = outputs;
            return this;
        }

        public DeConv2DTFBuilder config(DeConv2DConfig config) {
            this.config = config;
            return this;
        }

        public DeConv2DTF build() {
            return new DeConv2DTF(this.sameDiff, this.inputs, this.inputArrays, this.outputs, this.config);
        }

        public String toString() {
            return "DeConv2DTF.DeConv2DTFBuilder(sameDiff=" + this.sameDiff + ", inputs=" + Arrays.deepToString(this.inputs) + ", inputArrays=" + Arrays.deepToString(this.inputArrays) + ", outputs=" + Arrays.deepToString(this.outputs) + ", config=" + this.config + ")";
        }
    }
}

