/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.factory;

import java.lang.reflect.Constructor;
import org.nd4j.autodiff.functions.DifferentialFunction;
import org.nd4j.imports.converters.DifferentialFunctionClassHolder;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.Accumulation;
import org.nd4j.linalg.api.ops.BroadcastOp;
import org.nd4j.linalg.api.ops.GradientOp;
import org.nd4j.linalg.api.ops.IndexAccumulation;
import org.nd4j.linalg.api.ops.LossFunction;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.api.ops.ScalarOp;
import org.nd4j.linalg.api.ops.TransformOp;
import org.nd4j.linalg.api.ops.factory.OpFactory;
import org.nd4j.linalg.api.ops.impl.accum.StandardDeviation;
import org.nd4j.linalg.api.ops.impl.accum.Variance;
import org.nd4j.linalg.api.ops.impl.transforms.Pow;
import org.nd4j.linalg.api.ops.impl.transforms.RectifedLinear;
import org.nd4j.linalg.api.ops.impl.transforms.Set;
import org.nd4j.linalg.api.ops.impl.transforms.Step;
import org.nd4j.linalg.api.ops.impl.transforms.gradient.GradientBackwardsMarker;
import org.nd4j.linalg.api.ops.impl.transforms.gradient.SigmoidDerivative;
import org.nd4j.linalg.api.ops.impl.transforms.gradient.SoftMaxDerivative;
import org.nd4j.linalg.api.ops.impl.transforms.gradient.TanhDerivative;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultOpFactory
implements OpFactory {
    private static final Logger log = LoggerFactory.getLogger(DefaultOpFactory.class);

    @Override
    public GradientOp createGradientOp(String name, INDArray x, INDArray y, INDArray z) {
        switch (name) {
            case "softmaxderivative": {
                return new SoftMaxDerivative(x, y, z);
            }
            case "sigmoidderivative": {
                return new SigmoidDerivative(x, y, z);
            }
            case "tanhderivative": {
                return new TanhDerivative(x, y, z);
            }
            case "gradientbackwards": {
                return new GradientBackwardsMarker(x, y, z);
            }
        }
        throw new IllegalStateException("Illegal opName " + name);
    }

    @Override
    public Op createShape(String name, INDArray x, INDArray z, Object[] extraArgs) {
        throw new IllegalArgumentException("Illegal opName for create shape op" + name);
    }

    @Override
    public LossFunction createLossFunction(String name, INDArray x, INDArray y) {
        try {
            Constructor<?> constructor = DifferentialFunctionClassHolder.getInstance().getInstance(name).getClass().getDeclaredConstructor(INDArray.class, INDArray.class);
            Op create = (Op)constructor.newInstance(x, y);
            return (LossFunction)create;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Illegal op " + name);
        }
    }

    @Override
    public Accumulation createAccum(String name, INDArray x) {
        return this.createAccum(name, x, null, x, null);
    }

    @Override
    public Accumulation createAccum(String name, INDArray x, INDArray y, INDArray z) {
        return this.createAccum(name, x, y, z, null);
    }

    @Override
    public Accumulation createAccum(String name, INDArray x, INDArray y, INDArray z, Object[] extraArgs) {
        Accumulation ret = null;
        switch (name) {
            case "mmul": 
            case "std": {
                ret = new StandardDeviation(x, y, z, x.length(), (boolean)((Boolean)extraArgs[0]));
                break;
            }
            case "var": {
                ret = new Variance(x, y, z, x.length(), (boolean)((Boolean)extraArgs[0]));
                break;
            }
            default: {
                try {
                    ret = (Accumulation)DifferentialFunctionClassHolder.getInstance().getInstance(name).getClass().getConstructor(INDArray.class, INDArray.class, INDArray.class, Long.TYPE).newInstance(x, y, z, x.length());
                    break;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (ret == null) {
            throw new IllegalArgumentException("Illegal operation opName " + name);
        }
        ret.setExtraArgs(extraArgs);
        return ret;
    }

    @Override
    public Accumulation createAccum(String name, INDArray x, INDArray y) {
        return this.createAccum(name, x, y, x, null);
    }

    @Override
    public IndexAccumulation createIndexAccum(String opName, INDArray x, INDArray y, INDArray z, Object[] extraArgs) {
        IndexAccumulation ret = null;
        try {
            ret = (IndexAccumulation)DifferentialFunctionClassHolder.getInstance().getInstance(opName).getClass().getConstructor(INDArray.class, INDArray.class).newInstance(x, y);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        ret.setExtraArgs(extraArgs);
        return ret;
    }

    @Override
    public IndexAccumulation createIndexAccum(String name, INDArray x) {
        return this.createIndexAccum(name, x, null, x, null);
    }

    @Override
    public IndexAccumulation createIndexAccum(String name, INDArray x, INDArray y) {
        return this.createIndexAccum(name, x, y, x, null);
    }

    @Override
    public TransformOp createTransform(String name, INDArray x, INDArray y) {
        return this.createTransform(name, x, y, x, null);
    }

    @Override
    public TransformOp createTransform(String name, INDArray x) {
        return this.createTransform(name, x, null, x, null);
    }

    @Override
    public TransformOp createTransform(String name, INDArray x, Object[] extraArgs) {
        return this.createTransform(name, x, null, x, extraArgs);
    }

    @Override
    public TransformOp createTransform(String name, INDArray x, INDArray y, INDArray z) {
        return this.createTransform(name, x, y, z, null);
    }

    @Override
    public TransformOp createTransform(String name, INDArray x, INDArray y, INDArray z, Object[] extraArgs) {
        TransformOp op = null;
        switch (name) {
            case "_softmaxderivative": {
                op = new org.nd4j.linalg.api.ops.impl.transforms.SoftMaxDerivative(x, z);
                break;
            }
            case "set": {
                op = new Set(x, y, z, z.length());
                break;
            }
            case "relu": {
                op = new RectifedLinear(x, z, x.length(), extraArgs == null || extraArgs[0] == null ? 0.0 : (Double)extraArgs[0]);
                break;
            }
            case "step": {
                op = new Step(x, y, z, x.length(), extraArgs == null || extraArgs[0] == null ? 0.0 : (Double)extraArgs[0]);
                break;
            }
            case "pow": {
                op = new Pow(x, z, (Double)extraArgs[0]);
                break;
            }
            default: {
                try {
                    if (y == null) {
                        op = (TransformOp)DifferentialFunctionClassHolder.getInstance().getInstance(name).getClass().getConstructor(INDArray.class, INDArray.class).newInstance(x, z);
                        break;
                    }
                    op = (TransformOp)DifferentialFunctionClassHolder.getInstance().getInstance(name).getClass().getConstructor(INDArray.class, INDArray.class, INDArray.class).newInstance(x, y, z);
                    break;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        op.setExtraArgs(extraArgs);
        return op;
    }

    @Override
    public ScalarOp createScalarTransform(String name, INDArray x, INDArray y, double scalar) {
        return this.createScalarTransform(name, x, y, x, null, scalar);
    }

    @Override
    public ScalarOp createScalarTransform(String name, INDArray x, double scalar) {
        return this.createScalarTransform(name, x, null, x, null, scalar);
    }

    @Override
    public ScalarOp createScalarTransform(String name, INDArray x, Object[] extraArgs, double scalar) {
        return this.createScalarTransform(name, x, null, x, null, scalar);
    }

    @Override
    public ScalarOp createScalarTransform(String name, INDArray x, INDArray y, INDArray z, double scalar) {
        return this.createScalarTransform(name, x, y, z, null, scalar);
    }

    @Override
    public ScalarOp createScalarTransform(String name, INDArray x, INDArray y, INDArray z, Object[] extraArgs, double scalar) {
        ScalarOp ret = null;
        try {
            ret = (ScalarOp)DifferentialFunctionClassHolder.getInstance().getInstance(name).getClass().getConstructor(INDArray.class, INDArray.class, INDArray.class, Long.TYPE, Number.class).newInstance(x, y, z, x.length(), scalar);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        ret.setExtraArgs(extraArgs);
        return ret;
    }

    @Override
    public BroadcastOp createBroadcastOp(String name, INDArray x, INDArray y, INDArray z, int ... dimension) {
        return this.createBroadcastOp(name, x, y, z, (Object[])null, dimension);
    }

    @Override
    public BroadcastOp createBroadcastOp(String name, INDArray x, INDArray y, INDArray z, Object[] extraArgs, int ... dimension) {
        BroadcastOp broadcastOp = null;
        try {
            broadcastOp = (BroadcastOp)DifferentialFunctionClassHolder.getInstance().getInstance(name).getClass().getConstructor(INDArray.class, INDArray.class, INDArray.class, int[].class).newInstance(x, y, z, dimension);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        broadcastOp.setExtraArgs(extraArgs);
        return broadcastOp;
    }

    @Override
    public BroadcastOp createBroadcastOp(String name, INDArray x, INDArray y, int ... dimension) {
        return this.createBroadcastOp(name, x, y, x, (Object[])null, dimension);
    }

    @Override
    public int getOpNumByName(String opName) {
        try {
            DifferentialFunction op = DifferentialFunctionClassHolder.getInstance().getInstance(opName);
            return op.opNum();
        }
        catch (Exception e) {
            throw new RuntimeException("OpName failed: [" + opName + "]", e);
        }
    }

    @Override
    public int getOpNumIfExists(String opName) {
        if (DifferentialFunctionClassHolder.getInstance().hasName(opName)) {
            return this.getOpNumByName(opName);
        }
        return -1;
    }

    @Override
    public Op getOpByName(String opName) {
        return (Op)((Object)DifferentialFunctionClassHolder.getInstance().getInstance(opName));
    }
}

