/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops;

import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import onnx.OnnxProto3;
import org.nd4j.autodiff.functions.DifferentialFunction;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.imports.graphmapper.onnx.OnnxGraphMapper;
import org.nd4j.imports.graphmapper.tf.TFGraphMapper;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.Accumulation;
import org.nd4j.linalg.api.ops.BaseOp;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.api.shape.Shape;
import org.nd4j.linalg.exception.ND4JIllegalStateException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tensorflow.framework.AttrValue;
import org.tensorflow.framework.GraphDef;
import org.tensorflow.framework.NodeDef;

public abstract class BaseAccumulation
extends BaseOp
implements Accumulation {
    private static final Logger log = LoggerFactory.getLogger(BaseAccumulation.class);
    protected Number finalResult;
    protected boolean keepDims = false;
    protected boolean newFormat = false;
    protected boolean isComplex = false;

    public BaseAccumulation(SameDiff sameDiff, SDVariable i_v, int[] dimensions, boolean keepDims) {
        super(sameDiff, new Object[]{dimensions});
        if (i_v != null) {
            if (dimensions == null || dimensions.length < 1) {
                dimensions = new int[]{Integer.MAX_VALUE};
            }
            this.dimensions = dimensions;
            this.f().validateDifferentialFunctionsameDiff(i_v);
            this.keepDims = keepDims;
            this.xVertexId = i_v.getVarName();
            sameDiff.addArgsFor(new String[]{this.xVertexId}, (DifferentialFunction)this);
            if (Shape.isPlaceholderShape(i_v.getShape())) {
                sameDiff.addPropertyToResolve(this, i_v.getVarName());
            }
        } else {
            throw new IllegalArgumentException("Input not null variable.");
        }
        this.newFormat = true;
    }

    public BaseAccumulation(SameDiff sameDiff, SDVariable i_v, SDVariable i_v2, int[] dimensions, boolean keepDims) {
        super(sameDiff, new Object[]{dimensions});
        if (i_v != null) {
            if (dimensions == null || dimensions.length < 1) {
                dimensions = new int[]{Integer.MAX_VALUE};
            }
        } else {
            throw new IllegalArgumentException("Input not null variable.");
        }
        this.dimensions = dimensions;
        this.xVertexId = i_v.getVarName();
        this.yVertexId = i_v2.getVarName();
        this.f().validateDifferentialFunctionsameDiff(i_v);
        this.f().validateDifferentialFunctionsameDiff(i_v2);
        this.keepDims = keepDims;
        sameDiff.addArgsFor(new String[]{this.xVertexId, this.yVertexId}, (DifferentialFunction)this);
        this.newFormat = true;
    }

    public BaseAccumulation(SameDiff sameDiff, SDVariable i_v) {
        this(sameDiff, i_v, null, false);
    }

    public BaseAccumulation(SameDiff sameDiff, SDVariable i_v, int[] dimensions) {
        this(sameDiff, i_v, dimensions, false);
    }

    public BaseAccumulation(SameDiff sameDiff, SDVariable i_v, SDVariable i_v2, int[] dimensions) {
        this(sameDiff, i_v, i_v2, dimensions, false);
    }

    public BaseAccumulation() {
    }

    public BaseAccumulation(INDArray x, INDArray y, INDArray z, long n) {
        super(x, y, z, n);
        this.init();
    }

    public BaseAccumulation(INDArray x, INDArray y, INDArray z, boolean newFormat, boolean keepDims, int[] dimensions) {
        super(x, y, z, x.lengthLong());
        this.newFormat = newFormat;
        this.keepDims = keepDims;
        this.dimensions = dimensions;
        this.init();
    }

    public BaseAccumulation(INDArray x, INDArray y, long n) {
        this(x, y, x, n);
    }

    public BaseAccumulation(INDArray x) {
        this(x, null, x, x.lengthLong());
    }

    public BaseAccumulation(INDArray x, INDArray y) {
        this(x, y, x, x.lengthLong());
    }

    public BaseAccumulation(SameDiff sameDiff) {
        this.sameDiff = sameDiff;
    }

    private void init() {
        if (this.z == null || this.x == this.z) {
            this.init(this.x, this.y, this.x, this.x.lengthLong());
        } else {
            this.init(this.x, this.y, this.z, this.x.lengthLong());
        }
    }

    @Override
    public INDArray noOp() {
        if (this.z != null && this.x != this.z) {
            return this.z().assign(this.x);
        }
        return this.x().dup(this.x().ordering());
    }

    @Override
    public boolean isKeepDims() {
        return this.keepDims;
    }

    @Override
    public List<long[]> calculateOutputShape() {
        if (this.args().length < 1) {
            throw new ND4JIllegalStateException("Unable to compute input shape. No arguments found.");
        }
        long[] argShape = this.arg().getShape();
        if (argShape == null && this.x() == null) {
            return Collections.emptyList();
        }
        long[] inputShape = argShape == null ? this.x().shape() : argShape;
        ArrayList<long[]> ret = new ArrayList<long[]>(1);
        long[] reducedShape = Shape.getReducedShape(inputShape, this.dimensions, this.isKeepDims(), this.newFormat);
        ret.add(reducedShape);
        return ret;
    }

    @Override
    public void initFromTensorFlow(NodeDef nodeDef, SameDiff initWith, Map<String, AttrValue> attributesForNode, GraphDef graph) {
        this.newFormat = true;
        if (!attributesForNode.containsKey("axis") && !this.hasReductionIndices(nodeDef)) {
            this.dimensions = new int[]{Integer.MAX_VALUE};
        } else if (this.hasReductionIndices(nodeDef)) {
            NodeDef reductionNode = null;
            for (int i = 0; i < graph.getNodeCount(); ++i) {
                if (!graph.getNode(i).getName().equals(nodeDef.getName() + "/reduction_indices")) continue;
                reductionNode = graph.getNode(i);
                INDArray arr = TFGraphMapper.getInstance().getNDArrayFromTensor("value", reductionNode, graph);
                boolean keepAxis = nodeDef.getAttrOrThrow("keep_dims").getB();
                int[] dimensions = arr.data().asInt();
                this.dimensions = dimensions;
                break;
            }
            if (reductionNode == null) {
                throw new ND4JIllegalStateException("No node found!");
            }
        } else {
            int[] dims = TFGraphMapper.getInstance().getNDArrayFromTensor("axis", nodeDef, graph).data().asInt();
            this.dimensions = dims;
        }
        if (attributesForNode.containsKey("keep_dims")) {
            boolean keepDims;
            this.keepDims = keepDims = attributesForNode.get("keep_dims").getB();
        }
    }

    protected boolean hasReductionIndices(NodeDef nodeDef) {
        for (int i = 0; i < nodeDef.getInputCount(); ++i) {
            if (!nodeDef.getInput(i).contains("reduction_indices")) continue;
            return true;
        }
        return false;
    }

    @Override
    public void initFromOnnx(OnnxProto3.NodeProto node, SameDiff initWith, Map<String, OnnxProto3.AttributeProto> attributesForNode, OnnxProto3.GraphProto graph) {
        if (!attributesForNode.containsKey("axes")) {
            this.dimensions = new int[]{Integer.MAX_VALUE};
        } else {
            Map<String, OnnxProto3.AttributeProto> map = OnnxGraphMapper.getInstance().getAttrMap(node);
            int[] dims = Ints.toArray(map.get("axes").getIntsList());
            this.dimensions = dims;
        }
    }

    @Override
    public void setFinalResult(double value) {
        this.finalResult = value;
    }

    @Override
    public Number getFinalResult() {
        return this.finalResult;
    }

    @Override
    public double zeroDouble() {
        return 0.0;
    }

    @Override
    public float zeroFloat() {
        return 0.0f;
    }

    @Override
    public float zeroHalf() {
        return 0.0f;
    }

    @Override
    public Op.Type opType() {
        return Op.Type.REDUCE;
    }

    @Override
    public boolean isComplexAccumulation() {
        return this.isComplex;
    }

    public boolean isNewFormat() {
        return this.newFormat;
    }
}

