/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ndarray;

import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import com.google.flatbuffers.FlatBufferBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.TreeSet;
import lombok.NonNull;
import net.ericaro.neoitertools.Generator;
import org.apache.commons.math3.util.FastMath;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.graph.FlatArray;
import org.nd4j.linalg.api.blas.BlasBufferUtil;
import org.nd4j.linalg.api.blas.params.MMulTranspose;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.iter.FirstAxisIterator;
import org.nd4j.linalg.api.iter.NdIndexIterator;
import org.nd4j.linalg.api.memory.MemoryWorkspace;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ndarray.JvmShapeInfo;
import org.nd4j.linalg.api.ndarray.SparseFormat;
import org.nd4j.linalg.api.ops.Accumulation;
import org.nd4j.linalg.api.ops.impl.accum.AMax;
import org.nd4j.linalg.api.ops.impl.accum.AMean;
import org.nd4j.linalg.api.ops.impl.accum.AMin;
import org.nd4j.linalg.api.ops.impl.accum.Entropy;
import org.nd4j.linalg.api.ops.impl.accum.EqualsWithEps;
import org.nd4j.linalg.api.ops.impl.accum.LogEntropy;
import org.nd4j.linalg.api.ops.impl.accum.MatchCondition;
import org.nd4j.linalg.api.ops.impl.accum.Max;
import org.nd4j.linalg.api.ops.impl.accum.Mean;
import org.nd4j.linalg.api.ops.impl.accum.Min;
import org.nd4j.linalg.api.ops.impl.accum.Norm1;
import org.nd4j.linalg.api.ops.impl.accum.Norm2;
import org.nd4j.linalg.api.ops.impl.accum.NormMax;
import org.nd4j.linalg.api.ops.impl.accum.Prod;
import org.nd4j.linalg.api.ops.impl.accum.ShannonEntropy;
import org.nd4j.linalg.api.ops.impl.accum.StandardDeviation;
import org.nd4j.linalg.api.ops.impl.accum.Sum;
import org.nd4j.linalg.api.ops.impl.accum.Variance;
import org.nd4j.linalg.api.ops.impl.accum.distances.EuclideanDistance;
import org.nd4j.linalg.api.ops.impl.accum.distances.ManhattanDistance;
import org.nd4j.linalg.api.ops.impl.broadcast.BroadcastAddOp;
import org.nd4j.linalg.api.ops.impl.broadcast.BroadcastCopyOp;
import org.nd4j.linalg.api.ops.impl.broadcast.BroadcastDivOp;
import org.nd4j.linalg.api.ops.impl.broadcast.BroadcastMulOp;
import org.nd4j.linalg.api.ops.impl.broadcast.BroadcastRDivOp;
import org.nd4j.linalg.api.ops.impl.broadcast.BroadcastRSubOp;
import org.nd4j.linalg.api.ops.impl.broadcast.BroadcastSubOp;
import org.nd4j.linalg.api.ops.impl.controlflow.Where;
import org.nd4j.linalg.api.ops.impl.scalar.ScalarAdd;
import org.nd4j.linalg.api.ops.impl.scalar.ScalarDivision;
import org.nd4j.linalg.api.ops.impl.scalar.ScalarFMod;
import org.nd4j.linalg.api.ops.impl.scalar.ScalarMultiplication;
import org.nd4j.linalg.api.ops.impl.scalar.ScalarRemainder;
import org.nd4j.linalg.api.ops.impl.scalar.ScalarReverseDivision;
import org.nd4j.linalg.api.ops.impl.scalar.ScalarReverseSubtraction;
import org.nd4j.linalg.api.ops.impl.scalar.ScalarSet;
import org.nd4j.linalg.api.ops.impl.scalar.ScalarSubtraction;
import org.nd4j.linalg.api.ops.impl.scalar.comparison.ScalarEquals;
import org.nd4j.linalg.api.ops.impl.scalar.comparison.ScalarGreaterThan;
import org.nd4j.linalg.api.ops.impl.scalar.comparison.ScalarGreaterThanOrEqual;
import org.nd4j.linalg.api.ops.impl.scalar.comparison.ScalarLessThan;
import org.nd4j.linalg.api.ops.impl.scalar.comparison.ScalarLessThanOrEqual;
import org.nd4j.linalg.api.ops.impl.scalar.comparison.ScalarNotEquals;
import org.nd4j.linalg.api.ops.impl.shape.Tile;
import org.nd4j.linalg.api.ops.impl.transforms.Assign;
import org.nd4j.linalg.api.ops.impl.transforms.MatchConditionTransform;
import org.nd4j.linalg.api.ops.impl.transforms.Negative;
import org.nd4j.linalg.api.ops.impl.transforms.Set;
import org.nd4j.linalg.api.ops.impl.transforms.arithmetic.OldAddOp;
import org.nd4j.linalg.api.ops.impl.transforms.arithmetic.OldDivOp;
import org.nd4j.linalg.api.ops.impl.transforms.arithmetic.OldFModOp;
import org.nd4j.linalg.api.ops.impl.transforms.arithmetic.OldMulOp;
import org.nd4j.linalg.api.ops.impl.transforms.arithmetic.OldSubOp;
import org.nd4j.linalg.api.ops.impl.transforms.arithmetic.RemainderOp;
import org.nd4j.linalg.api.ops.impl.transforms.comparison.Eps;
import org.nd4j.linalg.api.ops.impl.transforms.comparison.OldEqualTo;
import org.nd4j.linalg.api.ops.impl.transforms.comparison.OldGreaterThan;
import org.nd4j.linalg.api.ops.impl.transforms.comparison.OldLessThan;
import org.nd4j.linalg.api.ops.impl.transforms.comparison.OldNotEqualTo;
import org.nd4j.linalg.api.ops.performance.PerformanceTracker;
import org.nd4j.linalg.api.shape.Shape;
import org.nd4j.linalg.api.shape.options.ArrayOptionsHelper;
import org.nd4j.linalg.exception.ND4JArraySizeException;
import org.nd4j.linalg.exception.ND4JIllegalArgumentException;
import org.nd4j.linalg.exception.ND4JIllegalStateException;
import org.nd4j.linalg.exception.Nd4jNoSuchWorkspaceException;
import org.nd4j.linalg.factory.NDArrayFactory;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.indexing.BooleanIndexing;
import org.nd4j.linalg.indexing.INDArrayIndex;
import org.nd4j.linalg.indexing.NDArrayIndex;
import org.nd4j.linalg.indexing.NDArrayIndexAll;
import org.nd4j.linalg.indexing.NewAxis;
import org.nd4j.linalg.indexing.PointIndex;
import org.nd4j.linalg.indexing.ShapeOffsetResolution;
import org.nd4j.linalg.indexing.SpecifiedIndex;
import org.nd4j.linalg.indexing.conditions.Condition;
import org.nd4j.linalg.memory.MemcpyDirection;
import org.nd4j.linalg.primitives.Pair;
import org.nd4j.linalg.string.NDArrayStrings;
import org.nd4j.linalg.util.ArrayUtil;
import org.nd4j.linalg.util.LinAlgExceptions;
import org.nd4j.linalg.util.LongUtils;
import org.nd4j.linalg.util.NDArrayMath;
import org.nd4j.linalg.workspace.WorkspaceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseNDArray
implements INDArray,
Iterable {
    private static final Logger log = LoggerFactory.getLogger(BaseNDArray.class);
    private static final long serialVersionUID = 3285982317165542614L;
    protected volatile transient DataBuffer shapeInformation;
    protected volatile transient DataBuffer data;
    protected transient boolean compressed = false;
    protected transient JvmShapeInfo jvmShapeInfo;
    private static final int[][] tadFinalPermuteDimensions = new int[32][0];

    public BaseNDArray() {
    }

    @Override
    public boolean isCompressed() {
        return this.compressed;
    }

    @Override
    public void markAsCompressed(boolean reallyCompressed) {
        this.compressed = reallyCompressed;
    }

    public BaseNDArray(DataBuffer buffer) {
        this.data = buffer;
        if (buffer.length() >= Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Length of buffer can not be >= Integer.MAX_VALUE");
        }
        int[] shape = new int[]{1, (int)buffer.length()};
        int[] stride = Nd4j.getStrides(shape);
        this.setShapeInformation(Nd4j.getShapeInfoProvider().createShapeInformation(shape, stride, 0L, 1, Nd4j.order().charValue()));
        this.init(shape, stride);
    }

    public BaseNDArray(DataBuffer buffer, int[] shape, int[] stride, long offset, char ordering) {
        this.data = offset > 0L ? Nd4j.createBuffer(buffer, offset, ArrayUtil.prodLong((int[])shape)) : buffer;
        this.setShapeInformation(Nd4j.getShapeInfoProvider().createShapeInformation(shape, stride, offset, Shape.elementWiseStride(shape, stride, ordering == 'f'), ordering));
        this.init(shape, stride);
    }

    public BaseNDArray(DataBuffer buffer, long[] shape, long[] stride, long offset, char ordering) {
        this.data = offset > 0L ? Nd4j.createBuffer(buffer, offset, ArrayUtil.prodLong((long[])shape)) : buffer;
        this.setShapeInformation(Nd4j.getShapeInfoProvider().createShapeInformation(shape, stride, offset, Shape.elementWiseStride(shape, stride, ordering == 'f'), ordering));
        this.init(shape, stride);
    }

    public BaseNDArray(double[][] data) {
        this(data, Nd4j.order().charValue());
    }

    public BaseNDArray(double[][] data, char ordering) {
        this(BaseNDArray.internalCreateBuffer(ordering == 'c' ? ArrayUtil.flatten((double[][])data) : ArrayUtil.flattenF((double[][])data)), new int[]{data.length, data[0].length}, Nd4j.getStrides(new int[]{data.length, data[0].length}, ordering), 0L, ordering);
        for (int r = 0; r < this.rows(); ++r) {
            assert (data[r].length == this.columns());
        }
    }

    public BaseNDArray(int[] shape, DataBuffer buffer) {
        this.data = buffer;
        this.init(shape, Nd4j.getStrides(shape));
    }

    public BaseNDArray(float[] data, int[] shape, char ordering) {
        this(data, shape, 0L, ordering);
    }

    public BaseNDArray(float[] data, int[] shape, long offset, char ordering) {
        this(data, shape, Nd4j.getStrides(shape, ordering), offset);
    }

    public BaseNDArray(double[] data, long[] shape, long offset, char ordering) {
        this(data, shape, Nd4j.getStrides(shape, ordering), offset);
    }

    public BaseNDArray(float[] data, long[] shape, long offset, char ordering) {
        this(data, shape, Nd4j.getStrides(shape, ordering), offset);
    }

    public BaseNDArray(int[] shape, int[] stride, long offset, char ordering) {
        this(Nd4j.createBuffer(ArrayUtil.prodLong((int[])shape)), shape, stride, offset, ordering);
    }

    public BaseNDArray(long[] shape, long[] stride, long offset, char ordering) {
        this(Nd4j.createBuffer(ArrayUtil.prodLong((long[])shape)), shape, stride, offset, ordering);
    }

    public BaseNDArray(int[] shape, int[] stride, long offset, char ordering, boolean initialize) {
        this(Nd4j.createBuffer(ArrayUtil.prodLong((int[])shape), initialize), shape, stride, offset, ordering);
    }

    public BaseNDArray(long[] shape, long[] stride, long offset, char ordering, boolean initialize) {
        this(Nd4j.createBuffer(ArrayUtil.prodLong((long[])shape), initialize), shape, stride, offset, ordering);
    }

    public BaseNDArray(int[] shape, int[] stride, char ordering) {
        this(shape, stride, 0L, ordering);
    }

    public BaseNDArray(int[] shape, long offset, char ordering) {
        this(shape, Nd4j.getStrides(shape, ordering), offset, ordering);
    }

    public BaseNDArray(long[] shape, long offset, char ordering) {
        this(shape, Nd4j.getStrides(shape, ordering), offset, ordering);
    }

    public BaseNDArray(int[] shape) {
        this(shape, 0L, Nd4j.order().charValue());
    }

    public BaseNDArray(long[] shape) {
        this(shape, 0L, Nd4j.order().charValue());
    }

    public BaseNDArray(int newRows, int newColumns, char ordering) {
        this.data = Nd4j.createBuffer((long)newRows * (long)newColumns);
        int[] shape = new int[]{newRows, newColumns};
        int[] stride = Nd4j.getStrides(shape, ordering);
        this.setShapeInformation(Nd4j.getShapeInfoProvider().createShapeInformation(shape, stride, 0L, Shape.elementWiseStride(shape, stride, ordering == 'f'), ordering));
        this.init(shape, stride);
    }

    public BaseNDArray(long newRows, long newColumns, char ordering) {
        this.data = Nd4j.createBuffer(newRows * newColumns);
        long[] shape = new long[]{newRows, newColumns};
        long[] stride = Nd4j.getStrides(shape, ordering);
        this.setShapeInformation(Nd4j.getShapeInfoProvider().createShapeInformation(shape, stride, 0L, Shape.elementWiseStride(shape, stride, ordering == 'f'), ordering));
        this.init(shape, stride);
    }

    public BaseNDArray(List<INDArray> slices, int[] shape, char ordering) {
        this(slices, shape, Nd4j.getStrides(shape, ordering), ordering);
    }

    public BaseNDArray(List<INDArray> slices, long[] shape, char ordering) {
        this(slices, shape, Nd4j.getStrides(shape, ordering), ordering);
    }

    public BaseNDArray(List<INDArray> slices, int[] shape, int[] stride, char ordering) {
        DataBuffer ret;
        this.data = ret = slices.get(0).data().dataType() == DataBuffer.Type.FLOAT ? Nd4j.createBuffer(new float[ArrayUtil.prod((int[])shape)]) : Nd4j.createBuffer(new double[ArrayUtil.prod((int[])shape)]);
        this.setShapeInformation(Nd4j.getShapeInfoProvider().createShapeInformation(shape, stride, 0L, Shape.elementWiseStride(shape, stride, ordering == 'f'), ordering));
        this.init(shape, stride);
        if (slices.get(0).isScalar()) {
            int i = 0;
            while ((long)i < this.length()) {
                this.putScalar((long)i, slices.get(i).getDouble(0L));
                ++i;
            }
        } else {
            int i = 0;
            while ((long)i < this.slices()) {
                this.putSlice(i, slices.get(i));
                ++i;
            }
        }
    }

    public BaseNDArray(List<INDArray> slices, long[] shape, long[] stride, char ordering) {
        DataBuffer ret;
        this.data = ret = slices.get(0).data().dataType() == DataBuffer.Type.FLOAT ? Nd4j.createBuffer(new float[ArrayUtil.prod((long[])shape)]) : Nd4j.createBuffer(new double[ArrayUtil.prod((long[])shape)]);
        this.setShapeInformation(Nd4j.getShapeInfoProvider().createShapeInformation(shape, stride, 0L, Shape.elementWiseStride(shape, stride, ordering == 'f'), ordering));
        this.init(shape, stride);
        if (slices.get(0).isScalar()) {
            int i = 0;
            while ((long)i < this.length()) {
                this.putScalar((long)i, slices.get(i).getDouble(0L));
                ++i;
            }
        } else {
            int i = 0;
            while ((long)i < this.slices()) {
                this.putSlice(i, slices.get(i));
                ++i;
            }
        }
    }

    public BaseNDArray(float[] data, int[] shape, int[] stride, char ordering) {
        this(data, shape, stride, 0L, ordering);
    }

    public BaseNDArray(float[] data, int[] shape, int[] stride, long offset, char ordering) {
        this.setShapeInformation(Nd4j.getShapeInfoProvider().createShapeInformation(shape, stride, offset, Shape.elementWiseStride(shape, stride, ordering == 'f'), ordering));
        if (data != null && data.length > 0) {
            long perfD = PerformanceTracker.getInstance().helperStartTransaction();
            this.data = BaseNDArray.internalCreateBuffer(data, offset);
            PerformanceTracker.getInstance().helperRegisterTransaction(0, perfD, data.length * Nd4j.sizeOfDataType(), MemcpyDirection.HOST_TO_HOST);
            if (offset >= (long)data.length) {
                throw new IllegalArgumentException("invalid offset: must be < data.length");
            }
        }
        this.init(shape, stride);
    }

    public BaseNDArray(float[] data, long[] shape, long[] stride, long offset, char ordering) {
        this.setShapeInformation(Nd4j.getShapeInfoProvider().createShapeInformation(shape, stride, offset, Shape.elementWiseStride(shape, stride, ordering == 'f'), ordering));
        if (data != null && data.length > 0) {
            this.data = Nd4j.createBuffer(data, offset);
            if (offset >= (long)data.length) {
                throw new IllegalArgumentException("invalid offset: must be < data.length");
            }
        }
        this.init(shape, stride);
    }

    public BaseNDArray(double[] data, long[] shape, long[] stride, long offset, char ordering) {
        this.setShapeInformation(Nd4j.getShapeInfoProvider().createShapeInformation(shape, stride, offset, Shape.elementWiseStride(shape, stride, ordering == 'f'), ordering));
        if (data != null && data.length > 0) {
            this.data = Nd4j.createBuffer(data, offset);
            if (offset >= (long)data.length) {
                throw new IllegalArgumentException("invalid offset: must be < data.length");
            }
        }
        this.init(shape, stride);
    }

    public BaseNDArray(DataBuffer data, int[] shape, int[] stride, long offset) {
        this.data = Nd4j.createBuffer(data, offset, ArrayUtil.prodLong((int[])shape));
        this.setShapeInformation(Nd4j.getShapeInfoProvider().createShapeInformation(shape, stride, offset, Shape.elementWiseStride(shape, stride, Nd4j.order().charValue() == 'f'), Nd4j.order().charValue()));
        this.init(shape, stride);
    }

    public BaseNDArray(int[] data, int[] shape, int[] strides) {
        this(BaseNDArray.internalCreateBuffer(data), shape, strides);
    }

    public BaseNDArray(DataBuffer data, int[] shape) {
        this(data, shape, Nd4j.getStrides(shape, Nd4j.order().charValue()), 0L, Nd4j.order().charValue());
    }

    public BaseNDArray(DataBuffer data, long[] shape) {
        this(data, shape, Nd4j.getStrides(shape, Nd4j.order().charValue()), 0L, Nd4j.order().charValue());
    }

    public BaseNDArray(DataBuffer buffer, int[] shape, long offset) {
        this(Nd4j.createBuffer(buffer, offset, ArrayUtil.prodLong((int[])shape)), shape, Nd4j.getStrides(shape), offset, Nd4j.order().charValue());
    }

    public BaseNDArray(DataBuffer buffer, int[] shape, char ordering) {
        this(buffer, shape, Nd4j.getStrides(shape, ordering), 0L, ordering);
    }

    public BaseNDArray(DataBuffer buffer, long[] shape, char ordering) {
        this(buffer, shape, Nd4j.getStrides(shape, ordering), 0L, ordering);
    }

    public BaseNDArray(double[] data, int[] shape, char ordering) {
        this(BaseNDArray.internalCreateBuffer(data), shape, ordering);
    }

    public BaseNDArray(double[] data, long[] shape, char ordering) {
        this(Nd4j.createBuffer(data), shape, ordering);
    }

    public BaseNDArray(float[] data, long[] shape, char ordering) {
        this(Nd4j.createBuffer(data), shape, ordering);
    }

    public BaseNDArray(double[] data, int[] shape, int[] stride, long offset, char ordering) {
        this(BaseNDArray.internalCreateBuffer(data, offset), shape, stride, offset, ordering);
    }

    public BaseNDArray(float[] data, char order) {
        this(BaseNDArray.internalCreateBuffer(data), order);
    }

    protected static DataBuffer internalCreateBuffer(float[] data) {
        long perfX = PerformanceTracker.getInstance().helperStartTransaction();
        DataBuffer buffer = Nd4j.createBuffer(data);
        PerformanceTracker.getInstance().helperRegisterTransaction(0, perfX, data.length * Nd4j.sizeOfDataType(), MemcpyDirection.HOST_TO_HOST);
        return buffer;
    }

    protected static DataBuffer internalCreateBuffer(double[] data) {
        long perfX = PerformanceTracker.getInstance().helperStartTransaction();
        DataBuffer buffer = Nd4j.createBuffer(data);
        PerformanceTracker.getInstance().helperRegisterTransaction(0, perfX, data.length * Nd4j.sizeOfDataType(), MemcpyDirection.HOST_TO_HOST);
        return buffer;
    }

    protected static DataBuffer internalCreateBuffer(int[] data) {
        long perfX = PerformanceTracker.getInstance().helperStartTransaction();
        DataBuffer buffer = Nd4j.createBuffer(data);
        PerformanceTracker.getInstance().helperRegisterTransaction(0, perfX, data.length * Nd4j.sizeOfDataType(), MemcpyDirection.HOST_TO_HOST);
        return buffer;
    }

    protected static DataBuffer internalCreateBuffer(float[] data, long offset) {
        long perfX = PerformanceTracker.getInstance().helperStartTransaction();
        DataBuffer buffer = Nd4j.createBuffer(data, offset);
        PerformanceTracker.getInstance().helperRegisterTransaction(0, perfX, data.length * Nd4j.sizeOfDataType(), MemcpyDirection.HOST_TO_HOST);
        return buffer;
    }

    protected static DataBuffer internalCreateBuffer(double[] data, long offset) {
        long perfX = PerformanceTracker.getInstance().helperStartTransaction();
        DataBuffer buffer = Nd4j.createBuffer(data, offset);
        PerformanceTracker.getInstance().helperRegisterTransaction(0, perfX, data.length * Nd4j.sizeOfDataType(), MemcpyDirection.HOST_TO_HOST);
        return buffer;
    }

    protected static DataBuffer internalCreateBuffer(int[] data, long offset) {
        long perfX = PerformanceTracker.getInstance().helperStartTransaction();
        DataBuffer buffer = Nd4j.createBuffer(data, offset);
        PerformanceTracker.getInstance().helperRegisterTransaction(0, perfX, data.length * Nd4j.sizeOfDataType(), MemcpyDirection.HOST_TO_HOST);
        return buffer;
    }

    public BaseNDArray(DataBuffer floatBuffer, char order) {
        this(floatBuffer, new int[]{(int)floatBuffer.length()}, Nd4j.getStrides(new int[]{(int)floatBuffer.length()}, order), 0L, order);
        if (floatBuffer.length() >= Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Length of buffer can not be >= Integer.MAX_VALUE");
        }
    }

    public BaseNDArray(DataBuffer buffer, int[] shape, int[] strides) {
        this(buffer, shape, strides, 0L, Nd4j.order().charValue());
    }

    public BaseNDArray(float[] data, int[] shape) {
        this(data, shape, 0L);
    }

    public BaseNDArray(float[] data, int[] shape, long offset) {
        this(data, shape, offset, Nd4j.order().charValue());
    }

    public BaseNDArray(int[] shape, int[] stride, long offset) {
        this(new float[ArrayUtil.prod((int[])shape)], shape, stride, offset, Nd4j.order().charValue());
    }

    public BaseNDArray(long[] shape, long[] stride, long offset) {
        this(new float[ArrayUtil.prod((long[])shape)], shape, stride, offset, Nd4j.order().charValue());
    }

    public BaseNDArray(int[] shape, int[] stride) {
        this(shape, stride, 0L);
    }

    public BaseNDArray(int[] shape, long offset) {
        this(shape, Nd4j.getStrides(shape), offset);
    }

    public BaseNDArray(int[] shape, char ordering) {
        this(shape, 0L, ordering);
    }

    public BaseNDArray(int newRows, int newColumns) {
        this(newRows, newColumns, Nd4j.order().charValue());
    }

    public BaseNDArray(long newRows, long newColumns) {
        this(newRows, newColumns, Nd4j.order().charValue());
    }

    public BaseNDArray(List<INDArray> slices, int[] shape) {
        this(slices, shape, Nd4j.order().charValue());
    }

    public BaseNDArray(List<INDArray> slices, long[] shape) {
        this(slices, shape, Nd4j.order().charValue());
    }

    public BaseNDArray(List<INDArray> slices, int[] shape, int[] stride) {
        this(slices, shape, stride, Nd4j.order().charValue());
    }

    public BaseNDArray(List<INDArray> slices, long[] shape, long[] stride) {
        this(slices, shape, stride, Nd4j.order().charValue());
    }

    public BaseNDArray(float[] data, int[] shape, int[] stride) {
        this(data, shape, stride, Nd4j.order().charValue());
    }

    public BaseNDArray(float[] data, int[] shape, int[] stride, long offset) {
        this(data, shape, stride, offset, Nd4j.order().charValue());
    }

    public BaseNDArray(double[] data, long[] shape, long[] stride, long offset) {
        this(data, shape, stride, offset, Nd4j.order().charValue());
    }

    public BaseNDArray(float[] data, long[] shape, long[] stride, long offset) {
        this(data, shape, stride, offset, Nd4j.order().charValue());
    }

    public BaseNDArray(float[] data) {
        this(Nd4j.createBuffer(data));
    }

    public BaseNDArray(float[][] data) {
        this(data, Nd4j.order().charValue());
    }

    public BaseNDArray(float[][] data, char ordering) {
        this(BaseNDArray.internalCreateBuffer(ordering == 'c' ? ArrayUtil.flatten((float[][])data) : ArrayUtil.flattenF((float[][])data)), new int[]{data.length, data[0].length}, Nd4j.getStrides(new int[]{data.length, data[0].length}, ordering), 0L, ordering);
        for (int r = 0; r < this.rows(); ++r) {
            assert (data[r].length == this.columns());
        }
    }

    public BaseNDArray(DataBuffer buffer, int[] shape, long offset, char ordering) {
        this(buffer, shape, Nd4j.getStrides(shape, ordering), offset, ordering);
    }

    public BaseNDArray(double[] data, int[] shape, int[] stride, long offset) {
        this(BaseNDArray.internalCreateBuffer(data), shape, stride, offset);
    }

    @Override
    @Deprecated
    public void setWrapAround(boolean wrapAround) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public boolean isWrapAround() {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public boolean isValid() {
        try {
            this.linearIndex(this.length() - 1L);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @Override
    @Deprecated
    public INDArray linearViewColumnOrder() {
        return this;
    }

    protected INDArray create(DataBuffer data, int[] shape, long offset) {
        return Nd4j.create(data, shape, offset);
    }

    @Override
    @Deprecated
    public INDArray linearView() {
        return this.reshape(this.ordering(), 1L, this.length());
    }

    @Override
    @Deprecated
    public void resetLinearView() {
    }

    @Override
    public int elementWiseStride() {
        return Shape.elementWiseStride(this.shapeInfoDataBuffer());
    }

    @Override
    public int elementStride() {
        return 1;
    }

    @Override
    @Deprecated
    public int majorStride() {
        return this.stride(-1);
    }

    @Override
    @Deprecated
    public int secondaryStride() {
        return this.majorStride();
    }

    @Override
    public long tensorssAlongDimension(int ... dimension) {
        if (dimension == null || dimension.length == 0) {
            throw new IllegalArgumentException("Invalid input: dimensions not specified (null or length 0)");
        }
        if (dimension.length >= this.rank() || dimension.length == 1 && dimension[0] == Integer.MAX_VALUE) {
            return 1L;
        }
        for (int i = 0; i < dimension.length; ++i) {
            if (dimension[i] >= 0) continue;
            int n = i;
            dimension[n] = dimension[n] + this.rank();
        }
        long[] tensorShape = ArrayUtil.keep((long[])this.shape(), (int[])dimension);
        long len = ArrayUtil.prodLong((long[])tensorShape);
        if (len == 0L) {
            throw new IllegalStateException("Illegal length found after removing index");
        }
        long length = this.length();
        if (length / len >= Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Tensors along dimension can not be >= Integer.MAX_VALUE");
        }
        return length / len;
    }

    @Override
    public INDArray tensorAlongDimension(int index, int ... dimension) {
        long tads;
        if (dimension == null || dimension.length == 0) {
            throw new IllegalArgumentException("Invalid input: dimensions not specified (null or length 0)");
        }
        if (dimension.length >= this.rank() || dimension.length == 1 && dimension[0] == Integer.MAX_VALUE) {
            return this;
        }
        for (int i = 0; i < dimension.length; ++i) {
            if (dimension[i] >= 0) continue;
            int n = i;
            dimension[n] = dimension[n] + this.rank();
        }
        if (dimension.length > 1) {
            dimension = Ints.toArray(new ArrayList(new TreeSet(Ints.asList((int[])dimension))));
        }
        if (dimension.length > 1) {
            Arrays.sort(dimension);
        }
        if ((long)index >= (tads = this.tensorssAlongDimension(dimension))) {
            throw new IllegalArgumentException("Illegal index " + index + " out of tads " + tads);
        }
        if (dimension.length == 1) {
            if (dimension[0] == 0 && this.isColumnVector()) {
                return this.transpose();
            }
            if (dimension[0] == 1 && this.isRowVector()) {
                return this;
            }
        }
        Pair<DataBuffer, DataBuffer> tadInfo = Nd4j.getExecutioner().getTADManager().getTADOnlyShapeInfo(this, dimension);
        DataBuffer shapeInfo = (DataBuffer)tadInfo.getFirst();
        long[] shape = Shape.shape(shapeInfo);
        long[] stride = Shape.stride(shapeInfo).asLong();
        long offset = this.offset() + ((DataBuffer)tadInfo.getSecond()).getLong((long)index);
        INDArray toTad = Nd4j.create(this.data(), shape, stride, offset);
        BaseNDArray baseNDArray = (BaseNDArray)toTad;
        char newOrder = Shape.getOrder(shape, stride, 1L);
        int ews = baseNDArray.shapeInfoDataBuffer().getInt(baseNDArray.shapeInfoDataBuffer().length() - 2L);
        if (!Shape.isRowVectorShape(baseNDArray.shapeInfoDataBuffer())) {
            ews = -1;
        }
        baseNDArray.setShapeInformation(Nd4j.getShapeInfoProvider().createShapeInformation(shape, stride, 0L, (long)ews, newOrder));
        return toTad;
    }

    @Override
    public INDArray javaTensorAlongDimension(int index, int ... dimension) {
        return this.doTad(index, dimension);
    }

    private void setShapeInformation(Pair<DataBuffer, long[]> shapeInfo) {
        this.shapeInformation = (DataBuffer)shapeInfo.getFirst();
        this.jvmShapeInfo = new JvmShapeInfo((long[])shapeInfo.getSecond());
    }

    private INDArray doTad(int index, int ... dimension) {
        long tads;
        if (dimension == null || dimension.length == 0) {
            throw new IllegalArgumentException("Invalid input: dimensions not specified (null or length 0)");
        }
        if (dimension.length >= this.rank()) {
            return this;
        }
        for (int i = 0; i < dimension.length; ++i) {
            if (dimension[i] >= 0) continue;
            int n = i;
            dimension[n] = dimension[n] + this.rank();
        }
        if (dimension.length > 1) {
            Arrays.sort(dimension);
        }
        if ((long)index >= (tads = this.tensorssAlongDimension(dimension))) {
            throw new IllegalArgumentException("Illegal index " + index + " out of tads " + tads);
        }
        if (dimension.length == 1) {
            if (dimension[0] == 0 && this.isColumnVector()) {
                return this.transpose();
            }
            if (dimension[0] == 1 && this.isRowVector()) {
                return this;
            }
        }
        long[] tensorShape = ArrayUtil.keep((long[])this.shape(), (int[])dimension);
        int[] reverseDimensions = ArrayUtil.reverseCopy((int[])dimension);
        int[] remove = ArrayUtil.removeIndex((int[])ArrayUtil.range((int)0, (int)this.rank()), (int[])dimension);
        int[] newPermuteDims = Ints.concat((int[][])new int[][]{remove, reverseDimensions});
        int[] finalPermuteDims = tadFinalPermuteDimensions[dimension.length];
        INDArray permuted = this.permute(newPermuteDims);
        long sliceIdx = NDArrayMath.sliceOffsetForTensor(index, permuted, tensorShape);
        INDArray ret2 = permuted.slice(sliceIdx);
        if (dimension.length == tensorShape.length && ArrayUtil.prodLong((long[])tensorShape) == ret2.length()) {
            if (dimension.length == 1 && ret2.isRowVector()) {
                return ret2;
            }
            if (finalPermuteDims.length != ret2.rank()) {
                finalPermuteDims = new int[ret2.rank()];
                int count = 0;
                int i = finalPermuteDims.length - 1;
                while (i >= 0) {
                    finalPermuteDims[count++] = i--;
                }
            }
            return ret2.permutei(finalPermuteDims);
        }
        int length = ArrayUtil.prod((long[])tensorShape);
        int tensorLength = ArrayUtil.prod((long[])tensorShape);
        long offset = (long)(index * tensorLength) / NDArrayMath.lengthPerSlice(ret2);
        if (sliceIdx == 0L && (long)length == NDArrayMath.lengthPerSlice(ret2)) {
            ret2 = ret2.slice((int)offset);
            if (dimension.length == 1 && ret2.isRowVector()) {
                return ret2;
            }
            return ret2.permutei(finalPermuteDims);
        }
        if ((long)length == NDArrayMath.lengthPerSlice(ret2)) {
            offset -= ret2.slices() * (offset / ret2.slices());
            ret2 = ret2.slice((int)offset);
            if (dimension.length == 1 && ret2.isRowVector()) {
                return ret2;
            }
            return ret2.permutei(finalPermuteDims);
        }
        while (ret2.length() > (long)length) {
            sliceIdx = NDArrayMath.sliceOffsetForTensor(index, ret2, tensorShape);
            sliceIdx -= ret2.slices() * (sliceIdx / ret2.slices());
            ret2 = ret2.slice(sliceIdx);
        }
        if (dimension.length == 1 && ret2.isRowVector()) {
            return ret2;
        }
        return ret2.permutei(finalPermuteDims);
    }

    @Override
    public long vectorsAlongDimension(int dimension) {
        if (dimension == 0 && this.isVector() || this.isRowVector()) {
            return 1L;
        }
        if (this.size(dimension) == 1L && !this.isVector()) {
            for (int i = dimension; i < this.rank(); ++i) {
                if (this.size(i) == 1L) continue;
                return this.vectorsAlongDimension(i);
            }
            return this.length();
        }
        if (this.size(0) == 1L && !this.isVector()) {
            int realDimension = this.rank() - this.getLeadingOnes();
            long length = this.length();
            if (length / this.size(realDimension) >= Integer.MAX_VALUE) {
                throw new IllegalArgumentException("Vectors along dimension can not be >= Integer.MAX_VALUE");
            }
            return length / this.size(realDimension);
        }
        long length = this.length();
        if (dimension >= this.jvmShapeInfo.rank) {
            if (length / this.size(this.jvmShapeInfo.rank - 1) >= Integer.MAX_VALUE) {
                throw new IllegalArgumentException("Vectors along dimension can not be >= Integer.MAX_VALUE");
            }
            return (int)(length / this.size(this.jvmShapeInfo.rank - 1));
        }
        if (length / this.size(dimension) >= Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Vectors along dimension can not be >= Integer.MAX_VALUE");
        }
        return length / this.size(dimension);
    }

    @Override
    public INDArray vectorAlongDimension(int index, int dimension) {
        if (dimension < 0) {
            dimension = this.jvmShapeInfo.getRank() + dimension;
        }
        if (dimension == this.jvmShapeInfo.getRank() - 1 && this.size(dimension) == 1L && this.rank() > 2 || this.rank() > 2 && dimension == 0 && this.size(dimension) == 1L) {
            return this;
        }
        INDArray ret = this.tensorAlongDimension(index, dimension);
        if (this.isMatrix() && ret.isVector() && dimension == 1 && !ret.isRowVector()) {
            return ret.reshape(ArrayUtil.reverseCopy((long[])ret.shape()));
        }
        if (this.isMatrix() && ret.isVector() && dimension == 0 && !ret.isColumnVector()) {
            return ret.reshape(ArrayUtil.reverseCopy((long[])ret.shape()));
        }
        return ret;
    }

    @Override
    public void setOrder(char order) {
        this.setShapeInformation(Nd4j.getShapeInfoProvider().createShapeInformation(this.shape(), this.stride(), 0L, (long)this.elementWiseStride(), order));
    }

    @Override
    public void setShape(long[] shape) {
        this.setShapeInformation(Nd4j.getShapeInfoProvider().createShapeInformation(shape, this.stride(), 0L, (long)this.elementWiseStride(), this.ordering()));
    }

    @Override
    public void setStride(long[] stride) {
        this.setShapeInformation(Nd4j.getShapeInfoProvider().createShapeInformation(this.shape(), stride, 0L, (long)this.elementWiseStride(), this.ordering()));
    }

    @Override
    public void setShapeAndStride(int[] shape, int[] stride) {
        this.setShapeInformation(Nd4j.getShapeInfoProvider().createShapeInformation(shape, stride, 0L, -1, this.ordering()));
    }

    @Override
    public INDArray cumsumi(int dimension) {
        if (this.isVector()) {
            double s = 0.0;
            int i = 0;
            while ((long)i < this.length()) {
                this.putScalar((long)i, s += this.getDouble((long)i));
                ++i;
            }
        } else {
            if (dimension == Integer.MAX_VALUE) {
                INDArray flattened = this.ravel();
                double prevVal = flattened.getDouble(0L);
                int i = 1;
                while ((long)i < flattened.length()) {
                    double d = prevVal + flattened.getDouble((long)i);
                    flattened.putScalar((long)i, d);
                    prevVal = d;
                    ++i;
                }
                return flattened;
            }
            int i = 0;
            while ((long)i < this.vectorsAlongDimension(dimension)) {
                INDArray vec = this.vectorAlongDimension(i, dimension);
                vec.cumsumi(0);
                ++i;
            }
        }
        return this;
    }

    @Override
    public Number normmaxNumber() {
        return this.normmax(Integer.MAX_VALUE).getDouble(0L);
    }

    @Override
    public Number norm2Number() {
        return this.norm2(Integer.MAX_VALUE).getDouble(0L);
    }

    @Override
    public Number norm1Number() {
        return this.norm1(Integer.MAX_VALUE).getDouble(0L);
    }

    @Override
    public Number stdNumber() {
        return this.std(Integer.MAX_VALUE).getDouble(0L);
    }

    @Override
    public Number prodNumber() {
        return this.prod(Integer.MAX_VALUE).getDouble(0L);
    }

    @Override
    public Number meanNumber() {
        return this.mean(Integer.MAX_VALUE).getDouble(0L);
    }

    @Override
    public Number ameanNumber() {
        return this.amean(Integer.MAX_VALUE).getDouble(0L);
    }

    @Override
    public Number varNumber() {
        return this.var(Integer.MAX_VALUE).getDouble(0L);
    }

    @Override
    public Number maxNumber() {
        return this.max(Integer.MAX_VALUE).getDouble(0L);
    }

    @Override
    public Number amaxNumber() {
        return this.amax(Integer.MAX_VALUE).getDouble(0L);
    }

    @Override
    public Number minNumber() {
        return this.min(Integer.MAX_VALUE).getDouble(0L);
    }

    @Override
    public Number aminNumber() {
        return this.amin(Integer.MAX_VALUE).getDouble(0L);
    }

    @Override
    public Number scan(Condition condition) {
        MatchCondition op = new MatchCondition((INDArray)this, condition);
        return Nd4j.getExecutioner().exec(op, Integer.MAX_VALUE).getDouble(0L);
    }

    @Override
    public Number sumNumber() {
        return this.sum(Integer.MAX_VALUE).getDouble(0L);
    }

    @Override
    public Number entropyNumber() {
        return this.entropy(Integer.MAX_VALUE).getDouble(0L);
    }

    @Override
    public Number shannonEntropyNumber() {
        return this.shannonEntropy(Integer.MAX_VALUE).getDouble(0L);
    }

    @Override
    public Number logEntropyNumber() {
        return this.logEntropy(Integer.MAX_VALUE).getDouble(0L);
    }

    @Override
    public INDArray cumsum(int dimension) {
        return this.dup().cumsumi(dimension);
    }

    @Override
    public INDArray assign(INDArray arr) {
        Nd4j.getExecutioner().exec(new Set(this, arr, this, this.length()));
        return this;
    }

    @Override
    public INDArray putScalar(long i, double value) {
        if (i < 0L) {
            i += (long)this.rank();
        }
        if (this.isScalar() || this.rank() == 1) {
            this.autoProcessScalarCall();
            this.data.put(i, value);
            return this;
        }
        if (this.isRowVector() && this.rank() == 2) {
            return this.putScalar(0L, i, value);
        }
        if (this.isColumnVector() && this.rank() == 2) {
            return this.putScalar(i, 0L, value);
        }
        long[] indexes = this.ordering() == 'c' ? Shape.ind2subC(this, i) : Shape.ind2sub(this, i);
        return this.putScalar(indexes, value);
    }

    @Override
    public INDArray putScalar(long i, float value) {
        return this.putScalar(i, (double)value);
    }

    @Override
    public INDArray putScalar(long i, int value) {
        return this.putScalar(i, (double)value);
    }

    @Override
    public INDArray putScalar(int[] indexes, double value) {
        Nd4j.getCompressor().autoDecompress((INDArray)this);
        for (int i = 0; i < indexes.length; ++i) {
            if (indexes[i] >= 0) continue;
            int n = i;
            indexes[n] = (int)((long)indexes[n] + this.size(i));
        }
        if (indexes.length == 1) {
            return this.putScalar((long)indexes[0], value);
        }
        if (indexes.length == 2) {
            return this.putScalar(indexes[0], indexes[1], value);
        }
        if (indexes.length == 3) {
            return this.putScalar(indexes[0], indexes[1], indexes[2], value);
        }
        if (indexes.length == 4) {
            return this.putScalar(indexes[0], indexes[1], indexes[2], indexes[3], value);
        }
        this.autoProcessScalarCall();
        long offset = Shape.getOffset(this.jvmShapeInfo.javaShapeInformation, indexes);
        this.data.put(offset, value);
        return this;
    }

    @Override
    public INDArray putScalar(long[] indexes, double value) {
        Nd4j.getCompressor().autoDecompress((INDArray)this);
        for (int i = 0; i < indexes.length; ++i) {
            if (indexes[i] >= 0L) continue;
            int n = i;
            indexes[n] = indexes[n] + this.size(i);
        }
        if (indexes.length == 1) {
            return this.putScalar(indexes[0], value);
        }
        if (indexes.length == 2) {
            return this.putScalar(indexes[0], indexes[1], value);
        }
        if (indexes.length == 3) {
            return this.putScalar(indexes[0], indexes[1], indexes[2], value);
        }
        if (indexes.length == 4) {
            return this.putScalar(indexes[0], indexes[1], indexes[2], indexes[3], value);
        }
        this.autoProcessScalarCall();
        long offset = Shape.getOffset(this.jvmShapeInfo.javaShapeInformation, indexes);
        this.data.put(offset, value);
        return this;
    }

    @Override
    public INDArray putScalar(long[] indexes, float value) {
        return this.putScalar(indexes, (double)value);
    }

    @Override
    public INDArray putScalar(long row, long col, double value) {
        Nd4j.getCompressor().autoDecompress((INDArray)this);
        this.autoProcessScalarCall();
        if (this.rank() > 2) {
            throw new IllegalStateException("Cannot use putScalar(int,int,double) on a rank " + this.rank() + " INDArray");
        }
        long offset = Shape.getOffsetUnsafe(this.jvmShapeInfo.javaShapeInformation, row, col);
        this.data.put(offset, value);
        return this;
    }

    @Override
    public INDArray putScalar(long dim0, long dim1, long dim2, double value) {
        Nd4j.getCompressor().autoDecompress((INDArray)this);
        this.autoProcessScalarCall();
        if (this.rank() != 3) {
            throw new IllegalStateException("Cannot use putScalar(int,int,int,double) on a rank " + this.rank() + " INDArray");
        }
        long offset = 0L;
        long size_0 = this.jvmShapeInfo.javaShapeInformation[1];
        long size_1 = this.jvmShapeInfo.javaShapeInformation[2];
        long size_2 = this.jvmShapeInfo.javaShapeInformation[3];
        if (size_0 != 1L) {
            offset += dim0 * this.jvmShapeInfo.javaShapeInformation[4];
        }
        if (size_1 != 1L) {
            offset += dim1 * this.jvmShapeInfo.javaShapeInformation[5];
        }
        if (size_2 != 1L) {
            offset += dim2 * this.jvmShapeInfo.javaShapeInformation[6];
        }
        this.data.put(offset, value);
        return this;
    }

    @Override
    public INDArray putScalar(long dim0, long dim1, long dim2, long dim3, double value) {
        Nd4j.getCompressor().autoDecompress((INDArray)this);
        this.autoProcessScalarCall();
        if (this.rank() != 4) {
            throw new IllegalStateException("Cannot use putScalar(int,int,int,int,double) on a rank " + this.rank() + " INDArray");
        }
        long offset = Shape.getOffsetUnsafe(this.jvmShapeInfo.javaShapeInformation, dim0, dim1, dim2, dim3);
        this.data.put(offset, value);
        return this;
    }

    @Override
    public INDArray putScalar(int[] indexes, float value) {
        return this.putScalar(indexes, (double)value);
    }

    @Override
    public INDArray putScalar(int[] indexes, int value) {
        return this.putScalar(indexes, (double)value);
    }

    @Override
    public INDArray putScalar(long[] indexes, int value) {
        return this.putScalar(indexes, (double)value);
    }

    @Override
    public INDArray eps(Number other) {
        return this.dup().epsi(other);
    }

    @Override
    public INDArray epsi(Number other) {
        INDArray otherArr = Nd4j.valueArrayOf(this.shape(), other.doubleValue());
        return this.epsi(otherArr);
    }

    @Override
    public INDArray eps(INDArray other) {
        return this.dup().epsi(other);
    }

    @Override
    public INDArray epsi(INDArray other) {
        Nd4j.getExecutioner().exec(new Eps(this, other, this, this.length()));
        return this;
    }

    @Override
    public INDArray lt(Number other) {
        return this.dup().lti(other);
    }

    @Override
    public INDArray lte(Number other) {
        return this.dup().ltei(other);
    }

    @Override
    public INDArray lti(Number other) {
        Nd4j.getExecutioner().exec(new ScalarLessThan((INDArray)this, other));
        return this;
    }

    @Override
    public INDArray ltei(Number other) {
        Nd4j.getExecutioner().exec(new ScalarLessThanOrEqual((INDArray)this, other));
        return this;
    }

    @Override
    public INDArray eq(Number other) {
        return this.dup().eqi(other);
    }

    @Override
    public INDArray eqi(Number other) {
        Nd4j.getExecutioner().exec(new ScalarEquals((INDArray)this, other));
        return this;
    }

    @Override
    public INDArray gt(Number other) {
        return this.dup().gti(other);
    }

    @Override
    public INDArray gte(Number other) {
        return this.dup().gtei(other);
    }

    @Override
    public INDArray gtei(Number other) {
        Nd4j.getExecutioner().exec(new ScalarGreaterThanOrEqual((INDArray)this, other));
        return this;
    }

    @Override
    public INDArray gti(Number other) {
        Nd4j.getExecutioner().exec(new ScalarGreaterThan((INDArray)this, other));
        return this;
    }

    @Override
    public INDArray lt(INDArray other) {
        return this.dup().lti(other);
    }

    @Override
    public INDArray lti(INDArray other) {
        Nd4j.getExecutioner().exec(new OldLessThan(this, other, this, this.length()));
        return this;
    }

    @Override
    public INDArray neq(Number other) {
        return this.dup().neqi(other);
    }

    @Override
    public INDArray neqi(Number other) {
        Nd4j.getExecutioner().exec(new ScalarNotEquals((INDArray)this, other));
        return this;
    }

    @Override
    public INDArray neq(INDArray other) {
        return this.dup().neqi(other);
    }

    @Override
    public INDArray neqi(INDArray other) {
        Nd4j.getExecutioner().exec(new OldNotEqualTo(this, other, this, this.length()));
        return this;
    }

    @Override
    public INDArray eq(INDArray other) {
        return this.dup().eqi(other);
    }

    @Override
    public INDArray eqi(INDArray other) {
        Nd4j.getExecutioner().exec(new OldEqualTo(this, other, this, this.length()));
        return this;
    }

    @Override
    public INDArray gt(INDArray other) {
        return this.dup().gti(other);
    }

    @Override
    public INDArray gti(INDArray other) {
        Nd4j.getExecutioner().exec(new OldGreaterThan(this, other, this, this.length()));
        return this;
    }

    @Override
    public INDArray neg() {
        return Nd4j.getExecutioner().exec(new Negative(this, Nd4j.createUninitialized(this.shape(), this.ordering()))).z();
    }

    @Override
    public INDArray negi() {
        Nd4j.getExecutioner().exec(new Negative(this));
        return this;
    }

    @Override
    public INDArray rdiv(Number n, INDArray result) {
        return this.rdivi(n, result);
    }

    @Override
    public INDArray rdivi(Number n, INDArray result) {
        if (Double.isNaN(n.doubleValue())) {
            n = Nd4j.EPS_THRESHOLD;
        }
        Nd4j.getExecutioner().exec(new ScalarReverseDivision(this, null, result, result.length(), n));
        if (Nd4j.ENFORCE_NUMERICAL_STABILITY) {
            Nd4j.clearNans(result);
        }
        return result;
    }

    @Override
    public INDArray rsub(Number n, INDArray result) {
        return this.rsubi(n, result);
    }

    @Override
    public INDArray rsubi(Number n, INDArray result) {
        if (Double.isNaN(n.doubleValue())) {
            n = Nd4j.EPS_THRESHOLD;
        }
        Nd4j.getExecutioner().exec(new ScalarReverseSubtraction(this, null, result, result.lengthLong(), n));
        if (Nd4j.ENFORCE_NUMERICAL_STABILITY) {
            Nd4j.clearNans(result);
        }
        return result;
    }

    @Override
    public INDArray div(Number n, INDArray result) {
        return this.divi(n, result);
    }

    @Override
    public INDArray divi(Number n, INDArray result) {
        if (Double.isNaN(n.doubleValue())) {
            n = Nd4j.EPS_THRESHOLD;
        }
        Nd4j.getExecutioner().exec(new ScalarDivision(this, null, result, result.lengthLong(), n));
        if (Nd4j.ENFORCE_NUMERICAL_STABILITY) {
            Nd4j.clearNans(result);
        }
        return result;
    }

    @Override
    public INDArray mul(Number n, INDArray result) {
        return this.muli(n, result);
    }

    @Override
    public INDArray muli(Number n, INDArray result) {
        if (Double.isNaN(n.doubleValue())) {
            n = Nd4j.EPS_THRESHOLD;
        }
        Nd4j.getExecutioner().exec(new ScalarMultiplication(this, null, result, result.lengthLong(), n));
        if (Nd4j.ENFORCE_NUMERICAL_STABILITY) {
            Nd4j.clearNans(result);
        }
        return result;
    }

    @Override
    public INDArray sub(Number n, INDArray result) {
        return this.subi(n, result);
    }

    @Override
    public INDArray subi(Number n, INDArray result) {
        if (Double.isNaN(n.doubleValue())) {
            n = Nd4j.EPS_THRESHOLD;
        }
        Nd4j.getExecutioner().exec(new ScalarSubtraction(this, null, result, result.lengthLong(), n));
        if (Nd4j.ENFORCE_NUMERICAL_STABILITY) {
            Nd4j.clearNans(result);
        }
        return result;
    }

    @Override
    public INDArray add(Number n, INDArray result) {
        return this.addi(n, result);
    }

    @Override
    public INDArray addi(Number n, INDArray result) {
        if (Double.isNaN(n.doubleValue())) {
            n = Nd4j.EPS_THRESHOLD;
        }
        Nd4j.getExecutioner().exec(new ScalarAdd(this, null, result, result.lengthLong(), n));
        if (Nd4j.ENFORCE_NUMERICAL_STABILITY) {
            Nd4j.clearNans(result);
        }
        return result;
    }

    @Override
    public INDArray getScalar(long row, long column) {
        return this.getScalar(new long[]{row, column});
    }

    @Override
    public INDArray dup() {
        WorkspaceUtils.assertValidArray(this, "Cannot duplicate INDArray");
        if (this.isCompressed() && this.ordering() == Nd4j.order().charValue()) {
            INDArray ret = Nd4j.createArrayFromShapeBuffer(this.data().dup(), this.shapeInfoDataBuffer());
            ret.markAsCompressed(true);
            return ret;
        }
        Nd4j.getCompressor().autoDecompress((INDArray)this);
        INDArray ret = Shape.toOffsetZeroCopy(this);
        return ret;
    }

    @Override
    public INDArray dup(char order) {
        WorkspaceUtils.assertValidArray(this, "Cannot duplicate INDArray");
        if (this.isCompressed() && this.ordering() == order) {
            INDArray ret = Nd4j.createArrayFromShapeBuffer(this.data().dup(), this.shapeInfoDataBuffer());
            ret.markAsCompressed(true);
            return ret;
        }
        Nd4j.getCompressor().autoDecompress((INDArray)this);
        return Shape.toOffsetZeroCopy(this, order);
    }

    @Override
    public int getInt(int ... indices) {
        return (int)this.getDouble(indices);
    }

    @Override
    public double getDouble(int ... indices) {
        this.autoProcessScalarCall();
        Nd4j.getCompressor().autoDecompress((INDArray)this);
        for (int i = 0; i < indices.length; ++i) {
            if (indices[i] >= 0) continue;
            int n = i;
            indices[n] = indices[n] + this.rank();
        }
        if (indices.length == 1) {
            if (this.rank() == 1) {
                return Shape.getDouble((INDArray)this, indices[0]);
            }
            if (this.isRowVector()) {
                return Shape.getDouble((INDArray)this, 0L, indices[0]);
            }
            if (this.isColumnVector()) {
                return Shape.getDouble((INDArray)this, indices[0], 0L);
            }
            if (this.isScalar() && indices[0] == 0) {
                return this.data().getDouble(0L);
            }
            throw new IllegalStateException("Indexes length must be > 1 for non vectors and scalars");
        }
        return Shape.getDouble((INDArray)this, indices);
    }

    @Override
    public double getDouble(long ... indices) {
        this.autoProcessScalarCall();
        Nd4j.getCompressor().autoDecompress((INDArray)this);
        for (int i = 0; i < indices.length; ++i) {
            if (indices[i] >= 0L) continue;
            int n = i;
            indices[n] = indices[n] + (long)this.rank();
        }
        if (indices.length == 1) {
            if (this.rank() == 1) {
                return Shape.getDouble((INDArray)this, indices[0]);
            }
            if (this.isRowVector()) {
                return Shape.getDouble((INDArray)this, 0L, indices[0]);
            }
            if (this.isColumnVector()) {
                return Shape.getDouble((INDArray)this, indices[0], 0L);
            }
            if (this.isScalar() && indices[0] == 0L) {
                return this.data().getDouble(0L);
            }
            throw new IllegalStateException("Indexes length must be > 1 for non vectors and scalars");
        }
        return Shape.getDouble((INDArray)this, indices);
    }

    @Override
    public float getFloat(int ... indices) {
        return (float)this.getDouble(indices);
    }

    @Override
    public float getFloat(long ... indices) {
        return (float)this.getDouble(indices);
    }

    @Override
    public boolean isScalar() {
        if (this.isEmpty()) {
            return false;
        }
        if (this.jvmShapeInfo.rank == 0) {
            return true;
        }
        if (this.jvmShapeInfo.rank > 2) {
            return false;
        }
        if (this.jvmShapeInfo.rank == 1) {
            return this.shape()[0] == 1L;
        }
        if (this.jvmShapeInfo.rank == 2) {
            return this.shape()[0] == 1L && this.shape()[1] == 1L || this.length() == 1L;
        }
        return false;
    }

    @Override
    public INDArray put(int[] indices, INDArray element) {
        Nd4j.getCompressor().autoDecompress((INDArray)this);
        if (!element.isScalar()) {
            throw new IllegalArgumentException("Unable to insert anything but a scalar");
        }
        if (this.isRowVector() && indices[0] == 0 && indices.length == 2) {
            int ix = 0;
            for (int i = 1; i < indices.length; ++i) {
                ix += indices[i] * this.stride(i);
            }
            if ((long)ix >= this.data.length()) {
                throw new IllegalArgumentException("Illegal indices " + Arrays.toString(indices));
            }
            this.data.put((long)ix, element.getDouble(0L));
        } else {
            int ix = 0;
            for (int i = 0; i < indices.length; ++i) {
                if (this.size(i) == 1L) continue;
                ix += indices[i] * this.stride(i);
            }
            if ((long)ix >= this.data.length()) {
                throw new IllegalArgumentException("Illegal indices " + Arrays.toString(indices));
            }
            this.data.put((long)ix, element.getDouble(0L));
        }
        return this;
    }

    @Override
    public INDArray match(INDArray comp, Condition condition) {
        return Nd4j.getExecutioner().exec(new MatchConditionTransform((INDArray)this, comp, condition)).z();
    }

    @Override
    public INDArray match(Number comp, Condition condition) {
        return Nd4j.getExecutioner().exec(new MatchConditionTransform((INDArray)this, comp.doubleValue(), condition)).z();
    }

    @Override
    public INDArray getWhere(INDArray comp, Condition condition) {
        return BooleanIndexing.chooseFrom(new INDArray[]{this, comp}, condition);
    }

    @Override
    public INDArray getWhere(Number comp, Condition condition) {
        return BooleanIndexing.chooseFrom(new INDArray[]{this}, Arrays.asList(comp.doubleValue()), Collections.emptyList(), condition);
    }

    @Override
    public INDArray putWhere(INDArray comp, INDArray put, Condition condition) {
        Nd4j.getCompressor().autoDecompress((INDArray)this);
        MatchConditionTransform matchCondition = new MatchConditionTransform((INDArray)this, comp, condition);
        Nd4j.getExecutioner().exec(matchCondition);
        return this.putWhereWithMask(matchCondition.z(), put);
    }

    @Override
    public INDArray putWhere(Number comp, INDArray put, Condition condition) {
        return this.putWhere(Nd4j.scalar(comp), put, condition);
    }

    @Override
    public INDArray putWhere(Number comp, Number put, Condition condition) {
        return this.putWhere(Nd4j.scalar(comp), Nd4j.scalar(put), condition);
    }

    @Override
    public INDArray putWhereWithMask(INDArray mask, INDArray put) {
        INDArray output = this.dup();
        Nd4j.getExecutioner().exec(new Where(new INDArray[]{mask, this, put}, new INDArray[]{output}));
        return output;
    }

    @Override
    public INDArray putWhereWithMask(INDArray mask, Number put) {
        return this.putWhereWithMask(mask, Nd4j.scalar(put));
    }

    @Override
    public INDArray put(int i, int j, INDArray element) {
        return this.put(new int[]{i, j}, element);
    }

    @Override
    public INDArray put(int i, int j, Number element) {
        return this.putScalar(new int[]{i, j}, element.doubleValue());
    }

    @Override
    public INDArray putSlice(int slice, INDArray put) {
        Nd4j.getCompressor().autoDecompress((INDArray)this);
        if (this.isScalar()) {
            assert (put.isScalar()) : "Invalid dimension. Can only insert a scalar in to another scalar";
            this.put(0, put.getScalar(0L));
            return this;
        }
        if (this.isVector()) {
            assert (put.isScalar() || put.isVector() && put.length() == this.length()) : "Invalid dimension on insertion. Can only insert scalars input vectors";
            if (put.isScalar()) {
                this.putScalar((long)slice, put.getDouble(0L));
            } else {
                int i = 0;
                while ((long)i < this.length()) {
                    this.putScalar((long)i, put.getDouble((long)i));
                    ++i;
                }
            }
            return this;
        }
        this.assertSlice(put, slice);
        INDArray view = this.slice(slice);
        if (put.length() == 1L) {
            this.putScalar((long)slice, put.getDouble(0L));
        } else if (put.isVector()) {
            int i = 0;
            while ((long)i < put.length()) {
                view.putScalar((long)i, put.getDouble((long)i));
                ++i;
            }
        } else {
            assert (Shape.shapeEquals(view.shape(), put.shape()));
            INDArray linear = view;
            INDArray putLinearView = put;
            int i = 0;
            while ((long)i < linear.length()) {
                linear.putScalar((long)i, putLinearView.getDouble((long)i));
                ++i;
            }
        }
        return this;
    }

    protected void assertSlice(INDArray put, long slice) {
        assert (slice <= this.slices()) : "Invalid slice specified " + slice;
        long[] sliceShape = put.shape();
        if (Shape.isRowVectorShape(sliceShape)) {
            return;
        }
        long[] requiredShape = ArrayUtil.removeIndex((long[])this.shape(), (int)0);
        if (put.isScalar()) {
            return;
        }
        if (this.isVector() && put.isVector() && put.length() < this.length()) {
            return;
        }
        if (Shape.isColumnVectorShape(sliceShape)) {
            return;
        }
        if (!(Shape.shapeEquals(sliceShape, requiredShape) || Shape.isRowVectorShape(requiredShape) || Shape.isRowVectorShape(sliceShape))) {
            throw new IllegalStateException(String.format("Invalid shape size of %s . Should have been %s ", Arrays.toString(sliceShape), Arrays.toString(requiredShape)));
        }
    }

    @Override
    public boolean isMatrix() {
        int rank = this.rank();
        return rank == 2 && this.size(0) != 1L && this.size(1) != 1L;
    }

    @Override
    @Deprecated
    public long index(long row, long column) {
        if (!this.isMatrix()) {
            if (this.isColumnVector()) {
                long idx = this.linearIndex(row);
                return idx;
            }
            if (this.isRowVector()) {
                long idx = this.linearIndex(column);
                return idx;
            }
            throw new IllegalStateException("Unable to get row/column from a non matrix");
        }
        return row * (long)this.stride(0) + column * (long)this.stride(1);
    }

    protected INDArray newShape(long[] newShape, char ordering) {
        return Nd4j.create(this.data(), newShape, this.stride(), 0L, ordering);
    }

    protected INDArray create(DataBuffer data, int[] newShape, int[] newStrides, long offset, char ordering) {
        return Nd4j.create(data, newShape, newStrides, offset, ordering);
    }

    protected INDArray create(DataBuffer data, int[] newShape, int[] newStrides, long offset) {
        return Nd4j.create(data, newShape, newStrides, offset);
    }

    protected INDArray create(int[] shape) {
        return Nd4j.create(shape, this.getStrides(shape, Nd4j.order().charValue()), 0L);
    }

    protected INDArray create(int[] shape, int[] strides, long offset) {
        return Nd4j.create(shape, strides, offset);
    }

    protected int[] getStrides(int[] shape, char ordering) {
        return Nd4j.getStrides(shape, ordering);
    }

    @Override
    public double squaredDistance(INDArray other) {
        double d2 = this.distance2(other);
        return d2 * d2;
    }

    @Override
    public double distance2(INDArray other) {
        Nd4j.getCompressor().autoDecompress((INDArray)this);
        return Nd4j.getExecutioner().execAndReturn(new EuclideanDistance(this, other)).getFinalResult().doubleValue();
    }

    @Override
    public double distance1(INDArray other) {
        Nd4j.getCompressor().autoDecompress((INDArray)this);
        return Nd4j.getExecutioner().execAndReturn(new ManhattanDistance(this, other)).getFinalResult().doubleValue();
    }

    @Override
    public INDArray get(INDArray indices) {
        ArrayList<INDArray> arrList;
        block9: {
            block8: {
                if (indices.rank() > 2) {
                    throw new ND4JIllegalArgumentException("Indices must be a vector or matrix.");
                }
                if (indices.rows() == this.rank()) {
                    INDArray ret = Nd4j.create(indices.columns());
                    for (int i = 0; i < indices.columns(); ++i) {
                        int[] specifiedIndex = indices.getColumn(i).dup().data().asInt();
                        double v = this.getDouble(specifiedIndex);
                        ret.putScalar((long)i, v);
                    }
                    return ret;
                }
                arrList = new ArrayList<INDArray>();
                if (!indices.isMatrix() && !indices.isColumnVector() && (!indices.isScalar() || indices.rank() != 2)) break block8;
                for (int i = 0; i < indices.rows(); ++i) {
                    int j;
                    INDArray row;
                    if (i == 0) {
                        row = indices.getRow(i);
                        j = 0;
                        while ((long)j < row.length()) {
                            arrList.add(this.slice(row.getInt(j++)));
                        }
                        continue;
                    }
                    row = indices.slice(i);
                    j = 0;
                    while ((long)j < row.length()) {
                        INDArray put = ((INDArray)arrList.get(j)).slice(row.getInt(j));
                        put = put.reshape(Longs.concat((long[][])new long[][]{{1L}, put.shape()}));
                        arrList.set(j, put);
                        ++j;
                    }
                }
                break block9;
            }
            if (!indices.isRowVector()) break block9;
            int i = 0;
            while ((long)i < indices.length()) {
                INDArray add = this.slice(indices.getInt(i++));
                add = add.reshape(Longs.concat((long[][])new long[][]{{1L}, add.shape()}));
                arrList.add(add);
            }
        }
        return Nd4j.concat(0, arrList.toArray(new INDArray[arrList.size()]));
    }

    @Override
    public INDArray get(List<List<Integer>> indices) {
        INDArrayIndex[] indArrayIndices = new INDArrayIndex[indices.size()];
        for (int i = 0; i < indArrayIndices.length; ++i) {
            indArrayIndices[i] = new SpecifiedIndex(Ints.toArray((Collection)indices.get(i)));
        }
        boolean hasNext = true;
        Generator<List<List<Long>>> iterate = SpecifiedIndex.iterate(indArrayIndices);
        ArrayList<INDArray> resultList = new ArrayList<INDArray>();
        while (hasNext) {
            try {
                List next = (List)iterate.next();
                int[][] nextArr = new int[next.size()][];
                for (int i = 0; i < next.size(); ++i) {
                    nextArr[i] = Ints.toArray((Collection)((Collection)next.get(i)));
                }
                int[] curr = Ints.concat((int[][])nextArr);
                INDArray currSlice = this;
                for (int j = 0; j < curr.length; ++j) {
                    currSlice = currSlice.slice(curr[j]);
                }
                currSlice = currSlice.reshape(Longs.concat((long[][])new long[][]{{1L}, currSlice.shape()}));
                resultList.add(currSlice);
            }
            catch (NoSuchElementException e) {
                hasNext = false;
            }
        }
        return Nd4j.concat(0, resultList.toArray(new INDArray[resultList.size()]));
    }

    @Override
    public INDArray put(List<List<Integer>> indices, INDArray element) {
        block11: {
            Generator<List<List<Long>>> iterate;
            boolean hasNext;
            block10: {
                INDArrayIndex[] indArrayIndices = new INDArrayIndex[indices.size()];
                for (int i = 0; i < indArrayIndices.length; ++i) {
                    indArrayIndices[i] = new SpecifiedIndex(Ints.toArray((Collection)indices.get(i)));
                }
                hasNext = true;
                iterate = SpecifiedIndex.iterate(indArrayIndices);
                if (indices.size() != this.rank()) break block10;
                NdIndexIterator ndIndexIterator = new NdIndexIterator(element.shape());
                while (hasNext) {
                    try {
                        List next = (List)iterate.next();
                        int[][] nextArr = new int[next.size()][];
                        for (int i = 0; i < next.size(); ++i) {
                            nextArr[i] = Ints.toArray((Collection)((Collection)next.get(i)));
                        }
                        int[] curr = Ints.concat((int[][])nextArr);
                        this.putScalar(curr, element.getDouble(ndIndexIterator.next()));
                    }
                    catch (NoSuchElementException e) {
                        hasNext = false;
                    }
                }
                break block11;
            }
            if (indices.size() < 2) break block11;
            while (hasNext) {
                try {
                    List next = (List)iterate.next();
                    int[][] nextArr = new int[next.size()][];
                    for (int i = 0; i < next.size(); ++i) {
                        nextArr[i] = Ints.toArray((Collection)((Collection)next.get(i)));
                    }
                    int[] curr = Ints.concat((int[][])nextArr);
                    INDArray currSlice = this;
                    for (int j = 0; j < curr.length; ++j) {
                        currSlice = currSlice.slice(curr[j]);
                    }
                    Nd4j.getExecutioner().exec(new Assign(new INDArray[]{currSlice, element}, new INDArray[]{currSlice}));
                }
                catch (NoSuchElementException e) {
                    hasNext = false;
                }
            }
        }
        return this;
    }

    @Override
    public INDArray put(INDArray indices, INDArray element) {
        block6: {
            ArrayList<INDArray> arrList;
            block7: {
                block5: {
                    if (indices.rank() > 2) {
                        throw new ND4JIllegalArgumentException("Indices must be a vector or matrix.");
                    }
                    if (indices.rows() != this.rank()) break block5;
                    NdIndexIterator ndIndexIterator = new NdIndexIterator(element.shape());
                    for (int i = 0; i < indices.columns(); ++i) {
                        int[] specifiedIndex = indices.getColumn(i).dup().data().asInt();
                        this.putScalar(specifiedIndex, element.getDouble(ndIndexIterator.next()));
                    }
                    break block6;
                }
                arrList = new ArrayList<INDArray>();
                if (!indices.isMatrix() && !indices.isColumnVector()) break block7;
                for (int i = 0; i < indices.rows(); ++i) {
                    INDArray row = indices.getRow(i);
                    int j = 0;
                    while ((long)j < row.length()) {
                        INDArray slice = this.slice(row.getInt(j));
                        Nd4j.getExecutioner().exec(new Assign(new INDArray[]{slice, element}, new INDArray[]{slice}));
                        arrList.add(this.slice(row.getInt(j++)));
                    }
                }
                break block6;
            }
            if (!indices.isRowVector()) break block6;
            int i = 0;
            while ((long)i < indices.length()) {
                arrList.add(this.slice(indices.getInt(i++)));
            }
        }
        return this;
    }

    @Override
    public INDArray put(INDArrayIndex[] indices, INDArray element) {
        Nd4j.getCompressor().autoDecompress((INDArray)this);
        if (indices[0] instanceof SpecifiedIndex && element.isVector()) {
            indices[0].reset();
            int cnt = 0;
            while (indices[0].hasNext()) {
                long idx = indices[0].next();
                this.putScalar((long)((int)idx), element.getDouble((long)cnt));
                ++cnt;
            }
            return this;
        }
        return this.get(indices).assign(element);
    }

    @Override
    public INDArray put(INDArrayIndex[] indices, Number element) {
        Nd4j.getCompressor().autoDecompress((INDArray)this);
        INDArray get = this.get(indices);
        int i = 0;
        while ((long)i < get.length()) {
            get.putScalar((long)i, element.doubleValue());
            ++i;
        }
        return this;
    }

    @Override
    public INDArray swapAxes(int dimension, int with) {
        int[] shape = ArrayUtil.range((int)0, (int)this.shape().length);
        shape[dimension] = with;
        shape[with] = dimension;
        return this.permute(shape);
    }

    @Override
    public boolean isView() {
        return Shape.offset(this.jvmShapeInfo.javaShapeInformation) > 0 || this.length() < this.data().length() && this.data.dataType() != DataBuffer.Type.INT || this.data().originalDataBuffer() != null;
    }

    @Override
    public boolean isSparse() {
        return false;
    }

    @Override
    public DataBuffer data() {
        return this.data;
    }

    @Override
    public void setData(DataBuffer data) {
        this.data = data;
    }

    @Override
    public long slices() {
        if (this.isRowVector()) {
            return this.length();
        }
        return this.size(0);
    }

    @Override
    public INDArray subArray(ShapeOffsetResolution resolution) {
        Nd4j.getCompressor().autoDecompress((INDArray)this);
        long[] offsets = resolution.getOffsets();
        int[] shape = LongUtils.toInts(resolution.getShapes());
        int[] stride = LongUtils.toInts(resolution.getStrides());
        long offset = this.offset() + resolution.getOffset();
        int n = shape.length;
        if (shape.length < 1) {
            return this.create(Nd4j.createBufferDetached(shape));
        }
        if (offsets.length != n) {
            throw new IllegalArgumentException("Invalid offset " + Arrays.toString(offsets));
        }
        if (stride.length != n) {
            throw new IllegalArgumentException("Invalid stride " + Arrays.toString(stride));
        }
        if (shape.length == this.rank() && Shape.contentEquals(shape, this.shapeOf())) {
            if (ArrayUtil.isZero((long[])offsets)) {
                return this;
            }
            throw new IllegalArgumentException("Invalid subArray offsets");
        }
        char newOrder = Shape.getOrder(shape, stride, 1);
        return this.create(this.data, Arrays.copyOf(shape, shape.length), stride, offset, newOrder);
    }

    @Override
    public INDArray subArray(long[] offsets, int[] shape, int[] stride) {
        Nd4j.getCompressor().autoDecompress((INDArray)this);
        int n = shape.length;
        if (shape.length < 1) {
            return this.create(Nd4j.createBufferDetached(shape));
        }
        if (offsets.length != n) {
            throw new IllegalArgumentException("Invalid offset " + Arrays.toString(offsets));
        }
        if (stride.length != n) {
            throw new IllegalArgumentException("Invalid stride " + Arrays.toString(stride));
        }
        if (Shape.contentEquals(shape, this.shapeOf())) {
            if (ArrayUtil.isZero((long[])offsets)) {
                return this;
            }
            throw new IllegalArgumentException("Invalid subArray offsets");
        }
        long[] dotProductOffsets = offsets;
        int[] dotProductStride = stride;
        long offset = (long)Shape.offset(this.jvmShapeInfo.javaShapeInformation) + NDArrayIndex.offset(dotProductStride, dotProductOffsets);
        if (offset >= this.data().length()) {
            offset = ArrayUtil.sumLong((long[])offsets);
        }
        return this.create(this.data, Arrays.copyOf(shape, shape.length), stride, offset, this.ordering());
    }

    protected INDArray create(DataBuffer buffer) {
        return Nd4j.create(buffer);
    }

    @Override
    public INDArray cond(Condition condition) {
        return this.dup().condi(condition);
    }

    @Override
    public INDArray condi(Condition condition) {
        Nd4j.getCompressor().autoDecompress((INDArray)this);
        BaseNDArray linear = this;
        int i = 0;
        while ((long)i < this.length()) {
            boolean met = condition.apply(linear.getDouble((long)i));
            linear.putScalar((long)i, met ? 1 : 0);
            ++i;
        }
        return this;
    }

    protected void init(int[] shape, int[] stride) {
        if (shape.length == 1) {
            this.init(new int[]{1, shape[0]}, new int[]{1, stride[0]});
        }
        if (this.ordering() == '\u0000') {
            Pair<DataBuffer, long[]> si = Nd4j.getShapeInfoProvider().createShapeInformation(shape, stride, 0L, 1, Nd4j.order().charValue());
            this.setShapeInformation(si);
        }
    }

    protected void init(long[] shape, long[] stride) {
        if (shape.length == 1) {
            this.init(new long[]{1L, shape[0]}, new long[]{1L, stride[0]});
        }
        if (this.ordering() == '\u0000') {
            Pair<DataBuffer, long[]> si = Nd4j.getShapeInfoProvider().createShapeInformation(shape, stride, 0L, 1L, Nd4j.order().charValue());
            this.setShapeInformation(si);
        }
    }

    @Override
    public INDArray getScalar(long i) {
        if (i > this.length()) {
            throw new ND4JIllegalStateException("Index can't be greater then array length");
        }
        if (i < 0L) {
            i += this.length();
        }
        long idx = this.isVector() ? i : Shape.getOffset(this.jvmShapeInfo.javaShapeInformation, Shape.ind2subC(this.shape(), i));
        DataBuffer buffer = Nd4j.createBuffer(this.data(), this.data().originalOffset() + idx, 1L);
        Pair<DataBuffer, long[]> shape = Nd4j.getShapeInfoProvider().createShapeInformation(new long[0], new long[0], 0L, 1L, 'c');
        return Nd4j.createArrayFromShapeBuffer(buffer, shape);
    }

    protected INDArray doColumnWise(INDArray columnVector, char operation) {
        Nd4j.getCompressor().autoDecompress((INDArray)this);
        if (columnVector.isScalar()) {
            switch (operation) {
                case 'a': {
                    this.addi(columnVector.getDouble(0L));
                    break;
                }
                case 'p': {
                    this.assign(columnVector.getDouble(0L));
                    break;
                }
                case 's': {
                    this.subi(columnVector.getDouble(0L));
                    break;
                }
                case 'm': {
                    this.muli(columnVector.getDouble(0L));
                    break;
                }
                case 'd': {
                    this.divi(columnVector.getDouble(0L));
                    break;
                }
                case 'h': {
                    this.rsubi(columnVector.getDouble(0L));
                    break;
                }
                case 't': {
                    this.rdivi(columnVector.getDouble(0L));
                }
            }
            return this;
        }
        if (this.isScalar()) {
            switch (operation) {
                case 'a': {
                    return columnVector.addi(this.getDouble(0L));
                }
                case 'p': {
                    return columnVector.assign(this.getDouble(0L));
                }
                case 's': {
                    return columnVector.subi(this.getDouble(0L));
                }
                case 'm': {
                    return columnVector.muli(this.getDouble(0L));
                }
                case 'd': {
                    return columnVector.divi(this.getDouble(0L));
                }
                case 'h': {
                    return columnVector.rsubi(this.getDouble(0L));
                }
                case 't': {
                    return columnVector.rdivi(this.getDouble(0L));
                }
            }
        }
        if (!columnVector.isColumnVector() && columnVector.rank() > 1 || this.size(0) != columnVector.size(0) || columnVector.length() <= 1L) {
            throw new IllegalStateException("Mismatched shapes (shape = " + Arrays.toString(this.shape()) + ", column vector shape =" + Arrays.toString(columnVector.shape()) + ")");
        }
        if (columnVector.data().sameUnderlyingData(this.data())) {
            return this.doColumnWise(columnVector.dup(), operation);
        }
        if (this.isVector()) {
            switch (operation) {
                case 'a': {
                    this.addi(columnVector);
                    break;
                }
                case 'p': {
                    this.assign(columnVector);
                    break;
                }
                case 's': {
                    this.subi(columnVector);
                    break;
                }
                case 'm': {
                    this.muli(columnVector);
                    break;
                }
                case 'd': {
                    this.divi(columnVector);
                    break;
                }
                case 'h': {
                    this.rsubi(columnVector);
                    break;
                }
                case 't': {
                    this.rdivi(columnVector);
                }
            }
            return this;
        }
        if (this.rows() == 1 && columnVector.isScalar()) {
            this.applyScalarOp(columnVector, operation);
        } else if (this.rank() == 2 && this.elementWiseStride() == 1 && this.ordering() == 'c' && columnVector.elementWiseStride() == 1) {
            switch (operation) {
                case 'a': {
                    ScalarAdd op = new ScalarAdd(this, columnVector, this, this.length(), 0.0);
                    op.setDimension(1);
                    Nd4j.getExecutioner().exec(op);
                    break;
                }
                case 'p': {
                    ScalarSet op = new ScalarSet(this, columnVector, this, this.length(), 0.0);
                    op.setDimension(1);
                    Nd4j.getExecutioner().exec(op);
                    break;
                }
                case 's': {
                    ScalarSubtraction op = new ScalarSubtraction(this, columnVector, this, this.length(), 0.0);
                    op.setDimension(1);
                    Nd4j.getExecutioner().exec(op);
                    break;
                }
                case 'm': {
                    ScalarMultiplication op = new ScalarMultiplication(this, columnVector, this, this.length(), 0.0);
                    op.setDimension(1);
                    Nd4j.getExecutioner().exec(op);
                    break;
                }
                case 'd': {
                    ScalarDivision op = new ScalarDivision(this, columnVector, this, this.length(), 0.0);
                    op.setDimension(1);
                    Nd4j.getExecutioner().exec(op);
                    break;
                }
                case 'h': {
                    ScalarReverseSubtraction op = new ScalarReverseSubtraction(this, columnVector, this, this.length(), 0.0);
                    op.setDimension(1);
                    Nd4j.getExecutioner().exec(op);
                    break;
                }
                case 't': {
                    ScalarReverseDivision op = new ScalarReverseDivision(this, columnVector, this, this.length(), 0.0);
                    op.setDimension(1);
                    Nd4j.getExecutioner().exec(op);
                    break;
                }
            }
        } else {
            this.applyBroadcastOp(columnVector, operation);
        }
        return this;
    }

    @Override
    @Deprecated
    public boolean isCleanedUp() {
        return false;
    }

    @Override
    @Deprecated
    public void cleanup() {
        if (Nd4j.shouldInstrument) {
            Nd4j.getInstrumentation().log(this, "destroyed");
        }
    }

    protected INDArray doRowWise(INDArray rowVector, char operation) {
        Nd4j.getCompressor().autoDecompress((INDArray)this);
        if (rowVector.isScalar()) {
            switch (operation) {
                case 'a': {
                    this.addi(rowVector.getDouble(0L));
                    break;
                }
                case 'p': {
                    this.assign(rowVector.getDouble(0L));
                    break;
                }
                case 's': {
                    this.subi(rowVector.getDouble(0L));
                    break;
                }
                case 'm': {
                    this.muli(rowVector.getDouble(0L));
                    break;
                }
                case 'd': {
                    this.divi(rowVector.getDouble(0L));
                    break;
                }
                case 'h': {
                    this.rsubi(rowVector.getDouble(0L));
                    break;
                }
                case 't': {
                    this.rdivi(rowVector.getDouble(0L));
                }
            }
            return this;
        }
        if (this.isScalar()) {
            switch (operation) {
                case 'a': {
                    return rowVector.addi(this.getDouble(0L));
                }
                case 'p': {
                    return rowVector.assign(this.getDouble(0L));
                }
                case 's': {
                    return rowVector.subi(this.getDouble(0L));
                }
                case 'm': {
                    return rowVector.muli(this.getDouble(0L));
                }
                case 'd': {
                    return rowVector.divi(this.getDouble(0L));
                }
                case 'h': {
                    return rowVector.rsubi(this.getDouble(0L));
                }
                case 't': {
                    return rowVector.rdivi(this.getDouble(0L));
                }
            }
        }
        if (!rowVector.isRowVector() || this.rank() > 1 && rowVector.rank() > 1 && this.size(1) != rowVector.size(1) || rowVector.length() <= 1L) {
            throw new IllegalStateException("Mismatched shapes (shape = " + Arrays.toString(this.shape()) + ", row vector shape =" + Arrays.toString(rowVector.shape()) + ")");
        }
        if (rowVector.data().sameUnderlyingData(this.data())) {
            return this.doRowWise(rowVector.dup(), operation);
        }
        if (this.isVector()) {
            switch (operation) {
                case 'a': {
                    this.addi(rowVector);
                    break;
                }
                case 'p': {
                    this.assign(rowVector);
                    break;
                }
                case 's': {
                    this.subi(rowVector);
                    break;
                }
                case 'm': {
                    this.muli(rowVector);
                    break;
                }
                case 'd': {
                    this.divi(rowVector);
                    break;
                }
                case 'h': {
                    this.rsubi(rowVector);
                    break;
                }
                case 't': {
                    this.rdivi(rowVector);
                }
            }
            return this;
        }
        if (this.rank() == 2 && this.columns() == 1 && rowVector.isScalar()) {
            this.applyScalarOp(rowVector, operation);
        } else if (this.rank() == 2 && this.elementWiseStride() == 1 && this.ordering() == 'f' && rowVector.elementWiseStride() == 1) {
            switch (operation) {
                case 'a': {
                    ScalarAdd op = new ScalarAdd(this, rowVector, this, this.length(), 0.0);
                    op.setDimension(0);
                    Nd4j.getExecutioner().exec(op);
                    break;
                }
                case 'p': {
                    ScalarSet op = new ScalarSet(this, rowVector, this, this.length(), 0.0);
                    op.setDimension(0);
                    Nd4j.getExecutioner().exec(op);
                    break;
                }
                case 's': {
                    ScalarSubtraction op = new ScalarSubtraction(this, rowVector, this, this.length(), 0.0);
                    op.setDimension(0);
                    Nd4j.getExecutioner().exec(op);
                    break;
                }
                case 'm': {
                    ScalarMultiplication op = new ScalarMultiplication(this, rowVector, this, this.length(), 0.0);
                    op.setDimension(0);
                    Nd4j.getExecutioner().exec(op);
                    break;
                }
                case 'd': {
                    ScalarDivision op = new ScalarDivision(this, rowVector, this, this.length(), 0.0);
                    op.setDimension(0);
                    Nd4j.getExecutioner().exec(op);
                    break;
                }
                case 'h': {
                    ScalarReverseSubtraction op = new ScalarReverseSubtraction(this, rowVector, this, this.length(), 0.0);
                    op.setDimension(0);
                    Nd4j.getExecutioner().exec(op);
                    break;
                }
                case 't': {
                    ScalarReverseDivision op = new ScalarReverseDivision(this, rowVector, this, this.length(), 0.0);
                    op.setDimension(0);
                    Nd4j.getExecutioner().exec(op);
                    break;
                }
            }
        } else {
            this.applyBroadcastOp(rowVector, operation);
        }
        return this;
    }

    private void applyBroadcastOp(INDArray vector, char operation) {
        int alongDimension;
        Nd4j.getCompressor().autoDecompress((INDArray)this);
        int n = alongDimension = Shape.isRowVectorShape(vector.shape()) ? 1 : 0;
        if (this.data() == vector.data()) {
            vector = vector.dup();
        }
        switch (operation) {
            case 'a': {
                Nd4j.getExecutioner().exec(new BroadcastAddOp((INDArray)this, vector, (INDArray)this, alongDimension), alongDimension);
                return;
            }
            case 's': {
                Nd4j.getExecutioner().exec(new BroadcastSubOp((INDArray)this, vector, (INDArray)this, alongDimension), alongDimension);
                return;
            }
            case 'm': {
                Nd4j.getExecutioner().exec(new BroadcastMulOp((INDArray)this, vector, (INDArray)this, alongDimension), alongDimension);
                return;
            }
            case 'd': {
                Nd4j.getExecutioner().exec(new BroadcastDivOp((INDArray)this, vector, (INDArray)this, alongDimension), alongDimension);
                return;
            }
            case 'h': {
                Nd4j.getExecutioner().exec(new BroadcastRSubOp((INDArray)this, vector, (INDArray)this, alongDimension), alongDimension);
                return;
            }
            case 't': {
                Nd4j.getExecutioner().exec(new BroadcastRDivOp((INDArray)this, vector, (INDArray)this, alongDimension), alongDimension);
                return;
            }
            case 'p': {
                Nd4j.getExecutioner().exec(new BroadcastCopyOp((INDArray)this, vector, (INDArray)this, alongDimension), alongDimension);
                return;
            }
        }
        throw new UnsupportedOperationException("Unknown operation: " + operation);
    }

    private void applyScalarOp(INDArray vector, char operation) {
        Nd4j.getCompressor().autoDecompress((INDArray)this);
        switch (operation) {
            case 'a': {
                this.addi(vector.getDouble(0L));
                break;
            }
            case 's': {
                this.subi(vector.getDouble(0L));
                break;
            }
            case 'm': {
                this.muli(vector.getDouble(0L));
                break;
            }
            case 'd': {
                this.divi(vector.getDouble(0L));
                break;
            }
            case 'h': {
                this.rsubi(vector.getDouble(0L));
                break;
            }
            case 't': {
                this.rdivi(vector.getDouble(0L));
            }
        }
    }

    protected DataBuffer shapeOf() {
        return Shape.shapeOf(this.shapeInfoDataBuffer());
    }

    protected DataBuffer strideOf() {
        return Shape.stride(this.shapeInfoDataBuffer());
    }

    @Override
    public int stride(int dimension) {
        int rank = this.jvmShapeInfo.rank;
        if (dimension < 0) {
            return (int)this.stride()[dimension + rank];
        }
        return (int)this.stride()[dimension];
    }

    @Override
    public INDArray rdiviColumnVector(INDArray columnVector) {
        return this.doColumnWise(columnVector, 't');
    }

    @Override
    public INDArray rdivColumnVector(INDArray columnVector) {
        return this.dup().rdiviColumnVector(columnVector);
    }

    @Override
    public INDArray rdiviRowVector(INDArray rowVector) {
        return this.doRowWise(rowVector, 't');
    }

    @Override
    public INDArray rdivRowVector(INDArray rowVector) {
        return this.dup().rdiviRowVector(rowVector);
    }

    @Override
    public INDArray rsubiColumnVector(INDArray columnVector) {
        return this.doColumnWise(columnVector, 'h');
    }

    @Override
    public INDArray rsubColumnVector(INDArray columnVector) {
        return this.dup().rsubiColumnVector(columnVector);
    }

    @Override
    public INDArray rsubiRowVector(INDArray rowVector) {
        return this.doRowWise(rowVector, 'h');
    }

    @Override
    public INDArray rsubRowVector(INDArray rowVector) {
        return this.dup().rsubiRowVector(rowVector);
    }

    @Override
    public INDArray put(int i, INDArray element) {
        if (!element.isScalar()) {
            throw new IllegalArgumentException("Element must be a scalar");
        }
        return this.putScalar((long)i, element.getDouble(0L));
    }

    @Override
    public INDArray diviColumnVector(INDArray columnVector) {
        return this.doColumnWise(columnVector, 'd');
    }

    @Override
    public INDArray divColumnVector(INDArray columnVector) {
        return this.dup().diviColumnVector(columnVector);
    }

    @Override
    public INDArray diviRowVector(INDArray rowVector) {
        return this.doRowWise(rowVector, 'd');
    }

    @Override
    public INDArray divRowVector(INDArray rowVector) {
        return this.dup().diviRowVector(rowVector);
    }

    @Override
    public INDArray muliColumnVector(INDArray columnVector) {
        return this.doColumnWise(columnVector, 'm');
    }

    @Override
    public INDArray mulColumnVector(INDArray columnVector) {
        return this.dup().muliColumnVector(columnVector);
    }

    @Override
    public INDArray muliRowVector(INDArray rowVector) {
        return this.doRowWise(rowVector, 'm');
    }

    @Override
    public INDArray mulRowVector(INDArray rowVector) {
        return this.dup().muliRowVector(rowVector);
    }

    @Override
    public INDArray subiColumnVector(INDArray columnVector) {
        return this.doColumnWise(columnVector, 's');
    }

    @Override
    public INDArray subColumnVector(INDArray columnVector) {
        return this.dup().subiColumnVector(columnVector);
    }

    @Override
    public INDArray subiRowVector(INDArray rowVector) {
        return this.doRowWise(rowVector, 's');
    }

    @Override
    public INDArray subRowVector(INDArray rowVector) {
        return this.dup().subiRowVector(rowVector);
    }

    @Override
    public INDArray addiColumnVector(INDArray columnVector) {
        return this.doColumnWise(columnVector, 'a');
    }

    @Override
    public INDArray putiColumnVector(INDArray columnVector) {
        return this.doColumnWise(columnVector, 'p');
    }

    @Override
    public INDArray addColumnVector(INDArray columnVector) {
        return this.dup().addiColumnVector(columnVector);
    }

    @Override
    public INDArray addiRowVector(INDArray rowVector) {
        return this.doRowWise(rowVector, 'a');
    }

    @Override
    public INDArray putiRowVector(INDArray rowVector) {
        return this.doRowWise(rowVector, 'p');
    }

    @Override
    public INDArray addRowVector(INDArray rowVector) {
        return this.dup().addiRowVector(rowVector);
    }

    @Override
    public INDArray mmul(INDArray other, INDArray result, MMulTranspose mMulTranspose) {
        MMulTranspose mMulTranspose1 = MMulTranspose.builder().a(this).b(other).transposeA(mMulTranspose.isTransposeA()).transposeB(mMulTranspose.isTransposeB()).transposeResult(mMulTranspose.isTransposeResult()).build();
        return mMulTranspose1.getA().mmul(mMulTranspose1.getB(), result);
    }

    @Override
    public INDArray mmul(INDArray other, MMulTranspose mMulTranspose) {
        MMulTranspose mMulTranspose1 = MMulTranspose.builder().a(this).b(other).transposeA(mMulTranspose.isTransposeA()).transposeB(mMulTranspose.isTransposeB()).transposeResult(mMulTranspose.isTransposeResult()).build();
        System.out.println(mMulTranspose1.getA());
        System.out.println(mMulTranspose1.getB());
        return mMulTranspose1.getA().mmul(mMulTranspose1.getB());
    }

    @Override
    public INDArray mmul(INDArray other) {
        long[] shape = new long[]{this.rows(), other.rank() == 1 ? 1L : (long)other.columns()};
        INDArray result = Nd4j.createUninitialized(shape, 'f');
        if (result.isScalar()) {
            return Nd4j.scalar(Nd4j.getBlasWrapper().dot(this, other));
        }
        return this.mmuli(other, result);
    }

    protected INDArray create(int[] shape, char ordering) {
        return Nd4j.create(shape, ordering);
    }

    @Override
    public double[][] toDoubleMatrix() {
        if (!this.isMatrix()) {
            throw new ND4JIllegalStateException("Unable to create a 2d array from a non matrix!");
        }
        if (this.rows() > Integer.MAX_VALUE || this.columns() > Integer.MAX_VALUE) {
            throw new ND4JArraySizeException();
        }
        double[][] ret = new double[this.rows()][this.columns()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = this.getRow(i).dup().data().asDouble();
        }
        return ret;
    }

    @Override
    public double[] toDoubleVector() {
        if (!this.isVectorOrScalar()) {
            throw new ND4JIllegalStateException("Unable to create a 1d array from a non vector!");
        }
        return this.dup().data().asDouble();
    }

    @Override
    public float[] toFloatVector() {
        if (!this.isVectorOrScalar()) {
            throw new ND4JIllegalStateException("Unable to create a 1d array from a non vector!");
        }
        return this.dup().data().asFloat();
    }

    @Override
    public float[][] toFloatMatrix() {
        if (!this.isMatrix()) {
            throw new ND4JIllegalStateException("Unable to create a 2d array from a non matrix!");
        }
        if (this.rows() > Integer.MAX_VALUE || this.columns() > Integer.MAX_VALUE) {
            throw new ND4JArraySizeException();
        }
        float[][] ret = new float[this.rows()][this.columns()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = this.getRow(i).dup().data().asFloat();
        }
        return ret;
    }

    @Override
    public int[] toIntVector() {
        if (!this.isVectorOrScalar()) {
            throw new ND4JIllegalStateException("Unable to create a 1d array from a non vector!");
        }
        return this.dup().data().asInt();
    }

    @Override
    public long[] toLongVector() {
        if (!this.isVectorOrScalar()) {
            throw new ND4JIllegalStateException("Unable to create a 1d array from a non vector!");
        }
        return this.dup().data().asLong();
    }

    @Override
    public long[][] toLongMatrix() {
        if (!this.isMatrix()) {
            throw new ND4JIllegalStateException("Unable to create a 2d array from a non matrix!");
        }
        if (this.rows() > Integer.MAX_VALUE || this.columns() > Integer.MAX_VALUE) {
            throw new ND4JArraySizeException();
        }
        long[][] ret = new long[this.rows()][this.columns()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = this.getRow(i).dup().data().asLong();
        }
        return ret;
    }

    @Override
    public int[][] toIntMatrix() {
        if (!this.isMatrix()) {
            throw new ND4JIllegalStateException("Unable to create a 2d array from a non matrix!");
        }
        if (this.rows() > Integer.MAX_VALUE || this.columns() > Integer.MAX_VALUE) {
            throw new ND4JArraySizeException();
        }
        int[][] ret = new int[this.rows()][this.columns()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = this.getRow(i).dup().data().asInt();
        }
        return ret;
    }

    @Override
    public INDArray mmul(INDArray other, INDArray result) {
        return this.mmuli(other, result);
    }

    @Override
    public INDArray div(INDArray other) {
        return this.divi(other, Nd4j.createUninitialized(this.shape(), this.ordering()));
    }

    @Override
    public INDArray div(INDArray other, INDArray result) {
        return this.divi(other, result);
    }

    @Override
    public INDArray mul(INDArray other) {
        return this.muli(other, Nd4j.createUninitialized(this.shape(), this.ordering()));
    }

    @Override
    public INDArray mul(INDArray other, INDArray result) {
        return this.muli(other, result);
    }

    @Override
    public INDArray sub(INDArray other) {
        return this.subi(other, Nd4j.createUninitialized(this.shape(), this.ordering()));
    }

    @Override
    public INDArray sub(INDArray other, INDArray result) {
        return this.subi(other, result);
    }

    @Override
    public INDArray add(INDArray other) {
        return this.addi(other, Nd4j.createUninitialized(this.shape(), this.ordering()));
    }

    @Override
    public INDArray add(INDArray other, INDArray result) {
        return this.dup().addi(other, result);
    }

    @Override
    public INDArray mmuli(INDArray other, MMulTranspose transpose) {
        return this.dup().mmuli(other, this, transpose);
    }

    @Override
    public INDArray mmuli(INDArray other) {
        return this.dup().mmuli(other, this);
    }

    @Override
    public INDArray mmuli(INDArray other, INDArray result, MMulTranspose transpose) {
        MMulTranspose mMulTranspose = MMulTranspose.builder().a(this).b(other).transposeA(transpose.isTransposeA()).transposeB(transpose.isTransposeB()).transposeResult(transpose.isTransposeResult()).build();
        return mMulTranspose.getA().mmuli(mMulTranspose.getB(), result);
    }

    @Override
    public INDArray mmuli(INDArray other, INDArray result) {
        LinAlgExceptions.assertMultiplies(this, other);
        if (other.isScalar()) {
            return this.muli(other.getDouble(0L), result);
        }
        if (this.isScalar()) {
            return other.muli(this.getDouble(0L), result);
        }
        if (result == this || result == other) {
            INDArray temp = Nd4j.create(result.shape(), Nd4j.getStrides(result.shape(), 'f'));
            if (other.columns() == 1 || other.rank() == 1) {
                Nd4j.getBlasWrapper().level2().gemv(BlasBufferUtil.getCharForTranspose(result), BlasBufferUtil.getCharForTranspose(this), 1.0, this, other, 0.0, temp);
            } else {
                Nd4j.getBlasWrapper().level3().gemm(BlasBufferUtil.getCharForTranspose(result), BlasBufferUtil.getCharForTranspose(this), BlasBufferUtil.getCharForTranspose(temp), 1.0, this, other, 0.0, temp);
            }
            result.assign(temp);
        } else {
            boolean requiresTemp = result.ordering() == 'c';
            INDArray gemmResultArr = requiresTemp ? Nd4j.createUninitialized(result.shape(), 'f') : result;
            if (other.columns() == 1 || other.rank() == 1) {
                Nd4j.getBlasWrapper().level2().gemv(this.ordering(), BlasBufferUtil.getCharForTranspose(other), 1.0, this, other, 0.0, gemmResultArr);
            } else {
                Nd4j.getBlasWrapper().level3().gemm(this.ordering(), BlasBufferUtil.getCharForTranspose(other), BlasBufferUtil.getCharForTranspose(gemmResultArr), 1.0, this, other, 0.0, gemmResultArr);
            }
            if (requiresTemp) {
                result.assign(gemmResultArr);
            }
        }
        if (other.rank() == 1) {
            result = result.reshape(result.length());
        }
        if (Nd4j.ENFORCE_NUMERICAL_STABILITY) {
            Nd4j.clearNans(result);
        }
        return result;
    }

    private INDArray create(int[] shape, int[] stride) {
        return Nd4j.create(shape, stride);
    }

    @Override
    public INDArray divi(INDArray other) {
        return this.divi(other, (INDArray)this);
    }

    @Override
    public INDArray divi(INDArray other, INDArray result) {
        if (other.isScalar()) {
            return this.divi(other.getDouble(0L), result);
        }
        if (this.isScalar()) {
            return other.rdivi(this.getDouble(0L), result);
        }
        if (!Shape.shapeEquals(this.shape(), other.shape())) {
            int[] broadcastDimensions = Shape.getBroadcastDimensions(this.shape(), other.shape());
            Nd4j.getExecutioner().exec(new BroadcastDivOp((INDArray)this, other, result, broadcastDimensions), broadcastDimensions);
            return result;
        }
        LinAlgExceptions.assertSameShape(other, result);
        Nd4j.getExecutioner().exec(new OldDivOp(this, other, result, this.length()));
        if (Nd4j.ENFORCE_NUMERICAL_STABILITY) {
            Nd4j.clearNans(result);
        }
        return result;
    }

    @Override
    public INDArray muli(INDArray other) {
        return this.muli(other, (INDArray)this);
    }

    @Override
    public INDArray muli(INDArray other, INDArray result) {
        if (other.isScalar()) {
            return this.muli(other.getDouble(0L), result);
        }
        if (this.isScalar()) {
            return other.muli(this.getDouble(0L), result);
        }
        if (!Shape.shapeEquals(this.shape(), other.shape())) {
            int[] broadcastDimensions = Shape.getBroadcastDimensions(this.shape(), other.shape());
            Nd4j.getExecutioner().exec(new BroadcastMulOp((INDArray)this, other, result, broadcastDimensions), broadcastDimensions);
            return result;
        }
        LinAlgExceptions.assertSameShape(other, result);
        Nd4j.getExecutioner().exec(new OldMulOp(this, other, result, this.length()));
        if (Nd4j.ENFORCE_NUMERICAL_STABILITY) {
            Nd4j.clearNans(result);
        }
        return result;
    }

    @Override
    public INDArray subi(INDArray other) {
        return this.subi(other, (INDArray)this);
    }

    @Override
    public INDArray subi(INDArray other, INDArray result) {
        if (other.isScalar()) {
            return this.subi(other.getDouble(0L), result);
        }
        if (this.isScalar()) {
            return other.rsubi(this.getDouble(0L), result);
        }
        if (!Shape.shapeEquals(this.shape(), other.shape())) {
            int[] broadcastDimensions = Shape.getBroadcastDimensions(this.shape(), other.shape());
            Nd4j.getExecutioner().exec(new BroadcastSubOp((INDArray)this, other, result, broadcastDimensions), broadcastDimensions);
            return result;
        }
        LinAlgExceptions.assertSameShape(other, result);
        Nd4j.getExecutioner().exec(new OldSubOp((INDArray)this, other, result));
        if (Nd4j.ENFORCE_NUMERICAL_STABILITY) {
            Nd4j.clearNans(result);
        }
        return result;
    }

    @Override
    public INDArray addi(INDArray other) {
        return this.addi(other, (INDArray)this);
    }

    @Override
    public INDArray addi(INDArray other, INDArray result) {
        if (other.isScalar()) {
            return this.addi(other.getDouble(0L), result);
        }
        if (this.isScalar()) {
            return other.addi(this.getDouble(0L), result);
        }
        if (!Shape.shapeEquals(this.shape(), other.shape())) {
            int[] broadcastDimensions = Shape.getBroadcastDimensions(this.shape(), other.shape());
            result = Nd4j.createUninitialized(Shape.broadcastOutputShape(this.shape(), other.shape()));
            Nd4j.getExecutioner().exec(new BroadcastAddOp((INDArray)this, other, result, broadcastDimensions), broadcastDimensions);
            return result;
        }
        LinAlgExceptions.assertSameShape(other, result);
        Nd4j.getExecutioner().exec(new OldAddOp(this, other, result, this.length()));
        if (Nd4j.ENFORCE_NUMERICAL_STABILITY) {
            Nd4j.clearNans(result);
        }
        return result;
    }

    @Override
    public INDArray normmax(int ... dimension) {
        return Nd4j.getExecutioner().exec(new NormMax(this), dimension);
    }

    @Override
    public INDArray rdiv(INDArray other) {
        return this.dup().rdivi(other);
    }

    @Override
    public INDArray rdivi(INDArray other) {
        return this.rdivi(other, (INDArray)this);
    }

    @Override
    public INDArray rdiv(INDArray other, INDArray result) {
        return this.dup().rdivi(other, result);
    }

    @Override
    public INDArray rdivi(INDArray other, INDArray result) {
        return other.divi(this, result);
    }

    @Override
    public INDArray rsub(INDArray other, INDArray result) {
        return this.dup().rsubi(other, result);
    }

    @Override
    public INDArray rsub(INDArray other) {
        return this.dup().rsubi(other);
    }

    @Override
    public INDArray rsubi(INDArray other) {
        return this.rsubi(other, (INDArray)this);
    }

    @Override
    public INDArray rsubi(INDArray other, INDArray result) {
        return other.subi(this, result);
    }

    @Override
    public INDArray assign(Number value) {
        Nd4j.getExecutioner().exec(new ScalarSet((INDArray)this, value));
        return this;
    }

    @Override
    public INDArray assignIf(INDArray arr, Condition condition) {
        BooleanIndexing.assignIf(this, arr, condition);
        return this;
    }

    @Override
    public INDArray replaceWhere(INDArray arr, Condition condition) {
        Nd4j.getCompressor().autoDecompress((INDArray)this);
        BooleanIndexing.replaceWhere((INDArray)this, arr, condition);
        return this;
    }

    @Override
    @Deprecated
    public long linearIndex(long i) {
        long idx = i;
        for (int j = 0; j < this.jvmShapeInfo.rank - 1; ++j) {
            if (this.size((int)i) == 1L) continue;
            idx += i * (long)this.stride(j);
        }
        return (long)Shape.offset(this.jvmShapeInfo.javaShapeInformation) + idx;
    }

    @Override
    public INDArray slice(long slice) {
        Nd4j.getCompressor().autoDecompress((INDArray)this);
        long slices = this.slices();
        if (slice >= slices) {
            throw new IllegalArgumentException("Illegal slice " + slice);
        }
        if (this.jvmShapeInfo.rank == 0 || this.isVector()) {
            if (slice == 0L || this.isVector()) {
                return this.createScalarForIndex(slice, true);
            }
            throw new IllegalArgumentException("Can't slice a 0-d NDArray");
        }
        if (slice < 0L) {
            slice += (long)this.rank();
        }
        INDArrayIndex[] indexes = new INDArrayIndex[this.rank()];
        indexes[0] = NDArrayIndex.point(slice);
        for (int i = 1; i < this.rank(); ++i) {
            indexes[i] = NDArrayIndex.all();
        }
        return this.get(indexes);
    }

    protected INDArray createScalarForIndex(long i, boolean applyOffset) {
        if (this.isVector()) {
            return this.getScalar(i);
        }
        return Nd4j.create(this.data(), new long[]{1L, 1L}, new long[]{1L, 1L}, i);
    }

    protected INDArray createScalar(double d) {
        return Nd4j.scalar(d);
    }

    @Override
    public int getTrailingOnes() {
        int numLeadingOnes = 0;
        for (int i = this.rank() - 1; i > 0; --i) {
            if (this.size(i) != 1L) continue;
            ++numLeadingOnes;
        }
        return numLeadingOnes;
    }

    @Override
    public int getLeadingOnes() {
        int numLeadingOnes = 0;
        for (int i = 0; i < this.rank(); ++i) {
            if (this.size(i) != 1L) continue;
            ++numLeadingOnes;
        }
        return numLeadingOnes;
    }

    @Override
    public INDArray slice(long slice, int dimension) {
        Nd4j.getCompressor().autoDecompress((INDArray)this);
        long slices = this.size(dimension);
        if (slice >= slices) {
            throw new IllegalArgumentException("Illegal slice " + slice);
        }
        if (this.jvmShapeInfo.rank == 0) {
            if (slice == 0L) {
                return this.createScalarForIndex(slice, true);
            }
            throw new IllegalArgumentException("Can't slice a 0-d NDArray");
        }
        if (slice < 0L) {
            slice += (long)this.rank();
        }
        INDArrayIndex[] indexes = new INDArrayIndex[this.rank()];
        indexes[dimension] = NDArrayIndex.point(slice);
        for (int i = 0; i < this.rank(); ++i) {
            if (i == dimension) continue;
            indexes[i] = NDArrayIndex.all();
        }
        return this.get(indexes);
    }

    @Override
    public INDArray getScalar(int[] indexes) {
        if (indexes.length > this.rank()) {
            throw new ND4JIllegalStateException("Indexes can't be longer then array rank");
        }
        for (int i = 0; i < indexes.length; ++i) {
            if (indexes[i] >= 0) continue;
            int n = i;
            indexes[n] = (int)((long)indexes[n] + this.size(i));
        }
        long idx = Shape.getOffset(this.jvmShapeInfo.javaShapeInformation, indexes);
        DataBuffer buffer = Nd4j.createBuffer(this.data(), idx, 1L);
        Pair<DataBuffer, long[]> shape = Nd4j.getShapeInfoProvider().createShapeInformation(new long[0], new long[0], 0L, 1L, 'c');
        return Nd4j.createArrayFromShapeBuffer(buffer, shape);
    }

    @Override
    public INDArray getScalar(long ... indexes) {
        if (indexes.length > this.rank()) {
            throw new ND4JIllegalStateException("Indexes can't be longer then array rank");
        }
        for (int i = 0; i < indexes.length; ++i) {
            if (indexes[i] >= 0L) continue;
            int n = i;
            indexes[n] = indexes[n] + this.size(i);
        }
        long idx = Shape.getOffset(this.jvmShapeInfo.javaShapeInformation, indexes);
        DataBuffer buffer = Nd4j.createBuffer(this.data(), idx, 1L);
        Pair<DataBuffer, long[]> shape = Nd4j.getShapeInfoProvider().createShapeInformation(new long[0], new long[0], 0L, 1L, 'c');
        return Nd4j.createArrayFromShapeBuffer(buffer, shape);
    }

    @Override
    public INDArray rdiv(Number n) {
        return this.rdivi(n, Nd4j.createUninitialized(this.shape(), this.ordering()));
    }

    @Override
    public INDArray rdivi(Number n) {
        return this.rdivi(n, (INDArray)this);
    }

    @Override
    public INDArray rsub(Number n) {
        return this.rsubi(n, Nd4j.createUninitialized(this.shape(), this.ordering()));
    }

    @Override
    public INDArray rsubi(Number n) {
        return this.rsubi(n, (INDArray)this);
    }

    @Override
    public INDArray div(Number n) {
        return this.divi(n, Nd4j.createUninitialized(this.shape(), this.ordering()));
    }

    @Override
    public INDArray divi(Number n) {
        return this.divi(n, (INDArray)this);
    }

    @Override
    public INDArray mul(Number n) {
        return this.muli(n, Nd4j.createUninitialized(this.shape(), this.ordering()));
    }

    @Override
    public INDArray muli(Number n) {
        return this.muli(n, (INDArray)this);
    }

    @Override
    public INDArray sub(Number n) {
        return this.subi(n, Nd4j.createUninitialized(this.shape(), this.ordering()));
    }

    @Override
    public INDArray subi(Number n) {
        return this.subi(n, (INDArray)this);
    }

    @Override
    public INDArray add(Number n) {
        return this.addi(n, Nd4j.createUninitialized(this.shape(), this.ordering()));
    }

    @Override
    public INDArray addi(Number n) {
        return this.addi(n, (INDArray)this);
    }

    @Override
    public INDArray repmat(int[] shape) {
        Nd4j.getCompressor().autoDecompress((INDArray)this);
        long rows = this.rows() * shape[0];
        long cols = this.columns() * shape[1];
        INDArray ret = this.reshape(1L, this.length()).repeat(0, shape[0]).reshape(rows, (long)this.columns()).repeat(0, shape[1]);
        return ret.reshape(rows, cols);
    }

    @Override
    public INDArray repeat(int dimension, int ... repeats) {
        return this.repeat(dimension, ArrayUtil.toLongArray((int[])repeats));
    }

    @Override
    public INDArray repeat(int dimension, long ... repeats) {
        Nd4j.getCompressor().autoDecompress((INDArray)this);
        if (dimension < 0) {
            dimension += this.rank();
        }
        if (repeats.length < this.rank()) {
            repeats = dimension > 0 ? Longs.concat((long[][])new long[][]{ArrayUtil.nTimes((long)((long)this.rank() - (long)repeats.length), (long)1L), repeats}) : Longs.concat((long[][])new long[][]{repeats, ArrayUtil.nTimes((long)((long)this.rank() - (long)repeats.length), (long)1L)});
        }
        long[] newShape = new long[this.rank()];
        for (int i = 0; i < newShape.length; ++i) {
            newShape[i] = this.size(i) * repeats[i];
        }
        INDArray ret = Nd4j.create(newShape);
        long repeatDelta = (long)ArrayUtil.prod((long[])newShape) / this.length();
        int i = 0;
        while ((long)i < this.tensorssAlongDimension(dimension)) {
            INDArray thisTensor = this.tensorAlongDimension(i, dimension);
            INDArray retTensor = ret.tensorAlongDimension(i, dimension);
            int retIdx = 0;
            int k = 0;
            while ((long)k < thisTensor.length()) {
                int j = 0;
                while ((long)j < repeatDelta) {
                    retTensor.putScalar((long)retIdx++, thisTensor.getDouble((long)k));
                    ++j;
                }
                ++k;
            }
            ++i;
        }
        return ret;
    }

    @Override
    public INDArray putRow(long row, INDArray toPut) {
        if (this.isRowVector() && toPut.isVector()) {
            return this.assign(toPut);
        }
        return this.put(new INDArrayIndex[]{NDArrayIndex.point(row), NDArrayIndex.all()}, toPut);
    }

    @Override
    public INDArray putColumn(int column, INDArray toPut) {
        Nd4j.getCompressor().autoDecompress((INDArray)this);
        if (this.isColumnVector() && toPut.isVector()) {
            return this.assign(toPut);
        }
        return this.put(new INDArrayIndex[]{NDArrayIndex.all(), NDArrayIndex.point(column)}, toPut);
    }

    @Override
    public double getDouble(long i) {
        Nd4j.getCompressor().autoDecompress((INDArray)this);
        if (i >= this.length()) {
            throw new IllegalArgumentException("Unable to get linear index " + i + ": values is greater than length (" + this.length() + ")");
        }
        this.autoProcessScalarCall();
        if (i == 0L) {
            return this.data().getDouble(i);
        }
        long[] dimensions = this.ordering() == 'c' ? Shape.ind2subC(this, i) : Shape.ind2sub(this, i);
        Shape.assertShapeLessThan(dimensions, this.shape());
        return this.getDouble(dimensions);
    }

    @Override
    public double getDouble(long i, long j) {
        return this.getDouble(new long[]{i, j});
    }

    @Override
    public float getFloat(long i) {
        return (float)this.getDouble(i);
    }

    @Override
    public float getFloat(long i, long j) {
        return (float)this.getDouble(i, j);
    }

    @Override
    public INDArray transpose() {
        return this.transposei();
    }

    @Override
    public INDArray transposei() {
        return this.permute(ArrayUtil.reverseCopy((int[])ArrayUtil.range((int)0, (int)this.rank())));
    }

    protected INDArray create(DataBuffer data, int[] shape, int[] strides) {
        return Nd4j.create(data, shape, strides, 0L, this.ordering());
    }

    @Override
    public INDArray reshape(char order, int ... newShape) {
        return this.reshape(order, ArrayUtil.toLongArray((int[])newShape));
    }

    @Override
    public INDArray reshape(char order, long ... newShape) {
        long prod;
        Nd4j.getCompressor().autoDecompress((INDArray)this);
        if (this.length() == 1L && (newShape == null || newShape.length == 0)) {
            return Nd4j.create(this.data(), new int[0], new int[0], 0L);
        }
        if (newShape == null || newShape.length < 1) {
            throw new ND4JIllegalStateException("Can't reshape(long...) without shape arguments. Got empty shape instead.");
        }
        if (newShape.length == 1 && newShape[0] == -1L) {
            newShape[0] = this.length();
        }
        int numberNegativesOnes = 0;
        long[] shape = ArrayUtil.copy((long[])newShape);
        for (int i = 0; i < shape.length; ++i) {
            if (shape[i] >= 0L) continue;
            if (numberNegativesOnes >= 1) {
                throw new IllegalArgumentException("Only one dimension can be negative ones. Got shape " + Arrays.toString(newShape));
            }
            ++numberNegativesOnes;
            int shapeLength = 1;
            for (int j = 0; j < shape.length; ++j) {
                if (shape[j] < 1L) continue;
                shapeLength = (int)((long)shapeLength * shape[j]);
            }
            long realShape = Math.abs(this.length() / (long)shapeLength);
            long[] thisNewShape = new long[shape.length];
            for (int j = 0; j < shape.length; ++j) {
                thisNewShape[j] = i != j ? shape[j] : realShape;
            }
            shape = thisNewShape;
            break;
        }
        if ((prod = ArrayUtil.prodLong((long[])shape)) != this.lengthLong()) {
            throw new ND4JIllegalStateException("New shape length doesn't match original length: [" + prod + "] vs [" + this.lengthLong() + "]. Original shape: " + Arrays.toString(this.shape()) + " New Shape: " + Arrays.toString(newShape));
        }
        INDArray reshapeAttempt = Shape.newShapeNoCopy((INDArray)this, shape, order == 'f');
        if (reshapeAttempt != null) {
            return reshapeAttempt;
        }
        INDArray ret = Nd4j.createUninitialized(shape, order);
        if (order != this.ordering()) {
            ret.setData(this.dup(order).data());
        } else {
            ret.assign(this);
        }
        return ret;
    }

    @Override
    public double getDoubleUnsafe(long offset) {
        return this.data().getDouble(offset);
    }

    @Override
    public INDArray putScalarUnsafe(long offset, double value) {
        this.autoProcessScalarCall();
        this.data().put(offset, value);
        return this;
    }

    @Override
    public int innerMostStride() {
        if (this.ordering() == 'c') {
            return this.stride(-1);
        }
        return this.stride(0);
    }

    @Override
    public INDArray reshape(char order, int rows, int columns) {
        return this.reshape(order, new long[]{rows, columns});
    }

    @Override
    public INDArray reshape(int[] shape) {
        return this.reshape(Nd4j.order().charValue(), shape);
    }

    @Override
    public INDArray reshape(long ... shape) {
        return this.reshape(Nd4j.order().charValue(), shape);
    }

    @Override
    public void checkDimensions(INDArray other) {
        assert (Shape.contentEquals(other.shape(), Shape.shapeOf(this.shapeInformation))) : " Other array should have been shape: " + Shape.toString(Shape.shapeOf(this.shapeInformation)) + " but was " + Arrays.toString(other.shape());
        assert (Shape.contentEquals(other.stride(), Shape.stride(this.shapeInformation))) : " Other array should have been stride: " + Shape.toString(Shape.stride(this.shapeInformation)) + " but was " + Arrays.toString(other.stride());
        assert ((long)Shape.offset(this.jvmShapeInfo.javaShapeInformation) == other.offset()) : "Offset of this array is " + Shape.offset(this.jvmShapeInfo.javaShapeInformation) + " but other was " + other.offset();
    }

    @Override
    public INDArray prod(int ... dimension) {
        return Nd4j.getExecutioner().exec(new Prod(this), dimension);
    }

    @Override
    public INDArray mean(int ... dimension) {
        return Nd4j.getExecutioner().exec(new Mean(this), dimension);
    }

    @Override
    public INDArray amean(int ... dimension) {
        return Nd4j.getExecutioner().exec(new AMean(this), dimension);
    }

    @Override
    public INDArray mean(@NonNull INDArray result, int ... dimension) {
        if (result == null) {
            throw new NullPointerException("result is marked @NonNull but is null");
        }
        return Nd4j.getExecutioner().exec(new Mean((INDArray)this, null, result), dimension);
    }

    @Override
    public INDArray var(int ... dimension) {
        return Nd4j.getExecutioner().exec((Accumulation)new Variance(this), dimension);
    }

    @Override
    public INDArray var(boolean biasCorrected, int ... dimension) {
        return Nd4j.getExecutioner().exec((Accumulation)new Variance((INDArray)this, biasCorrected), dimension);
    }

    @Override
    public INDArray max(int ... dimension) {
        return Nd4j.getExecutioner().exec(new Max(this), dimension);
    }

    @Override
    public INDArray amax(int ... dimension) {
        return Nd4j.getExecutioner().exec(new AMax(this), dimension);
    }

    @Override
    public INDArray min(int ... dimension) {
        return Nd4j.getExecutioner().exec(new Min(this), dimension);
    }

    @Override
    public INDArray amin(int ... dimension) {
        return Nd4j.getExecutioner().exec(new AMin(this), dimension);
    }

    @Override
    public INDArray sum(int ... dimension) {
        return Nd4j.getExecutioner().exec(new Sum(this), dimension);
    }

    @Override
    public INDArray entropy(int ... dimension) {
        return Nd4j.getExecutioner().exec(new Entropy(this), dimension);
    }

    @Override
    public INDArray shannonEntropy(int ... dimension) {
        return Nd4j.getExecutioner().exec(new ShannonEntropy(this), dimension);
    }

    @Override
    public INDArray logEntropy(int ... dimension) {
        return Nd4j.getExecutioner().exec(new LogEntropy(this), dimension);
    }

    @Override
    public INDArray sum(@NonNull INDArray result, int ... dimension) {
        if (result == null) {
            throw new NullPointerException("result is marked @NonNull but is null");
        }
        return Nd4j.getExecutioner().exec(new Sum((INDArray)this, null, result), dimension);
    }

    @Override
    public INDArray norm1(int ... dimension) {
        return Nd4j.getExecutioner().exec(new Norm1(this), dimension);
    }

    @Override
    public INDArray std(int ... dimension) {
        return Nd4j.getExecutioner().exec((Accumulation)new StandardDeviation(this), dimension);
    }

    @Override
    public INDArray std(boolean biasCorrected, int ... dimension) {
        return Nd4j.getExecutioner().exec((Accumulation)new StandardDeviation((INDArray)this, biasCorrected), dimension);
    }

    @Override
    public Number stdNumber(boolean biasCorrected) {
        return Nd4j.getExecutioner().exec((Accumulation)new StandardDeviation((INDArray)this, biasCorrected), Integer.MAX_VALUE).getDouble(0L);
    }

    @Override
    public INDArray norm2(int ... dimension) {
        return Nd4j.getExecutioner().exec(new Norm2(this), dimension);
    }

    @Override
    public int columns() {
        if (this.isMatrix()) {
            return (int)this.size(1);
        }
        if (Shape.isColumnVectorShape(this.shape())) {
            return 1;
        }
        if (Shape.isRowVectorShape(this.shape())) {
            return (int)this.length();
        }
        throw new IllegalStateException("Rank is [" + this.rank() + "]; columns() call is not valid");
    }

    @Override
    public int rows() {
        if (this.isMatrix()) {
            return (int)this.size(0);
        }
        if (Shape.isRowVectorShape(this.shape())) {
            return 1;
        }
        if (Shape.isColumnVectorShape(this.shape())) {
            return (int)this.length();
        }
        throw new IllegalStateException("Rank is " + this.rank() + " rows() call is not valid");
    }

    @Override
    public INDArray ravel(char ordering) {
        Nd4j.getCompressor().autoDecompress((INDArray)this);
        if (this.length() >= Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Length can not be >= Integer.MAX_VALUE");
        }
        INDArray ret = this.create(new int[]{1, (int)this.length()}, ordering);
        NDArrayIndex index = new NDArrayIndex(this.shape());
        int i = 0;
        while ((long)i < this.length()) {
            double val = this.getDouble((long)((int)index.next()));
            ret.putScalar(new int[]{0, i++}, val);
        }
        return ret;
    }

    @Override
    public INDArray ravel() {
        return this.reshape(1L, this.length());
    }

    @Override
    public void sliceVectors(List<INDArray> list) {
        if (this.isVector()) {
            list.add(this);
        } else {
            int i = 0;
            while ((long)i < this.slices()) {
                this.slice(i).sliceVectors(list);
                ++i;
            }
        }
    }

    @Override
    public INDArray reshape(long newRows, long newColumns) {
        return this.reshape(new long[]{newRows, newColumns});
    }

    @Override
    public INDArray getColumn(long c) {
        Nd4j.getCompressor().autoDecompress((INDArray)this);
        if (this.isColumnVector() && c == 0L) {
            return this;
        }
        if (this.isColumnVector() && c > 0L) {
            throw new IllegalArgumentException("Illegal index for row");
        }
        if (this.isRowVector()) {
            return Nd4j.scalar(this.getDouble(c));
        }
        return this.get(NDArrayIndex.all(), NDArrayIndex.point(c));
    }

    @Override
    public INDArray getRows(int[] rindices) {
        Nd4j.getCompressor().autoDecompress((INDArray)this);
        if (!this.isMatrix() && !this.isVector()) {
            throw new IllegalArgumentException("Unable to get columns from a non matrix or vector");
        }
        if (this.isVector()) {
            return Nd4j.pullRows(this, 1, rindices);
        }
        INDArray ret = Nd4j.create(rindices.length, this.columns());
        for (int i = 0; i < rindices.length; ++i) {
            ret.putRow(i, this.getRow(rindices[i]));
        }
        return ret;
    }

    @Override
    public INDArray get(INDArrayIndex ... indexes) {
        Nd4j.getCompressor().autoDecompress((INDArray)this);
        if (indexes.length > this.rank()) {
            int numNonNewAxis = 0;
            for (int i = 0; i < indexes.length; ++i) {
                if (indexes[i] instanceof NewAxis) continue;
                ++numNonNewAxis;
            }
            if (numNonNewAxis > this.rank()) {
                throw new IllegalArgumentException("Too many indices for array. Number of indexes must be <= rank()");
            }
        }
        if (indexes.length == 1 && indexes[0] instanceof NDArrayIndexAll || indexes.length == 2 && (this.isRowVector() && indexes[0] instanceof PointIndex && indexes[0].offset() == 0L && indexes[1] instanceof NDArrayIndexAll || this.isColumnVector() && indexes[1] instanceof PointIndex && indexes[0].offset() == 0L && indexes[0] instanceof NDArrayIndexAll)) {
            return this;
        }
        indexes = NDArrayIndex.resolve(this.shapeInfoDataBuffer(), indexes);
        ShapeOffsetResolution resolution = new ShapeOffsetResolution(this);
        resolution.exec(indexes);
        if (indexes.length < 1) {
            throw new IllegalStateException("Invalid index found of zero length");
        }
        int[] shape = LongUtils.toInts(resolution.getShapes());
        int numSpecifiedIndex = 0;
        for (int i = 0; i < indexes.length; ++i) {
            if (!(indexes[i] instanceof SpecifiedIndex)) continue;
            ++numSpecifiedIndex;
        }
        if (shape != null && numSpecifiedIndex > 0) {
            Generator<List<List<Long>>> gen = SpecifiedIndex.iterate(indexes);
            INDArray ret = Nd4j.create(shape, 'c');
            int count = 0;
            do {
                try {
                    List next = (List)gen.next();
                    ArrayList coordsCombo = new ArrayList();
                    for (int i = 0; i < next.size(); ++i) {
                        if (((List)next.get(i)).size() > 1) {
                            throw new IllegalStateException("Illegal entry returned");
                        }
                        coordsCombo.add(((List)next.get(i)).get(0));
                    }
                    ret.putScalar((long)count++, this.getDouble(Ints.toArray(coordsCombo)));
                }
                catch (NoSuchElementException e) {
                    break;
                }
            } while ((long)count < ret.length());
            return ret;
        }
        INDArray ret = this.subArray(resolution);
        return ret;
    }

    @Override
    public INDArray getColumns(int ... cindices) {
        if (!this.isMatrix() && !this.isVector()) {
            throw new IllegalArgumentException("Unable to get columns from a non matrix or vector");
        }
        if (this.isVector()) {
            return Nd4j.pullRows((INDArray)this, 0, cindices, this.ordering());
        }
        INDArray ret = Nd4j.create(this.rows(), cindices.length);
        for (int i = 0; i < cindices.length; ++i) {
            ret.putColumn(i, this.getColumn(cindices[i]));
        }
        return ret;
    }

    protected INDArray create(int rows, int length) {
        return this.create(new int[]{rows, length});
    }

    @Override
    public INDArray getRow(long r) {
        if (this.isRowVector() && r == 0L) {
            return this;
        }
        if (this.isRowVector() && r > 0L) {
            throw new IllegalArgumentException("Illegal index for row: requested row " + r + " but this.size(0)=" + this.size(0));
        }
        INDArray result = this.get(NDArrayIndex.point(r), NDArrayIndex.all());
        if (!this.isView() && this.ordering() == 'c' && result.elementWiseStride() == 1 && result.ordering() != 'c') {
            ((BaseNDArray)result).setShapeInformation(Nd4j.getShapeInfoProvider().createShapeInformation(result.shape(), result.stride(), 0L, 1L, 'c'));
        }
        return result;
    }

    @Override
    public boolean equalsWithEps(Object o, double eps) {
        Nd4j.getCompressor().autoDecompress((INDArray)this);
        if (o == null) {
            return false;
        }
        if (!(o instanceof INDArray)) {
            return false;
        }
        INDArray n = (INDArray)o;
        if (n.isSparse()) {
            return n.equals(this);
        }
        if (this.lengthLong() != n.lengthLong()) {
            return false;
        }
        if (this.isScalar() && n.isScalar()) {
            if (this.data.dataType() == DataBuffer.Type.FLOAT) {
                double val = this.getDouble(0L);
                double val2 = n.getDouble(0L);
                if (Double.isNaN(val) != Double.isNaN(val2)) {
                    return false;
                }
                return Math.abs(val - val2) < eps;
            }
            double val = this.getDouble(0L);
            double val2 = n.getDouble(0L);
            if (Double.isNaN(val) != Double.isNaN(val2)) {
                return false;
            }
            return Math.abs(val - val2) < eps;
        }
        if (this.isVector() && n.isVector()) {
            EqualsWithEps op = new EqualsWithEps((INDArray)this, n, eps);
            Nd4j.getExecutioner().exec(op);
            double diff = op.getFinalResult().doubleValue();
            return diff < 0.5;
        }
        if (!Arrays.equals(this.shape(), n.shape())) {
            return false;
        }
        if (!Shape.shapeEquals(this.shape(), n.shape())) {
            return false;
        }
        if (this.slices() != n.slices()) {
            return false;
        }
        if (n.ordering() == this.ordering()) {
            EqualsWithEps op = new EqualsWithEps((INDArray)this, n, eps);
            Nd4j.getExecutioner().exec(op);
            double diff = op.getFinalResult().doubleValue();
            return diff < 0.5;
        }
        EqualsWithEps op = new EqualsWithEps((INDArray)this, n, eps);
        Nd4j.getExecutioner().exec(op);
        double diff = op.getFinalResult().doubleValue();
        return diff < 0.5;
    }

    @Override
    public boolean equalShapes(@NonNull INDArray other) {
        if (other == null) {
            throw new NullPointerException("other is marked @NonNull but is null");
        }
        if (this.rank() != other.rank()) {
            return false;
        }
        for (int i = 0; i < this.rank(); ++i) {
            if (this.size(i) == other.size(i)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        return this.equalsWithEps(o, Nd4j.EPS_THRESHOLD);
    }

    @Override
    public DataBuffer shapeInfoDataBuffer() {
        return this.shapeInformation;
    }

    @Override
    public LongBuffer shapeInfo() {
        return this.shapeInformation.asNioLong();
    }

    @Override
    public long[] shape() {
        return this.jvmShapeInfo.shape;
    }

    @Override
    public String shapeInfoToString() {
        return Shape.shapeToString(this);
    }

    @Override
    public long[] stride() {
        return this.jvmShapeInfo.stride;
    }

    @Override
    public long offset() {
        if (this.data().offset() >= Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Offset of buffer can not be >= Integer.MAX_VALUE");
        }
        return this.data().offset();
    }

    @Override
    public char ordering() {
        return this.jvmShapeInfo.order;
    }

    @Override
    public long size(int dimension) {
        if (dimension < 0) {
            dimension += this.jvmShapeInfo.rank;
        }
        if (this.isScalar()) {
            if (dimension == 0 || dimension == 1 || dimension < 0) {
                return this.length();
            }
            throw new IllegalArgumentException("Illegal dimension for scalar " + dimension);
        }
        if (dimension >= this.rank()) {
            throw new IllegalArgumentException("Invalid size: cannot get size of dimension " + dimension + " for rank " + this.rank() + " NDArray (array shape: " + Arrays.toString(this.shape()) + ")");
        }
        return this.jvmShapeInfo.shape[dimension];
    }

    @Override
    public int rank() {
        return this.jvmShapeInfo.rank;
    }

    @Override
    public long length() {
        return this.jvmShapeInfo.length;
    }

    @Override
    @Deprecated
    public long lengthLong() {
        return this.jvmShapeInfo.length;
    }

    @Override
    public INDArray broadcast(INDArray result) {
        int i;
        Nd4j.getCompressor().autoDecompress((INDArray)this);
        long[] shape = result.shape();
        if (Shape.shapeEquals(shape, this.shape())) {
            return this;
        }
        if (this.isScalar()) {
            return Nd4j.createUninitialized(shape).assign(this.getDouble(0L));
        }
        boolean compatible = true;
        int count = shape.length - 1;
        int thisCount = this.jvmShapeInfo.rank - 1;
        for (int i2 = shape.length - 1; i2 > 0 && count >= 0 && thisCount >= 0; --count, --thisCount, --i2) {
            if (shape[count] == this.shape()[thisCount] || shape[count] == 1L || this.shape()[thisCount] == 1L) continue;
            compatible = false;
            break;
        }
        if (!compatible) {
            throw new IllegalArgumentException("Incompatible broadcast from " + Arrays.toString(this.shape()) + " to " + Arrays.toString(shape));
        }
        long[] retShape = new long[shape.length];
        ArrayList<Integer> broadCastDimensions = new ArrayList<Integer>();
        ArrayList<Integer> nonBroadCastDimensions = new ArrayList<Integer>();
        for (i = 0; i < retShape.length; ++i) {
            if (this.shape().length == 1) {
                if (i == 0) {
                    if (i < this.shape().length) {
                        retShape[i] = Math.max(1L, shape[i]);
                        continue;
                    }
                    retShape[i] = shape[i];
                    continue;
                }
                if (i < this.shape().length) {
                    retShape[i] = Math.max(shape[i], this.size(i));
                    continue;
                }
                retShape[i] = shape[i];
                continue;
            }
            if (i < this.rank() && this.size(i) == 1L) {
                broadCastDimensions.add(i);
            } else {
                nonBroadCastDimensions.add(i);
            }
            retShape[i] = i < this.shape().length ? Math.max(shape[i], this.size(i)) : shape[i];
        }
        if (this.isRowVector()) {
            i = 0;
            while ((long)i < result.slices()) {
                result.putSlice(i, this);
                ++i;
            }
        } else if (this.isColumnVector()) {
            for (i = 0; i < result.columns(); ++i) {
                result.putColumn(i, this);
            }
        } else {
            int[] repeat = new int[shape.length];
            for (int i3 = 0; i3 < shape.length; ++i3) {
                if (i3 < this.rank()) {
                    if (this.size(i3) == 1L) {
                        repeat[i3] = (int)shape[i3];
                        continue;
                    }
                    repeat[i3] = 1;
                    continue;
                }
                repeat[i3] = (int)shape[i3];
            }
            if (this.isView()) {
                Nd4j.getExecutioner().exec(new Tile(new INDArray[]{this.dup(this.ordering())}, new INDArray[]{result}, repeat));
            } else {
                Nd4j.getExecutioner().exec(new Tile(new INDArray[]{this}, new INDArray[]{result}, repeat));
            }
        }
        return result;
    }

    @Override
    public INDArray broadcast(long ... shape) {
        return this.broadcast(Nd4j.createUninitialized(shape));
    }

    @Override
    public INDArray dimShuffle(Object[] rearrange, int[] newOrder, boolean[] broadCastable) {
        return this.dimShuffle(rearrange, ArrayUtil.toLongArray((int[])newOrder), broadCastable);
    }

    @Override
    public INDArray dimShuffle(Object[] rearrange, long[] newOrder, boolean[] broadCastable) {
        int i;
        Nd4j.getCompressor().autoDecompress((INDArray)this);
        if (broadCastable.length != this.jvmShapeInfo.rank) {
            throw new IllegalArgumentException("The broadcastable dimensions must be the same length as the current shape");
        }
        boolean broadcast = false;
        HashSet<Object> set = new HashSet<Object>();
        for (int i2 = 0; i2 < rearrange.length; ++i2) {
            set.add(rearrange[i2]);
            if (rearrange[i2] instanceof Integer) {
                Integer j = (Integer)rearrange[i2];
                if (j < broadCastable.length) continue;
                throw new IllegalArgumentException("Illegal dimension, dimension must be < broadcastable.length (aka the real dimensions");
            }
            if (rearrange[i2] instanceof Character) {
                Character c = (Character)rearrange[i2];
                if (c.charValue() != 'x') {
                    throw new IllegalArgumentException("Illegal input: Must be x");
                }
                broadcast = true;
                continue;
            }
            throw new IllegalArgumentException("Only characters and integers allowed");
        }
        if (!broadcast) {
            int[] ret = new int[rearrange.length];
            for (int i3 = 0; i3 < ret.length; ++i3) {
                ret[i3] = (Integer)rearrange[i3];
            }
            return this.permute(ret);
        }
        ArrayList<Integer> drop = new ArrayList<Integer>();
        for (int i4 = 0; i4 < broadCastable.length; ++i4) {
            if (set.contains(i4)) continue;
            if (broadCastable[i4]) {
                drop.add(i4);
                continue;
            }
            throw new IllegalArgumentException("We can't drop the given dimension because its not broadcastable");
        }
        int[] shuffle = new int[broadCastable.length];
        int count = 0;
        for (int i5 = 0; i5 < rearrange.length; ++i5) {
            if (!(rearrange[i5] instanceof Integer)) continue;
            shuffle[count++] = (Integer)rearrange[i5];
        }
        ArrayList<Integer> augment = new ArrayList<Integer>();
        for (int i6 = 0; i6 < rearrange.length; ++i6) {
            if (!(rearrange[i6] instanceof Character)) continue;
            augment.add(i6);
        }
        Integer[] augmentDims = augment.toArray(new Integer[1]);
        count = 0;
        int dropIdx = 0;
        int[] newShape = new int[shuffle.length + drop.size()];
        for (int i7 = 0; i7 < newShape.length; ++i7) {
            if (i7 < shuffle.length) {
                newShape[count++] = shuffle[i7];
                continue;
            }
            newShape[count++] = (Integer)drop.get(dropIdx++);
        }
        INDArray ret = this.permute(newShape);
        ArrayList<Long> newDims = new ArrayList<Long>();
        long[] shape = Arrays.copyOfRange(ret.shape(), 0, shuffle.length);
        for (i = 0; i < shape.length; ++i) {
            newDims.add(shape[i]);
        }
        for (i = 0; i < augmentDims.length; ++i) {
            newDims.add(augmentDims[i], 1L);
        }
        long[] toReshape = ArrayUtil.toArrayLong(newDims);
        ret = ret.reshape(toReshape);
        return ret;
    }

    @Override
    public INDArray permute(int ... rearrange) {
        Nd4j.getCompressor().autoDecompress((INDArray)this);
        if (rearrange.length != this.rank()) {
            return this.dup();
        }
        boolean alreadyInOrder = true;
        int rank = this.jvmShapeInfo.rank;
        for (int i = 0; i < rank; ++i) {
            if (rearrange[i] == i) continue;
            alreadyInOrder = false;
            break;
        }
        if (alreadyInOrder) {
            return this;
        }
        this.checkArrangeArray(rearrange);
        int[] newShape = this.doPermuteSwap(this.shapeOf(), rearrange);
        int[] newStride = this.doPermuteSwap(this.strideOf(), rearrange);
        char newOrder = Shape.getOrder(newShape, newStride, this.elementStride());
        INDArray value = this.create(this.data(), newShape, newStride, this.offset(), newOrder);
        return value;
    }

    @Override
    public INDArray permutei(int ... rearrange) {
        boolean alreadyInOrder = true;
        LongBuffer shapeInfo = this.shapeInfo();
        int rank = this.jvmShapeInfo.rank;
        for (int i = 0; i < rank; ++i) {
            if (rearrange[i] == i) continue;
            alreadyInOrder = false;
            break;
        }
        if (alreadyInOrder) {
            return this;
        }
        this.checkArrangeArray(rearrange);
        long[] newShape = this.doPermuteSwap(Shape.shapeOf(shapeInfo), rearrange);
        long[] newStride = this.doPermuteSwap(Shape.stride(shapeInfo), rearrange);
        char newOrder = Shape.getOrder(newShape, newStride, (long)this.elementStride());
        long ews = shapeInfo.get(2 * rank + 2);
        Pair<DataBuffer, long[]> si = Nd4j.getShapeInfoProvider().createShapeInformation(newShape, newStride, 0L, ews, newOrder);
        this.setShapeInformation(si);
        if (shapeInfo.get(2 * rank + 2) > 0L) {
            this.setShapeInformation(Nd4j.getShapeInfoProvider().createShapeInformation(newShape, newStride, this.offset(), -1L, newOrder));
        }
        return this;
    }

    protected long[] doPermuteSwap(LongBuffer shape, int[] rearrange) {
        long[] ret = new long[rearrange.length];
        for (int i = 0; i < rearrange.length; ++i) {
            ret[i] = shape.get(rearrange[i]);
        }
        return ret;
    }

    protected int[] doPermuteSwap(IntBuffer shape, int[] rearrange) {
        int[] ret = new int[rearrange.length];
        for (int i = 0; i < rearrange.length; ++i) {
            ret[i] = shape.get(rearrange[i]);
        }
        return ret;
    }

    protected int[] doPermuteSwap(DataBuffer shape, int[] rearrange) {
        int[] ret = new int[rearrange.length];
        for (int i = 0; i < rearrange.length; ++i) {
            ret[i] = shape.getInt((long)rearrange[i]);
        }
        return ret;
    }

    protected void checkArrangeArray(int[] arr) {
        int i;
        assert (arr.length == this.jvmShapeInfo.rank) : "Invalid rearrangement: number of arrangement != shape";
        for (i = 0; i < arr.length; ++i) {
            if (arr[i] >= arr.length) {
                throw new IllegalArgumentException("The specified dimensions can't be swapped. Given element " + i + " was >= number of dimensions");
            }
            if (arr[i] >= 0) continue;
            throw new IllegalArgumentException("Invalid dimension: " + i + " : negative value");
        }
        for (i = 0; i < arr.length; ++i) {
            for (int j = 0; j < arr.length; ++j) {
                if (i == j || arr[i] != arr[j]) continue;
                throw new IllegalArgumentException("Permute array must have unique elements");
            }
        }
    }

    protected void autoProcessScalarCall() {
    }

    @Override
    public boolean isVector() {
        if (this.jvmShapeInfo.rank == 1) {
            return true;
        }
        return this.isRowVector() || this.isColumnVector();
    }

    @Override
    public boolean isVectorOrScalar() {
        return this.isVector() || this.isScalar();
    }

    @Override
    public boolean isSquare() {
        return this.isMatrix() && this.rows() == this.columns();
    }

    @Override
    public boolean isRowVector() {
        return this.rank() == 2 && this.rows() == 1 && this.length() > 1L || this.rank() == 1 && this.length() > 1L;
    }

    @Override
    public boolean isColumnVector() {
        return this.rank() == 2 && this.columns() == 1 && this.length() > 1L;
    }

    @Override
    public boolean isColumnVectorOrScalar() {
        return this.isColumnVector() || this.isScalar();
    }

    @Override
    public boolean isRowVectorOrScalar() {
        return this.isRowVector() || this.isScalar();
    }

    public String toString() {
        if (!this.isCompressed() && !Nd4j.preventUnpack) {
            return new NDArrayStrings().format(this);
        }
        if (this.isCompressed() && Nd4j.compressDebug) {
            return "COMPRESSED ARRAY. SYSTEM PROPERTY compressdebug is true. This is to prevent auto decompression from being triggered.";
        }
        if (Nd4j.preventUnpack) {
            return "Array string unpacking is disabled.";
        }
        return new NDArrayStrings().format(this);
    }

    @Override
    public Object element() {
        if (!this.isScalar()) {
            throw new IllegalStateException("Unable to retrieve element from non scalar matrix");
        }
        if (this.data.dataType() == DataBuffer.Type.FLOAT) {
            return Float.valueOf(this.data.getFloat(0L));
        }
        return this.data.getDouble(0L);
    }

    @Override
    public INDArray remainder(INDArray denominator) {
        return this.remainder(denominator, Nd4j.createUninitialized(this.shape()));
    }

    @Override
    public INDArray remainder(INDArray denominator, INDArray result) {
        RemainderOp op = new RemainderOp((INDArray)this, denominator, result);
        Nd4j.getExecutioner().exec(op);
        return result;
    }

    @Override
    public INDArray remainder(Number denominator) {
        return this.remainder(denominator, Nd4j.createUninitialized(this.shape()));
    }

    @Override
    public INDArray remainder(Number denominator, INDArray result) {
        ScalarRemainder op = new ScalarRemainder(this, null, result, this.length(), denominator);
        Nd4j.getExecutioner().exec(op);
        return result;
    }

    @Override
    public INDArray remainderi(INDArray denominator) {
        RemainderOp op = new RemainderOp((INDArray)this, denominator, this);
        Nd4j.getExecutioner().exec(op);
        return this;
    }

    @Override
    public INDArray remainderi(Number denominator) {
        ScalarRemainder op = new ScalarRemainder(this, null, this, this.length(), denominator);
        Nd4j.getExecutioner().exec(op);
        return this;
    }

    @Override
    public INDArray fmod(INDArray denominator) {
        return this.fmod(denominator, Nd4j.createUninitialized(this.shape()));
    }

    @Override
    public INDArray fmod(INDArray denominator, INDArray result) {
        OldFModOp op = new OldFModOp((INDArray)this, denominator, result);
        Nd4j.getExecutioner().exec(op);
        return result;
    }

    @Override
    public INDArray fmod(Number denominator) {
        return this.fmod(denominator, Nd4j.createUninitialized(this.shape()));
    }

    @Override
    public INDArray fmod(Number denominator, INDArray result) {
        ScalarFMod op = new ScalarFMod(this, null, result, this.length(), denominator);
        Nd4j.getExecutioner().exec(op);
        return result;
    }

    @Override
    public INDArray fmodi(INDArray denominator) {
        OldFModOp op = new OldFModOp((INDArray)this, denominator, this);
        Nd4j.getExecutioner().exec(op);
        return this;
    }

    @Override
    public INDArray fmodi(Number denominator) {
        ScalarFMod op = new ScalarFMod(this, null, this, this.length(), denominator);
        Nd4j.getExecutioner().exec(op);
        return this;
    }

    public Iterator<Object> iterator() {
        return new FirstAxisIterator(this);
    }

    @Override
    public long originalOffset() {
        if (this.data().originalOffset() >= Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Original offset of buffer can not be >= Integer.MAX_VALUE");
        }
        return this.data().originalOffset();
    }

    private void readObject(ObjectInputStream s) {
        try {
            s.defaultReadObject();
            this.read(s);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        this.write(out);
    }

    protected void write(ObjectOutputStream out) throws IOException {
        if (this.isView()) {
            INDArray copy = this.dup();
            copy.shapeInfoDataBuffer().write((OutputStream)out);
            copy.data().write((OutputStream)out);
        } else {
            this.shapeInformation.write((OutputStream)out);
            this.data().write((OutputStream)out);
        }
    }

    protected void read(ObjectInputStream s) {
        this.shapeInformation = Nd4j.createBuffer(new int[Shape.shapeInfoLength(this.rank())], 0L);
        this.shapeInformation.read((InputStream)s);
        this.setShapeInformation((Pair<DataBuffer, long[]>)Pair.create((Object)this.shapeInformation, (Object)this.shapeInformation.asLong()));
        this.data = Nd4j.createBuffer(this.length(), false);
        this.data().read((InputStream)s);
    }

    @Override
    public INDArray argMax(int ... dimension) {
        return Nd4j.argMax(this, dimension);
    }

    @Override
    public boolean isAttached() {
        if (this.isEmpty()) {
            return false;
        }
        if (this.data == null && !this.isEmpty()) {
            throw new IllegalStateException();
        }
        return this.data.isAttached() || this.data.underlyingDataBuffer() != null && this.data.underlyingDataBuffer().isAttached() || this.data.originalDataBuffer() != null && this.data.originalDataBuffer().isAttached();
    }

    @Override
    public boolean isInScope() {
        if (!this.isAttached()) {
            return true;
        }
        return this.data.isInScope();
    }

    @Override
    public INDArray detach() {
        if (!this.isAttached()) {
            return this;
        }
        WorkspaceUtils.assertValidArray(this, "Cannot detach INDArray");
        Nd4j.getExecutioner().commit();
        if (Nd4j.getMemoryManager().getCurrentWorkspace() == null) {
            if (!this.isView()) {
                Nd4j.getExecutioner().commit();
                DataBuffer buffer = Nd4j.createBuffer(this.lengthLong(), false);
                Nd4j.getMemoryManager().memcpy(buffer, this.data());
                return Nd4j.createArrayFromShapeBuffer(buffer, this.shapeInfoDataBuffer());
            }
            INDArray copy = Nd4j.createUninitialized(this.shape(), this.ordering());
            copy.assign(this);
            Nd4j.getExecutioner().commit();
            return copy;
        }
        MemoryWorkspace workspace = Nd4j.getMemoryManager().getCurrentWorkspace();
        Nd4j.getMemoryManager().setCurrentWorkspace(null);
        INDArray copy = null;
        if (!this.isView()) {
            Nd4j.getExecutioner().commit();
            DataBuffer buffer = Nd4j.createBuffer(this.lengthLong(), false);
            Nd4j.getMemoryManager().memcpy(buffer, this.data());
            copy = Nd4j.createArrayFromShapeBuffer(buffer, this.shapeInfoDataBuffer());
        } else {
            copy = Nd4j.createUninitialized(this.shape(), this.ordering());
            copy.assign(this);
            Nd4j.getExecutioner().commit();
        }
        Nd4j.getMemoryManager().setCurrentWorkspace(workspace);
        return copy;
    }

    @Override
    public INDArray leverage() {
        WorkspaceUtils.assertValidArray(this, "Cannot leverage INDArray to new workspace");
        if (!this.isAttached()) {
            return this;
        }
        MemoryWorkspace workspace = Nd4j.getMemoryManager().getCurrentWorkspace();
        if (workspace == null) {
            return this.detach();
        }
        MemoryWorkspace parentWorkspace = workspace.getParentWorkspace();
        if (this.data.getParentWorkspace() == parentWorkspace) {
            return this;
        }
        if (parentWorkspace == null) {
            return this.detach();
        }
        Nd4j.getExecutioner().commit();
        Nd4j.getMemoryManager().setCurrentWorkspace(parentWorkspace);
        INDArray copy = null;
        if (!this.isView()) {
            Nd4j.getExecutioner().commit();
            DataBuffer buffer = Nd4j.createBuffer(this.lengthLong(), false);
            Nd4j.getMemoryManager().memcpy(buffer, this.data());
            copy = Nd4j.createArrayFromShapeBuffer(buffer, this.shapeInfoDataBuffer());
        } else {
            copy = this.dup(this.ordering());
            Nd4j.getExecutioner().commit();
        }
        Nd4j.getMemoryManager().setCurrentWorkspace(workspace);
        return copy;
    }

    @Override
    public INDArray leverageTo(String id) {
        return this.leverageTo(id, false);
    }

    @Override
    public INDArray leverageTo(String id, boolean enforceExistence) throws Nd4jNoSuchWorkspaceException {
        WorkspaceUtils.assertValidArray(this, "Cannot leverage INDArray to new workspace");
        if (!this.isAttached()) {
            return this;
        }
        if (!Nd4j.getWorkspaceManager().checkIfWorkspaceExists(id)) {
            if (enforceExistence) {
                throw new Nd4jNoSuchWorkspaceException(id);
            }
            return this;
        }
        MemoryWorkspace current = Nd4j.getMemoryManager().getCurrentWorkspace();
        MemoryWorkspace target = Nd4j.getWorkspaceManager().getWorkspaceForCurrentThread(id);
        if (this.data.getParentWorkspace() == target) {
            return this;
        }
        Nd4j.getMemoryManager().setCurrentWorkspace(target);
        INDArray copy = null;
        if (!this.isView()) {
            Nd4j.getExecutioner().commit();
            DataBuffer buffer = Nd4j.createBuffer(this.lengthLong(), false);
            Nd4j.getMemoryManager().memcpy(buffer, this.data());
            copy = Nd4j.createArrayFromShapeBuffer(buffer, this.shapeInfoDataBuffer());
        } else {
            copy = this.dup(this.ordering());
            Nd4j.getExecutioner().commit();
        }
        Nd4j.getMemoryManager().setCurrentWorkspace(current);
        return copy;
    }

    @Override
    public INDArray leverageOrDetach(String id) {
        if (!this.isAttached()) {
            return this;
        }
        if (!Nd4j.getWorkspaceManager().checkIfWorkspaceExistsAndActive(id)) {
            return this.detach();
        }
        return this.leverageTo(id);
    }

    @Override
    public INDArray migrate() {
        return this.migrate(false);
    }

    @Override
    public INDArray migrate(boolean detachOnNoWs) {
        WorkspaceUtils.assertValidArray(this, "Cannot leverage INDArray to new workspace");
        MemoryWorkspace current = Nd4j.getMemoryManager().getCurrentWorkspace();
        if (current == null) {
            if (detachOnNoWs) {
                return this.detach();
            }
            return this;
        }
        INDArray copy = null;
        if (!this.isView()) {
            Nd4j.getExecutioner().commit();
            DataBuffer buffer = Nd4j.createBuffer(this.lengthLong(), false);
            Nd4j.getMemoryManager().memcpy(buffer, this.data());
            copy = Nd4j.createArrayFromShapeBuffer(buffer, this.shapeInfoDataBuffer());
        } else {
            copy = this.dup(this.ordering());
            Nd4j.getExecutioner().commit();
        }
        return copy;
    }

    @Override
    public Number percentileNumber(Number quantile) {
        if (quantile.intValue() < 0 || quantile.intValue() > 100) {
            throw new ND4JIllegalStateException("Percentile value should be in 0...100 range");
        }
        if (this.isScalar()) {
            return this.getDouble(0L);
        }
        INDArray sorted = Nd4j.sort(this.dup(this.ordering()), true);
        return this.getPercentile(quantile, sorted);
    }

    @Override
    public Number medianNumber() {
        return this.percentileNumber(50);
    }

    @Override
    public INDArray median(int ... dimension) {
        return this.percentile(50, dimension);
    }

    protected double getPercentile(Number quantile, INDArray sorted) {
        if (quantile.intValue() == 0) {
            return sorted.getDouble(0L);
        }
        if (quantile.intValue() == 100) {
            return sorted.getDouble(sorted.length() - 1L);
        }
        double pos = quantile.doubleValue() / 100.0 * (double)(sorted.length() + 1L);
        double fposition = FastMath.floor((double)pos);
        int position = (int)fposition;
        double diff = pos - fposition;
        double lower = sorted.getDouble((long)(position - 1));
        double upper = sorted.getDouble((long)position);
        return lower + diff * (upper - lower);
    }

    @Override
    public INDArray percentile(Number quantile, int ... dimension) {
        if (quantile.doubleValue() < 0.0 || quantile.doubleValue() > 100.0) {
            throw new ND4JIllegalStateException("Percentile value should be in 0...100 range");
        }
        if (this.isScalar()) {
            return Nd4j.scalar(this.getDouble(0L));
        }
        INDArray sorted = Nd4j.getNDArrayFactory().sort(this.dup(this.ordering()), false, dimension);
        INDArray ret = Nd4j.createUninitialized(sorted.tensorssAlongDimension(dimension));
        int i = 0;
        while ((long)i < ret.length()) {
            ret.putScalar((long)i, this.getPercentile(quantile, sorted.tensorAlongDimension(i, dimension)));
            ++i;
        }
        return ret;
    }

    @Override
    public int toFlatArray(FlatBufferBuilder builder) {
        int shape = FlatArray.createShapeVector(builder, this.shapeInfoDataBuffer().asLong());
        int buffer = this.isEmpty() ? 0 : FlatArray.createBufferVector(builder, this.data().asBytes());
        byte type = this.isEmpty() ? SameDiff.getDataTypeAsByte(Nd4j.dataType()) : SameDiff.getDataTypeAsByte(this.data().dataType());
        int array = FlatArray.createFlatArray(builder, shape, buffer, type, (byte)1);
        return array;
    }

    @Override
    public DataBuffer getVectorCoordinates() {
        throw new UnsupportedOperationException("Not a sparse ndarray");
    }

    @Override
    public INDArray toDense() {
        return this;
    }

    @Override
    public int nnz() {
        throw new UnsupportedOperationException("Not a sparse ndarray");
    }

    @Override
    public SparseFormat getFormat() {
        return SparseFormat.NONE;
    }

    @Override
    public DataBuffer sparseInfoDataBuffer() {
        throw new UnsupportedOperationException("Not a sparse ndarray");
    }

    @Override
    public int[] flags() {
        throw new UnsupportedOperationException("Not a sparse ndarray");
    }

    @Override
    public int[] hiddenDimensions() {
        throw new UnsupportedOperationException("Not a sparse ndarray");
    }

    @Override
    public int[] sparseOffsets() {
        throw new UnsupportedOperationException("Not a sparse ndarray");
    }

    @Override
    public int underlyingRank() {
        throw new UnsupportedOperationException("Not a sparse ndarray");
    }

    @Override
    public INDArray convertToHalfs() {
        if (this.data.dataType() == DataBuffer.Type.HALF) {
            return this;
        }
        NDArrayFactory factory = Nd4j.getNDArrayFactory();
        DataBuffer buffer = Nd4j.createBuffer(new long[]{this.length()}, DataBuffer.Type.HALF);
        factory.convertDataEx(BaseNDArray.convertType(this.data.dataType()), this.data().addressPointer(), DataBuffer.TypeEx.FLOAT16, buffer.addressPointer(), buffer.length());
        return Nd4j.createArrayFromShapeBuffer(buffer, this.shapeInformation);
    }

    @Override
    public INDArray convertToFloats() {
        if (this.data.dataType() == DataBuffer.Type.FLOAT) {
            return this;
        }
        NDArrayFactory factory = Nd4j.getNDArrayFactory();
        DataBuffer buffer = Nd4j.createBuffer(new long[]{this.length()}, DataBuffer.Type.FLOAT);
        factory.convertDataEx(BaseNDArray.convertType(this.data.dataType()), this.data().addressPointer(), DataBuffer.TypeEx.FLOAT, buffer.addressPointer(), buffer.length());
        return Nd4j.createArrayFromShapeBuffer(buffer, this.shapeInformation);
    }

    @Override
    public INDArray convertToDoubles() {
        if (this.data.dataType() == DataBuffer.Type.DOUBLE) {
            return this;
        }
        NDArrayFactory factory = Nd4j.getNDArrayFactory();
        DataBuffer buffer = Nd4j.createBuffer(new long[]{this.length()}, DataBuffer.Type.DOUBLE);
        factory.convertDataEx(BaseNDArray.convertType(this.data.dataType()), this.data().addressPointer(), DataBuffer.TypeEx.DOUBLE, buffer.addressPointer(), buffer.length());
        return Nd4j.createArrayFromShapeBuffer(buffer, this.shapeInformation);
    }

    protected static DataBuffer.TypeEx convertType(DataBuffer.Type type) {
        if (type == DataBuffer.Type.HALF) {
            return DataBuffer.TypeEx.FLOAT16;
        }
        if (type == DataBuffer.Type.FLOAT) {
            return DataBuffer.TypeEx.FLOAT;
        }
        if (type == DataBuffer.Type.DOUBLE) {
            return DataBuffer.TypeEx.DOUBLE;
        }
        if (type == DataBuffer.Type.INT) {
            return DataBuffer.TypeEx.INT8;
        }
        if (type == DataBuffer.Type.LONG) {
            return DataBuffer.TypeEx.INT16;
        }
        throw new IllegalStateException("Unknown dataType: [" + type + "]");
    }

    @Override
    public boolean isEmpty() {
        return Shape.isEmpty(this.jvmShapeInfo.javaShapeInformation);
    }

    @Override
    public long[] shapeInfoJava() {
        return this.jvmShapeInfo.javaShapeInformation;
    }

    @Override
    public DataBuffer.Type dataType() {
        DataBuffer.Type t;
        if (this.data != null) {
            return this.data.dataType();
        }
        long e = Shape.extras(this.jvmShapeInfo.javaShapeInformation);
        if (e != 0L && (t = ArrayOptionsHelper.dataType(this.jvmShapeInfo.javaShapeInformation)) != DataBuffer.Type.UNKNOWN) {
            return t;
        }
        return DataBuffer.Type.UNKNOWN;
    }

    static {
        BaseNDArray.tadFinalPermuteDimensions[1] = new int[]{1, 0};
        for (int i = 2; i < 32; ++i) {
            BaseNDArray.tadFinalPermuteDimensions[i] = new int[i];
            int k = i - 1;
            int j = 0;
            while (k >= 0) {
                BaseNDArray.tadFinalPermuteDimensions[i][j] = k--;
                ++j;
            }
        }
    }
}

