/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.imports.graphmapper;

import com.github.os72.protobuf351.Message;
import com.github.os72.protobuf351.TextFormat;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.nd4j.autodiff.functions.DifferentialFunction;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.imports.NoOpNameFoundException;
import org.nd4j.imports.descriptors.properties.PropertyMapping;
import org.nd4j.imports.graphmapper.GraphMapper;
import org.nd4j.imports.graphmapper.ImportState;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.exception.ND4JIllegalStateException;
import org.nd4j.weightinit.impl.ZeroInitScheme;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseGraphMapper<GRAPH_TYPE, NODE_TYPE, ATTR_TYPE, TENSOR_TYPE>
implements GraphMapper<GRAPH_TYPE, NODE_TYPE, ATTR_TYPE, TENSOR_TYPE> {
    private static final Logger log = LoggerFactory.getLogger(BaseGraphMapper.class);

    @Override
    public Op.Type opTypeForNode(NODE_TYPE nodeDef) {
        DifferentialFunction opWithTensorflowName = this.getMappedOp(this.getOpType(nodeDef));
        if (opWithTensorflowName == null) {
            throw new NoOpNameFoundException("No op found with name " + this.getOpType(nodeDef));
        }
        Op.Type type = opWithTensorflowName.opType();
        return type;
    }

    @Override
    public void mapProperties(DifferentialFunction on, NODE_TYPE node, GRAPH_TYPE graph, SameDiff sameDiff, Map<String, Map<String, PropertyMapping>> propertyMappings) {
        Map<String, PropertyMapping> mappings = propertyMappings.get(this.getOpType(node));
        if (mappings == null || mappings.isEmpty()) {
            return;
        }
        for (Map.Entry<String, PropertyMapping> entry : mappings.entrySet()) {
            this.mapProperty(entry.getKey(), on, node, graph, sameDiff, propertyMappings);
        }
    }

    @Override
    public SameDiff importGraph(InputStream inputStream) {
        GRAPH_TYPE def = this.readGraph(inputStream);
        return this.importGraph(def);
    }

    protected GRAPH_TYPE readGraph(InputStream inputStream) {
        byte[] bytes = null;
        Message def = null;
        try {
            bytes = IOUtils.toByteArray((InputStream)inputStream);
            def = (Message)this.parseGraphFrom(bytes);
        }
        catch (IOException e) {
            try (BufferedInputStream bis2 = new BufferedInputStream(new ByteArrayInputStream(bytes));
                 BufferedReader reader = new BufferedReader(new InputStreamReader(bis2));){
                Message.Builder builder = this.getNewGraphBuilder();
                StringBuilder str = new StringBuilder();
                String line = null;
                while ((line = reader.readLine()) != null) {
                    str.append(line);
                }
                TextFormat.getParser().merge((CharSequence)str.toString(), builder);
                def = builder.build();
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        return (GRAPH_TYPE)def;
    }

    @Override
    public SameDiff importGraph(String graphFile) {
        return this.importGraph(new File(graphFile));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SameDiff importGraph(File graphFile) {
        GRAPH_TYPE def = null;
        try (FileInputStream fis = new FileInputStream(graphFile);){
            SameDiff sameDiff = this.importGraph(fis);
            return sameDiff;
        }
        catch (Exception e) {
            e.printStackTrace();
            if (def != null) return this.importGraph(def);
            throw new ND4JIllegalStateException("Unknown format: " + graphFile.getAbsolutePath());
        }
    }

    @Override
    public Map<String, NODE_TYPE> nameIndexForGraph(GRAPH_TYPE graph) {
        List nodes = this.getNodeList(graph);
        HashMap ret = new HashMap();
        for (Object node : nodes) {
            ret.put(this.getName(node), node);
        }
        return ret;
    }

    @Override
    public Map<String, NODE_TYPE> nodesByName(GRAPH_TYPE graph) {
        List nodeTypes = this.getNodeList(graph);
        LinkedHashMap ret = new LinkedHashMap();
        for (int i = 0; i < nodeTypes.size(); ++i) {
            ret.put(this.getName(nodeTypes.get(i)), nodeTypes.get(i));
        }
        return ret;
    }

    @Override
    public SameDiff importGraph(GRAPH_TYPE tfGraph) {
        SameDiff diff = SameDiff.create();
        ImportState importState = new ImportState();
        importState.setSameDiff(diff);
        importState.setGraph(tfGraph);
        Map variablesForGraph = this.variablesForGraph(tfGraph);
        importState.setVariables(variablesForGraph);
        for (Map.Entry entry : variablesForGraph.entrySet()) {
            SDVariable var;
            if (this.dataTypeForTensor(entry.getValue()) == DataBuffer.Type.UNKNOWN) {
                SDVariable var2 = importState.getSameDiff().var(entry.getKey(), null, new ZeroInitScheme('c'));
                if (!this.isPlaceHolder(entry.getValue())) continue;
                importState.getSameDiff().addAsPlaceHolder(var2.getVarName());
                if (var2.getShape() == null) continue;
                importState.getSameDiff().setOriginalPlaceHolderShape(var2.getVarName(), var2.getShape());
                continue;
            }
            INDArray arr = this.getNDArrayFromTensor(entry.getKey(), entry.getValue(), tfGraph);
            if (arr != null) {
                var = importState.getSameDiff().var(entry.getKey(), arr);
                diff.associateArrayWithVariable(arr, var);
                continue;
            }
            if (this.getShapeFromTensor(entry.getValue()) == null) {
                var = importState.getSameDiff().var(entry.getKey(), null, new ZeroInitScheme('c'));
                if (!this.isPlaceHolder(entry.getValue())) continue;
                long[] originalShape = this.getShapeFromTensor(entry.getValue());
                importState.getSameDiff().addAsPlaceHolder(var.getVarName());
                if (var.getShape() == null) continue;
                importState.getSameDiff().setOriginalPlaceHolderShape(var.getVarName(), originalShape);
                continue;
            }
            long[] originalShape = this.getShapeFromTensor(entry.getValue());
            SDVariable var3 = importState.getSameDiff().var(entry.getKey(), originalShape);
            if (!this.isPlaceHolder(entry.getValue())) continue;
            importState.getSameDiff().addAsPlaceHolder(var3.getVarName());
            importState.getSameDiff().setOriginalPlaceHolderShape(var3.getVarName(), originalShape);
        }
        List tfNodesList = this.getNodeList(tfGraph);
        for (Object tfNode : tfNodesList) {
            if (this.opsToIgnore().contains(this.getOpType(tfNode)) && !this.isOpIgnoreException(tfNode)) continue;
            this.mapNodeType(tfNode, importState);
        }
        return diff;
    }

    @Override
    public boolean validTensorDataType(TENSOR_TYPE tensorType) {
        return this.dataTypeForTensor(tensorType) != DataBuffer.Type.UNKNOWN;
    }
}

