/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.autodiff.samediff;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import onnx.OnnxProto3;
import org.nd4j.autodiff.functions.DifferentialFunction;
import org.nd4j.autodiff.samediff.SDIndex;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.base.Preconditions;
import org.nd4j.imports.NoOpNameFoundException;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.exception.ND4JIllegalStateException;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.util.ArrayUtil;
import org.nd4j.weightinit.WeightInitScheme;
import org.nd4j.weightinit.impl.ZeroInitScheme;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tensorflow.framework.AttrValue;
import org.tensorflow.framework.GraphDef;
import org.tensorflow.framework.NodeDef;

public class SDVariable
extends DifferentialFunction
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(SDVariable.class);
    private String varName;
    protected WeightInitScheme weightInitScheme;
    private int outputIndex = 0;
    private DifferentialFunction creator;

    private SDVariable(String varName, SameDiff sameDiff, long[] shape, WeightInitScheme weightInitScheme) {
        super(sameDiff, new Object[0]);
        this.varName = varName;
        this.weightInitScheme = weightInitScheme;
        if (weightInitScheme == null) {
            this.weightInitScheme = new ZeroInitScheme('c');
        }
        if (shape == null) {
            sameDiff.addAsPlaceHolder(varName);
        } else {
            boolean foundPlaceHolder = false;
            for (int i = 0; i < shape.length; ++i) {
                if (shape[i] >= 0L) continue;
                sameDiff.addAsPlaceHolder(varName);
                sameDiff.setOriginalPlaceHolderShape(varName, shape);
                foundPlaceHolder = true;
                break;
            }
            if (!foundPlaceHolder && shape != null) {
                sameDiff.putShapeForVarName(varName, shape);
            }
        }
        this.sameDiff = sameDiff;
    }

    public boolean isPlaceHolder() {
        return this.sameDiff.isPlaceHolder(this.varName);
    }

    @Override
    public String opName() {
        return "variable";
    }

    @Override
    public SDVariable[] outputVariables() {
        return new SDVariable[]{this};
    }

    @Override
    public SDVariable arg() {
        return this;
    }

    @Override
    public SDVariable[] args() {
        return new SDVariable[]{this};
    }

    @Override
    public SDVariable[] outputVariables(String baseName) {
        return new SDVariable[]{this};
    }

    @Override
    public void initFromTensorFlow(NodeDef nodeDef, SameDiff initWith, Map<String, AttrValue> attributesForNode, GraphDef graph) {
    }

    @Override
    public void initFromOnnx(OnnxProto3.NodeProto node, SameDiff initWith, Map<String, OnnxProto3.AttributeProto> attributesForNode, OnnxProto3.GraphProto graph) {
    }

    public INDArray storeAndAllocateNewArray() {
        long[] shape = this.sameDiff.getShapeForVarName(this.getVarName());
        INDArray currArr = this.getArr();
        if (currArr != null && Arrays.equals(currArr.shape(), shape)) {
            return this.getArr();
        }
        if (this.varName == null) {
            throw new ND4JIllegalStateException("Unable to store array for null variable name!");
        }
        if (shape == null) {
            throw new ND4JIllegalStateException("Unable to allocate new array. No shape found for variable " + this.varName);
        }
        INDArray arr = this.getWeightInitScheme().create(shape);
        this.sameDiff.associateArrayWithVariable(arr, this);
        if (log.isTraceEnabled()) {
            log.trace("Generated and stored new array for variable \"{}\": old shape: {}, new shape {}", new Object[]{this.getVarName(), currArr == null ? "null" : Arrays.toString(currArr.shape()), Arrays.toString(arr.shape())});
        }
        return arr;
    }

    public INDArray getArr() {
        return this.getArr(false);
    }

    public INDArray getArr(boolean enforceExistence) {
        if (this.sameDiff.arrayAlreadyExistsForVarName(this.getVarName())) {
            return this.sameDiff.getArrForVarName(this.getVarName());
        }
        if (this.getScalarValue() != null && ArrayUtil.prod((long[])this.getShape()) == 1) {
            INDArray arr = Nd4j.valueArrayOf(this.getShape(), this.getScalarValue().doubleValue());
            this.sameDiff.associateArrayWithVariable(arr, this);
            if (log.isTraceEnabled()) {
                log.trace("getArr() for variable \"{}\" allocated new scalar array: shape {}", (Object)this.getVarName(), (Object)Arrays.toString(this.getShape()));
            }
        } else {
            if (this.sameDiff.getShapeForVarName(this.getVarName()) == null) {
                if (enforceExistence) {
                    throw new IllegalStateException("Cannot get array for SDVariable \"" + this.getVarName() + "\": no array has been defined, and array shape cannot be calculated");
                }
                if (log.isTraceEnabled()) {
                    log.trace("SDVariable.getArr(): could not get array for variable {}: shape is null", (Object)this.getVarName());
                }
                return null;
            }
            long[] shape = this.sameDiff.getShapeForVarName(this.getVarName());
            INDArray newAlloc = this.getWeightInitScheme().create(shape);
            this.sameDiff.associateArrayWithVariable(newAlloc, this);
            if (log.isTraceEnabled()) {
                log.trace("getArr() for variable \"{}\" allocated new array with shape {}", (Object)this.getVarName(), (Object)Arrays.toString(this.getShape()));
            }
        }
        return this.sameDiff.getArrForVarName(this.getVarName());
    }

    public SDVariable gradient() {
        return this.getGradient();
    }

    public SDVariable getGradient() {
        return this.sameDiff.getGradForVariable(this.getVarName());
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> f1) {
        throw new ND4JIllegalStateException("Unable to differentiate a variable! Must be a function.");
    }

    public long[] getShape() {
        INDArray arr;
        long[] initialShape = this.sameDiff.getShapeForVarName(this.getVarName());
        if (initialShape == null && (arr = this.getArr()) != null) {
            return arr.shape();
        }
        return initialShape;
    }

    @Override
    public SDVariable dup() {
        return this.sameDiff.var(this);
    }

    public SDVariable assign(Number value) {
        return this.sameDiff.scalarSet(this, value);
    }

    public SDVariable neg() {
        return this.f().neg(this);
    }

    public SDVariable neg(String name) {
        return this.sameDiff.neg(name, this);
    }

    public SDVariable lt(double value) {
        return this.lt(null, value);
    }

    public SDVariable lt(String name, double value) {
        return this.sameDiff.lt(name, this, value);
    }

    public SDVariable lte(double value) {
        return this.lte(null, value);
    }

    public SDVariable lte(String name, double value) {
        return this.sameDiff.lte(name, this, value);
    }

    public SDVariable gt(double value) {
        return this.gt(null, value);
    }

    public SDVariable gt(String name, double value) {
        return this.sameDiff.gt(name, this, value);
    }

    public SDVariable gte(double value) {
        return this.gte(null, value);
    }

    public SDVariable gte(String name, double value) {
        return this.sameDiff.gte(name, this, value);
    }

    public SDVariable eq(double value) {
        return this.eq(null, value);
    }

    public SDVariable eq(String name, double value) {
        return this.sameDiff.eq(name, this, value);
    }

    public SDVariable neq(double value) {
        return this.neq(null, value);
    }

    public SDVariable neq(String name, double value) {
        return this.sameDiff.neq(name, this, value);
    }

    public SDVariable lt(SDVariable other) {
        return this.lt(null, other);
    }

    public SDVariable lt(String name, SDVariable other) {
        return this.sameDiff.lt(name, this, other);
    }

    public SDVariable lte(SDVariable other) {
        return this.lte(null, other);
    }

    public SDVariable lte(String name, SDVariable other) {
        return this.sameDiff.lte(name, this, other);
    }

    public SDVariable gt(SDVariable other) {
        return this.gt(null, other);
    }

    public SDVariable gt(String name, SDVariable other) {
        return this.sameDiff.gt(name, this, other);
    }

    public SDVariable gte(SDVariable other) {
        return this.gte(null, other);
    }

    public SDVariable gte(String name, SDVariable other) {
        return this.sameDiff.gte(name, this, other);
    }

    public SDVariable eq(SDVariable other) {
        return this.eq(null, other);
    }

    public SDVariable eq(String name, SDVariable other) {
        return this.sameDiff.eq(name, this, other);
    }

    public SDVariable neq(SDVariable other) {
        return this.neq(null, other);
    }

    public SDVariable neq(String name, SDVariable other) {
        return this.sameDiff.neq(name, this, other);
    }

    public SDVariable mmul(SDVariable other) {
        return this.sameDiff.mmul(this, other);
    }

    public SDVariable rsub(double sameDiffVariable) {
        return this.rsub(this.sameDiff.generateNewVarName("reversesubtract", 0), sameDiffVariable);
    }

    public SDVariable rdiv(double sameDiffVariable) {
        return this.rdiv(this.sameDiff.generateNewVarName("reversedivide", 0), sameDiffVariable);
    }

    public SDVariable add(double sameDiffVariable) {
        return this.add(this.sameDiff.generateNewVarName("add", 0), sameDiffVariable);
    }

    public SDVariable sub(double sameDiffVariable) {
        return this.sub(this.sameDiff.generateNewVarName("subtract", 0), sameDiffVariable);
    }

    public SDVariable squaredDifference(SDVariable sameDiffVariable) {
        return this.squaredDifference(this.sameDiff.generateNewVarName("squaredsubtract", 0), sameDiffVariable);
    }

    public SDVariable div(double sameDiffVariable) {
        return this.div(this.sameDiff.generateNewVarName("divide", 0), sameDiffVariable);
    }

    public SDVariable mul(double sameDiffVariable) {
        return this.mul(this.sameDiff.generateNewVarName("multiply", 0), sameDiffVariable);
    }

    public SDVariable rsubi(double sameDiffVariable) {
        return this.rsubi(this.sameDiff.generateNewVarName("reversesubtract", 0), sameDiffVariable);
    }

    public SDVariable rdivi(double sameDiffVariable) {
        return this.rdivi(this.sameDiff.generateNewVarName("reversedivide", 0), sameDiffVariable);
    }

    public SDVariable addi(double sameDiffVariable) {
        return this.addi(this.sameDiff.generateNewVarName("add", 0), sameDiffVariable);
    }

    public SDVariable subi(double sameDiffVariable) {
        return this.subi(this.sameDiff.generateNewVarName("subtract", 0), sameDiffVariable);
    }

    public SDVariable divi(double sameDiffVariable) {
        return this.divi(this.sameDiff.generateNewVarName("divide", 0), sameDiffVariable);
    }

    public SDVariable muli(double sameDiffVariable) {
        return this.muli(this.sameDiff.generateNewVarName("multiply", 0), sameDiffVariable);
    }

    public SDVariable rsub(SDVariable sameDiffVariable) {
        return this.rsub(this.sameDiff.generateNewVarName("reversesubtract", 0), sameDiffVariable);
    }

    public SDVariable rdiv(SDVariable sameDiffVariable) {
        return this.rdiv(this.sameDiff.generateNewVarName("reversedivide", 0), sameDiffVariable);
    }

    public SDVariable truncatedDiv(SDVariable sameDiffVariable) {
        return this.truncatedDiv(this.sameDiff.generateNewVarName("truncatediv", 0), sameDiffVariable);
    }

    public SDVariable add(SDVariable sameDiffVariable) {
        return this.add(this.sameDiff.generateNewVarName("add", 0), sameDiffVariable);
    }

    public SDVariable sub(SDVariable sameDiffVariable) {
        return this.sub(this.sameDiff.generateNewVarName("subtract", 0), sameDiffVariable);
    }

    public SDVariable div(SDVariable sameDiffVariable) {
        return this.div(this.sameDiff.generateNewVarName("divide", 0), sameDiffVariable);
    }

    public SDVariable mul(SDVariable sameDiffVariable) {
        return this.mul(this.sameDiff.generateNewVarName("multiply", 0), sameDiffVariable);
    }

    public SDVariable rsubi(SDVariable sameDiffVariable) {
        return this.rsubi(this.sameDiff.generateNewVarName("reversesubtract", 0), sameDiffVariable);
    }

    public SDVariable rdivi(SDVariable sameDiffVariable) {
        return this.rdivi(this.sameDiff.generateNewVarName("reversedivide", 0), sameDiffVariable);
    }

    public SDVariable addi(SDVariable sameDiffVariable) {
        return this.addi(this.sameDiff.generateNewVarName("add", 0), sameDiffVariable);
    }

    public SDVariable subi(SDVariable sameDiffVariable) {
        return this.subi(this.sameDiff.generateNewVarName("subtract", 0), sameDiffVariable);
    }

    public SDVariable divi(SDVariable sameDiffVariable) {
        return this.divi(this.sameDiff.generateNewVarName("divide", 0), sameDiffVariable);
    }

    public SDVariable muli(SDVariable sameDiffVariable) {
        return this.muli(this.sameDiff.generateNewVarName("multiply", 0), sameDiffVariable);
    }

    public SDVariable rsub(String varName, double sameDiffVariable) {
        SDVariable function = this.sameDiff.f().rsub(this, sameDiffVariable);
        return this.sameDiff.updateVariableNameAndReference(function, varName);
    }

    public SDVariable rdiv(String varName, double sameDiffVariable) {
        SDVariable function = this.sameDiff.f().rdiv(this, sameDiffVariable);
        return this.sameDiff.updateVariableNameAndReference(function, varName);
    }

    public SDVariable truncatedDiv(String varName, SDVariable sameDiffVariable) {
        SDVariable function = this.sameDiff.f().truncatedDiv(this, sameDiffVariable);
        return this.sameDiff.updateVariableNameAndReference(function, varName);
    }

    public SDVariable add(String varName, double sameDiffVariable) {
        SDVariable function = this.sameDiff.f().add(this, sameDiffVariable);
        return this.sameDiff.updateVariableNameAndReference(function, varName);
    }

    public SDVariable sub(String varName, double sameDiffVariable) {
        SDVariable right = this;
        SDVariable result = this.sameDiff.f().sub(right, sameDiffVariable);
        return this.sameDiff.updateVariableNameAndReference(result, varName);
    }

    public SDVariable div(String varName, double sameDiffVariable) {
        SDVariable function = this.sameDiff.f().div(this, sameDiffVariable);
        return this.sameDiff.updateVariableNameAndReference(function, varName);
    }

    public SDVariable mul(String varName, double value) {
        SDVariable function = this.sameDiff.f().mul(this, value);
        return this.sameDiff.updateVariableNameAndReference(function, varName);
    }

    public SDVariable pow(double value) {
        return this.pow(null, value);
    }

    public SDVariable pow(String varName, double value) {
        SDVariable ret = this.f().pow(this, value);
        return this.sameDiff.updateVariableNameAndReference(ret, varName);
    }

    public SDVariable rsubi(String varName, double sameDiffVariable) {
        SDVariable function = this.sameDiff.f().rsubi(this, sameDiffVariable);
        return this.sameDiff.updateVariableNameAndReference(function, varName);
    }

    public SDVariable rdivi(String varName, double sameDiffVariable) {
        SDVariable function = this.sameDiff.f().rdivi(this, sameDiffVariable);
        return this.sameDiff.updateVariableNameAndReference(function, varName);
    }

    public SDVariable addi(String varName, double sameDiffVariable) {
        SDVariable function = this.sameDiff.f().addi(this, sameDiffVariable);
        return this.sameDiff.updateVariableNameAndReference(function, varName);
    }

    public SDVariable subi(String varName, double sameDiffVariable) {
        SDVariable function = this.sameDiff.f().subi(this, sameDiffVariable);
        return this.sameDiff.updateVariableNameAndReference(function, varName);
    }

    public SDVariable divi(String varName, double sameDiffVariable) {
        SDVariable function = this.sameDiff.f().divi(this, sameDiffVariable);
        return this.sameDiff.updateVariableNameAndReference(function, varName);
    }

    public SDVariable muli(String varName, double sameDiffVariable) {
        SDVariable function = this.sameDiff.f().muli(this, sameDiffVariable);
        return this.sameDiff.updateVariableNameAndReference(function, varName);
    }

    public SDVariable rsub(String varName, SDVariable sameDiffVariable) {
        this.assertShapeEquals(sameDiffVariable);
        SDVariable result = this.sameDiff.f().rsub(this, sameDiffVariable);
        return this.sameDiff.updateVariableNameAndReference(result, varName);
    }

    public SDVariable rdiv(String varName, SDVariable sameDiffVariable) {
        this.assertShapeEquals(sameDiffVariable);
        SDVariable result = this.sameDiff.f().rdiv(this, sameDiffVariable);
        return this.sameDiff.updateVariableNameAndReference(result, varName);
    }

    public SDVariable add(String varName, SDVariable sameDiffVariable) {
        this.assertShapeEquals(sameDiffVariable);
        SDVariable result = this.sameDiff.f().add(this, sameDiffVariable);
        return this.sameDiff.updateVariableNameAndReference(result, varName);
    }

    public SDVariable sub(String varName, SDVariable sameDiffVariable) {
        this.assertShapeEquals(sameDiffVariable);
        SDVariable left = this;
        SDVariable right = sameDiffVariable;
        SDVariable result = this.sameDiff.f().sub(left, right);
        return this.sameDiff.updateVariableNameAndReference(result, varName);
    }

    public SDVariable squaredDifference(String varName, SDVariable sameDiffVariable) {
        this.assertShapeEquals(sameDiffVariable);
        SDVariable left = this;
        SDVariable right = sameDiffVariable;
        SDVariable result = this.sameDiff.f().squaredDifference(left, right);
        return this.sameDiff.updateVariableNameAndReference(result, varName);
    }

    public SDVariable div(String varName, SDVariable sameDiffVariable) {
        this.assertShapeEquals(sameDiffVariable);
        SDVariable result = this.sameDiff.f().div(this, sameDiffVariable);
        return this.sameDiff.updateVariableNameAndReference(result, varName);
    }

    public SDVariable mul(String varName, SDVariable sameDiffVariable) {
        this.assertShapeEquals(sameDiffVariable);
        SDVariable left = this;
        SDVariable right = sameDiffVariable;
        Preconditions.checkNotNull((Object)left, (String)"Left input is null!");
        Preconditions.checkNotNull((Object)right, (String)"Right input is null!");
        SDVariable result = this.sameDiff.f().mul(left, right);
        return this.sameDiff.updateVariableNameAndReference(result, varName);
    }

    public SDVariable rsubi(String varName, SDVariable sameDiffVariable) {
        this.assertShapeEquals(sameDiffVariable);
        SDVariable result = this.sameDiff.f().rsubi(this, sameDiffVariable);
        return this.sameDiff.updateVariableNameAndReference(result, varName);
    }

    public SDVariable rdivi(String varName, SDVariable sameDiffVariable) {
        this.assertShapeEquals(sameDiffVariable);
        SDVariable result = this.sameDiff.f().rdivi(this, sameDiffVariable);
        return this.sameDiff.updateVariableNameAndReference(result, varName);
    }

    public SDVariable addi(String varName, SDVariable sameDiffVariable) {
        this.assertShapeEquals(sameDiffVariable);
        SDVariable result = this.sameDiff.f().addi(this, sameDiffVariable);
        return this.sameDiff.updateVariableNameAndReference(result, varName);
    }

    @Override
    public Op.Type opType() {
        return Op.Type.RETURN;
    }

    public SDVariable subi(String varName, SDVariable sameDiffVariable) {
        this.assertShapeEquals(sameDiffVariable);
        SDVariable left = this;
        SDVariable right = sameDiffVariable;
        SDVariable result = this.sameDiff.f().subi(left, right);
        return this.sameDiff.updateVariableNameAndReference(result, varName);
    }

    public SDVariable divi(String varName, SDVariable sameDiffVariable) {
        this.assertShapeEquals(sameDiffVariable);
        SDVariable result = this.sameDiff.f().divi(this, sameDiffVariable);
        result.setVarName(varName);
        return result;
    }

    public SDVariable muli(String varName, SDVariable sameDiffVariable) {
        this.assertShapeEquals(sameDiffVariable);
        SDVariable left = this;
        SDVariable right = sameDiffVariable;
        SDVariable result = this.sameDiff.f().muli(left, right);
        result.setVarName(varName);
        return result;
    }

    public SDVariable sum(int ... dimensions) {
        return this.sum(null, dimensions);
    }

    public SDVariable sum(boolean keepDims, int ... dimensions) {
        return this.sum(null, keepDims, dimensions);
    }

    public SDVariable sum(String name, int ... dimensions) {
        return this.sum(name, false, dimensions);
    }

    public SDVariable sum(String name, boolean keepDims, int ... dimensions) {
        return this.sameDiff.sum(name, this, keepDims, dimensions);
    }

    public SDVariable mean(boolean keepDims, int ... dimensions) {
        return this.mean(null, keepDims, dimensions);
    }

    public SDVariable mean(String name, int ... dimensions) {
        return this.mean(name, false, dimensions);
    }

    public SDVariable mean(int ... dimensions) {
        return this.mean(null, false, dimensions);
    }

    public SDVariable mean(String name, boolean keepDims, int ... dimensions) {
        return this.sameDiff.mean(name, this, keepDims, dimensions);
    }

    public SDVariable std(boolean biasCorrected, int ... dimensions) {
        return this.std(null, biasCorrected, dimensions);
    }

    public SDVariable std(String name, boolean biasCorrected, int ... dimensions) {
        return this.sameDiff.standardDeviation(name, this, biasCorrected, dimensions);
    }

    public SDVariable std(String name, boolean biasCorrected, boolean keepDims, int ... dimensions) {
        return this.sameDiff.standardDeviation(name, this, biasCorrected, keepDims, dimensions);
    }

    public SDVariable prod(int ... dimensions) {
        return this.prod(null, dimensions);
    }

    public SDVariable prod(boolean keepDims, int ... dimensions) {
        return this.prod(null, keepDims, dimensions);
    }

    public SDVariable prod(String name, int ... dimensions) {
        return this.sameDiff.prod(name, this, dimensions);
    }

    public SDVariable prod(String name, boolean keepDims, int ... dimensions) {
        return this.sameDiff.prod(name, this, keepDims, dimensions);
    }

    public SDVariable min(int ... dimensions) {
        return this.min(null, dimensions);
    }

    public SDVariable min(boolean keepDims, int ... dimensions) {
        return this.min(null, keepDims, dimensions);
    }

    public SDVariable min(String name, int ... dimensions) {
        return this.min(name, false, dimensions);
    }

    public SDVariable min(String name, boolean keepDims, int ... dimensions) {
        return this.sameDiff.min(name, this, keepDims, dimensions);
    }

    public SDVariable max(int ... dimensions) {
        return this.max(null, dimensions);
    }

    public SDVariable max(boolean keepDims, int ... dimensions) {
        return this.max(null, keepDims, dimensions);
    }

    public SDVariable max(String name, int ... dimensions) {
        return this.max(name, false, dimensions);
    }

    public SDVariable max(String name, boolean keepDims, int ... dimensions) {
        return this.sameDiff.max(name, this, keepDims, dimensions);
    }

    public SDVariable norm1(int ... dimensions) {
        return this.norm1(null, dimensions);
    }

    public SDVariable norm1(boolean keepDims, int ... dimensions) {
        return this.norm1(null, keepDims, dimensions);
    }

    public SDVariable norm1(String name, int ... dimensions) {
        return this.norm1(name, false, dimensions);
    }

    public SDVariable norm1(String name, boolean keepDims, int ... dimensions) {
        return this.sameDiff.norm1(name, this, keepDims, dimensions);
    }

    public SDVariable norm2(int ... dimensions) {
        return this.norm2(null, dimensions);
    }

    public SDVariable norm2(boolean keepDims, int ... dimensions) {
        return this.norm2(null, keepDims, dimensions);
    }

    public SDVariable norm2(String name, int ... dimensions) {
        return this.norm2(name, false, dimensions);
    }

    public SDVariable norm2(String name, boolean keepDims, int ... dimensions) {
        return this.sameDiff.norm2(name, this, keepDims, dimensions);
    }

    public SDVariable normmax(int ... dimensions) {
        return this.normmax(null, dimensions);
    }

    public SDVariable normmax(boolean keepDims, int ... dimensions) {
        return this.normmax(null, keepDims, dimensions);
    }

    public SDVariable normmax(String name, int ... dimensions) {
        return this.normmax(name, false, dimensions);
    }

    public SDVariable normmax(String name, boolean keepDims, int ... dimensions) {
        return this.sameDiff.normmax(name, this, keepDims, dimensions);
    }

    public SDVariable argmax(int ... dimensions) {
        return this.argmax(null, dimensions);
    }

    public SDVariable argmax(String name, int ... dimensions) {
        return this.sameDiff.argmax(name, this, dimensions);
    }

    public SDVariable argmin(int ... dimensions) {
        return this.argmin(null, dimensions);
    }

    public SDVariable argmin(String name, int ... dimensions) {
        return this.sameDiff.argmin(name, this, dimensions);
    }

    public SDVariable setArray(INDArray array) {
        this.sameDiff.associateArrayWithVariable(array, this);
        return this;
    }

    public INDArray eval() {
        this.sameDiff.exec();
        return this.getArr();
    }

    private void assertShapeEquals(SDVariable variable) {
    }

    @Override
    public String toString() {
        return this.varName;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SDVariable that = (SDVariable)o;
        if (this.varName != null ? !this.varName.equals(that.varName) : that.varName != null) {
            return false;
        }
        return this.weightInitScheme != null ? this.weightInitScheme.equals(that.weightInitScheme) : that.weightInitScheme == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.varName != null ? this.varName.hashCode() : 0);
        result = 31 * result + (this.weightInitScheme != null ? this.weightInitScheme.hashCode() : 0);
        return result;
    }

    @Override
    public String onnxName() {
        throw new NoOpNameFoundException("No onnx op opName found for " + this.opName());
    }

    @Override
    public String tensorflowName() {
        throw new NoOpNameFoundException("No tensorflow op opName found for " + this.opName());
    }

    public SDVariable get(SDIndex ... indices) {
        int ndims = indices.length;
        long[] begin = new long[ndims];
        long[] end = new long[ndims];
        long[] strides = new long[ndims];
        int[] begin_mask_arr = new int[ndims];
        int[] end_mask_arr = new int[ndims];
        int[] shrink_axis_mask_arr = new int[ndims];
        for (int i = 0; i < ndims; ++i) {
            strides[i] = 1L;
            SDIndex index = indices[i];
            SDIndex.IndexType indexType = index.getIndexType();
            if (indexType == SDIndex.IndexType.ALL) {
                begin_mask_arr[i] = 1;
                end_mask_arr[i] = 1;
                continue;
            }
            if (indexType == SDIndex.IndexType.POINT) {
                long pointIndex;
                begin[i] = pointIndex = index.getPointIndex();
                end[i] = pointIndex + 1L;
                shrink_axis_mask_arr[i] = 1;
                continue;
            }
            if (indexType != SDIndex.IndexType.INTERVAL) continue;
            if (index.getIntervalBegin() == null) {
                begin_mask_arr[i] = 1;
            } else {
                begin[i] = index.getIntervalBegin();
            }
            if (index.getIntervalEnd() == null) {
                end_mask_arr[i] = 1;
            } else {
                end[i] = index.getIntervalEnd();
            }
            strides[i] = index.getIntervalStrides() == null ? 1L : index.getIntervalStrides();
        }
        int begin_mask = SDVariable.binArrToInt(begin_mask_arr);
        int end_mask = SDVariable.binArrToInt(end_mask_arr);
        int shrink_axis = SDVariable.binArrToInt(shrink_axis_mask_arr);
        return this.sameDiff.stridedSlice(this, begin, end, strides, begin_mask, end_mask, 0, 0, shrink_axis);
    }

    private static int binArrToInt(int[] arr) {
        int x = 0;
        int m = 1;
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i] == 1) {
                x += m;
            }
            m *= 2;
        }
        return x;
    }

    public static SDVariableBuilder builder() {
        return new SDVariableBuilder();
    }

    public int getOutputIndex() {
        return this.outputIndex;
    }

    public DifferentialFunction getCreator() {
        return this.creator;
    }

    public void setOutputIndex(int outputIndex) {
        this.outputIndex = outputIndex;
    }

    public void setCreator(DifferentialFunction creator) {
        this.creator = creator;
    }

    public SDVariable() {
    }

    public String getVarName() {
        return this.varName;
    }

    public void setVarName(String varName) {
        this.varName = varName;
    }

    public WeightInitScheme getWeightInitScheme() {
        return this.weightInitScheme;
    }

    public void setWeightInitScheme(WeightInitScheme weightInitScheme) {
        this.weightInitScheme = weightInitScheme;
    }

    public static class SDVariableBuilder {
        private String varName;
        private SameDiff sameDiff;
        private long[] shape;
        private WeightInitScheme weightInitScheme;

        SDVariableBuilder() {
        }

        public SDVariableBuilder varName(String varName) {
            this.varName = varName;
            return this;
        }

        public SDVariableBuilder sameDiff(SameDiff sameDiff) {
            this.sameDiff = sameDiff;
            return this;
        }

        public SDVariableBuilder shape(long[] shape) {
            this.shape = shape;
            return this;
        }

        public SDVariableBuilder weightInitScheme(WeightInitScheme weightInitScheme) {
            this.weightInitScheme = weightInitScheme;
            return this;
        }

        public SDVariable build() {
            return new SDVariable(this.varName, this.sameDiff, this.shape, this.weightInitScheme);
        }

        public String toString() {
            return "SDVariable.SDVariableBuilder(varName=" + this.varName + ", sameDiff=" + this.sameDiff + ", shape=" + Arrays.toString(this.shape) + ", weightInitScheme=" + this.weightInitScheme + ")";
        }
    }
}

