/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.weightinit.impl;

import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.weightinit.BaseWeightInitScheme;
import org.nd4j.weightinit.WeightInit;

public class VarScalingNormalUniformFanInInitScheme
extends BaseWeightInitScheme {
    private double fanIn;

    public VarScalingNormalUniformFanInInitScheme(char order, double fanIn) {
        super(order);
        this.fanIn = fanIn;
    }

    @Override
    public INDArray doCreate(int[] shape, INDArray paramsView) {
        double scalingFanIn = 3.0 / Math.sqrt(this.fanIn);
        return Nd4j.rand(shape, Nd4j.getDistributions().createUniform(-scalingFanIn, scalingFanIn));
    }

    @Override
    public WeightInit type() {
        return WeightInit.VAR_SCALING_UNIFORM_FAN_IN;
    }

    public static VarScalingNormalUniformFanInInitSchemeBuilder builder() {
        return new VarScalingNormalUniformFanInInitSchemeBuilder();
    }

    public static class VarScalingNormalUniformFanInInitSchemeBuilder {
        private char order;
        private double fanIn;

        VarScalingNormalUniformFanInInitSchemeBuilder() {
        }

        public VarScalingNormalUniformFanInInitSchemeBuilder order(char order) {
            this.order = order;
            return this;
        }

        public VarScalingNormalUniformFanInInitSchemeBuilder fanIn(double fanIn) {
            this.fanIn = fanIn;
            return this;
        }

        public VarScalingNormalUniformFanInInitScheme build() {
            return new VarScalingNormalUniformFanInInitScheme(this.order, this.fanIn);
        }

        public String toString() {
            return "VarScalingNormalUniformFanInInitScheme.VarScalingNormalUniformFanInInitSchemeBuilder(order=" + this.order + ", fanIn=" + this.fanIn + ")";
        }
    }
}

