/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.random.impl;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.imports.NoOpNameFoundException;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.random.BaseRandomOp;

public class AlphaDropOut
extends BaseRandomOp {
    private double p;
    private double a;
    private double alphaPrime;
    private double b;

    public AlphaDropOut() {
    }

    public AlphaDropOut(@NonNull INDArray x, double p, double alpha, double alphaPrime, double beta) {
        this(x, x, p, alpha, alphaPrime, beta, x.lengthLong());
        if (x == null) {
            throw new NullPointerException("x");
        }
    }

    public AlphaDropOut(@NonNull INDArray x, @NonNull INDArray z, double p, double alpha, double alphaPrime, double beta) {
        this(x, z, p, alpha, alphaPrime, beta, x.lengthLong());
        if (x == null) {
            throw new NullPointerException("x");
        }
        if (z == null) {
            throw new NullPointerException("z");
        }
    }

    public AlphaDropOut(@NonNull INDArray x, @NonNull INDArray z, double p, double alpha, double alphaPrime, double beta, long n) {
        if (x == null) {
            throw new NullPointerException("x");
        }
        if (z == null) {
            throw new NullPointerException("z");
        }
        this.p = p;
        this.a = alpha;
        this.b = beta;
        this.alphaPrime = alphaPrime;
        this.init(x, null, z, n);
    }

    @Override
    public Map<String, Object> propertiesForFunction() {
        LinkedHashMap<String, Object> ret = new LinkedHashMap<String, Object>();
        ret.put("p", this.p);
        ret.put("a", this.a);
        ret.put("alphaPrime", this.alphaPrime);
        ret.put("b", this.b);
        return ret;
    }

    @Override
    public int opNum() {
        return 12;
    }

    @Override
    public String opName() {
        return "alpha_dropout";
    }

    @Override
    public void init(INDArray x, INDArray y, INDArray z, long n) {
        super.init(x, y, z, n);
        this.extraArgs = new Object[]{this.p, this.a, this.b, this.alphaPrime};
    }

    @Override
    public String onnxName() {
        throw new NoOpNameFoundException("No onnx op opName found for " + this.opName());
    }

    @Override
    public String tensorflowName() {
        throw new NoOpNameFoundException("No tensorflow op opName found for " + this.opName());
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> f1) {
        return null;
    }
}

