/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.shape;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.imports.descriptors.properties.PropertyMapping;
import org.nd4j.imports.graphmapper.tf.TFGraphMapper;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.util.ArrayUtil;
import org.tensorflow.framework.AttrValue;
import org.tensorflow.framework.GraphDef;
import org.tensorflow.framework.NodeDef;

public class Tile
extends DynamicCustomOp {
    private int[] axis;
    private boolean is_static_reps = false;

    public Tile(SameDiff sameDiff, SDVariable i_v, int[] axis) {
        super(null, sameDiff, new SDVariable[]{i_v}, false);
        this.axis = axis;
        this.addArguments();
    }

    public Tile() {
    }

    private void addArguments() {
        this.is_static_reps = true;
        this.addIArgument(this.axis);
    }

    @Override
    public void initFromTensorFlow(NodeDef nodeDef, SameDiff initWith, Map<String, AttrValue> attributesForNode, GraphDef graph) {
        NodeDef lastNode = TFGraphMapper.getInstance().getNodeWithNameFromGraph(graph, nodeDef.getInput(nodeDef.getInputCount() - 1));
        INDArray arr = TFGraphMapper.getInstance().getNDArrayFromTensor("value", lastNode, graph);
        if (arr != null) {
            this.axis = arr.data().asInt();
            this.addArguments();
        }
    }

    @Override
    public Map<String, Object> propertiesForFunction() {
        LinkedHashMap<String, Object> ret = new LinkedHashMap<String, Object>();
        ret.put("axis", this.axis);
        return ret;
    }

    @Override
    public void resolvePropertiesFromSameDiffBeforeExecution() {
        this.populateInputsAndOutputsFromSameDiff();
    }

    @Override
    public Map<String, Map<String, PropertyMapping>> mappingsForFunction() {
        HashMap<String, Map<String, PropertyMapping>> ret = new HashMap<String, Map<String, PropertyMapping>>();
        HashMap<String, PropertyMapping> map = new HashMap<String, PropertyMapping>();
        PropertyMapping axisMapping = PropertyMapping.builder().onnxAttrName("axis").tfInputPosition(-1).propertyNames(new String[]{"axis"}).build();
        map.put("axis", axisMapping);
        ret.put(this.tensorflowName(), map);
        ret.put(this.onnxName(), map);
        return ret;
    }

    @Override
    public List<int[]> calculateOutputShape() {
        if (this.is_static_reps) {
            return Nd4j.getExecutioner().calculateOutputShape(this);
        }
        if (this.inputArguments().length < 2) {
            return Collections.emptyList();
        }
        INDArray array = this.inputArguments()[1];
        int[] reps = new int[array.length()];
        for (int e = 0; e < reps.length; ++e) {
            reps[e] = (int)array.getDouble(e);
        }
        if (ArrayUtil.prod((int[])reps) == 0) {
            return Collections.emptyList();
        }
        return Nd4j.getExecutioner().calculateOutputShape(this);
    }

    @Override
    public String opName() {
        return "tile";
    }

    @Override
    public String onnxName() {
        return "Tile";
    }

    @Override
    public String tensorflowName() {
        return "Tile";
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> i_v) {
        throw new UnsupportedOperationException();
    }
}

