/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.ops.transforms;

import lombok.NonNull;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.ScalarOp;
import org.nd4j.linalg.api.ops.TransformOp;
import org.nd4j.linalg.api.ops.impl.accum.distances.CosineSimilarity;
import org.nd4j.linalg.api.ops.impl.scalar.ScalarMax;
import org.nd4j.linalg.api.ops.impl.scalar.ScalarMin;
import org.nd4j.linalg.api.ops.impl.transforms.ACos;
import org.nd4j.linalg.api.ops.impl.transforms.ASin;
import org.nd4j.linalg.api.ops.impl.transforms.ATan;
import org.nd4j.linalg.api.ops.impl.transforms.Abs;
import org.nd4j.linalg.api.ops.impl.transforms.Ceil;
import org.nd4j.linalg.api.ops.impl.transforms.Cos;
import org.nd4j.linalg.api.ops.impl.transforms.Exp;
import org.nd4j.linalg.api.ops.impl.transforms.Floor;
import org.nd4j.linalg.api.ops.impl.transforms.HardTanh;
import org.nd4j.linalg.api.ops.impl.transforms.Identity;
import org.nd4j.linalg.api.ops.impl.transforms.LeakyReLU;
import org.nd4j.linalg.api.ops.impl.transforms.Log;
import org.nd4j.linalg.api.ops.impl.transforms.Negative;
import org.nd4j.linalg.api.ops.impl.transforms.Pow;
import org.nd4j.linalg.api.ops.impl.transforms.RectifedLinear;
import org.nd4j.linalg.api.ops.impl.transforms.Round;
import org.nd4j.linalg.api.ops.impl.transforms.Sigmoid;
import org.nd4j.linalg.api.ops.impl.transforms.Sign;
import org.nd4j.linalg.api.ops.impl.transforms.Sin;
import org.nd4j.linalg.api.ops.impl.transforms.SoftPlus;
import org.nd4j.linalg.api.ops.impl.transforms.Sqrt;
import org.nd4j.linalg.api.ops.impl.transforms.Stabilize;
import org.nd4j.linalg.api.ops.impl.transforms.Tanh;
import org.nd4j.linalg.api.ops.impl.transforms.comparison.Eps;
import org.nd4j.linalg.api.ops.impl.transforms.comparison.GreaterThanOrEqual;
import org.nd4j.linalg.api.ops.impl.transforms.comparison.LessThanOrEqual;
import org.nd4j.linalg.api.ops.impl.transforms.comparison.Max;
import org.nd4j.linalg.api.ops.impl.transforms.comparison.Min;
import org.nd4j.linalg.factory.Nd4j;

public class Transforms {
    private Transforms() {
    }

    public static double cosineSim(@NonNull INDArray d1, @NonNull INDArray d2) {
        if (d1 == null) {
            throw new NullPointerException("d1");
        }
        if (d2 == null) {
            throw new NullPointerException("d2");
        }
        return Nd4j.getExecutioner().execAndReturn(new CosineSimilarity(d1, d2, d1.length())).getFinalResult().doubleValue();
    }

    public static double manhattanDistance(@NonNull INDArray d1, @NonNull INDArray d2) {
        if (d1 == null) {
            throw new NullPointerException("d1");
        }
        if (d2 == null) {
            throw new NullPointerException("d2");
        }
        return d1.distance1(d2);
    }

    public static double euclideanDistance(@NonNull INDArray d1, @NonNull INDArray d2) {
        if (d1 == null) {
            throw new NullPointerException("d1");
        }
        if (d2 == null) {
            throw new NullPointerException("d2");
        }
        return d1.distance2(d2);
    }

    public static INDArray normalizeZeroMeanAndUnitVariance(INDArray toNormalize) {
        INDArray columnMeans = toNormalize.mean(0);
        INDArray columnStds = toNormalize.std(0);
        toNormalize.subiRowVector(columnMeans);
        columnStds.addi(Nd4j.EPS_THRESHOLD);
        toNormalize.diviRowVector(columnStds);
        return toNormalize;
    }

    public static INDArray unitVec(INDArray toScale) {
        double length = toScale.norm2Number().doubleValue();
        if (length > 0.0) {
            if (toScale.data().dataType() == DataBuffer.Type.FLOAT) {
                return Nd4j.getBlasWrapper().scal(1.0f / (float)length, toScale);
            }
            return Nd4j.getBlasWrapper().scal(1.0 / length, toScale);
        }
        return toScale;
    }

    public static INDArray neg(INDArray ndArray) {
        return Transforms.neg(ndArray, Nd4j.copyOnOps);
    }

    public static INDArray floor(INDArray ndArray) {
        return Transforms.floor(ndArray, Nd4j.copyOnOps);
    }

    public static INDArray ceiling(INDArray ndArray) {
        return Transforms.ceiling(ndArray, Nd4j.copyOnOps);
    }

    public static INDArray ceiling(INDArray ndArray, boolean copyOnOps) {
        return Transforms.exec(copyOnOps ? new Ceil(ndArray, ndArray.dup()) : new Ceil(ndArray, ndArray));
    }

    public static INDArray sign(INDArray toSign) {
        return Transforms.sign(toSign, Nd4j.copyOnOps);
    }

    public static INDArray stabilize(INDArray ndArray, double k) {
        return Transforms.stabilize(ndArray, k, Nd4j.copyOnOps);
    }

    public static INDArray sin(INDArray in) {
        return Transforms.sin(in, Nd4j.copyOnOps);
    }

    public static INDArray sin(INDArray in, boolean copy) {
        return Nd4j.getExecutioner().execAndReturn(new Sin(copy ? in.dup() : in));
    }

    public static INDArray cos(INDArray in) {
        return Transforms.cos(in, Nd4j.copyOnOps);
    }

    public static INDArray cos(INDArray in, boolean copy) {
        return Nd4j.getExecutioner().execAndReturn(new Cos(copy ? in.dup() : in));
    }

    public static INDArray acos(INDArray arr) {
        return Transforms.acos(arr, Nd4j.copyOnOps);
    }

    public static INDArray acos(INDArray in, boolean copy) {
        return Nd4j.getExecutioner().execAndReturn(new ACos(copy ? in.dup() : in));
    }

    public static INDArray asin(INDArray arr) {
        return Transforms.asin(arr, Nd4j.copyOnOps);
    }

    public static INDArray asin(INDArray in, boolean copy) {
        return Nd4j.getExecutioner().execAndReturn(new ASin(copy ? in.dup() : in));
    }

    public static INDArray atan(INDArray arr) {
        return Transforms.atan(arr, Nd4j.copyOnOps);
    }

    public static INDArray atan(INDArray in, boolean copy) {
        return Nd4j.getExecutioner().execAndReturn(new ATan(copy ? in.dup() : in));
    }

    public static INDArray ceil(INDArray arr) {
        return Transforms.ceil(arr, Nd4j.copyOnOps);
    }

    public static INDArray ceil(INDArray in, boolean copy) {
        return Nd4j.getExecutioner().execAndReturn(new Ceil(copy ? in.dup() : in));
    }

    public static INDArray relu(INDArray arr) {
        return Transforms.relu(arr, Nd4j.copyOnOps);
    }

    public static INDArray relu(INDArray in, boolean copy) {
        return Nd4j.getExecutioner().execAndReturn(new RectifedLinear(copy ? in.dup() : in));
    }

    public static INDArray leakyRelu(INDArray arr) {
        return Transforms.leakyRelu(arr, Nd4j.copyOnOps);
    }

    public static INDArray leakyRelu(INDArray in, boolean copy) {
        return Nd4j.getExecutioner().execAndReturn(new LeakyReLU(copy ? in.dup() : in));
    }

    public static INDArray softPlus(INDArray arr) {
        return Transforms.softPlus(arr, Nd4j.copyOnOps);
    }

    public static INDArray softPlus(INDArray in, boolean copy) {
        return Nd4j.getExecutioner().execAndReturn(new SoftPlus(copy ? in.dup() : in));
    }

    public static INDArray abs(INDArray ndArray) {
        return Transforms.abs(ndArray, true);
    }

    public static INDArray exp(INDArray ndArray) {
        return Transforms.exp(ndArray, Nd4j.copyOnOps);
    }

    public static INDArray hardTanh(INDArray ndArray) {
        return Transforms.hardTanh(ndArray, Nd4j.copyOnOps);
    }

    public static INDArray identity(INDArray ndArray) {
        return Transforms.identity(ndArray, Nd4j.copyOnOps);
    }

    public static INDArray pow(INDArray ndArray, Number power) {
        return Transforms.pow(ndArray, power, Nd4j.copyOnOps);
    }

    public static INDArray round(INDArray ndArray) {
        return Transforms.round(ndArray, Nd4j.copyOnOps);
    }

    public static INDArray sigmoid(INDArray ndArray) {
        return Transforms.sigmoid(ndArray, Nd4j.copyOnOps);
    }

    public static INDArray sqrt(INDArray ndArray) {
        return Transforms.sqrt(ndArray, Nd4j.copyOnOps);
    }

    public static INDArray tanh(INDArray ndArray) {
        return Transforms.tanh(ndArray, Nd4j.copyOnOps);
    }

    public static INDArray log(INDArray ndArray) {
        return Transforms.log(ndArray, Nd4j.copyOnOps);
    }

    public static INDArray eps(INDArray ndArray) {
        return Transforms.eps(ndArray, Nd4j.copyOnOps);
    }

    public static INDArray greaterThanOrEqual(INDArray first, INDArray ndArray) {
        return Transforms.greaterThanOrEqual(first, ndArray, Nd4j.copyOnOps);
    }

    public static INDArray lessThanOrEqual(INDArray first, INDArray ndArray) {
        return Transforms.lessThanOrEqual(first, ndArray, Nd4j.copyOnOps);
    }

    public static INDArray lessThanOrEqual(INDArray first, INDArray ndArray, boolean dup) {
        return Transforms.exec(dup ? new LessThanOrEqual(first.dup(), ndArray) : new LessThanOrEqual(first, ndArray));
    }

    public static INDArray greaterThanOrEqual(INDArray first, INDArray ndArray, boolean dup) {
        return Transforms.exec(dup ? new GreaterThanOrEqual(first.dup(), ndArray) : new GreaterThanOrEqual(first, ndArray));
    }

    public static INDArray eps(INDArray ndArray, boolean dup) {
        return Transforms.exec(dup ? new Eps(ndArray.dup()) : new Eps(ndArray));
    }

    public static INDArray floor(INDArray ndArray, boolean dup) {
        return Transforms.exec(dup ? new Floor(ndArray.dup()) : new Floor(ndArray));
    }

    public static INDArray sign(INDArray toSign, boolean dup) {
        return Transforms.exec(dup ? new Sign(toSign, toSign.dup()) : new Sign(toSign));
    }

    public static INDArray max(INDArray ndArray, double k, boolean dup) {
        return Transforms.exec(dup ? new ScalarMax(ndArray.dup(), k) : new ScalarMax(ndArray, k));
    }

    public static INDArray max(INDArray ndArray, double k) {
        return Transforms.max(ndArray, k, Nd4j.copyOnOps);
    }

    public static INDArray max(INDArray first, INDArray second, boolean dup) {
        if (dup) {
            first = first.dup();
        }
        return Transforms.exec(new Max(second, first, first, first.length()));
    }

    public static INDArray max(INDArray first, INDArray second) {
        return Transforms.max(first, second, Nd4j.copyOnOps);
    }

    public static INDArray min(INDArray ndArray, double k, boolean dup) {
        return Transforms.exec(dup ? new ScalarMin(ndArray.dup(), k) : new ScalarMin(ndArray, k));
    }

    public static INDArray min(INDArray ndArray, double k) {
        return Transforms.min(ndArray, k, Nd4j.copyOnOps);
    }

    public static INDArray min(INDArray first, INDArray second, boolean dup) {
        if (dup) {
            first = first.dup();
        }
        return Transforms.exec(new Min(second, first, first, first.length()));
    }

    public static INDArray min(INDArray first, INDArray second) {
        return Transforms.min(first, second, Nd4j.copyOnOps);
    }

    public static INDArray stabilize(INDArray ndArray, double k, boolean dup) {
        return Transforms.exec(dup ? new Stabilize(ndArray, ndArray.dup(), k) : new Stabilize(ndArray, k));
    }

    public static INDArray abs(INDArray ndArray, boolean dup) {
        return Transforms.exec(dup ? new Abs(ndArray, ndArray.dup()) : new Abs(ndArray));
    }

    public static INDArray exp(INDArray ndArray, boolean dup) {
        return Transforms.exec(dup ? new Exp(ndArray, ndArray.dup()) : new Exp(ndArray));
    }

    public static INDArray hardTanh(INDArray ndArray, boolean dup) {
        return Transforms.exec(dup ? new HardTanh(ndArray, ndArray.dup()) : new HardTanh(ndArray));
    }

    public static INDArray identity(INDArray ndArray, boolean dup) {
        return Transforms.exec(dup ? new Identity(ndArray, ndArray.dup()) : new Identity(ndArray));
    }

    public static INDArray pow(INDArray ndArray, Number power, boolean dup) {
        return Transforms.exec(dup ? new Pow(ndArray, ndArray.dup(), power.doubleValue()) : new Pow(ndArray, power.doubleValue()));
    }

    public static INDArray round(INDArray ndArray, boolean dup) {
        return Transforms.exec(dup ? new Round(ndArray, ndArray.dup()) : new Round(ndArray));
    }

    public static INDArray sigmoid(INDArray ndArray, boolean dup) {
        return Transforms.exec(dup ? new Sigmoid(ndArray, ndArray.dup()) : new Sigmoid(ndArray));
    }

    public static INDArray sqrt(INDArray ndArray, boolean dup) {
        return Transforms.exec(dup ? new Sqrt(ndArray, ndArray.dup()) : new Sqrt(ndArray));
    }

    public static INDArray tanh(INDArray ndArray, boolean dup) {
        return Transforms.exec(dup ? new Tanh(ndArray, ndArray.dup()) : new Tanh(ndArray));
    }

    public static INDArray log(INDArray ndArray, boolean dup) {
        return Transforms.exec(dup ? new Log(ndArray, ndArray.dup()) : new Log(ndArray));
    }

    public static INDArray neg(INDArray ndArray, boolean dup) {
        return Transforms.exec(dup ? new Negative(ndArray, ndArray.dup()) : new Negative(ndArray));
    }

    private static INDArray exec(ScalarOp op) {
        if (op.x().isCleanedUp()) {
            throw new IllegalStateException("NDArray already freed");
        }
        return Nd4j.getExecutioner().exec(op).z();
    }

    private static INDArray exec(TransformOp op) {
        if (op.x().isCleanedUp()) {
            throw new IllegalStateException("NDArray already freed");
        }
        return Nd4j.getExecutioner().execAndReturn(op);
    }
}

