/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.dataset.api.iterator.fetcher;

import java.util.List;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.dataset.DataSet;
import org.nd4j.linalg.dataset.api.iterator.fetcher.DataSetFetcher;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.util.FeatureUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseDataFetcher
implements DataSetFetcher {
    protected static final Logger log = LoggerFactory.getLogger(BaseDataFetcher.class);
    private static final long serialVersionUID = -859588773699432365L;
    protected int cursor = 0;
    protected int numOutcomes = -1;
    protected int inputColumns = -1;
    protected DataSet curr;
    protected int totalExamples;

    protected INDArray createInputMatrix(int numRows) {
        return Nd4j.create(numRows, this.inputColumns);
    }

    protected INDArray createOutputVector(int outcomeLabel) {
        return FeatureUtil.toOutcomeVector(outcomeLabel, this.numOutcomes);
    }

    protected INDArray createOutputMatrix(int numRows) {
        return Nd4j.create(numRows, this.numOutcomes);
    }

    protected void initializeCurrFromList(List<DataSet> examples) {
        if (examples.isEmpty()) {
            log.warn("Warning: empty dataset from the fetcher");
        }
        INDArray inputs = this.createInputMatrix(examples.size());
        INDArray labels = this.createOutputMatrix(examples.size());
        for (int i = 0; i < examples.size(); ++i) {
            inputs.putRow(i, examples.get(i).getFeatureMatrix());
            labels.putRow(i, examples.get(i).getLabels());
        }
        this.curr = new DataSet(inputs, labels);
    }

    @Override
    public boolean hasMore() {
        return this.cursor < this.totalExamples;
    }

    @Override
    public DataSet next() {
        return this.curr;
    }

    @Override
    public int totalOutcomes() {
        return this.numOutcomes;
    }

    @Override
    public int inputColumns() {
        return this.inputColumns;
    }

    @Override
    public int totalExamples() {
        return this.totalExamples;
    }

    @Override
    public void reset() {
        this.cursor = 0;
    }

    @Override
    public int cursor() {
        return this.cursor;
    }
}

