/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.dataset.api.iterator.cache;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.nd4j.linalg.dataset.DataSet;
import org.nd4j.linalg.dataset.api.iterator.cache.DataSetCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryDataSetCache
implements DataSetCache {
    private static final Logger log = LoggerFactory.getLogger(DataSetCache.class);
    private Map<String, byte[]> cache = new HashMap<String, byte[]>();
    private Set<String> completeNamespaces = new HashSet<String>();

    @Override
    public boolean isComplete(String namespace) {
        return this.completeNamespaces.contains(namespace);
    }

    @Override
    public void setComplete(String namespace, boolean value) {
        if (value) {
            this.completeNamespaces.add(namespace);
        } else {
            this.completeNamespaces.remove(namespace);
        }
    }

    @Override
    public DataSet get(String key) {
        if (!this.cache.containsKey(key)) {
            return null;
        }
        byte[] data = this.cache.get(key);
        ByteArrayInputStream is = new ByteArrayInputStream(data);
        DataSet ds = new DataSet();
        ds.load(is);
        return ds;
    }

    @Override
    public void put(String key, DataSet dataSet) {
        if (this.cache.containsKey(key)) {
            log.debug("evicting key %s from data set cache", (Object)key);
            this.cache.remove(key);
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        dataSet.save(os);
        this.cache.put(key, os.toByteArray());
    }

    @Override
    public boolean contains(String key) {
        return this.cache.containsKey(key);
    }
}

