/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.transforms;

import org.apache.commons.math3.util.FastMath;
import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseTransformOp;
import org.nd4j.linalg.api.ops.Op;

public class CubeDerivative
extends BaseTransformOp {
    public CubeDerivative() {
    }

    public CubeDerivative(INDArray x, INDArray z) {
        super(x, z);
    }

    public CubeDerivative(INDArray x, INDArray z, long n) {
        super(x, z, n);
    }

    public CubeDerivative(INDArray x, INDArray y, INDArray z, long n) {
        super(x, y, z, n);
    }

    public CubeDerivative(INDArray x) {
        super(x);
    }

    @Override
    public int opNum() {
        return 50;
    }

    @Override
    public String name() {
        return "cubederivative";
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, double other) {
        throw new UnsupportedOperationException("Cube Derivative not supported on Complex Numbers");
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, float other) {
        throw new UnsupportedOperationException("Cube Derivative not supported on Complex Numbers");
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, IComplexNumber other) {
        throw new UnsupportedOperationException("Cube Derivative not supported on Complex Numbers");
    }

    @Override
    public float op(float origin, float other) {
        return (float)(3.0 * FastMath.pow((double)origin, (int)2));
    }

    @Override
    public double op(double origin, double other) {
        return 3.0 * FastMath.pow((double)origin, (int)2);
    }

    @Override
    public double op(double origin) {
        return 3.0 * FastMath.pow((double)origin, (int)2);
    }

    @Override
    public float op(float origin) {
        return (float)(3.0 * FastMath.pow((double)origin, (int)2));
    }

    @Override
    public IComplexNumber op(IComplexNumber origin) {
        throw new UnsupportedOperationException("Cube Derivative not supported on Complex Numbers");
    }

    @Override
    public Op opForDimension(int index, int dimension) {
        INDArray xAlongDimension = this.x.vectorAlongDimension(index, dimension);
        if (this.y() != null) {
            return new CubeDerivative(this.x.vectorAlongDimension(index, dimension), this.y.vectorAlongDimension(index, dimension), this.z.vectorAlongDimension(index, dimension), xAlongDimension.length());
        }
        return new CubeDerivative(this.x.vectorAlongDimension(index, dimension), this.z.vectorAlongDimension(index, dimension), xAlongDimension.length());
    }

    @Override
    public Op opForDimension(int index, int ... dimension) {
        INDArray xAlongDimension = this.x.tensorAlongDimension(index, dimension);
        if (this.y() != null) {
            return new CubeDerivative(this.x.tensorAlongDimension(index, dimension), this.y.tensorAlongDimension(index, dimension), this.z.tensorAlongDimension(index, dimension), xAlongDimension.length());
        }
        return new CubeDerivative(this.x.tensorAlongDimension(index, dimension), this.z.tensorAlongDimension(index, dimension), xAlongDimension.length());
    }
}

