/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.blas.impl;

import org.nd4j.linalg.api.blas.Lapack;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseLapack
implements Lapack {
    private static Logger logger = LoggerFactory.getLogger(BaseLapack.class);

    @Override
    public INDArray getrf(INDArray A) {
        int m = A.rows();
        int n = A.columns();
        INDArray INFO = Nd4j.createArrayFromShapeBuffer(Nd4j.getDataBufferFactory().createInt(1L), Nd4j.getShapeInfoProvider().createShapeInformation(new int[]{1, 1}));
        int mn = Math.min(m, n);
        INDArray IPIV = Nd4j.createArrayFromShapeBuffer(Nd4j.getDataBufferFactory().createInt((long)mn), Nd4j.getShapeInfoProvider().createShapeInformation(new int[]{1, mn}));
        if (A.data().dataType() == DataBuffer.Type.DOUBLE) {
            this.dgetrf(m, n, A, IPIV, INFO);
        } else if (A.data().dataType() == DataBuffer.Type.FLOAT) {
            this.sgetrf(m, n, A, IPIV, INFO);
        } else {
            throw new UnsupportedOperationException();
        }
        if (INFO.getInt(0) < 0) {
            throw new Error("Parameter #" + INFO.getInt(0) + " to getrf() was not valid");
        }
        if (INFO.getInt(0) > 0) {
            logger.warn("The matrix is singular - cannot be used for inverse op. Check L matrix at row " + INFO.getInt(0));
        }
        return IPIV;
    }

    public abstract void sgetrf(int var1, int var2, INDArray var3, INDArray var4, INDArray var5);

    public abstract void dgetrf(int var1, int var2, INDArray var3, INDArray var4, INDArray var5);

    @Override
    public void sgesvd(INDArray A, INDArray S, INDArray U, INDArray VT) {
        int m = A.rows();
        int n = A.columns();
        byte jobu = (byte)(U == null ? 78 : 65);
        byte jobvt = (byte)(VT == null ? 78 : 65);
        INDArray INFO = Nd4j.createArrayFromShapeBuffer(Nd4j.getDataBufferFactory().createInt(1L), Nd4j.getShapeInfoProvider().createShapeInformation(new int[]{1, 1}));
        if (A.data().dataType() == DataBuffer.Type.DOUBLE) {
            this.dgesvd(jobu, jobvt, m, n, A, S, U, VT, INFO);
        } else if (A.data().dataType() == DataBuffer.Type.FLOAT) {
            this.sgesvd(jobu, jobvt, m, n, A, S, U, VT, INFO);
        } else {
            throw new UnsupportedOperationException();
        }
        if (INFO.getInt(0) < 0) {
            throw new Error("Parameter #" + INFO.getInt(0) + " to gesvd() was not valid");
        }
        if (INFO.getInt(0) > 0) {
            logger.warn("The matrix contains singular elements. Check S matrix at row " + INFO.getInt(0));
        }
    }

    public abstract void sgesvd(byte var1, byte var2, int var3, int var4, INDArray var5, INDArray var6, INDArray var7, INDArray var8, INDArray var9);

    public abstract void dgesvd(byte var1, byte var2, int var3, int var4, INDArray var5, INDArray var6, INDArray var7, INDArray var8, INDArray var9);

    @Override
    public INDArray getPFactor(int M, INDArray ipiv) {
        INDArray P = Nd4j.eye(M);
        for (int i = 0; i < ipiv.length(); ++i) {
            int pivot = ipiv.getInt(i) - 1;
            if (pivot <= i) continue;
            INDArray v1 = P.getColumn(i).dup();
            INDArray v2 = P.getColumn(pivot);
            P.putColumn(i, v2);
            P.putColumn(pivot, v1);
        }
        return P;
    }

    @Override
    public INDArray getLFactor(INDArray A) {
        int m = A.rows();
        int n = A.columns();
        INDArray L = Nd4j.create(m, n);
        for (int r = 0; r < m; ++r) {
            for (int c = 0; c < n; ++c) {
                if (r > c && r < m && c < n) {
                    L.putScalar(r, c, A.getFloat(r, c));
                    continue;
                }
                if (r < c) {
                    L.putScalar(r, c, 0.0);
                    continue;
                }
                L.putScalar(r, c, 1.0);
            }
        }
        return L;
    }

    @Override
    public INDArray getUFactor(INDArray A) {
        int m = A.rows();
        int n = A.columns();
        INDArray U = Nd4j.create(n, n);
        for (int r = 0; r < n; ++r) {
            for (int c = 0; c < n; ++c) {
                if (r <= c && r < m && c < n) {
                    U.putScalar(r, c, A.getFloat(r, c));
                    continue;
                }
                U.putScalar(r, c, 0.0);
            }
        }
        return U;
    }
}

