/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.dimensionalityreduction;

import org.nd4j.linalg.api.complex.IComplexNDArray;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.eigen.Eigen;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.indexing.INDArrayIndex;
import org.nd4j.linalg.indexing.NDArrayIndex;

public class PCA {
    private PCA() {
    }

    public static INDArray pca(INDArray X, int nDims, boolean normalize) {
        if (normalize) {
            INDArray mean = X.mean(0);
            X = X.subiRowVector(mean);
        }
        INDArray C = X.size(1) < X.size(0) ? X.transpose().mmul(X) : X.mmul(X.transpose()).muli(1 / X.size(0));
        IComplexNDArray[] eigen = Eigen.eigenvectors(C);
        IComplexNDArray M = eigen[1];
        IComplexNDArray lambda = eigen[0];
        IComplexNDArray diagLambda = Nd4j.diag(lambda);
        INDArray[] sorted = Nd4j.sortWithIndices(diagLambda, 0, false);
        INDArray indices = sorted[0];
        INDArrayIndex[] indices2 = NDArrayIndex.create(indices.get(NDArrayIndex.interval(0, nDims)));
        INDArrayIndex[] rowsAndColumnIndices = new INDArrayIndex[]{NDArrayIndex.interval(0, M.rows()), indices2[0]};
        M = M.get(rowsAndColumnIndices);
        X = Nd4j.createComplex(X.subRowVector(X.mean(0))).mmul(M);
        return X;
    }
}

