/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.dataset.api.iterator;

import java.util.ArrayList;
import java.util.List;
import org.nd4j.linalg.dataset.MultiDataSet;
import org.nd4j.linalg.dataset.api.MultiDataSetPreProcessor;
import org.nd4j.linalg.dataset.api.iterator.MultiDataSetIterator;

public class TestMultiDataSetIterator
implements MultiDataSetIterator {
    private int curr = 0;
    private int batch = 10;
    private List<org.nd4j.linalg.dataset.api.MultiDataSet> list;
    private MultiDataSetPreProcessor preProcessor;

    public TestMultiDataSetIterator(org.nd4j.linalg.dataset.api.MultiDataSet dataset) {
        this(dataset, 5);
    }

    public TestMultiDataSetIterator(org.nd4j.linalg.dataset.api.MultiDataSet dataset, int batch) {
        this.list = new ArrayList<org.nd4j.linalg.dataset.api.MultiDataSet>(dataset.asList());
        this.batch = batch;
    }

    @Override
    public org.nd4j.linalg.dataset.api.MultiDataSet next(int num) {
        int end = this.curr + num;
        ArrayList<org.nd4j.linalg.dataset.api.MultiDataSet> r = new ArrayList<org.nd4j.linalg.dataset.api.MultiDataSet>();
        if (end >= this.list.size()) {
            end = this.list.size();
        }
        while (this.curr < end) {
            r.add(this.list.get(this.curr));
            ++this.curr;
        }
        MultiDataSet d = MultiDataSet.merge(r);
        if (this.preProcessor != null) {
            this.preProcessor.preProcess(d);
        }
        return d;
    }

    @Override
    public void setPreProcessor(MultiDataSetPreProcessor preProcessor) {
        this.preProcessor = preProcessor;
    }

    @Override
    public boolean resetSupported() {
        return true;
    }

    @Override
    public boolean asyncSupported() {
        return false;
    }

    @Override
    public void reset() {
        this.curr = 0;
    }

    @Override
    public boolean hasNext() {
        return this.curr < this.list.size();
    }

    @Override
    public org.nd4j.linalg.dataset.api.MultiDataSet next() {
        return this.next(this.batch);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

