/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.dataset;

import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.math3.util.Pair;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.executioner.GridExecutioner;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.indexing.INDArrayIndex;
import org.nd4j.linalg.indexing.NDArrayIndex;

public class MultiDataSet
implements org.nd4j.linalg.dataset.api.MultiDataSet {
    private INDArray[] features;
    private INDArray[] labels;
    private INDArray[] featuresMaskArrays;
    private INDArray[] labelsMaskArrays;
    private List<Serializable> exampleMetaData;

    public MultiDataSet() {
    }

    public MultiDataSet(INDArray features, INDArray labels) {
        INDArray[] iNDArrayArray;
        INDArray[] iNDArrayArray2;
        if (features != null) {
            INDArray[] iNDArrayArray3 = new INDArray[1];
            iNDArrayArray2 = iNDArrayArray3;
            iNDArrayArray3[0] = features;
        } else {
            iNDArrayArray2 = null;
        }
        if (labels != null) {
            INDArray[] iNDArrayArray4 = new INDArray[1];
            iNDArrayArray = iNDArrayArray4;
            iNDArrayArray4[0] = labels;
        } else {
            iNDArrayArray = null;
        }
        this(iNDArrayArray2, iNDArrayArray);
    }

    public MultiDataSet(INDArray[] features, INDArray[] labels) {
        this(features, labels, null, null);
    }

    public MultiDataSet(INDArray[] features, INDArray[] labels, INDArray[] featuresMaskArrays, INDArray[] labelsMaskArrays) {
        if (features != null && featuresMaskArrays != null && features.length != featuresMaskArrays.length) {
            throw new IllegalArgumentException("Invalid features / features mask arrays combination: features and features mask arrays must not be different lengths");
        }
        if (labels != null && labelsMaskArrays != null && labels.length != labelsMaskArrays.length) {
            throw new IllegalArgumentException("Invalid labels / labels mask arrays combination: labels and labels mask arrays must not be different lengths");
        }
        this.features = features;
        this.labels = labels;
        this.featuresMaskArrays = featuresMaskArrays;
        this.labelsMaskArrays = labelsMaskArrays;
        if (Nd4j.getExecutioner() instanceof GridExecutioner) {
            ((GridExecutioner)Nd4j.getExecutioner()).flushQueueBlocking();
        }
    }

    @Override
    public List<Serializable> getExampleMetaData() {
        return this.exampleMetaData;
    }

    @Override
    public <T extends Serializable> List<T> getExampleMetaData(Class<T> metaDataType) {
        return this.exampleMetaData;
    }

    @Override
    public void setExampleMetaData(List<? extends Serializable> exampleMetaData) {
        this.exampleMetaData = exampleMetaData;
    }

    @Override
    public int numFeatureArrays() {
        return this.features != null ? this.features.length : 0;
    }

    @Override
    public int numLabelsArrays() {
        return this.labels != null ? this.labels.length : 0;
    }

    @Override
    public INDArray[] getFeatures() {
        return this.features;
    }

    @Override
    public INDArray getFeatures(int index) {
        return this.features[index];
    }

    @Override
    public void setFeatures(INDArray[] features) {
        this.features = features;
    }

    @Override
    public void setFeatures(int idx, INDArray features) {
        this.features[idx] = features;
    }

    @Override
    public INDArray[] getLabels() {
        return this.labels;
    }

    @Override
    public INDArray getLabels(int index) {
        return this.labels[index];
    }

    @Override
    public void setLabels(INDArray[] labels) {
        this.labels = labels;
    }

    @Override
    public void setLabels(int idx, INDArray labels) {
        this.labels[idx] = labels;
    }

    @Override
    public boolean hasMaskArrays() {
        if (this.featuresMaskArrays == null && this.labelsMaskArrays == null) {
            return false;
        }
        if (this.featuresMaskArrays != null) {
            for (INDArray i : this.featuresMaskArrays) {
                if (i == null) continue;
                return true;
            }
        }
        if (this.labelsMaskArrays != null) {
            for (INDArray i : this.labelsMaskArrays) {
                if (i == null) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public INDArray[] getFeaturesMaskArrays() {
        return this.featuresMaskArrays;
    }

    @Override
    public INDArray getFeaturesMaskArray(int index) {
        return this.featuresMaskArrays != null ? this.featuresMaskArrays[index] : null;
    }

    @Override
    public void setFeaturesMaskArrays(INDArray[] maskArrays) {
        this.featuresMaskArrays = maskArrays;
    }

    @Override
    public void setFeaturesMaskArray(int idx, INDArray maskArray) {
        this.featuresMaskArrays[idx] = maskArray;
    }

    @Override
    public INDArray[] getLabelsMaskArrays() {
        return this.labelsMaskArrays;
    }

    @Override
    public INDArray getLabelsMaskArray(int index) {
        return this.labelsMaskArrays != null ? this.labelsMaskArrays[index] : null;
    }

    @Override
    public void setLabelsMaskArray(INDArray[] labelsMaskArrays) {
        this.labelsMaskArrays = labelsMaskArrays;
    }

    @Override
    public void setLabelsMaskArray(int idx, INDArray labelsMaskArray) {
        this.labelsMaskArrays[idx] = labelsMaskArray;
    }

    @Override
    public void save(OutputStream to) throws IOException {
        int numFArr = this.features == null ? 0 : this.features.length;
        int numLArr = this.labels == null ? 0 : this.labels.length;
        int numFMArr = this.featuresMaskArrays == null ? 0 : this.featuresMaskArrays.length;
        int numLMArr = this.labelsMaskArrays == null ? 0 : this.labelsMaskArrays.length;
        try (DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(to));){
            dos.writeInt(numFArr);
            dos.writeInt(numLArr);
            dos.writeInt(numFMArr);
            dos.writeInt(numLMArr);
            if (this.features != null && this.features.length > 0) {
                for (INDArray f : this.features) {
                    Nd4j.write(f, dos);
                }
            }
            if (this.labels != null && this.labels.length > 0) {
                for (INDArray l : this.labels) {
                    Nd4j.write(l, dos);
                }
            }
            if (this.featuresMaskArrays != null && this.featuresMaskArrays.length > 0) {
                for (INDArray fm : this.featuresMaskArrays) {
                    Nd4j.write(fm, dos);
                }
            }
            if (this.labelsMaskArrays != null && this.labelsMaskArrays.length > 0) {
                for (INDArray lm : this.labelsMaskArrays) {
                    Nd4j.write(lm, dos);
                }
            }
        }
    }

    @Override
    public void save(File to) throws IOException {
        this.save(new FileOutputStream(to));
    }

    @Override
    public void load(InputStream from) throws IOException {
        try (DataInputStream dis = new DataInputStream(from);){
            int i;
            int numFArr = dis.readInt();
            int numLArr = dis.readInt();
            int numFMArr = dis.readInt();
            int numLMArr = dis.readInt();
            if (numFArr > 0) {
                this.features = new INDArray[numFArr];
                for (i = 0; i < numFArr; ++i) {
                    this.features[i] = Nd4j.read(dis);
                }
            } else {
                this.features = null;
            }
            if (numLArr > 0) {
                this.labels = new INDArray[numLArr];
                for (i = 0; i < numLArr; ++i) {
                    this.labels[i] = Nd4j.read(dis);
                }
            } else {
                this.labels = null;
            }
            if (numFMArr > 0) {
                this.featuresMaskArrays = new INDArray[numFMArr];
                for (i = 0; i < numFMArr; ++i) {
                    this.featuresMaskArrays[i] = Nd4j.read(dis);
                }
            } else {
                this.featuresMaskArrays = null;
            }
            if (numLMArr > 0) {
                this.labelsMaskArrays = new INDArray[numLMArr];
                for (i = 0; i < numLMArr; ++i) {
                    this.labelsMaskArrays[i] = Nd4j.read(dis);
                }
            } else {
                this.labelsMaskArrays = null;
            }
        }
    }

    @Override
    public void load(File from) throws IOException {
        this.load(new FileInputStream(from));
    }

    @Override
    public List<org.nd4j.linalg.dataset.api.MultiDataSet> asList() {
        int nExamples = this.features[0].size(0);
        ArrayList<org.nd4j.linalg.dataset.api.MultiDataSet> list = new ArrayList<org.nd4j.linalg.dataset.api.MultiDataSet>();
        for (int i = 0; i < nExamples; ++i) {
            int j;
            INDArray[] thisFeatures = new INDArray[this.features.length];
            INDArray[] thisLabels = new INDArray[this.labels.length];
            INDArray[] thisFeaturesMaskArray = this.featuresMaskArrays != null ? new INDArray[this.featuresMaskArrays.length] : null;
            INDArray[] thisLabelsMaskArray = this.labelsMaskArrays != null ? new INDArray[this.labelsMaskArrays.length] : null;
            for (j = 0; j < this.features.length; ++j) {
                thisFeatures[j] = MultiDataSet.getSubsetForExample(this.features[j], i);
            }
            for (j = 0; j < this.labels.length; ++j) {
                thisLabels[j] = MultiDataSet.getSubsetForExample(this.labels[j], i);
            }
            if (thisFeaturesMaskArray != null) {
                for (j = 0; j < thisFeaturesMaskArray.length; ++j) {
                    if (this.featuresMaskArrays[j] == null) continue;
                    thisFeaturesMaskArray[j] = MultiDataSet.getSubsetForExample(this.featuresMaskArrays[j], i);
                }
            }
            if (thisLabelsMaskArray != null) {
                for (j = 0; j < thisLabelsMaskArray.length; ++j) {
                    if (this.labelsMaskArrays[j] == null) continue;
                    thisLabelsMaskArray[j] = MultiDataSet.getSubsetForExample(this.labelsMaskArrays[j], i);
                }
            }
            list.add(new MultiDataSet(thisFeatures, thisLabels, thisFeaturesMaskArray, thisLabelsMaskArray));
        }
        return list;
    }

    private static INDArray getSubsetForExample(INDArray array, int idx) {
        switch (array.rank()) {
            case 2: {
                return array.get(NDArrayIndex.point(idx), NDArrayIndex.all());
            }
            case 3: {
                return array.get(NDArrayIndex.point(idx), NDArrayIndex.all(), NDArrayIndex.all());
            }
            case 4: {
                return array.get(NDArrayIndex.point(idx), NDArrayIndex.all(), NDArrayIndex.all(), NDArrayIndex.all());
            }
        }
        throw new IllegalStateException("Cannot get subset for rank " + array.rank() + " array");
    }

    @Override
    public MultiDataSet copy() {
        MultiDataSet ret = new MultiDataSet(this.copy(this.getFeatures()), this.copy(this.getLabels()));
        if (this.labelsMaskArrays != null) {
            ret.setLabelsMaskArray(this.copy(this.labelsMaskArrays));
        }
        if (this.featuresMaskArrays != null) {
            ret.setFeaturesMaskArrays(this.copy(this.featuresMaskArrays));
        }
        return ret;
    }

    private INDArray[] copy(INDArray[] arrays) {
        INDArray[] result = new INDArray[arrays.length];
        for (int i = 0; i < arrays.length; ++i) {
            result[i] = arrays[i].dup();
        }
        return result;
    }

    public static MultiDataSet merge(Collection<? extends org.nd4j.linalg.dataset.api.MultiDataSet> toMerge) {
        if (toMerge.size() == 1) {
            org.nd4j.linalg.dataset.api.MultiDataSet mds = toMerge.iterator().next();
            if (mds instanceof MultiDataSet) {
                return (MultiDataSet)mds;
            }
            return new MultiDataSet(mds.getFeatures(), mds.getLabels(), mds.getFeaturesMaskArrays(), mds.getLabelsMaskArrays());
        }
        ArrayList<? extends org.nd4j.linalg.dataset.api.MultiDataSet> list = toMerge instanceof List ? (ArrayList<? extends org.nd4j.linalg.dataset.api.MultiDataSet>)toMerge : new ArrayList<org.nd4j.linalg.dataset.api.MultiDataSet>(toMerge);
        int nInArrays = ((org.nd4j.linalg.dataset.api.MultiDataSet)list.get(0)).numFeatureArrays();
        int nOutArrays = ((org.nd4j.linalg.dataset.api.MultiDataSet)list.get(0)).numLabelsArrays();
        INDArray[][] features = new INDArray[list.size()][0];
        INDArray[][] labels = new INDArray[list.size()][0];
        INDArray[][] featuresMasks = new INDArray[list.size()][0];
        INDArray[][] labelsMasks = new INDArray[list.size()][0];
        int i = 0;
        for (org.nd4j.linalg.dataset.api.MultiDataSet multiDataSet : list) {
            features[i] = multiDataSet.getFeatures();
            labels[i] = multiDataSet.getLabels();
            featuresMasks[i] = multiDataSet.getFeaturesMaskArrays();
            labelsMasks[i] = multiDataSet.getLabelsMaskArrays();
            if (features[i] == null || features[i].length != nInArrays) {
                throw new IllegalStateException("Cannot merge MultiDataSets with different number of input arrays: toMerge[0] has " + nInArrays + " input arrays; toMerge[" + i + "] has " + (features[i] != null ? Integer.valueOf(features[i].length) : null) + " arrays");
            }
            if (labels[i] == null || labels[i].length != nOutArrays) {
                throw new IllegalStateException("Cannot merge MultiDataSets with different number of output arrays: toMerge[0] has " + nOutArrays + " output arrays; toMerge[" + i + "] has " + (labels[i] != null ? Integer.valueOf(labels[i].length) : null) + " arrays");
            }
            ++i;
        }
        INDArray[] mergedFeatures = new INDArray[nInArrays];
        INDArray[] iNDArrayArray = new INDArray[nOutArrays];
        INDArray[] mergedFeaturesMasks = new INDArray[nInArrays];
        INDArray[] mergedLabelsMasks = new INDArray[nOutArrays];
        boolean needFeaturesMasks = false;
        for (i = 0; i < nInArrays; ++i) {
            Pair<INDArray, INDArray> pair = MultiDataSet.merge(features, featuresMasks, i);
            mergedFeatures[i] = (INDArray)pair.getFirst();
            mergedFeaturesMasks[i] = (INDArray)pair.getSecond();
            if (mergedFeaturesMasks[i] == null) continue;
            needFeaturesMasks = true;
        }
        if (!needFeaturesMasks) {
            mergedFeaturesMasks = null;
        }
        boolean needLabelsMasks = false;
        for (i = 0; i < nOutArrays; ++i) {
            Pair<INDArray, INDArray> pair = MultiDataSet.merge(labels, labelsMasks, i);
            iNDArrayArray[i] = (INDArray)pair.getFirst();
            mergedLabelsMasks[i] = (INDArray)pair.getSecond();
            if (mergedLabelsMasks[i] == null) continue;
            needLabelsMasks = true;
        }
        if (!needLabelsMasks) {
            mergedLabelsMasks = null;
        }
        return new MultiDataSet(mergedFeatures, iNDArrayArray, mergedFeaturesMasks, mergedLabelsMasks);
    }

    private static Pair<INDArray, INDArray> merge(INDArray[][] arrays, INDArray[][] masks, int column) {
        int rank = arrays[0][column].rank();
        if (rank == 2) {
            return new Pair((Object)MultiDataSet.merge2d(arrays, column), null);
        }
        if (rank == 3) {
            return MultiDataSet.mergeTimeSeries(arrays, masks, column);
        }
        if (rank == 4) {
            return new Pair((Object)MultiDataSet.merge4d(arrays, column), null);
        }
        throw new UnsupportedOperationException("Cannot merge arrays with rank 5 or more (input/output number: " + column + ")");
    }

    private static INDArray merge2d(INDArray[][] arrays, int inOutIdx) {
        int nExamples = 0;
        int cols = arrays[0][inOutIdx].columns();
        for (int i = 0; i < arrays.length; ++i) {
            nExamples += arrays[i][inOutIdx].rows();
            if (arrays[i][inOutIdx].columns() == cols) continue;
            throw new IllegalStateException("Cannot merge 2d arrays with different numbers of columns (firstNCols=" + cols + ", ithNCols=" + arrays[i][inOutIdx].columns() + ")");
        }
        INDArray out = Nd4j.create(nExamples, cols);
        int rowsSoFar = 0;
        for (int i = 0; i < arrays.length; ++i) {
            int thisRows = arrays[i][inOutIdx].rows();
            out.put(new INDArrayIndex[]{NDArrayIndex.interval(rowsSoFar, rowsSoFar + thisRows), NDArrayIndex.all()}, arrays[i][inOutIdx]);
            rowsSoFar += thisRows;
        }
        return out;
    }

    private static Pair<INDArray, INDArray> mergeTimeSeries(INDArray[][] arrays, INDArray[][] masks, int inOutIdx) {
        int firstLength = arrays[0][inOutIdx].size(2);
        int size = arrays[0][inOutIdx].size(1);
        int maxLength = firstLength;
        boolean hasMask = false;
        boolean lengthsDiffer = false;
        int totalExamples = 0;
        for (int i = 0; i < arrays.length; ++i) {
            totalExamples += arrays[i][inOutIdx].size(0);
            int thisLength = arrays[i][inOutIdx].size(2);
            maxLength = Math.max(maxLength, thisLength);
            if (thisLength != firstLength) {
                lengthsDiffer = true;
            }
            if (masks != null && masks[i] != null && masks[i][inOutIdx] != null) {
                hasMask = true;
            }
            if (arrays[i][inOutIdx].size(1) == size) continue;
            throw new IllegalStateException("Cannot merge time series with different size for dimension 1 (first shape: " + Arrays.toString(arrays[0][inOutIdx].shape()) + ", " + i + "th shape: " + Arrays.toString(arrays[i][inOutIdx].shape()));
        }
        boolean needMask = hasMask || lengthsDiffer;
        INDArray arr = Nd4j.create(totalExamples, size, maxLength);
        INDArray mask = needMask ? Nd4j.ones(totalExamples, maxLength) : null;
        int examplesSoFar = 0;
        if (!lengthsDiffer && !needMask) {
            for (int i = 0; i < arrays.length; ++i) {
                int thisNExamples = arrays[i][inOutIdx].size(0);
                arr.put(new INDArrayIndex[]{NDArrayIndex.interval(examplesSoFar, examplesSoFar + thisNExamples), NDArrayIndex.all(), NDArrayIndex.all()}, arrays[i][inOutIdx]);
                examplesSoFar += thisNExamples;
            }
            return new Pair((Object)arr, null);
        }
        for (int i = 0; i < arrays.length; ++i) {
            INDArray a = arrays[i][inOutIdx];
            int thisNExamples = a.size(0);
            int thisLength = a.size(2);
            arr.put(new INDArrayIndex[]{NDArrayIndex.interval(examplesSoFar, examplesSoFar + thisNExamples), NDArrayIndex.all(), NDArrayIndex.interval(0, thisLength)}, a);
            if (masks != null && masks[i] != null && masks[i][inOutIdx] != null) {
                INDArray origMask = masks[i][inOutIdx];
                int maskLength = origMask.size(1);
                mask.put(new INDArrayIndex[]{NDArrayIndex.interval(examplesSoFar, examplesSoFar + thisNExamples), NDArrayIndex.interval(0, maskLength)}, origMask);
                if (maskLength < maxLength) {
                    mask.put(new INDArrayIndex[]{NDArrayIndex.interval(examplesSoFar, examplesSoFar + thisNExamples), NDArrayIndex.interval(maskLength, maxLength)}, Nd4j.zeros(thisNExamples, maxLength - maskLength));
                }
            } else if (thisLength < maxLength) {
                mask.put(new INDArrayIndex[]{NDArrayIndex.interval(examplesSoFar, examplesSoFar + thisNExamples), NDArrayIndex.interval(thisLength, maxLength)}, Nd4j.zeros(thisNExamples, maxLength - thisLength));
            }
            examplesSoFar += thisNExamples;
        }
        return new Pair((Object)arr, (Object)mask);
    }

    private static INDArray merge4d(INDArray[][] arrays, int inOutIdx) {
        int nExamples = 0;
        int[] shape = arrays[0][inOutIdx].shape();
        for (int i = 0; i < arrays.length; ++i) {
            nExamples += arrays[i][inOutIdx].size(0);
            int[] thisShape = arrays[i][inOutIdx].shape();
            if (thisShape.length != 4) {
                throw new IllegalStateException("Cannot merge 4d arrays with non 4d arrays");
            }
            for (int j = 1; j < 4; ++j) {
                if (thisShape[j] == shape[j]) continue;
                throw new IllegalStateException("Cannot merge 4d arrays with different shape (other than # examples):  data[0][" + inOutIdx + "].shape = " + Arrays.toString(shape) + ", data[" + i + "][" + inOutIdx + "].shape = " + Arrays.toString(thisShape));
            }
        }
        INDArray out = Nd4j.create(nExamples, shape[1], shape[2], shape[3]);
        int rowsSoFar = 0;
        for (int i = 0; i < arrays.length; ++i) {
            int thisRows = arrays[i][inOutIdx].size(0);
            out.put(new INDArrayIndex[]{NDArrayIndex.interval(rowsSoFar, rowsSoFar + thisRows), NDArrayIndex.all(), NDArrayIndex.all(), NDArrayIndex.all()}, arrays[i][inOutIdx]);
            rowsSoFar += thisRows;
        }
        return out;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        int totalEntries = this.numFeatureArrays();
        if (totalEntries != this.numLabelsArrays()) {
            return "";
        }
        for (int i = 0; i < totalEntries; ++i) {
            builder.append("\n=========== ENTRY " + i + " =================\n");
            builder.append("\n=== INPUT ===\n").append(this.getFeatures(i).toString().replaceAll(";", "\n")).append("\n=== OUTPUT ===\n").append(this.getLabels(i).toString().replaceAll(";", "\n"));
            if (this.getFeaturesMaskArray(i) != null) {
                builder.append("\n=== INPUT MASK ===\n").append(this.getFeaturesMaskArray(i).toString().replaceAll(";", "\n"));
            }
            if (this.getLabelsMaskArray(i) == null) continue;
            builder.append("\n=== OUTPUT MASK ===\n").append(this.getLabelsMaskArray(i).toString().replaceAll(";", "\n"));
        }
        return builder.toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MultiDataSet)) {
            return false;
        }
        MultiDataSet m = (MultiDataSet)o;
        if (!this.bothNullOrEqual(this.features, m.features)) {
            return false;
        }
        if (!this.bothNullOrEqual(this.labels, m.labels)) {
            return false;
        }
        if (!this.bothNullOrEqual(this.featuresMaskArrays, m.featuresMaskArrays)) {
            return false;
        }
        return this.bothNullOrEqual(this.labelsMaskArrays, m.labelsMaskArrays);
    }

    private boolean bothNullOrEqual(INDArray[] first, INDArray[] second) {
        if (first == null && second == null) {
            return true;
        }
        if (first == null || second == null) {
            return false;
        }
        if (first.length != second.length) {
            return false;
        }
        for (int i = 0; i < first.length; ++i) {
            if (first[i].equals(second[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 0;
        if (this.features != null) {
            for (INDArray f : this.features) {
                result = result * 31 + f.hashCode();
            }
        }
        if (this.labels != null) {
            for (INDArray l : this.labels) {
                result = result * 31 + l.hashCode();
            }
        }
        if (this.featuresMaskArrays != null) {
            for (INDArray fm : this.featuresMaskArrays) {
                result = result * 31 + fm.hashCode();
            }
        }
        if (this.labelsMaskArrays != null) {
            for (INDArray lm : this.labelsMaskArrays) {
                result = result * 31 + lm.hashCode();
            }
        }
        return result;
    }
}

