/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.random.impl;

import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.random.BaseRandomOp;

public class BinomialDistribution
extends BaseRandomOp {
    private int trials;
    private double probability;

    public BinomialDistribution() {
    }

    public BinomialDistribution(INDArray z, int trials, double probability) {
        this.init(z, z, z, z.length());
        this.trials = trials;
        this.probability = probability;
        this.extraArgs = new Object[]{(double)this.trials, this.probability};
    }

    public BinomialDistribution(INDArray z, int trials, INDArray probabilities) {
        if (trials > probabilities.length()) {
            throw new IllegalStateException("Number of trials is > then amount of probabilities provided");
        }
        if (probabilities.elementWiseStride() < 1) {
            throw new IllegalStateException("Probabilities array shouldn't have negative elementWiseStride");
        }
        this.init(z, probabilities, z, z.length());
        this.trials = trials;
        this.probability = 0.0;
        this.extraArgs = new Object[]{(double)this.trials, this.probability};
    }

    public BinomialDistribution(INDArray z, INDArray probabilities) {
        this(z, probabilities.length(), probabilities);
    }

    @Override
    public int opNum() {
        return 8;
    }

    @Override
    public String name() {
        return "distribution_binomial";
    }

    @Override
    public boolean isExecSpecial() {
        return true;
    }
}

