/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.transforms;

import org.apache.commons.math3.util.FastMath;
import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseTransformOp;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.api.ops.TransformOp;
import org.nd4j.linalg.api.ops.impl.transforms.CubeDerivative;
import org.nd4j.linalg.util.ComplexUtil;

public class Cube
extends BaseTransformOp {
    public Cube() {
    }

    public Cube(INDArray x, INDArray z) {
        super(x, z);
    }

    public Cube(INDArray x, INDArray z, long n) {
        super(x, z, n);
    }

    public Cube(INDArray x, INDArray y, INDArray z, long n) {
        super(x, y, z, n);
    }

    public Cube(INDArray x, INDArray y, INDArray z) {
        super(x, y, z, x.lengthLong());
    }

    public Cube(INDArray x) {
        super(x);
    }

    @Override
    public int opNum() {
        return 49;
    }

    @Override
    public String name() {
        return "cube";
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, double other) {
        return ComplexUtil.pow(origin, 3.0);
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, float other) {
        return ComplexUtil.pow(origin, 3.0);
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, IComplexNumber other) {
        return ComplexUtil.pow(origin, 3.0);
    }

    @Override
    public float op(float origin, float other) {
        return (float)FastMath.pow((double)origin, (int)3);
    }

    @Override
    public double op(double origin, double other) {
        return FastMath.pow((double)origin, (int)3);
    }

    @Override
    public double op(double origin) {
        return FastMath.pow((double)origin, (int)3);
    }

    @Override
    public float op(float origin) {
        return (float)FastMath.pow((double)origin, (int)3);
    }

    @Override
    public IComplexNumber op(IComplexNumber origin) {
        return ComplexUtil.pow(origin, 3.0);
    }

    @Override
    public TransformOp derivative() {
        return new CubeDerivative(this.x, this.y, this.z, this.n);
    }

    @Override
    public Op opForDimension(int index, int dimension) {
        INDArray xAlongDimension = this.x.vectorAlongDimension(index, dimension);
        if (this.y() != null) {
            return new Cube(xAlongDimension, this.y.vectorAlongDimension(index, dimension), this.z.vectorAlongDimension(index, dimension), xAlongDimension.length());
        }
        return new Cube(xAlongDimension, this.z.vectorAlongDimension(index, dimension), xAlongDimension.length());
    }

    @Override
    public Op opForDimension(int index, int ... dimension) {
        INDArray xAlongDimension = this.x.tensorAlongDimension(index, dimension);
        if (this.y() != null) {
            return new Cube(xAlongDimension, this.y.tensorAlongDimension(index, dimension), this.z.tensorAlongDimension(index, dimension), xAlongDimension.length());
        }
        return new Cube(xAlongDimension, this.z.tensorAlongDimension(index, dimension), xAlongDimension.length());
    }
}

