/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.instrumentation;

import java.util.Arrays;
import java.util.Collection;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.instrumentation.DataBufferLogEntry;
import org.nd4j.linalg.api.ndarray.INDArray;

public class LogEntry
extends DataBufferLogEntry {
    private String id;
    private int[] shape;
    private int[] stride;
    private String ndArrayType;

    public LogEntry() {
    }

    public LogEntry(INDArray toLog, String status) {
        this.shape = toLog.shape();
        this.stride = toLog.stride();
        this.ndArrayType = toLog.getClass().getName();
        this.length = toLog.length();
        this.references = toLog.data().references();
        this.dataType = toLog.data().dataType() == DataBuffer.Type.DOUBLE ? "double" : "float";
        this.timestamp = System.currentTimeMillis();
        this.stackTraceElements = Thread.currentThread().getStackTrace();
        this.status = status;
    }

    public LogEntry(INDArray toLog, StackTraceElement[] stackTraceElements, String status) {
        this.shape = toLog.shape();
        this.stride = toLog.stride();
        this.ndArrayType = toLog.getClass().getName();
        this.length = toLog.length();
        this.references = toLog.data().references();
        this.dataType = toLog.data().dataType() == DataBuffer.Type.DOUBLE ? "double" : "float";
        this.timestamp = System.currentTimeMillis();
        this.stackTraceElements = stackTraceElements;
        this.status = status;
    }

    public LogEntry(INDArray toLog, StackTraceElement[] stackTraceElements) {
        this(toLog, stackTraceElements, "created");
    }

    public LogEntry(INDArray toLog) {
        this(toLog, Thread.currentThread().getStackTrace());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LogEntry)) {
            return false;
        }
        LogEntry logEntry = (LogEntry)o;
        if (this.length != logEntry.length) {
            return false;
        }
        if (this.dataType != null ? !this.dataType.equals(logEntry.dataType) : logEntry.dataType != null) {
            return false;
        }
        if (this.id != null ? !this.id.equals(logEntry.id) : logEntry.id != null) {
            return false;
        }
        if (this.ndArrayType != null ? !this.ndArrayType.equals(logEntry.ndArrayType) : logEntry.ndArrayType != null) {
            return false;
        }
        if (this.references != null ? !this.references.equals(logEntry.references) : logEntry.references != null) {
            return false;
        }
        if (!Arrays.equals(this.shape, logEntry.shape)) {
            return false;
        }
        if (!Arrays.equals(this.stackTraceElements, logEntry.stackTraceElements)) {
            return false;
        }
        return Arrays.equals(this.stride, logEntry.stride);
    }

    @Override
    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.shape != null ? Arrays.hashCode(this.shape) : 0);
        result = 31 * result + (this.stride != null ? Arrays.hashCode(this.stride) : 0);
        result = 31 * result + (int)(this.length ^ this.length >>> 32);
        result = 31 * result + (this.ndArrayType != null ? this.ndArrayType.hashCode() : 0);
        result = 31 * result + (this.references != null ? this.references.hashCode() : 0);
        result = 31 * result + (this.dataType != null ? this.dataType.hashCode() : 0);
        result = 31 * result + (this.stackTraceElements != null ? Arrays.hashCode(this.stackTraceElements) : 0);
        return result;
    }

    @Override
    public String toString() {
        return "LogEntry{id='" + this.id + '\'' + ", shape=" + Arrays.toString(this.shape) + ", stride=" + Arrays.toString(this.stride) + ", length=" + this.length + ", ndArrayType='" + this.ndArrayType + '\'' + ", references=" + this.references + ", dataType='" + this.dataType + '\'' + ", stackTraceElements=" + Arrays.toString(this.stackTraceElements) + '}';
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public int[] getShape() {
        return this.shape;
    }

    public void setShape(int[] shape) {
        this.shape = shape;
    }

    public int[] getStride() {
        return this.stride;
    }

    public void setStride(int[] stride) {
        this.stride = stride;
    }

    @Override
    public long length() {
        return this.length;
    }

    @Override
    public void setLength(long length) {
        this.length = length;
    }

    public String getNdArrayType() {
        return this.ndArrayType;
    }

    public void setNdArrayType(String ndArrayType) {
        this.ndArrayType = ndArrayType;
    }

    @Override
    public Collection<String> getReferences() {
        return this.references;
    }

    @Override
    public void setReferences(Collection<String> numReferences) {
        this.references = numReferences;
    }

    @Override
    public String getDataType() {
        return this.dataType;
    }

    @Override
    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    @Override
    public StackTraceElement[] getStackTraceElements() {
        return this.stackTraceElements;
    }

    @Override
    public void setStackTraceElements(StackTraceElement[] stackTraceElements) {
        this.stackTraceElements = stackTraceElements;
    }
}

