/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.executors;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ExecutorServiceProvider {
    public static final String EXEC_THREADS = "org.nd4j.parallel.threads";
    public static final String ENABLED = "org.nd4j.parallel.enabled";
    private static final int nThreads;
    private static ExecutorService executorService;
    private static ForkJoinPool forkJoinPool;

    public static synchronized ExecutorService getExecutorService() {
        if (executorService != null) {
            return executorService;
        }
        executorService = new ThreadPoolExecutor(nThreads, nThreads, 60L, TimeUnit.SECONDS, new LinkedTransferQueue<Runnable>(), new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = Executors.defaultThreadFactory().newThread(r);
                t.setDaemon(true);
                return t;
            }
        });
        return executorService;
    }

    public static synchronized ForkJoinPool getForkJoinPool() {
        if (forkJoinPool != null) {
            return forkJoinPool;
        }
        forkJoinPool = new ForkJoinPool(nThreads, ForkJoinPool.defaultForkJoinWorkerThreadFactory, null, true);
        return forkJoinPool;
    }

    static {
        int defaultThreads = Runtime.getRuntime().availableProcessors();
        boolean enabled = Boolean.parseBoolean(System.getProperty(ENABLED, "true"));
        nThreads = !enabled ? 1 : Integer.parseInt(System.getProperty(EXEC_THREADS, String.valueOf(defaultThreads)));
    }
}

