/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.util;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Arrays;
import org.nd4j.linalg.api.blas.Level1;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.shape.Shape;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.indexing.INDArrayIndex;
import org.nd4j.linalg.indexing.Indices;
import org.nd4j.linalg.ops.transforms.Transforms;
import org.nd4j.linalg.util.ArrayUtil;

public class NDArrayUtil {
    public static INDArray exp(INDArray toExp) {
        return NDArrayUtil.expi(toExp.dup());
    }

    public static INDArray expi(INDArray toExp) {
        INDArray flattened = toExp.ravel();
        for (int i = 0; i < flattened.length(); ++i) {
            flattened.put(i, Nd4j.scalar(Math.exp((Double)flattened.getScalar(i).element())));
        }
        return flattened.reshape(toExp.shape());
    }

    public static INDArray center(INDArray arr, int[] shape) {
        if (arr.length() < ArrayUtil.prod(shape)) {
            return arr;
        }
        for (int i = 0; i < shape.length; ++i) {
            if (shape[i] >= 1) continue;
            shape[i] = 1;
        }
        INDArray shapeMatrix = ArrayUtil.toNDArray(shape);
        INDArray currShape = ArrayUtil.toNDArray(arr.shape());
        INDArray startIndex = Transforms.floor(currShape.sub(shapeMatrix).divi(Nd4j.scalar(2.0f)));
        INDArray endIndex = startIndex.add(shapeMatrix);
        INDArrayIndex[] indexes = Indices.createFromStartAndEnd(startIndex, endIndex);
        if (shapeMatrix.length() > 1) {
            return arr.get(indexes);
        }
        INDArray ret = Nd4j.create(new int[]{(int)shapeMatrix.getDouble(0)});
        int start = (int)startIndex.getDouble(0);
        int end = (int)endIndex.getDouble(0);
        int count = 0;
        for (int i = start; i < end; ++i) {
            ret.putScalar(count++, arr.getDouble(i));
        }
        return ret;
    }

    public static INDArray truncate(INDArray nd, int n, int dimension) {
        if (nd.isVector()) {
            INDArray truncated = Nd4j.create(new int[]{n});
            for (int i = 0; i < n; ++i) {
                truncated.put(i, nd.getScalar(i));
            }
            return truncated;
        }
        if (nd.size(dimension) > n) {
            int[] targetShape = ArrayUtil.copy(nd.shape());
            targetShape[dimension] = n;
            int numRequired = ArrayUtil.prod(targetShape);
            if (nd.isVector()) {
                INDArray ret = Nd4j.create(targetShape);
                int count = 0;
                for (int i = 0; i < nd.length(); i += nd.stride()[dimension]) {
                    ret.put(count++, nd.getScalar(i));
                }
                return ret;
            }
            if (nd.isMatrix()) {
                ArrayList<Double> list = new ArrayList<Double>();
                if (dimension == 0) {
                    for (int i = 0; i < nd.rows(); ++i) {
                        INDArray row = nd.getRow(i);
                        for (int j = 0; j < row.length(); ++j) {
                            if (list.size() == numRequired) {
                                return Nd4j.create(ArrayUtil.toArrayDouble(list), targetShape);
                            }
                            list.add((Double)row.getScalar(j).element());
                        }
                    }
                } else if (dimension == 1) {
                    for (int i = 0; i < nd.columns(); ++i) {
                        INDArray row = nd.getColumn(i);
                        for (int j = 0; j < row.length(); ++j) {
                            if (list.size() == numRequired) {
                                return Nd4j.create(ArrayUtil.toArrayDouble(list), targetShape);
                            }
                            list.add((Double)row.getScalar(j).element());
                        }
                    }
                } else {
                    throw new IllegalArgumentException("Illegal dimension for matrix " + dimension);
                }
                return Nd4j.create(ArrayUtil.toArrayDouble(list), targetShape);
            }
            if (dimension == 0) {
                ArrayList<INDArray> slices = new ArrayList<INDArray>();
                for (int i = 0; i < n; ++i) {
                    INDArray slice = nd.slice(i);
                    slices.add(slice);
                }
                return Nd4j.create(slices, targetShape);
            }
            ArrayList<Double> list = new ArrayList<Double>();
            int numElementsPerSlice = ArrayUtil.prod(ArrayUtil.removeIndex(targetShape, 0));
            for (int i = 0; i < nd.slices(); ++i) {
                INDArray slice = nd.slice(i).ravel();
                for (int j = 0; j < numElementsPerSlice; ++j) {
                    list.add((Double)slice.getScalar(j).element());
                }
            }
            assert (list.size() == ArrayUtil.prod(targetShape)) : "Illegal shape for length " + list.size();
            return Nd4j.create(ArrayUtil.toArrayDouble(list), targetShape);
        }
        return nd;
    }

    public static INDArray padWithZeros(INDArray nd, int[] targetShape) {
        if (Arrays.equals(nd.shape(), targetShape)) {
            return nd;
        }
        if (ArrayUtil.prod(nd.shape()) >= ArrayUtil.prod(targetShape)) {
            return nd;
        }
        INDArray ret = Nd4j.create(targetShape);
        System.arraycopy(nd.data(), 0, ret.data(), 0, nd.data().length());
        return ret;
    }

    public static Tensor1DStats get1DTensorStats(INDArray array, int dimension) {
        int elementWiseStride;
        int tensorStartSeparation;
        int tensorLength = ArrayUtil.prod(ArrayUtil.keep(array.shape(), dimension));
        int numTensors = array.length() / tensorLength;
        int firstTensorOffset = array.offset();
        if (numTensors == 1) {
            tensorStartSeparation = -1;
            elementWiseStride = array.elementWiseStride();
        } else {
            INDArray secondTensor = array.tensorAlongDimension(1, dimension);
            tensorStartSeparation = secondTensor.offset() - firstTensorOffset;
            elementWiseStride = secondTensor.elementWiseStride();
        }
        return new Tensor1DStats(firstTensorOffset, tensorStartSeparation, numTensors, tensorLength, elementWiseStride);
    }

    public static void doElementWiseOp(INDArray first, INDArray second, char op) {
        if (NDArrayUtil.canDoElementWiseOpDirectly(first, second)) {
            NDArrayUtil.doOpDirectly(first, second, op);
        } else {
            int opAlongDimension = NDArrayUtil.chooseElementWiseTensorDimension(first, second);
            if (first.rank() == 2) {
                Tensor1DStats fs = NDArrayUtil.get1DTensorStats(first, opAlongDimension);
                Tensor1DStats ss = NDArrayUtil.get1DTensorStats(second, opAlongDimension);
                if (fs.tensorStartSeparation == fs.getTensorLength() * fs.getElementWiseStride() && ss.tensorStartSeparation == ss.getTensorLength() * ss.getElementWiseStride()) {
                    NDArrayUtil.doOpDirectly(first, second, op);
                } else {
                    NDArrayUtil.doOpOnMatrix(first, second, op, fs, ss);
                }
            } else {
                NDArrayUtil.doElementWiseOpGeneral(first, second, op);
            }
        }
    }

    private static boolean canDoElementWiseOpDirectly(INDArray first, INDArray second) {
        if (first.isVector()) {
            return true;
        }
        int l1 = first.length();
        int dl1 = first.data().length();
        int l2 = second.length();
        int dl2 = second.data().length();
        int[] strides1 = first.stride();
        int[] strides2 = second.stride();
        boolean equalStrides = Arrays.equals(strides1, strides2);
        if (l1 == dl1 && l2 == dl2 && equalStrides) {
            return true;
        }
        int[] shape1 = first.shape();
        int[] stridesAsInit = first.ordering() == 'c' ? ArrayUtil.calcStrides(shape1) : ArrayUtil.calcStridesFortran(shape1);
        boolean stridesSameAsInit = Arrays.equals(strides1, stridesAsInit);
        return equalStrides && stridesSameAsInit;
    }

    private static int chooseElementWiseTensorDimension(INDArray first, INDArray second) {
        int opAlongDimensionMinStride = ArrayUtil.argMinOfMax(first.stride(), second.stride());
        int opAlongDimensionMaxLength = ArrayUtil.argMax(first.shape());
        if (first.size(opAlongDimensionMinStride) == 1) {
            return opAlongDimensionMaxLength;
        }
        int nOpsAlongMinStride = ArrayUtil.prod(ArrayUtil.keep(first.shape(), opAlongDimensionMinStride));
        int nOpsAlongMaxLength = ArrayUtil.prod(ArrayUtil.keep(first.shape(), opAlongDimensionMaxLength));
        if (nOpsAlongMinStride <= 10 * nOpsAlongMaxLength) {
            return opAlongDimensionMinStride;
        }
        return opAlongDimensionMaxLength;
    }

    private static void doOpDirectly(INDArray first, INDArray second, char op) {
        switch (op) {
            case 'a': 
            case 's': {
                double a = op == 'a' ? 1.0 : -1.0;
                Nd4j.getBlasWrapper().level1().axpy(first.length(), a, second, first);
                break;
            }
            case 'd': 
            case 'm': {
                int incrFirst = first.elementWiseStride();
                int incrSecond = second.elementWiseStride();
                int offsetFirst = first.offset();
                int offsetSecond = second.offset();
                int opLength = first.length();
                Object arrayFirst = first.data().array();
                Object arraySecond = second.data().array();
                if (arrayFirst instanceof float[]) {
                    float[] fArr1 = (float[])arrayFirst;
                    float[] fArr2 = (float[])arraySecond;
                    if (op == 'm') {
                        if (incrFirst == 1 && incrSecond == 1) {
                            if (offsetFirst == 0 && offsetSecond == 0) {
                                NDArrayUtil.muliSimpleFloat(fArr1, fArr2, opLength);
                                break;
                            }
                            NDArrayUtil.muliOffsetUnitIncrementFloat(fArr1, fArr2, opLength, offsetFirst, offsetSecond);
                            break;
                        }
                        if (offsetFirst == 0 && offsetSecond == 0) {
                            NDArrayUtil.muliIncrementNoOffsetFloat(fArr1, fArr2, opLength, incrFirst, incrSecond);
                            break;
                        }
                        NDArrayUtil.muliIncrementOffsetFloat(fArr1, fArr2, opLength, offsetFirst, offsetSecond, incrFirst, incrSecond);
                        break;
                    }
                    if (incrFirst == 1 && incrSecond == 1) {
                        if (offsetFirst == 0 && offsetSecond == 0) {
                            NDArrayUtil.diviSimpleFloat(fArr1, fArr2, opLength);
                            break;
                        }
                        NDArrayUtil.diviOffsetUnitIncrementFloat(fArr1, fArr2, opLength, offsetFirst, offsetSecond);
                        break;
                    }
                    if (offsetFirst == 0 && offsetSecond == 0) {
                        NDArrayUtil.diviIncrementNoOffsetFloat(fArr1, fArr2, opLength, incrFirst, incrSecond);
                        break;
                    }
                    NDArrayUtil.diviIncrementOffsetFloat(fArr1, fArr2, opLength, offsetFirst, offsetSecond, incrFirst, incrSecond);
                    break;
                }
                double[] dArr1 = (double[])arrayFirst;
                double[] dArr2 = (double[])arraySecond;
                if (op == 'm') {
                    if (incrFirst == 1 && incrSecond == 1) {
                        if (offsetFirst == 0 && offsetSecond == 0) {
                            NDArrayUtil.muliSimpleDouble(dArr1, dArr2, opLength);
                            break;
                        }
                        NDArrayUtil.muliOffsetUnitIncrementDouble(dArr1, dArr2, opLength, offsetFirst, offsetSecond);
                        break;
                    }
                    if (offsetFirst == 0 && offsetSecond == 0) {
                        NDArrayUtil.muliIncrementNoOffsetDouble(dArr1, dArr2, opLength, incrFirst, incrSecond);
                        break;
                    }
                    NDArrayUtil.muliIncrementOffsetDouble(dArr1, dArr2, opLength, offsetFirst, offsetSecond, incrFirst, incrSecond);
                    break;
                }
                if (incrFirst == 1 && incrSecond == 1) {
                    if (offsetFirst == 0 && offsetSecond == 0) {
                        NDArrayUtil.diviSimpleDouble(dArr1, dArr2, opLength);
                        break;
                    }
                    NDArrayUtil.diviOffsetUnitIncrementDouble(dArr1, dArr2, opLength, offsetFirst, offsetSecond);
                    break;
                }
                if (offsetFirst == 0 && offsetSecond == 0) {
                    NDArrayUtil.diviIncrementNoOffsetDouble(dArr1, dArr2, opLength, incrFirst, incrSecond);
                    break;
                }
                NDArrayUtil.diviIncrementOffsetDouble(dArr1, dArr2, opLength, offsetFirst, offsetSecond, incrFirst, incrSecond);
                break;
            }
            case 'p': {
                Nd4j.getBlasWrapper().level1().copy(second, first);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown op: " + op);
            }
        }
    }

    private static void doOpOnMatrix(INDArray first, INDArray second, char op, Tensor1DStats fs, Tensor1DStats ss) {
        DataBuffer df = first.data();
        DataBuffer ds = second.data();
        int n = fs.getTensorLength();
        int nTensors = fs.getNumTensors();
        int incrF = fs.getElementWiseStride();
        int incrS = ss.getElementWiseStride();
        Level1 l1Blas = Nd4j.getBlasWrapper().level1();
        switch (op) {
            case 'a': 
            case 's': {
                double a = op == 'a' ? 1.0 : -1.0;
                for (int i = 0; i < nTensors; ++i) {
                    int offset1 = fs.getFirstTensorOffset() + i * fs.getTensorStartSeparation();
                    int offset2 = ss.getFirstTensorOffset() + i * ss.getTensorStartSeparation();
                    l1Blas.axpy(n, a, ds, offset2, incrS, df, offset1, incrF);
                }
                break;
            }
            case 'm': {
                Object arrayFirst = first.data().array();
                Object arraySecond = second.data().array();
                if (arrayFirst instanceof float[]) {
                    float[] f1 = (float[])arrayFirst;
                    float[] f2 = (float[])arraySecond;
                    if (incrF == 1 && incrS == 1) {
                        for (int i = 0; i < nTensors; ++i) {
                            int offset1 = fs.getFirstTensorOffset() + i * fs.getTensorStartSeparation();
                            int offset2 = ss.getFirstTensorOffset() + i * ss.getTensorStartSeparation();
                            NDArrayUtil.muliOffsetUnitIncrementFloat(f1, f2, n, offset1, offset2);
                        }
                    } else {
                        for (int i = 0; i < nTensors; ++i) {
                            int offset1 = fs.getFirstTensorOffset() + i * fs.getTensorStartSeparation();
                            int offset2 = ss.getFirstTensorOffset() + i * ss.getTensorStartSeparation();
                            NDArrayUtil.muliIncrementOffsetFloat(f1, f2, n, offset1, offset2, incrF, incrS);
                        }
                    }
                } else {
                    double[] f1 = (double[])arrayFirst;
                    double[] f2 = (double[])arraySecond;
                    if (incrF == 1 && incrS == 1) {
                        for (int i = 0; i < nTensors; ++i) {
                            int offset1 = fs.getFirstTensorOffset() + i * fs.getTensorStartSeparation();
                            int offset2 = ss.getFirstTensorOffset() + i * ss.getTensorStartSeparation();
                            NDArrayUtil.muliOffsetUnitIncrementDouble(f1, f2, n, offset1, offset2);
                        }
                    } else {
                        for (int i = 0; i < nTensors; ++i) {
                            int offset1 = fs.getFirstTensorOffset() + i * fs.getTensorStartSeparation();
                            int offset2 = ss.getFirstTensorOffset() + i * ss.getTensorStartSeparation();
                            NDArrayUtil.muliIncrementOffsetDouble(f1, f2, n, offset1, offset2, incrF, incrS);
                        }
                    }
                }
                break;
            }
            case 'd': {
                Object arrayFirstd = first.data().array();
                Object arraySecondd = second.data().array();
                if (arrayFirstd instanceof float[]) {
                    float[] f1 = (float[])arrayFirstd;
                    float[] f2 = (float[])arraySecondd;
                    if (incrF == 1 && incrS == 1) {
                        for (int i = 0; i < nTensors; ++i) {
                            int offset1 = fs.getFirstTensorOffset() + i * fs.getTensorStartSeparation();
                            int offset2 = ss.getFirstTensorOffset() + i * ss.getTensorStartSeparation();
                            NDArrayUtil.diviOffsetUnitIncrementFloat(f1, f2, n, offset1, offset2);
                        }
                    } else {
                        for (int i = 0; i < nTensors; ++i) {
                            int offset1 = fs.getFirstTensorOffset() + i * fs.getTensorStartSeparation();
                            int offset2 = ss.getFirstTensorOffset() + i * ss.getTensorStartSeparation();
                            NDArrayUtil.diviIncrementOffsetFloat(f1, f2, n, offset1, offset2, incrF, incrS);
                        }
                    }
                } else {
                    double[] f1 = (double[])arrayFirstd;
                    double[] f2 = (double[])arraySecondd;
                    if (incrF == 1 && incrS == 1) {
                        for (int i = 0; i < nTensors; ++i) {
                            int offset1 = fs.getFirstTensorOffset() + i * fs.getTensorStartSeparation();
                            int offset2 = ss.getFirstTensorOffset() + i * ss.getTensorStartSeparation();
                            NDArrayUtil.diviOffsetUnitIncrementDouble(f1, f2, n, offset1, offset2);
                        }
                    } else {
                        for (int i = 0; i < nTensors; ++i) {
                            int offset1 = fs.getFirstTensorOffset() + i * fs.getTensorStartSeparation();
                            int offset2 = ss.getFirstTensorOffset() + i * ss.getTensorStartSeparation();
                            NDArrayUtil.diviIncrementOffsetDouble(f1, f2, n, offset1, offset2, incrF, incrS);
                        }
                    }
                }
                break;
            }
            case 'p': {
                for (int i = 0; i < nTensors; ++i) {
                    int offset1 = fs.getFirstTensorOffset() + i * fs.getTensorStartSeparation();
                    int offset2 = ss.getFirstTensorOffset() + i * ss.getTensorStartSeparation();
                    l1Blas.copy(n, ds, offset2, incrS, df, offset1, incrF);
                }
                break;
            }
            default: {
                throw new RuntimeException("Unknown op: " + op);
            }
        }
    }

    private static void doElementWiseOpGeneral(INDArray first, INDArray second, char op) {
        int opAlongDimension = NDArrayUtil.chooseElementWiseTensorDimension(first, second);
        int nTensors = first.tensorssAlongDimension(opAlongDimension);
        DataBuffer df = first.data();
        DataBuffer ds = second.data();
        Level1 l1Blas = Nd4j.getBlasWrapper().level1();
        switch (op) {
            case 'a': 
            case 's': {
                double a = op == 'a' ? 1.0 : -1.0;
                for (int i = 0; i < nTensors; ++i) {
                    INDArray tad1 = first.tensorAlongDimension(i, opAlongDimension);
                    INDArray tad2 = second.tensorAlongDimension(i, opAlongDimension);
                    l1Blas.axpy(tad1.length(), a, ds, tad2.offset(), tad2.elementWiseStride(), df, tad1.offset(), tad1.elementWiseStride());
                }
                break;
            }
            case 'm': {
                Object arrayFirst = df.array();
                Object arraySecond = ds.array();
                if (arrayFirst instanceof float[]) {
                    float[] f1 = (float[])arrayFirst;
                    float[] f2 = (float[])arraySecond;
                    for (int i = 0; i < nTensors; ++i) {
                        INDArray tad1 = first.tensorAlongDimension(i, opAlongDimension);
                        INDArray tad2 = second.tensorAlongDimension(i, opAlongDimension);
                        NDArrayUtil.muliIncrementOffsetFloat(f1, f2, tad1.length(), tad1.offset(), tad2.offset(), tad1.elementWiseStride(), tad2.elementWiseStride());
                    }
                } else {
                    double[] f1 = (double[])arrayFirst;
                    double[] f2 = (double[])arraySecond;
                    for (int i = 0; i < nTensors; ++i) {
                        INDArray tad1 = first.tensorAlongDimension(i, opAlongDimension);
                        INDArray tad2 = second.tensorAlongDimension(i, opAlongDimension);
                        NDArrayUtil.muliIncrementOffsetDouble(f1, f2, tad1.length(), tad1.offset(), tad2.offset(), tad1.elementWiseStride(), tad2.elementWiseStride());
                    }
                }
                break;
            }
            case 'd': {
                Object arrayFirstd = first.data().array();
                Object arraySecondd = second.data().array();
                if (arrayFirstd instanceof float[]) {
                    float[] f1 = (float[])arrayFirstd;
                    float[] f2 = (float[])arraySecondd;
                    for (int i = 0; i < nTensors; ++i) {
                        INDArray tad1 = first.tensorAlongDimension(i, opAlongDimension);
                        INDArray tad2 = second.tensorAlongDimension(i, opAlongDimension);
                        NDArrayUtil.diviIncrementOffsetFloat(f1, f2, tad1.length(), tad1.offset(), tad2.offset(), tad1.elementWiseStride(), tad2.elementWiseStride());
                    }
                } else {
                    double[] f1 = (double[])arrayFirstd;
                    double[] f2 = (double[])arraySecondd;
                    for (int i = 0; i < nTensors; ++i) {
                        INDArray tad1 = first.tensorAlongDimension(i, opAlongDimension);
                        INDArray tad2 = second.tensorAlongDimension(i, opAlongDimension);
                        NDArrayUtil.diviIncrementOffsetDouble(f1, f2, tad1.length(), tad1.offset(), tad2.offset(), tad1.elementWiseStride(), tad2.elementWiseStride());
                    }
                }
                break;
            }
            case 'p': {
                for (int i = 0; i < nTensors; ++i) {
                    INDArray tad1 = first.tensorAlongDimension(i, opAlongDimension);
                    INDArray tad2 = second.tensorAlongDimension(i, opAlongDimension);
                    l1Blas.copy(tad1.length(), ds, tad2.offset(), tad2.elementWiseStride(), df, tad1.offset(), tad1.elementWiseStride());
                }
                break;
            }
            default: {
                throw new RuntimeException("Unknown op: " + op);
            }
        }
    }

    public static void doVectorOp(INDArray array, INDArray vector, char op) {
        double[] dataDoubleVec;
        double[] dataDouble;
        float[] dataFloatVec;
        float[] dataFloat;
        if (array.rank() != 2) {
            throw new IllegalArgumentException("Cannot do row/column operation on non-2d matrix");
        }
        boolean rowOp = Shape.isRowVectorShape(vector.shape());
        if (vector.length() == 1) {
            if (array.isRowVector()) {
                rowOp = false;
            } else if (array.isColumnVector()) {
                rowOp = true;
            } else {
                throw new IllegalArgumentException("Invalid input: vector input is a scalar but array is not a vector");
            }
        }
        Tensor1DStats tensorStats = NDArrayUtil.get1DTensorStats(array, rowOp ? 1 : 0);
        int incr = tensorStats.getElementWiseStride();
        int incrVec = vector.elementWiseStride();
        int offsetVec = vector.offset();
        int opLength = vector.length();
        int nTensors = tensorStats.getNumTensors();
        DataBuffer buffer = array.data();
        DataBuffer bufferVec = vector.data();
        Object dataArray = buffer.array();
        Object dataArrayVec = bufferVec.array();
        if (dataArray instanceof float[]) {
            dataFloat = (float[])dataArray;
            dataFloatVec = (float[])dataArrayVec;
            dataDouble = null;
            dataDoubleVec = null;
        } else {
            dataFloat = null;
            dataFloatVec = null;
            dataDouble = (double[])dataArray;
            dataDoubleVec = (double[])dataArrayVec;
        }
        Level1 l1Blas = Nd4j.getBlasWrapper().level1();
        switch (op) {
            case 'a': 
            case 's': {
                double a = op == 'a' ? 1.0 : -1.0;
                for (int i = 0; i < nTensors; ++i) {
                    int tOffset = tensorStats.getFirstTensorOffset() + i * tensorStats.getTensorStartSeparation();
                    l1Blas.axpy(opLength, a, bufferVec, offsetVec, incrVec, buffer, tOffset, incr);
                }
                break;
            }
            case 'm': {
                if (dataFloat != null) {
                    if (incr == 1 && incrVec == 1) {
                        for (int i = 0; i < nTensors; ++i) {
                            int tOffset = tensorStats.getFirstTensorOffset() + i * tensorStats.getTensorStartSeparation();
                            NDArrayUtil.muliOffsetUnitIncrementFloat(dataFloat, dataFloatVec, opLength, tOffset, offsetVec);
                        }
                    } else {
                        for (int i = 0; i < nTensors; ++i) {
                            int tOffset = tensorStats.getFirstTensorOffset() + i * tensorStats.getTensorStartSeparation();
                            NDArrayUtil.muliIncrementOffsetFloat(dataFloat, dataFloatVec, opLength, tOffset, offsetVec, incr, incrVec);
                        }
                    }
                } else if (incr == 1 && incrVec == 1) {
                    for (int i = 0; i < nTensors; ++i) {
                        int tOffset = tensorStats.getFirstTensorOffset() + i * tensorStats.getTensorStartSeparation();
                        NDArrayUtil.muliOffsetUnitIncrementDouble(dataDouble, dataDoubleVec, opLength, tOffset, offsetVec);
                    }
                } else {
                    for (int i = 0; i < nTensors; ++i) {
                        int tOffset = tensorStats.getFirstTensorOffset() + i * tensorStats.getTensorStartSeparation();
                        NDArrayUtil.muliIncrementOffsetDouble(dataDouble, dataDoubleVec, opLength, tOffset, offsetVec, incr, incrVec);
                    }
                }
                break;
            }
            case 'd': {
                if (dataFloat != null) {
                    if (incr == 1 && incrVec == 1) {
                        for (int i = 0; i < nTensors; ++i) {
                            int tOffset = tensorStats.getFirstTensorOffset() + i * tensorStats.getTensorStartSeparation();
                            NDArrayUtil.diviOffsetUnitIncrementFloat(dataFloat, dataFloatVec, opLength, tOffset, offsetVec);
                        }
                    } else {
                        for (int i = 0; i < nTensors; ++i) {
                            int tOffset = tensorStats.getFirstTensorOffset() + i * tensorStats.getTensorStartSeparation();
                            NDArrayUtil.diviIncrementOffsetFloat(dataFloat, dataFloatVec, opLength, tOffset, offsetVec, incr, incrVec);
                        }
                    }
                } else if (incr == 1 && incrVec == 1) {
                    for (int i = 0; i < nTensors; ++i) {
                        int tOffset = tensorStats.getFirstTensorOffset() + i * tensorStats.getTensorStartSeparation();
                        NDArrayUtil.diviOffsetUnitIncrementDouble(dataDouble, dataDoubleVec, opLength, tOffset, offsetVec);
                    }
                } else {
                    for (int i = 0; i < nTensors; ++i) {
                        int tOffset = tensorStats.getFirstTensorOffset() + i * tensorStats.getTensorStartSeparation();
                        NDArrayUtil.diviIncrementOffsetDouble(dataDouble, dataDoubleVec, opLength, tOffset, offsetVec, incr, incrVec);
                    }
                }
                break;
            }
            case 'p': {
                for (int i = 0; i < nTensors; ++i) {
                    int tOffset = tensorStats.getFirstTensorOffset() + i * tensorStats.getTensorStartSeparation();
                    l1Blas.copy(opLength, bufferVec, offsetVec, incrVec, buffer, tOffset, incr);
                }
                break;
            }
            case 'h': {
                if (dataFloat != null) {
                    if (incr == 1 && incrVec == 1) {
                        for (int i = 0; i < nTensors; ++i) {
                            int tOffset = tensorStats.getFirstTensorOffset() + i * tensorStats.getTensorStartSeparation();
                            NDArrayUtil.rsubiOffsetUnitIncrementFloat(dataFloat, dataFloatVec, opLength, tOffset, offsetVec);
                        }
                    } else {
                        for (int i = 0; i < nTensors; ++i) {
                            int tOffset = tensorStats.getFirstTensorOffset() + i * tensorStats.getTensorStartSeparation();
                            NDArrayUtil.rsubiIncrementOffsetFloat(dataFloat, dataFloatVec, opLength, tOffset, offsetVec, incr, incrVec);
                        }
                    }
                } else if (incr == 1 && incrVec == 1) {
                    for (int i = 0; i < nTensors; ++i) {
                        int tOffset = tensorStats.getFirstTensorOffset() + i * tensorStats.getTensorStartSeparation();
                        NDArrayUtil.rsubiOffsetUnitIncrementDouble(dataDouble, dataDoubleVec, opLength, tOffset, offsetVec);
                    }
                } else {
                    for (int i = 0; i < nTensors; ++i) {
                        int tOffset = tensorStats.getFirstTensorOffset() + i * tensorStats.getTensorStartSeparation();
                        NDArrayUtil.rsubiIncrementOffsetDouble(dataDouble, dataDoubleVec, opLength, tOffset, offsetVec, incr, incrVec);
                    }
                }
                break;
            }
            case 't': {
                if (dataFloat != null) {
                    if (incr == 1 && incrVec == 1) {
                        for (int i = 0; i < nTensors; ++i) {
                            int tOffset = tensorStats.getFirstTensorOffset() + i * tensorStats.getTensorStartSeparation();
                            NDArrayUtil.rdiviOffsetUnitIncrementFloat(dataFloat, dataFloatVec, opLength, tOffset, offsetVec);
                        }
                    } else {
                        for (int i = 0; i < nTensors; ++i) {
                            int tOffset = tensorStats.getFirstTensorOffset() + i * tensorStats.getTensorStartSeparation();
                            NDArrayUtil.rdiviIncrementOffsetFloat(dataFloat, dataFloatVec, opLength, tOffset, offsetVec, incr, incrVec);
                        }
                    }
                } else if (incr == 1 && incrVec == 1) {
                    for (int i = 0; i < nTensors; ++i) {
                        int tOffset = tensorStats.getFirstTensorOffset() + i * tensorStats.getTensorStartSeparation();
                        NDArrayUtil.rdiviOffsetUnitIncrementDouble(dataDouble, dataDoubleVec, opLength, tOffset, offsetVec);
                    }
                } else {
                    for (int i = 0; i < nTensors; ++i) {
                        int tOffset = tensorStats.getFirstTensorOffset() + i * tensorStats.getTensorStartSeparation();
                        NDArrayUtil.rdiviIncrementOffsetDouble(dataDouble, dataDoubleVec, opLength, tOffset, offsetVec, incr, incrVec);
                    }
                }
                break;
            }
            default: {
                throw new RuntimeException("Unknown op: " + op);
            }
        }
    }

    private static void muliIncrementOffsetFloat(float[] first, float[] second, int opLength, int offsetFirst, int offsetSecond, int incrFirst, int incrSecond) {
        for (int i = 0; i < opLength; ++i) {
            int n = offsetFirst + i * incrFirst;
            first[n] = first[n] * second[offsetSecond + i * incrSecond];
        }
    }

    private static void muliIncrementNoOffsetFloat(float[] first, float[] second, int opLength, int incrFirst, int incrSecond) {
        for (int i = 0; i < opLength; ++i) {
            int n = i * incrFirst;
            first[n] = first[n] * second[i * incrSecond];
        }
    }

    private static void muliOffsetUnitIncrementFloat(float[] first, float[] second, int opLength, int offsetFirst, int offsetSecond) {
        for (int i = 0; i < opLength; ++i) {
            int n = offsetFirst + i;
            first[n] = first[n] * second[offsetSecond + i];
        }
    }

    private static void muliSimpleFloat(float[] first, float[] second, int opLength) {
        for (int i = 0; i < opLength; ++i) {
            int n = i;
            first[n] = first[n] * second[i];
        }
    }

    private static void muliIncrementOffsetDouble(double[] first, double[] second, int opLength, int offsetFirst, int offsetSecond, int incrFirst, int incrSecond) {
        for (int i = 0; i < opLength; ++i) {
            int n = offsetFirst + i * incrFirst;
            first[n] = first[n] * second[offsetSecond + i * incrSecond];
        }
    }

    private static void muliIncrementNoOffsetDouble(double[] first, double[] second, int opLength, int incrFirst, int incrSecond) {
        for (int i = 0; i < opLength; ++i) {
            int n = i * incrFirst;
            first[n] = first[n] * second[i * incrSecond];
        }
    }

    private static void muliOffsetUnitIncrementDouble(double[] first, double[] second, int opLength, int offsetFirst, int offsetSecond) {
        for (int i = 0; i < opLength; ++i) {
            int n = offsetFirst + i;
            first[n] = first[n] * second[offsetSecond + i];
        }
    }

    private static void muliSimpleDouble(double[] first, double[] second, int opLength) {
        for (int i = 0; i < opLength; ++i) {
            int n = i;
            first[n] = first[n] * second[i];
        }
    }

    private static void diviIncrementOffsetFloat(float[] first, float[] second, int opLength, int offsetFirst, int offsetSecond, int incrFirst, int incrSecond) {
        for (int i = 0; i < opLength; ++i) {
            int n = offsetFirst + i * incrFirst;
            first[n] = first[n] / second[offsetSecond + i * incrSecond];
        }
    }

    private static void diviIncrementNoOffsetFloat(float[] first, float[] second, int opLength, int incrFirst, int incrSecond) {
        for (int i = 0; i < opLength; ++i) {
            int n = i * incrFirst;
            first[n] = first[n] / second[i * incrSecond];
        }
    }

    private static void diviOffsetUnitIncrementFloat(float[] first, float[] second, int opLength, int offsetFirst, int offsetSecond) {
        for (int i = 0; i < opLength; ++i) {
            int n = offsetFirst + i;
            first[n] = first[n] / second[offsetSecond + i];
        }
    }

    private static void diviSimpleFloat(float[] first, float[] second, int opLength) {
        for (int i = 0; i < opLength; ++i) {
            int n = i;
            first[n] = first[n] / second[i];
        }
    }

    private static void diviIncrementOffsetDouble(double[] first, double[] second, int opLength, int offsetFirst, int offsetSecond, int incrFirst, int incrSecond) {
        for (int i = 0; i < opLength; ++i) {
            int n = offsetFirst + i * incrFirst;
            first[n] = first[n] / second[offsetSecond + i * incrSecond];
        }
    }

    private static void diviIncrementNoOffsetDouble(double[] first, double[] second, int opLength, int incrFirst, int incrSecond) {
        for (int i = 0; i < opLength; ++i) {
            int n = i * incrFirst;
            first[n] = first[n] / second[i * incrSecond];
        }
    }

    private static void diviOffsetUnitIncrementDouble(double[] first, double[] second, int opLength, int offsetFirst, int offsetSecond) {
        for (int i = 0; i < opLength; ++i) {
            int n = offsetFirst + i;
            first[n] = first[n] / second[offsetSecond + i];
        }
    }

    private static void diviSimpleDouble(double[] first, double[] second, int opLength) {
        for (int i = 0; i < opLength; ++i) {
            int n = i;
            first[n] = first[n] / second[i];
        }
    }

    private static void rsubiIncrementOffsetFloat(float[] first, float[] second, int opLength, int offsetFirst, int offsetSecond, int incrFirst, int incrSecond) {
        for (int i = 0; i < opLength; ++i) {
            int fIdx = offsetFirst + i * incrFirst;
            first[fIdx] = second[offsetSecond + i * incrSecond] - first[fIdx];
        }
    }

    private static void rsubiOffsetUnitIncrementFloat(float[] first, float[] second, int opLength, int offsetFirst, int offsetSecond) {
        for (int i = 0; i < opLength; ++i) {
            int fIdx = offsetFirst + i;
            first[fIdx] = second[offsetSecond + i] - first[fIdx];
        }
    }

    private static void rsubiIncrementOffsetDouble(double[] first, double[] second, int opLength, int offsetFirst, int offsetSecond, int incrFirst, int incrSecond) {
        for (int i = 0; i < opLength; ++i) {
            int fIdx = offsetFirst + i * incrFirst;
            first[fIdx] = second[offsetSecond + i * incrSecond] - first[fIdx];
        }
    }

    private static void rsubiOffsetUnitIncrementDouble(double[] first, double[] second, int opLength, int offsetFirst, int offsetSecond) {
        for (int i = 0; i < opLength; ++i) {
            int fIdx = offsetFirst + i;
            first[fIdx] = second[offsetSecond + i] - first[fIdx];
        }
    }

    private static void rdiviIncrementOffsetFloat(float[] first, float[] second, int opLength, int offsetFirst, int offsetSecond, int incrFirst, int incrSecond) {
        for (int i = 0; i < opLength; ++i) {
            int fIdx = offsetFirst + i * incrFirst;
            first[fIdx] = second[offsetSecond + i * incrSecond] / first[fIdx];
        }
    }

    private static void rdiviOffsetUnitIncrementFloat(float[] first, float[] second, int opLength, int offsetFirst, int offsetSecond) {
        for (int i = 0; i < opLength; ++i) {
            int fIdx = offsetFirst + i;
            first[fIdx] = second[offsetSecond + i] / first[fIdx];
        }
    }

    private static void rdiviIncrementOffsetDouble(double[] first, double[] second, int opLength, int offsetFirst, int offsetSecond, int incrFirst, int incrSecond) {
        for (int i = 0; i < opLength; ++i) {
            int fIdx = offsetFirst + i * incrFirst;
            first[fIdx] = second[offsetSecond + i * incrSecond] / first[fIdx];
        }
    }

    private static void rdiviOffsetUnitIncrementDouble(double[] first, double[] second, int opLength, int offsetFirst, int offsetSecond) {
        for (int i = 0; i < opLength; ++i) {
            int fIdx = offsetFirst + i;
            first[fIdx] = second[offsetSecond + i] / first[fIdx];
        }
    }

    public static class Tensor1DStats {
        public final int firstTensorOffset;
        public final int tensorStartSeparation;
        public final int numTensors;
        public final int tensorLength;
        public final int elementWiseStride;

        @ConstructorProperties(value={"firstTensorOffset", "tensorStartSeparation", "numTensors", "tensorLength", "elementWiseStride"})
        public Tensor1DStats(int firstTensorOffset, int tensorStartSeparation, int numTensors, int tensorLength, int elementWiseStride) {
            this.firstTensorOffset = firstTensorOffset;
            this.tensorStartSeparation = tensorStartSeparation;
            this.numTensors = numTensors;
            this.tensorLength = tensorLength;
            this.elementWiseStride = elementWiseStride;
        }

        public int getFirstTensorOffset() {
            return this.firstTensorOffset;
        }

        public int getTensorStartSeparation() {
            return this.tensorStartSeparation;
        }

        public int getNumTensors() {
            return this.numTensors;
        }

        public int getTensorLength() {
            return this.tensorLength;
        }

        public int getElementWiseStride() {
            return this.elementWiseStride;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Tensor1DStats)) {
                return false;
            }
            Tensor1DStats other = (Tensor1DStats)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getFirstTensorOffset() != other.getFirstTensorOffset()) {
                return false;
            }
            if (this.getTensorStartSeparation() != other.getTensorStartSeparation()) {
                return false;
            }
            if (this.getNumTensors() != other.getNumTensors()) {
                return false;
            }
            if (this.getTensorLength() != other.getTensorLength()) {
                return false;
            }
            return this.getElementWiseStride() == other.getElementWiseStride();
        }

        protected boolean canEqual(Object other) {
            return other instanceof Tensor1DStats;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getFirstTensorOffset();
            result = result * 59 + this.getTensorStartSeparation();
            result = result * 59 + this.getNumTensors();
            result = result * 59 + this.getTensorLength();
            result = result * 59 + this.getElementWiseStride();
            return result;
        }

        public String toString() {
            return "NDArrayUtil.Tensor1DStats(firstTensorOffset=" + this.getFirstTensorOffset() + ", tensorStartSeparation=" + this.getTensorStartSeparation() + ", numTensors=" + this.getNumTensors() + ", tensorLength=" + this.getTensorLength() + ", elementWiseStride=" + this.getElementWiseStride() + ")";
        }
    }
}

