/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.transforms;

import org.nd4j.linalg.api.complex.IComplexNDArray;
import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseTransformOp;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.api.ops.impl.transforms.VectorFFT;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.util.ComplexNDArrayUtil;

public class VectorIFFT
extends BaseTransformOp {
    protected int fftLength;
    private int originalN = -1;
    protected boolean executed = false;

    public VectorIFFT() {
    }

    public VectorIFFT(INDArray x, INDArray z, int fftLength) {
        super(x, z);
        this.fftLength = fftLength;
        this.exec();
    }

    public VectorIFFT(INDArray x, INDArray z, int n, int fftLength) {
        super(x, z, n);
        this.fftLength = fftLength;
        this.exec();
    }

    public VectorIFFT(INDArray x, INDArray y, INDArray z, int n, int fftLength) {
        super(x, y, z, n);
        this.fftLength = fftLength;
        this.exec();
    }

    public VectorIFFT(INDArray x, int fftLength) {
        super(x);
        this.fftLength = fftLength;
        this.exec();
    }

    public VectorIFFT(INDArray x) {
        this(x, x.length());
    }

    @Override
    public String name() {
        return "ifft";
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, double other) {
        return origin;
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, float other) {
        return origin;
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, IComplexNumber other) {
        return origin;
    }

    @Override
    public float op(float origin, float other) {
        return origin;
    }

    @Override
    public double op(double origin, double other) {
        return origin;
    }

    @Override
    public double op(double origin) {
        return origin;
    }

    @Override
    public float op(float origin) {
        return origin;
    }

    @Override
    public IComplexNumber op(IComplexNumber origin) {
        return origin;
    }

    @Override
    public Op opForDimension(int index, int dimension) {
        INDArray xAlongDimension = this.x.vectorAlongDimension(index, dimension);
        if (this.y() != null) {
            return new VectorIFFT(xAlongDimension, this.y.vectorAlongDimension(index, dimension), this.z.vectorAlongDimension(index, dimension), xAlongDimension.length(), this.fftLength);
        }
        return new VectorIFFT(xAlongDimension, this.z.vectorAlongDimension(index, dimension), xAlongDimension.length(), this.fftLength);
    }

    @Override
    public Op opForDimension(int index, int ... dimension) {
        INDArray xAlongDimension = this.x.tensorAlongDimension(index, dimension);
        if (this.y() != null) {
            return new VectorIFFT(xAlongDimension, this.y.tensorAlongDimension(index, dimension), this.z.tensorAlongDimension(index, dimension), xAlongDimension.length(), this.fftLength);
        }
        return new VectorIFFT(xAlongDimension, this.z.tensorAlongDimension(index, dimension), xAlongDimension.length(), this.fftLength);
    }

    @Override
    public boolean isPassThrough() {
        return true;
    }

    @Override
    public void setX(INDArray x) {
        this.x = x;
        this.executed = false;
        this.n = this.fftLength = this.z.length();
    }

    @Override
    public void setZ(INDArray z) {
        this.z = z;
        this.executed = false;
        this.n = this.fftLength = z.length();
    }

    @Override
    public void exec() {
        if (!this.x.isVector()) {
            return;
        }
        if (this.executed) {
            return;
        }
        this.executed = true;
        IComplexNDArray ndArray = this.x instanceof IComplexNDArray ? (IComplexNDArray)this.x : Nd4j.createComplex(this.x);
        IComplexNDArray fft = (IComplexNDArray)Nd4j.getExecutioner().execAndReturn(new VectorFFT(ndArray.conj(), this.y, this.z, this.x.length(), this.fftLength));
        IComplexNDArray ret = fft.conj().divi(Nd4j.complexScalar(this.fftLength));
        this.x = this.z = this.originalN > 0 ? ComplexNDArrayUtil.truncate(ret, this.originalN, 0) : ret;
    }
}

