/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.transforms;

import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseTransformOp;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.factory.Nd4j;

public class TimesOneMinus
extends BaseTransformOp {
    public TimesOneMinus() {
    }

    public TimesOneMinus(INDArray x, INDArray z) {
        super(x, z);
    }

    public TimesOneMinus(INDArray x, INDArray z, int n) {
        super(x, z, n);
    }

    public TimesOneMinus(INDArray x, INDArray y, INDArray z, int n) {
        super(x, y, z, n);
    }

    public TimesOneMinus(INDArray x) {
        super(x);
    }

    @Override
    public String name() {
        return "timesoneminus";
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, double other) {
        return Nd4j.createComplexNumber(1, 1).subi(origin).muli(origin);
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, float other) {
        return Nd4j.createComplexNumber(1, 1).subi(origin).muli(origin);
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, IComplexNumber other) {
        return Nd4j.createComplexNumber(1, 1).subi(origin).muli(origin);
    }

    @Override
    public float op(float origin, float other) {
        return origin * (1.0f - origin);
    }

    @Override
    public double op(double origin, double other) {
        return origin * (1.0 - origin);
    }

    @Override
    public double op(double origin) {
        return origin * (1.0 - origin);
    }

    @Override
    public float op(float origin) {
        return origin * (1.0f - origin);
    }

    @Override
    public IComplexNumber op(IComplexNumber origin) {
        return Nd4j.createComplexNumber(1, 1).subi(origin).muli(origin);
    }

    @Override
    public Op opForDimension(int index, int dimension) {
        INDArray xAlongDimension = this.x.vectorAlongDimension(index, dimension);
        if (this.y() != null) {
            return new TimesOneMinus(xAlongDimension, this.y.vectorAlongDimension(index, dimension), this.z.vectorAlongDimension(index, dimension), xAlongDimension.length());
        }
        return new TimesOneMinus(xAlongDimension, this.z.vectorAlongDimension(index, dimension), this.x.length());
    }

    @Override
    public Op opForDimension(int index, int ... dimension) {
        INDArray xAlongDimension = this.x.tensorAlongDimension(index, dimension);
        if (this.y() != null) {
            return new TimesOneMinus(xAlongDimension, this.y.tensorAlongDimension(index, dimension), this.z.tensorAlongDimension(index, dimension), xAlongDimension.length());
        }
        return new TimesOneMinus(xAlongDimension, this.z.tensorAlongDimension(index, dimension), this.x.length());
    }
}

