/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.accum;

import org.apache.commons.math3.util.FastMath;
import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseAccumulation;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.util.ComplexUtil;

public class Norm2
extends BaseAccumulation {
    public Norm2() {
    }

    public Norm2(INDArray x, INDArray y, INDArray z, int n) {
        super(x, y, z, n);
    }

    public Norm2(INDArray x, INDArray y, int n) {
        super(x, y, n);
    }

    public Norm2(INDArray x) {
        super(x);
    }

    public Norm2(INDArray x, INDArray y) {
        super(x, y);
    }

    @Override
    public void update(Number result) {
        this.currentResult = this.currentResult.doubleValue() + FastMath.pow((double)result.doubleValue(), (int)2);
        if (this.numProcessed == this.n) {
            this.currentResult = FastMath.sqrt((double)this.currentResult.doubleValue());
        }
    }

    @Override
    public void update(IComplexNumber result) {
        this.currentComplexResult.addi(ComplexUtil.pow(result, 2.0));
        if (this.numProcessed == this.n) {
            this.currentComplexResult.set(ComplexUtil.sqrt(this.currentComplexResult));
        }
    }

    @Override
    public Number zero() {
        return 0.0;
    }

    @Override
    public IComplexNumber zeroComplex() {
        return Nd4j.createComplexNumber(0.0, 0.0);
    }

    @Override
    public String name() {
        return "norm2";
    }

    @Override
    public Op opForDimension(int index, int dimension) {
        INDArray xAlongDimension = this.x.vectorAlongDimension(index, dimension);
        if (this.y() != null) {
            return new Norm2(xAlongDimension, this.y.vectorAlongDimension(index, dimension), xAlongDimension.length());
        }
        return new Norm2(this.x.vectorAlongDimension(index, dimension));
    }

    @Override
    public Op opForDimension(int index, int ... dimension) {
        INDArray xAlongDimension = this.x.tensorAlongDimension(index, dimension);
        if (this.y() != null) {
            return new Norm2(xAlongDimension, this.y.tensorAlongDimension(index, dimension), xAlongDimension.length());
        }
        return new Norm2(this.x.tensorAlongDimension(index, dimension));
    }
}

