/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.exception;

import java.io.Serializable;
import java.util.Arrays;
import org.nd4j.linalg.api.blas.BlasBufferUtil;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.Op;

public class BlasOpErrorMessage
implements Serializable {
    private Op op;

    public BlasOpErrorMessage(Op op) {
        this.op = op;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer().append("Op " + this.op.name() + " of length " + this.op.n()).append(" will fail with x of " + this.shapeInfo(this.op.x()));
        if (this.op.y() != null) {
            sb.append(" y of " + this.shapeInfo(this.op.y()));
        }
        sb.append(" and z of " + this.op.z());
        return sb.toString();
    }

    private String shapeInfo(INDArray arr) {
        return Arrays.toString(arr.shape()) + " and stride " + Arrays.toString(arr.stride()) + " and offset " + arr.offset() + " and blas stride of " + BlasBufferUtil.getBlasStride(arr);
    }
}

