/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.complex;

import org.nd4j.linalg.api.complex.IComplexDouble;
import org.nd4j.linalg.api.complex.IComplexFloat;
import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.factory.Nd4j;

public abstract class BaseComplexDouble
implements IComplexDouble {
    protected double real;
    protected double imag;

    public BaseComplexDouble() {
    }

    public BaseComplexDouble(Double real, Double imag) {
        this.real = real;
        this.imag = imag;
    }

    public BaseComplexDouble(double real, double imag) {
        this.real = real;
        this.imag = imag;
    }

    public BaseComplexDouble(double real) {
        this(real, 0.0);
    }

    @Override
    public IComplexNumber dup() {
        return Nd4j.createComplexNumber(this.real, this.imag);
    }

    @Override
    public IComplexNumber eqc(IComplexNumber num) {
        double val = num.realComponent().doubleValue();
        double imag = num.imaginaryComponent().doubleValue();
        double otherVal = num.realComponent().doubleValue();
        double otherImag = num.imaginaryComponent().doubleValue();
        if (val == otherVal) {
            return Nd4j.createComplexNumber(1, 0);
        }
        if (val != otherVal) {
            return Nd4j.createComplexNumber(0, 0);
        }
        if (imag == otherImag) {
            return Nd4j.createComplexNumber(1, 0);
        }
        return Nd4j.createComplexNumber(0, 0);
    }

    @Override
    public IComplexNumber neqc(IComplexNumber num) {
        double val = num.realComponent().doubleValue();
        double imag = num.imaginaryComponent().doubleValue();
        double otherVal = num.realComponent().doubleValue();
        double otherImag = num.imaginaryComponent().doubleValue();
        if (val != otherVal) {
            return Nd4j.createComplexNumber(1, 0);
        }
        if (val == otherVal) {
            return Nd4j.createComplexNumber(0, 0);
        }
        if (imag != otherImag) {
            return Nd4j.createComplexNumber(1, 0);
        }
        return Nd4j.createComplexNumber(0, 0);
    }

    @Override
    public IComplexNumber gt(IComplexNumber num) {
        double val = num.realComponent().doubleValue();
        double imag = num.imaginaryComponent().doubleValue();
        double otherVal = num.realComponent().doubleValue();
        double otherImag = num.imaginaryComponent().doubleValue();
        if (val > otherVal) {
            return Nd4j.createComplexNumber(1, 0);
        }
        if (val < otherVal) {
            return Nd4j.createComplexNumber(0, 0);
        }
        if (imag > otherImag) {
            return Nd4j.createComplexNumber(1, 0);
        }
        return Nd4j.createComplexNumber(0, 0);
    }

    @Override
    public IComplexNumber lt(IComplexNumber num) {
        double val = num.realComponent().doubleValue();
        double imag = num.imaginaryComponent().doubleValue();
        double otherVal = num.realComponent().doubleValue();
        double otherImag = num.imaginaryComponent().doubleValue();
        if (val < otherVal) {
            return Nd4j.createComplexNumber(1, 0);
        }
        if (val > otherVal) {
            return Nd4j.createComplexNumber(0, 0);
        }
        if (imag < otherImag) {
            return Nd4j.createComplexNumber(1, 0);
        }
        return Nd4j.createComplexNumber(0, 0);
    }

    @Override
    public IComplexDouble asDouble() {
        return this;
    }

    @Override
    public IComplexDouble conji() {
        this.set(this.realComponent(), -this.imaginaryComponent().doubleValue());
        return this;
    }

    @Override
    public IComplexNumber conj() {
        return this.dup().conji();
    }

    @Override
    public IComplexNumber set(Number real, Number imag) {
        this.real = real.doubleValue();
        this.imag = imag.doubleValue();
        return this;
    }

    @Override
    public IComplexNumber copy(IComplexNumber other) {
        return Nd4j.createDouble(other.realComponent().doubleValue(), other.imaginaryComponent().doubleValue());
    }

    @Override
    public IComplexNumber set(IComplexNumber set) {
        return this.set(set.realComponent().doubleValue(), set.imaginaryComponent().doubleValue());
    }

    @Override
    public IComplexNumber rsubi(IComplexNumber c) {
        return this.rsubi(c, (IComplexNumber)this);
    }

    @Override
    public IComplexNumber rsub(IComplexNumber c) {
        return this.dup().rsubi(c);
    }

    @Override
    public IComplexNumber rsubi(IComplexNumber a, IComplexNumber result) {
        return result.set(a.sub(this));
    }

    @Override
    public IComplexNumber rsubi(Number a, IComplexNumber result) {
        return result.set(a.doubleValue() - result.realComponent().doubleValue(), this.imaginaryComponent());
    }

    @Override
    public IComplexNumber rsubi(Number a) {
        return this.set(a.doubleValue() - this.realComponent(), this.imaginaryComponent());
    }

    @Override
    public IComplexNumber rsub(Number r) {
        return this.dup().rsubi(r);
    }

    @Override
    public IComplexNumber rdiv(IComplexNumber c) {
        return this.dup().rdivi(c);
    }

    @Override
    public IComplexNumber rdivi(IComplexNumber c, IComplexNumber result) {
        return result.set(c.realComponent().doubleValue() / this.realComponent(), c.imaginaryComponent().doubleValue() / this.imaginaryComponent());
    }

    @Override
    public IComplexNumber rdivi(IComplexNumber c) {
        return this.rdivi(c, (IComplexNumber)this);
    }

    @Override
    public IComplexNumber rdivi(Number v, IComplexNumber result) {
        double d = this.realComponent() * this.realComponent() + this.imaginaryComponent() * this.imaginaryComponent();
        return result.set(v.doubleValue() * result.realComponent().doubleValue() / d, -v.doubleValue() * result.imaginaryComponent().doubleValue() / d);
    }

    @Override
    public IComplexNumber rdivi(Number v) {
        return this.set(v.doubleValue() / this.realComponent(), this.imaginaryComponent());
    }

    @Override
    public IComplexNumber rdiv(Number v) {
        return this.dup().rdivi(v);
    }

    @Override
    public IComplexFloat asFloat() {
        return Nd4j.createFloat(this.realComponent().floatValue(), this.imaginaryComponent().floatValue());
    }

    @Override
    public IComplexNumber addi(IComplexNumber c, IComplexNumber result) {
        result.set(this.realComponent() + c.realComponent().doubleValue(), this.imaginaryComponent() + c.imaginaryComponent().doubleValue());
        return this;
    }

    @Override
    public IComplexNumber addi(IComplexNumber c) {
        return this.addi(c, (IComplexNumber)this);
    }

    @Override
    public IComplexNumber add(IComplexNumber c) {
        return this.dup().addi(c);
    }

    @Override
    public IComplexNumber addi(Number a, IComplexNumber result) {
        return result.set(result.realComponent().doubleValue() + a.doubleValue(), result.imaginaryComponent().doubleValue());
    }

    @Override
    public IComplexNumber addi(Number c) {
        return this.addi(c, (IComplexNumber)this);
    }

    @Override
    public IComplexNumber add(Number c) {
        return this.dup().addi(c);
    }

    @Override
    public IComplexNumber subi(IComplexNumber c, IComplexNumber result) {
        return result.set(this.realComponent() - c.realComponent().doubleValue(), this.imaginaryComponent() - c.imaginaryComponent().doubleValue());
    }

    @Override
    public IComplexNumber subi(IComplexNumber c) {
        return this.subi(c, (IComplexNumber)this);
    }

    @Override
    public IComplexNumber sub(IComplexNumber c) {
        return this.dup().subi(c);
    }

    @Override
    public IComplexNumber subi(Number a, IComplexNumber result) {
        return result.set(this.realComponent() - a.doubleValue(), (double)this.imaginaryComponent());
    }

    @Override
    public IComplexNumber subi(Number a) {
        return this.subi(a, (IComplexNumber)this);
    }

    @Override
    public IComplexNumber sub(Number r) {
        return this.dup().subi(r);
    }

    @Override
    public IComplexNumber muli(IComplexNumber c, IComplexNumber result) {
        double newR = this.real * c.realComponent().doubleValue() - this.imag * c.imaginaryComponent().doubleValue();
        double newI = this.real * c.imaginaryComponent().doubleValue() + this.imag * c.realComponent().doubleValue();
        result.set(newR, newI);
        return result;
    }

    @Override
    public IComplexNumber muli(IComplexNumber c) {
        return this.muli(c, (IComplexNumber)this);
    }

    @Override
    public IComplexNumber mul(IComplexNumber c) {
        return this.dup().muli(c);
    }

    @Override
    public IComplexNumber mul(Number v) {
        return this.dup().muli(v);
    }

    @Override
    public IComplexNumber muli(Number v, IComplexNumber result) {
        return result.set(this.realComponent() * v.doubleValue(), this.imaginaryComponent() * v.doubleValue());
    }

    @Override
    public IComplexNumber muli(Number v) {
        return this.muli(v, (IComplexNumber)this);
    }

    @Override
    public IComplexNumber div(IComplexNumber c) {
        return this.dup().divi(c);
    }

    @Override
    public IComplexNumber divi(IComplexNumber c, IComplexNumber result) {
        double d = c.realComponent().doubleValue() * c.realComponent().doubleValue() + c.imaginaryComponent().doubleValue() * c.imaginaryComponent().doubleValue();
        double newR = (this.realComponent() * c.realComponent().doubleValue() + this.imaginaryComponent() * c.imaginaryComponent().doubleValue()) / d;
        double newI = (this.imaginaryComponent() * c.realComponent().doubleValue() - this.realComponent() * c.imaginaryComponent().doubleValue()) / d;
        result.set(newR, newI);
        return result;
    }

    @Override
    public IComplexNumber divi(IComplexNumber c) {
        return this.divi(c, (IComplexNumber)this);
    }

    @Override
    public IComplexNumber divi(Number v, IComplexNumber result) {
        return result.set(result.realComponent().doubleValue() / v.doubleValue(), result.imaginaryComponent().doubleValue() / v.doubleValue());
    }

    @Override
    public IComplexNumber divi(Number v) {
        return this.divi(v, (IComplexNumber)this);
    }

    @Override
    public IComplexNumber div(Number v) {
        return this.dup().divi(v);
    }

    @Override
    public boolean eq(IComplexNumber c) {
        return this.realComponent().equals(c.realComponent()) && this.imaginaryComponent().equals(c.imaginaryComponent());
    }

    @Override
    public boolean ne(IComplexNumber c) {
        return !this.eq(c);
    }

    @Override
    public boolean isZero() {
        return this.real == 0.0;
    }

    @Override
    public boolean isReal() {
        return this.imag == 0.0;
    }

    @Override
    public boolean isImag() {
        return this.real == 0.0;
    }

    @Override
    public Double realComponent() {
        return this.real;
    }

    @Override
    public Double imaginaryComponent() {
        return this.imag;
    }

    @Override
    public IComplexDouble divi(double v) {
        this.imag /= v;
        this.real /= v;
        return this;
    }

    @Override
    public IComplexNumber div(double v) {
        return this.dup().divi(v);
    }

    @Override
    public Double absoluteValue() {
        return Math.sqrt(this.real * this.real + this.imag * this.imag);
    }

    @Override
    public Double complexArgument() {
        return Math.acos(this.realComponent() / this.absoluteValue());
    }

    @Override
    public IComplexDouble invi() {
        double d = this.realComponent() * this.realComponent() + this.imaginaryComponent() * this.imaginaryComponent();
        this.set(this.realComponent() / d, -this.imaginaryComponent().doubleValue() / d);
        return this;
    }

    @Override
    public IComplexNumber inv() {
        return this.dup().invi();
    }

    @Override
    public IComplexNumber neg() {
        return this.dup().negi();
    }

    @Override
    public IComplexDouble negi() {
        this.set(-this.realComponent().doubleValue(), -this.imaginaryComponent().doubleValue());
        return this;
    }

    @Override
    public IComplexDouble sqrt() {
        double a = this.absoluteValue();
        double s2 = Math.sqrt(2.0);
        double p = Math.sqrt(a + this.realComponent()) / s2;
        double q = Math.sqrt(a - this.realComponent()) / s2 * Math.signum(this.imaginaryComponent());
        return Nd4j.createDouble(p, q);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IComplexNumber)) {
            return false;
        }
        IComplexNumber that = (IComplexNumber)o;
        if (Math.abs(that.realComponent().doubleValue() - this.real) > Nd4j.EPS_THRESHOLD) {
            return false;
        }
        return !(Math.abs(that.imaginaryComponent().doubleValue() - this.imag) > Nd4j.EPS_THRESHOLD);
    }

    public int hashCode() {
        long temp = Double.doubleToLongBits(this.real);
        int result = (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.imag);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public String toString() {
        if (this.imag >= 0.0) {
            return this.real + " + " + this.imag + "i";
        }
        return this.real + " - " + -this.imag + "i";
    }
}

