/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.util;

import java.util.Arrays;
import org.nd4j.linalg.api.complex.IComplexNDArray;
import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.indexing.INDArrayIndex;
import org.nd4j.linalg.indexing.Indices;
import org.nd4j.linalg.indexing.NDArrayIndex;
import org.nd4j.linalg.ops.transforms.Transforms;
import org.nd4j.linalg.util.ArrayUtil;
import org.nd4j.linalg.util.ComplexUtil;

public class ComplexNDArrayUtil {
    public static IComplexNDArray exp(IComplexNDArray toExp) {
        return ComplexNDArrayUtil.expi(toExp.dup());
    }

    public static IComplexNDArray expi(IComplexNDArray toExp) {
        IComplexNDArray flattened = toExp.ravel();
        for (int i = 0; i < flattened.length(); ++i) {
            IComplexNumber n = flattened.getComplex(i);
            flattened.put(i, Nd4j.scalar(ComplexUtil.exp(n)));
        }
        return flattened.reshape(toExp.shape());
    }

    public static IComplexNDArray center(IComplexNDArray arr, int[] shape) {
        if (arr.length() < ArrayUtil.prod(shape)) {
            return arr;
        }
        for (int i = 0; i < shape.length; ++i) {
            if (shape[i] >= 1) continue;
            shape[i] = 1;
        }
        INDArray shapeMatrix = ArrayUtil.toNDArray(shape);
        INDArray currShape = ArrayUtil.toNDArray(arr.shape());
        INDArray startIndex = Transforms.floor(currShape.sub(shapeMatrix).divi(Nd4j.scalar(2.0f)));
        INDArray endIndex = startIndex.add(shapeMatrix);
        INDArrayIndex[] indexes = Indices.createFromStartAndEnd(startIndex, endIndex);
        if (shapeMatrix.length() > 1) {
            return arr.get(indexes);
        }
        IComplexNDArray ret = Nd4j.createComplex(new int[]{(int)shapeMatrix.getDouble(0)});
        int start = (int)startIndex.getDouble(0);
        int end = (int)endIndex.getDouble(0);
        int count = 0;
        for (int i = start; i < end; ++i) {
            ret.putScalar(count++, arr.getComplex(i));
        }
        return ret;
    }

    public static IComplexNDArray truncate(IComplexNDArray nd, int n, int dimension) {
        if (nd.isVector()) {
            IComplexNDArray truncated = Nd4j.createComplex(new int[]{1, n});
            for (int i = 0; i < n; ++i) {
                truncated.putScalar(i, nd.getComplex(i));
            }
            return truncated;
        }
        if (nd.size(dimension) > n) {
            int[] shape = ArrayUtil.copy(nd.shape());
            shape[dimension] = n;
            IComplexNDArray ret = Nd4j.createComplex(shape);
            IComplexNDArray ndLinear = nd.linearView();
            IComplexNDArray retLinear = ret.linearView();
            for (int i = 0; i < ret.length(); ++i) {
                retLinear.putScalar(i, ndLinear.getComplex(i));
            }
            return ret;
        }
        return nd;
    }

    public static IComplexNDArray padWithZeros(IComplexNDArray nd, int[] targetShape) {
        if (Arrays.equals(nd.shape(), targetShape)) {
            return nd;
        }
        if (ArrayUtil.prod(nd.shape()) >= ArrayUtil.prod(targetShape)) {
            return nd;
        }
        IComplexNDArray ret = Nd4j.createComplex(targetShape);
        INDArrayIndex[] targetShapeIndex = NDArrayIndex.createCoveringShape(nd.shape());
        ret.put(targetShapeIndex, nd);
        return ret;
    }
}

