/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.string;

import java.text.DecimalFormat;
import org.apache.commons.lang3.StringUtils;
import org.nd4j.linalg.api.complex.IComplexNDArray;
import org.nd4j.linalg.api.ndarray.INDArray;

public class NDArrayStrings {
    private DecimalFormat decimalFormat = new DecimalFormat("#,###,##0.00");
    private String sep = ",";

    public NDArrayStrings(String sep) {
        this.sep = sep;
    }

    public NDArrayStrings() {
        this(",");
    }

    public String format(INDArray arr) {
        return this.format(arr, arr.rank());
    }

    private String format(INDArray arr, int rank) {
        StringBuffer sb = new StringBuffer();
        if (arr.isScalar()) {
            if (arr instanceof IComplexNDArray) {
                return ((IComplexNDArray)arr).getComplex(0).toString();
            }
            return this.decimalFormat.format(arr.getDouble(0));
        }
        if (arr.isVector()) {
            sb.append("[");
            for (int i = 0; i < arr.length(); ++i) {
                sb.append(StringUtils.repeat((String)" ", (int)(rank - 1)));
                if (arr instanceof IComplexNDArray) {
                    sb.append(((IComplexNDArray)arr).getComplex(i).toString());
                } else {
                    sb.append(this.decimalFormat.format(arr.getDouble(i)));
                }
                if (i >= arr.length() - 1) continue;
                sb.append(this.sep);
            }
            sb.append("]");
            return sb.toString();
        }
        sb.append("[");
        for (int i = 0; i < arr.slices(); ++i) {
            sb.append(this.format(arr.slice(i), rank - 1));
            if (i >= arr.slices() - 1) continue;
            sb.append("\n");
            sb.append(StringUtils.repeat((String)" ", (int)(rank - 1)));
        }
        sb.append("]");
        return sb.toString();
    }
}

